/*
 * Decompiled with CFR 0.152.
 */
package org.holoeverywhere.builder;

import java.util.Map;
import org.holoeverywhere.builder.Block;
import org.holoeverywhere.builder.Document;
import org.holoeverywhere.builder.Parseable;
import org.holoeverywhere.builder.Parser;
import org.json.JSONObject;

public class IncludeRow
implements Parseable<JSONObject, IncludeRow> {
    public String name = "";
    public IncludeType type = IncludeType.ALL;

    @Override
    public IncludeRow parse(JSONObject data) {
        this.name = data.optString("name", "");
        this.type = IncludeType.find(data.optString("type", IncludeType.ALL.tag));
        return this;
    }

    public void process(Map<String, Block> blocks, Map<String, Block> data) {
        if (blocks == null || data == null) {
            return;
        }
        Document document = Parser.parse(this.name);
        if (document == null) {
            return;
        }
        switch (this.type) {
            default: {
                data.putAll(document.data);
            }
            case ONLY_BLOCKS: 
        }
        blocks.putAll(document.blocks);
        for (IncludeRow i : document.include) {
            i.process(blocks, data);
        }
    }

    public static enum IncludeType {
        ALL("all"),
        ONLY_BLOCKS("only blocks");

        public final String tag;

        public static IncludeType find(String tag) {
            for (IncludeType i : IncludeType.values()) {
                if (!i.tag.equals(tag)) continue;
                return i;
            }
            return null;
        }

        private IncludeType() {
            this(null);
        }

        private IncludeType(String tag) {
            this.tag = tag == null ? this.name().toLowerCase().replace('_', ' ') : tag;
        }
    }
}

