/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.app;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.res.Configuration;
import android.content.res.TypedArray;
import android.os.Build;
import android.os.Bundle;
import android.support.v4.app.Watson;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.ContextMenu;
import android.view.LayoutInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import com.actionbarsherlock.internal.view.menu.ContextMenuBuilder;
import com.actionbarsherlock.internal.view.menu.ContextMenuDecorView;
import com.actionbarsherlock.internal.view.menu.ContextMenuItemWrapper;
import com.actionbarsherlock.internal.view.menu.ContextMenuListener;
import com.actionbarsherlock.internal.view.menu.ContextMenuWrapper;
import com.actionbarsherlock.view.ContextMenu;
import com.actionbarsherlock.view.Menu;
import com.actionbarsherlock.view.MenuInflater;
import org.holoeverywhere.IHoloActivity;
import org.holoeverywhere.LayoutInflater;
import org.holoeverywhere.R;
import org.holoeverywhere.SystemServiceManager;
import org.holoeverywhere.ThemeManager;
import org.holoeverywhere.app.Application;
import org.holoeverywhere.preference.PreferenceManager;

public abstract class _HoloActivity
extends Watson
implements IHoloActivity {
    private Holo config;
    private boolean forceThemeApply = false;
    private int lastThemeResourceId = 0;
    private final String TAG = this.getClass().getSimpleName();
    private boolean wasInited = false;

    public void addContentView(View view, ViewGroup.LayoutParams params) {
        super.addContentView(this.prepareDecorView(view), params);
    }

    private void checkWindowSizes() {
        View view = this.getWindow().getDecorView();
        if (Build.VERSION.SDK_INT < 11 && view != null) {
            DisplayMetrics dm = this.getResources().getDisplayMetrics();
            TypedArray a = this.obtainStyledAttributes(R.styleable.HoloActivity);
            int windowMinWidthMajor = (int)a.getFraction(0, dm.widthPixels, 1, 0.0f);
            int windowMinWidthMinor = (int)a.getFraction(1, dm.widthPixels, 1, 0.0f);
            a.recycle();
            switch (this.getRequestedOrientation()) {
                case 0: 
                case 8: {
                    view.setMinimumWidth(windowMinWidthMajor);
                    break;
                }
                case 1: 
                case 9: {
                    view.setMinimumWidth(windowMinWidthMinor);
                }
            }
        }
    }

    @Override
    public void createContextMenu(ContextMenuBuilder contextMenuBuilder, View view, ContextMenu.ContextMenuInfo menuInfo, ContextMenuListener listener) {
        listener.onCreateContextMenu(contextMenuBuilder, view, menuInfo);
    }

    @Override
    public Application.Config getConfig() {
        return Application.config();
    }

    @Override
    public org.holoeverywhere.preference.SharedPreferences getDefaultSharedPreferences() {
        return PreferenceManager.getDefaultSharedPreferences((Context)this);
    }

    @Override
    public org.holoeverywhere.preference.SharedPreferences getDefaultSharedPreferences(Application.Config.PreferenceImpl impl) {
        return PreferenceManager.getDefaultSharedPreferences((Context)this, impl);
    }

    public Holo getHolo() {
        return this.config;
    }

    public int getLastThemeResourceId() {
        return this.lastThemeResourceId;
    }

    @Override
    public LayoutInflater getLayoutInflater() {
        return LayoutInflater.from((Context)this);
    }

    @Override
    public org.holoeverywhere.preference.SharedPreferences getSharedPreferences(Application.Config.PreferenceImpl impl, String name, int mode) {
        return PreferenceManager.wrap((Context)this, impl, name, mode);
    }

    @Override
    public org.holoeverywhere.preference.SharedPreferences getSharedPreferences(String name, int mode) {
        return PreferenceManager.wrap((Context)this, name, mode);
    }

    @Override
    public Application getSupportApplication() {
        return Application.getLastInstance();
    }

    @Override
    public MenuInflater getSupportMenuInflater() {
        return null;
    }

    public Object getSystemService(String name) {
        return SystemServiceManager.getSystemService((Context)this, name);
    }

    protected void init(Holo config) {
        this.config = config;
    }

    public void invalidateOptionsMenu() {
        this.supportInvalidateOptionsMenu();
    }

    @Override
    public boolean isABSSupport() {
        return false;
    }

    @Override
    public boolean isForceThemeApply() {
        return this.forceThemeApply;
    }

    @SuppressLint(value={"NewApi"})
    public void onBackPressed() {
        if (!this.getSupportFragmentManager().popBackStackImmediate()) {
            this.finish();
        }
    }

    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        this.checkWindowSizes();
    }

    public void onContentChanged() {
        super.onContentChanged();
        this.checkWindowSizes();
    }

    public final boolean onContextItemSelected(MenuItem item) {
        return this.onContextItemSelected(new ContextMenuItemWrapper(item));
    }

    @Override
    public boolean onContextItemSelected(com.actionbarsherlock.view.MenuItem item) {
        if (item instanceof ContextMenuItemWrapper) {
            return super.onContextItemSelected(((ContextMenuItemWrapper)item).unwrap());
        }
        return false;
    }

    public final void onContextMenuClosed(android.view.Menu menu) {
        if (menu instanceof android.view.ContextMenu) {
            this.onContextMenuClosed(new ContextMenuWrapper((android.view.ContextMenu)menu));
        } else {
            Log.w((String)this.TAG, (String)"onContextMenuClosed: menu is not ContextMenu instance");
            super.onContextMenuClosed(menu);
        }
    }

    @Override
    public void onContextMenuClosed(ContextMenu menu) {
        if (menu instanceof ContextMenuWrapper) {
            super.onContextMenuClosed((android.view.Menu)((ContextMenuWrapper)menu).unwrap());
        }
    }

    protected void onCreate(Bundle savedInstanceState) {
        this.onPreInit();
        this.onInit(this.config);
        super.onCreate(savedInstanceState);
        this.onPostInit(this.config);
    }

    public final void onCreateContextMenu(android.view.ContextMenu menu, View v, ContextMenu.ContextMenuInfo menuInfo) {
        this.onCreateContextMenu(new ContextMenuWrapper(menu), v, menuInfo);
    }

    @Override
    public void onCreateContextMenu(ContextMenu menu, View view, ContextMenu.ContextMenuInfo menuInfo) {
        if (menu instanceof ContextMenuWrapper) {
            super.onCreateContextMenu(((ContextMenuWrapper)menu).unwrap(), view, menuInfo);
        }
    }

    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        return false;
    }

    protected void onDestroy() {
        super.onDestroy();
        LayoutInflater.onDestroy((Context)this);
    }

    protected void onInit(Holo config) {
        if (config.addFactoryToInflater) {
            this.getLayoutInflater().addFactory((LayoutInflater.Factory)this, 0);
        }
        boolean forceThemeApply = this.isForceThemeApply();
        if (config.forceThemeApply) {
            forceThemeApply = true;
            this.setForceThemeApply(true);
        }
        if (this.lastThemeResourceId == 0) {
            forceThemeApply = true;
        }
        ThemeManager.applyTheme((Activity)this, forceThemeApply);
        if (!config.ignoreThemeCheck) {
            TypedArray a = this.obtainStyledAttributes(R.styleable.HoloActivity);
            boolean holoTheme = a.getBoolean(2, false);
            a.recycle();
            if (!holoTheme) {
                throw new HoloThemeException(this);
            }
        }
    }

    @Override
    public boolean onOptionsItemSelected(com.actionbarsherlock.view.MenuItem item) {
        return false;
    }

    protected void onPostInit(Holo config) {
        int layout2 = config.layout;
        if (layout2 > 0) {
            this.setContentView(layout2);
        }
    }

    protected void onPreInit() {
        if (this.wasInited) {
            return;
        }
        this.wasInited = true;
        if (this.config == null) {
            this.config = Holo.defaultConfig();
        }
    }

    @Override
    public boolean onPrepareOptionsMenu(Menu menu) {
        return false;
    }

    @Override
    public View prepareDecorView(View v) {
        return ContextMenuDecorView.prepareDecorView((Context)this, v, this, 0);
    }

    public void setContentView(int layoutResID) {
        this.setContentView(this.getLayoutInflater().inflate(layoutResID));
    }

    public void setContentView(View view) {
        super.setContentView(this.prepareDecorView(view));
    }

    public void setContentView(View view, ViewGroup.LayoutParams params) {
        super.setContentView(this.prepareDecorView(view), params);
    }

    public void setForceThemeApply(boolean forceThemeApply) {
        this.forceThemeApply = forceThemeApply;
    }

    public void setTheme(int resid) {
        this.lastThemeResourceId = resid;
        super.setTheme(resid);
    }

    public void startActivities(Intent[] intents) {
        this.startActivities(intents, null);
    }

    public void startActivities(Intent[] intents, Bundle options) {
        for (Intent intent : intents) {
            this.startActivity(intent, options);
        }
    }

    public void startActivity(Intent intent) {
        this.startActivity(intent, null);
    }

    public void startActivity(Intent intent, Bundle options) {
        this.startActivityForResult(intent, -1, options);
    }

    public void startActivityForResult(Intent intent, int requestCode) {
        this.startActivityForResult(intent, requestCode, null);
    }

    public void startActivityForResult(Intent intent, int requestCode, Bundle options) {
        if (this.getConfig().isAlwaysUseParentTheme()) {
            ThemeManager.startActivity((Context)this, intent, requestCode, options);
        } else {
            this.superStartActivity(intent, requestCode, options);
        }
    }

    @Override
    public SharedPreferences superGetSharedPreferences(String name, int mode) {
        return super.getSharedPreferences(name, mode);
    }

    @Override
    public Object superGetSystemService(String name) {
        return super.getSystemService(name);
    }

    @Override
    @SuppressLint(value={"NewApi"})
    public void superStartActivity(Intent intent, int requestCode, Bundle options) {
        if (Build.VERSION.SDK_INT >= 16) {
            super.startActivityForResult(intent, requestCode, options);
        } else {
            super.startActivityForResult(intent, requestCode);
        }
    }

    @Override
    public void supportInvalidateOptionsMenu() {
        if (Build.VERSION.SDK_INT >= 11) {
            super.invalidateOptionsMenu();
        }
    }

    private static final class HoloThemeException
    extends RuntimeException {
        private static final long serialVersionUID = -2346897999325868420L;

        public HoloThemeException(_HoloActivity activity) {
            super("You must apply Holo.Theme, Holo.Theme.Light or Holo.Theme.Light.DarkActionBar theme on the activity (" + activity.getClass().getSimpleName() + ") for using HoloEverywhere");
        }
    }

    public static class Holo {
        public boolean addFactoryToInflater = true;
        public boolean forceThemeApply = false;
        public boolean ignoreThemeCheck = false;
        public int layout = -1;

        public static Holo defaultConfig() {
            return new Holo();
        }

        public static Holo wrap(Holo holo) {
            return Holo.defaultConfig().onWrap(holo);
        }

        protected Holo onWrap(Holo holo) {
            this.addFactoryToInflater = holo.addFactoryToInflater;
            this.forceThemeApply = holo.forceThemeApply;
            this.ignoreThemeCheck = holo.ignoreThemeCheck;
            this.layout = holo.layout;
            return this;
        }
    }
}

