/*
 * Decompiled with CFR 0.152.
 */
package com.actionbarsherlock.internal.view.menu;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.IBinder;
import android.util.EventLog;
import android.util.Log;
import android.view.ContextMenu;
import android.view.View;
import com.actionbarsherlock.internal.view.menu.ContextMenuListener;
import com.actionbarsherlock.internal.view.menu.MenuBuilder;
import com.actionbarsherlock.internal.view.menu.MenuDialogHelper;
import com.actionbarsherlock.view.ContextMenu;
import java.lang.reflect.Method;
import org.holoeverywhere.app.Application;

public class ContextMenuBuilder
extends MenuBuilder
implements ContextMenu {
    private ContextMenu.ContextMenuInfo contextMenuInfo;
    private final ContextMenuListener listener;
    private final String TAG = this.getClass().getSimpleName();

    public ContextMenuBuilder(Context context, ContextMenuListener listener) {
        super(context);
        if (listener == null) {
            throw new IllegalArgumentException("ContextMenuListener can't be null");
        }
        this.listener = listener;
    }

    public ContextMenu.ContextMenuInfo getContextMenuInfo() {
        return this.contextMenuInfo;
    }

    private ContextMenu.ContextMenuInfo getContextMenuInfo(View view) {
        ContextMenu.ContextMenuInfo menuInfo;
        block4: {
            if (view instanceof ContextMenuInfoGetter) {
                return ((ContextMenuInfoGetter)view).getContextMenuInfo();
            }
            menuInfo = null;
            try {
                Class<?> clazz;
                for (clazz = view.getClass(); clazz != View.class; clazz = clazz.getSuperclass()) {
                }
                Method method = clazz.getDeclaredMethod("getContextMenuInfo", new Class[0]);
                method.setAccessible(true);
                menuInfo = (ContextMenu.ContextMenuInfo)method.invoke((Object)view, new Object[0]);
            }
            catch (Exception e) {
                if (!Application.isDebugMode()) break block4;
                Log.e((String)this.TAG, (String)"getContextMenuInfo error", (Throwable)e);
            }
        }
        return menuInfo;
    }

    @Override
    public ContextMenu setHeaderIcon(Drawable icon) {
        return (ContextMenu)((Object)super.setHeaderIconInt(icon));
    }

    @Override
    public ContextMenu setHeaderIcon(int iconRes) {
        return (ContextMenu)((Object)super.setHeaderIconInt(iconRes));
    }

    @Override
    public ContextMenu setHeaderTitle(CharSequence title) {
        return (ContextMenu)((Object)super.setHeaderTitleInt(title));
    }

    @Override
    public ContextMenu setHeaderTitle(int titleRes) {
        return (ContextMenu)((Object)super.setHeaderTitleInt(titleRes));
    }

    @Override
    public ContextMenu setHeaderView(View view) {
        return (ContextMenu)((Object)super.setHeaderViewInt(view));
    }

    @SuppressLint(value={"NewApi"})
    public MenuDialogHelper show(View originalView, IBinder token) {
        this.contextMenuInfo = this.getContextMenuInfo(originalView);
        this.listener.createContextMenu(this, originalView, this.contextMenuInfo, this.listener);
        if (this.getVisibleItems().size() > 0) {
            if (Build.VERSION.SDK_INT >= 8) {
                EventLog.writeEvent((int)50001, (int)1);
            }
            MenuDialogHelper helper = new MenuDialogHelper(this);
            helper.show(token);
            return helper;
        }
        return null;
    }

    public static interface ContextMenuInfoGetter {
        public ContextMenu.ContextMenuInfo getContextMenuInfo();
    }
}

