/*
 * Decompiled with CFR 0.152.
 */
package com.actionbarsherlock.internal.view.menu;

import android.content.Context;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.widget.FrameLayout;
import com.actionbarsherlock.internal.view.menu.ContextMenuBuilder;
import com.actionbarsherlock.internal.view.menu.ContextMenuListener;
import com.actionbarsherlock.internal.view.menu.MenuBuilder;
import com.actionbarsherlock.internal.view.menu.MenuDialogHelper;
import com.actionbarsherlock.internal.view.menu.MenuItemImpl;
import com.actionbarsherlock.internal.view.menu.MenuPresenter;
import com.actionbarsherlock.view.ContextMenu;
import com.actionbarsherlock.view.MenuItem;
import org.holoeverywhere.app.Application;

public final class ContextMenuDecorView
extends FrameLayout {
    private ContextMenuBuilder contextMenu;
    private final InternalWrapper listener;
    private MenuDialogHelper menuDialogHelper;
    private final View view;

    public static View prepareDecorView(Context context, View v, ContextMenuListener listener, int decorViewId) {
        if (v != null && !Application.config().isDisableContextMenu()) {
            v = new ContextMenuDecorView(context, (View)v, listener);
            if (decorViewId > 0) {
                v.setId(decorViewId);
            }
        }
        return v;
    }

    public ContextMenuDecorView(Context context, View view, ContextMenuListener listener) {
        super(context);
        this.listener = new InternalWrapper(listener);
        if (view != null) {
            ViewParent parent = view.getParent();
            if (parent != null && parent instanceof ViewGroup) {
                ((ViewGroup)parent).removeView(view);
            }
            this.addView(view, -1, -1);
        }
        this.view = view;
    }

    public boolean showContextMenuForChild(View originalView) {
        if (Application.config().isDisableContextMenu()) {
            return super.showContextMenuForChild(originalView);
        }
        if (this.contextMenu == null) {
            this.contextMenu = new ContextMenuBuilder(this.getContext(), this.listener.unwrap());
            this.contextMenu.setCallback(this.listener);
        } else {
            this.contextMenu.clearAll();
        }
        MenuDialogHelper helper = this.contextMenu.show(originalView, originalView.getWindowToken());
        if (helper != null) {
            helper.setPresenterCallback(this.listener);
        }
        this.menuDialogHelper = helper;
        return this.menuDialogHelper != null;
    }

    public View unwrap() {
        return this.view;
    }

    private static final class InternalWrapper
    implements MenuPresenter.Callback,
    MenuBuilder.Callback {
        private final ContextMenuListener listener;
        private final String TAG = this.getClass().getSimpleName();

        public InternalWrapper(ContextMenuListener listener) {
            if (listener == null) {
                throw new IllegalArgumentException("Listener is null", new NullPointerException());
            }
            this.listener = listener;
            if (Application.isDebugMode()) {
                Log.v((String)this.TAG, (String)("Create new InternalWrapper with listener: " + listener));
            }
        }

        @Override
        public void onCloseMenu(MenuBuilder menu, boolean allMenusAreClosing) {
            if (Application.isDebugMode()) {
                Log.v((String)this.TAG, (String)("Calling onContextMenuClosed on " + this.listener));
            }
            this.listener.onContextMenuClosed((ContextMenu)((Object)menu));
        }

        @Override
        public boolean onMenuItemSelected(MenuBuilder menu, MenuItem item) {
            if (Application.isDebugMode()) {
                Log.v((String)this.TAG, (String)("Calling onContextItemSelected on " + this.listener));
            }
            if (menu instanceof ContextMenuBuilder && item instanceof MenuItemImpl) {
                ((MenuItemImpl)item).setMenuInfo(((ContextMenuBuilder)menu).getContextMenuInfo());
            }
            return this.listener.onContextItemSelected(item);
        }

        @Override
        public void onMenuModeChange(MenuBuilder menu) {
        }

        @Override
        public boolean onOpenSubMenu(MenuBuilder subMenu) {
            return false;
        }

        public ContextMenuListener unwrap() {
            return this.listener;
        }
    }
}

