/*
 * Decompiled with CFR 0.152.
 */
package org.holoeverywhere;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Typeface;
import android.os.Build;
import android.util.Log;
import android.util.SparseArray;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.holoeverywhere.LayoutInflater;

public final class FontLoader {
    private static final SparseArray<Typeface> fontArray = new SparseArray();
    private static final String TAG = "FontLoader";

    public static View apply(View view) {
        return FontLoader.applyDefaultStyles(view);
    }

    public static View apply(View view, HoloFont font) {
        if (font.ignore) {
            return view;
        }
        return FontLoader.apply(view, font.font);
    }

    @SuppressLint(value={"NewApi"})
    public static View apply(View view, int font) {
        if (view == null || view.getContext() == null || view.getContext().isRestricted()) {
            Log.e((String)TAG, (String)"View or context is invalid");
            return view;
        }
        if (font < 0) {
            return FontLoader.applyDefaultStyles(view);
        }
        Typeface typeface = FontLoader.loadTypeface(view.getContext(), font);
        if (typeface == null) {
            Log.v((String)TAG, (String)("Font " + font + " not found in resources"));
            return view;
        }
        return FontLoader.apply(view, typeface);
    }

    public static View apply(View view, Typeface typeface) {
        if (view == null || view.getContext() == null || view.getContext().isRestricted()) {
            return view;
        }
        if (typeface == null) {
            Log.v((String)TAG, (String)"Font is null");
            return view;
        }
        if (view instanceof TextView) {
            ((TextView)view).setTypeface(typeface);
        }
        if (view instanceof ViewGroup) {
            ViewGroup group = (ViewGroup)view;
            for (int i = 0; i < group.getChildCount(); ++i) {
                FontLoader.apply(group.getChildAt(i), typeface);
            }
        }
        return view;
    }

    public static View applyDefaultStyles(View view) {
        if (view == null || view.getContext() == null || view.getContext().isRestricted()) {
            return view;
        }
        if (view instanceof TextView) {
            TextView text = (TextView)view;
            Typeface typeface = text.getTypeface();
            if (typeface == null) {
                text.setTypeface(FontLoader.loadTypeface(view.getContext(), HoloFont.ROBOTO_REGULAR.font));
                return view;
            }
            boolean isBold = typeface.isBold();
            boolean isItalic = typeface.isItalic();
            HoloFont font = isBold && isItalic ? HoloFont.ROBOTO_BOLD_ITALIC : (isBold && !isItalic ? HoloFont.ROBOTO_BOLD : (!isBold && isItalic ? HoloFont.ROBOTO_ITALIC : HoloFont.ROBOTO_REGULAR));
            if (!font.ignore && (typeface = FontLoader.loadTypeface(view.getContext(), font.font)) != null) {
                text.setTypeface(typeface);
            }
        }
        if (view instanceof ViewGroup) {
            ViewGroup group = (ViewGroup)view;
            for (int i = 0; i < group.getChildCount(); ++i) {
                FontLoader.applyDefaultStyles(group.getChildAt(i));
            }
        }
        return view;
    }

    @Deprecated
    public static View inflate(Context context, int res) {
        return LayoutInflater.inflate(context, res);
    }

    @Deprecated
    public static View inflate(Context context, int res, ViewGroup parent) {
        return LayoutInflater.inflate(context, res, parent);
    }

    public static Typeface loadTypeface(Context context, int font) {
        if (fontArray.get(font) == null) {
            try {
                int read;
                File file = new File(context.getApplicationInfo().dataDir + "/fonts");
                if (!file.exists()) {
                    file.mkdirs();
                }
                if ((file = new File(file, Integer.toHexString(font))).exists()) {
                    file.delete();
                }
                Resources res = context.getResources();
                InputStream is = res.openRawResource(font);
                FileOutputStream os = new FileOutputStream(file);
                byte[] buffer = new byte[8192];
                while ((read = is.read(buffer)) > 0) {
                    ((OutputStream)os).write(buffer, 0, read);
                }
                os.flush();
                ((OutputStream)os).close();
                is.close();
                fontArray.put(font, (Object)Typeface.createFromFile((File)file));
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)"Error of loading font", (Throwable)e);
            }
        }
        return (Typeface)fontArray.get(font);
    }

    private FontLoader() {
    }

    public static class HoloFont {
        public static final HoloFont ROBOTO = new HoloFont(-1);
        public static final HoloFont ROBOTO_BOLD = new HoloFont(2131099648);
        public static final HoloFont ROBOTO_BOLD_ITALIC = new HoloFont(2131099649);
        public static final HoloFont ROBOTO_ITALIC = new HoloFont(2131099650);
        public static final HoloFont ROBOTO_REGULAR = new HoloFont(2131099651);
        protected final int font;
        protected final boolean ignore;

        private HoloFont(int font) {
            this(font, Build.VERSION.SDK_INT >= 11);
        }

        private HoloFont(int font, boolean ignore) {
            this.font = font;
            this.ignore = ignore;
        }
    }
}

