/*
 * Decompiled with CFR 0.152.
 */
package org.holoeverywhere;

import android.util.Log;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class Setting<T extends Setting<T>> {
    private static final Map<Class<? extends Setting<?>>, Setting<?>> settingMap = new HashMap();
    private static final String TAG = Setting.class.getSimpleName();
    private final List<SettingListener<T>> listeners = new ArrayList<SettingListener<T>>();
    private final List<Property<?>> propertyList = new ArrayList();

    public static <T extends Setting<T>> void addListener(Class<T> clazz, SettingListener<T> settingListener) {
        ((Setting)Setting.get(clazz)).addListener(settingListener);
    }

    public static <T extends Setting<T>> T get(Class<T> clazz) {
        if (!settingMap.containsKey(clazz)) {
            try {
                Setting t = (Setting)clazz.newInstance();
                settingMap.put(clazz, t);
                t.init();
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)"Error init setting instance", (Throwable)e);
            }
        }
        return (T)settingMap.get(clazz);
    }

    public static <T extends Setting<T>> void removeListener(Class<T> clazz, SettingListener<T> settingListener) {
        if (settingMap.containsKey(clazz)) {
            ((Setting)Setting.get(clazz)).removeListener(settingListener);
        }
    }

    public final T addListener(SettingListener<T> listener) {
        if (listener == null) {
            throw new IllegalArgumentException("SettingListener can't be null");
        }
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
            listener.onAttach(this);
        } else {
            this.listeners.remove(listener);
            this.listeners.add(listener);
        }
        return (T)this;
    }

    public final T attach(Property<?> property) {
        if (property == null || !property.isValid()) {
            throw new RuntimeException("Property not valid");
        }
        if (property.getSetting() != null && property.getSetting() != this) {
            throw new RuntimeException("Property already attached to " + property.getSetting().getClass().getName());
        }
        ((Property)property).setSetting(this);
        this.propertyList.add(property);
        return (T)this;
    }

    public final T detach(Property<?> property) {
        if (property != null) {
            this.propertyList.remove(property);
            ((Property)property).setSetting(null);
        }
        return (T)this;
    }

    private Field[] getFields() {
        try {
            return this.getClass().getDeclaredFields();
        }
        catch (Exception e) {
            return this.getClass().getFields();
        }
    }

    protected final void init() {
        for (Field field : this.getFields()) {
            try {
                field.setAccessible(true);
                if (!field.isAnnotationPresent(SettingProperty.class)) continue;
                SettingProperty settingProperty = field.getAnnotation(SettingProperty.class);
                if (settingProperty.create()) {
                    field.set(this, field.getType().newInstance());
                }
                Property property = (Property)field.get(this);
                property.onSetDefaultValue(settingProperty);
                this.attach(property);
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)"Error on processing property", (Throwable)e);
            }
        }
        this.onInit();
    }

    protected void onInit() {
    }

    protected void onPropertyChange(Property<?> property) {
        for (SettingListener<Setting> settingListener : this.listeners) {
            try {
                settingListener.onPropertyChange(this, property);
            }
            catch (RuntimeException e) {
                Log.w((String)TAG, (String)"Listener error", (Throwable)e);
            }
        }
    }

    public final T removeListener(SettingListener<T> listener) {
        if (listener == null) {
            throw new IllegalArgumentException("SettingListener can't be null");
        }
        if (this.listeners.contains(listener)) {
            listener.onDetach(this);
            this.listeners.remove(listener);
        }
        return (T)this;
    }

    public static class StringProperty
    extends Property<String> {
        @Override
        protected void onSetDefaultValue(SettingProperty settingProperty) {
            this.setValue(settingProperty.defaultString());
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface SettingProperty {
        public boolean create() default false;

        public boolean defaultBoolean() default false;

        public String defaultEnum() default "";

        public int defaultInt() default 0;

        public String defaultString() default "";

        public Class<? extends Enum<?>> enumClass() default NullEnum.class;
    }

    public static interface SettingListener<T extends Setting<T>> {
        public void onAttach(T var1);

        public void onDetach(T var1);

        public void onPropertyChange(T var1, Property<?> var2);
    }

    public static class Property<Z> {
        private Setting<?> setting;
        private Z value;
        private boolean wasAttach = false;

        public void attach(Setting<?> setting) {
            if (setting != null) {
                setting.attach(this);
            }
        }

        public void detach() {
            if (this.setting != null) {
                this.setting.detach(this);
            }
        }

        public final Setting<?> getSetting() {
            return this.setting;
        }

        public Z getValue() {
            return this.value;
        }

        public boolean isValid() {
            return true;
        }

        public final void notifyOnChange() {
            if (this.setting != null) {
                this.setting.onPropertyChange(this);
            }
        }

        protected void onAttach(Setting<?> setting) {
        }

        protected void onDetach() {
        }

        protected void onSetDefaultValue(SettingProperty settingProperty) {
        }

        private final void setSetting(Setting<?> setting) {
            this.setting = setting;
            if (setting != null) {
                if (this.wasAttach) {
                    this.onDetach();
                }
                this.onAttach(setting);
                this.wasAttach = true;
            } else if (this.wasAttach) {
                this.onDetach();
                this.wasAttach = false;
            }
        }

        public void setValue(Z value) {
            if (this.value != value) {
                this.value = value;
                this.notifyOnChange();
            }
        }
    }

    private static enum NullEnum {

    }

    public static class IntegerProperty
    extends Property<Integer> {
        @Override
        protected void onSetDefaultValue(SettingProperty settingProperty) {
            this.setValue(settingProperty.defaultInt());
        }
    }

    public static class EnumProperty<T extends Enum<T>>
    extends Property<T> {
        private String defaultValue;

        @Override
        protected void onSetDefaultValue(SettingProperty settingProperty) {
            Class<Enum<?>> clazz;
            this.defaultValue = settingProperty.defaultEnum();
            Class<Enum<?>> t = settingProperty.enumClass();
            Class<Enum<?>> clazz2 = clazz = t == NullEnum.class ? null : t;
            if (clazz != null) {
                this.setEnumClass(clazz);
            }
        }

        public void setEnumClass(Class<T> clazz) {
            if (this.defaultValue != null) {
                try {
                    Method method = clazz.getMethod("valueOf", String.class);
                    method.setAccessible(true);
                    this.setValue((Enum)method.invoke(null, this.defaultValue));
                }
                catch (Exception e) {
                    Log.w((String)TAG, (String)"Error on getting enum value", (Throwable)e);
                }
            }
        }
    }

    public static class BooleanProperty
    extends Property<Boolean> {
        @Override
        protected void onSetDefaultValue(SettingProperty settingProperty) {
            this.setValue(settingProperty.defaultBoolean());
        }
    }
}

