/*
 * Decompiled with CFR 0.152.
 */
package org.holoeverywhere;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.util.SparseIntArray;
import org.holoeverywhere.IHoloActivity;
import org.holoeverywhere.app.Application;

public final class ThemeManager {
    private static int _DEFAULT_THEME = 1;
    private static final int _START_RESOURCES_ID = 0x1000000;
    private static ThemeGetter _THEME_GETTER;
    private static final int _THEME_MASK = 31;
    private static int _THEME_MODIFIER;
    private static final String _THEME_TAG = "holoeverywhere:theme";
    private static final SparseIntArray _THEMES_MAP;
    public static final int DARK = 1;
    public static final int FULLSCREEN = 16;
    public static final int LIGHT = 2;
    @Deprecated
    public static final int LIGHT_WITH_DARK_ACTION_BAR = 4;
    public static final int MIXED = 4;
    public static final int NO_ACTION_BAR = 8;

    public static void applyTheme(Activity activity) {
        boolean force = activity instanceof IHoloActivity ? ((IHoloActivity)activity).isForceThemeApply() : false;
        ThemeManager.applyTheme(activity, force);
    }

    public static void applyTheme(Activity activity, boolean force) {
        if (force || ThemeManager.hasSpecifiedTheme(activity)) {
            activity.setTheme(ThemeManager.getThemeResource(activity));
        }
    }

    public static void cloneTheme(Intent sourceIntent, Intent intent) {
        ThemeManager.cloneTheme(sourceIntent, intent, false);
    }

    public static void cloneTheme(Intent sourceIntent, Intent intent, boolean force) {
        boolean hasSourceTheme = ThemeManager.hasSpecifiedTheme(sourceIntent);
        if (force || hasSourceTheme) {
            intent.putExtra(_THEME_TAG, hasSourceTheme ? ThemeManager.getTheme(sourceIntent) : _DEFAULT_THEME);
        }
    }

    public static int getDefaultTheme() {
        return _DEFAULT_THEME;
    }

    public static int getModifier() {
        return _THEME_MODIFIER;
    }

    public static int getTheme(Activity activity) {
        return ThemeManager.getTheme(activity.getIntent());
    }

    public static int getTheme(Intent intent) {
        return ThemeManager.prepareFlags(intent.getIntExtra(_THEME_TAG, _DEFAULT_THEME));
    }

    public static int getThemeResource(Activity activity) {
        return ThemeManager.getThemeResource(ThemeManager.getTheme(activity));
    }

    public static int getThemeResource(int themeTag) {
        int getterResource;
        if ((themeTag = ThemeManager.prepareFlags(themeTag)) >= 0x1000000) {
            return themeTag;
        }
        if (_THEME_GETTER != null && (getterResource = _THEME_GETTER.getThemeResource(new ThemeGetter.ThemeTag(themeTag))) > 0) {
            return getterResource;
        }
        int i = _THEMES_MAP.get(themeTag, _DEFAULT_THEME);
        if (i == _DEFAULT_THEME) {
            return _THEMES_MAP.get(_DEFAULT_THEME, 2131558607);
        }
        return i;
    }

    public static int getThemeResource(Intent intent) {
        return ThemeManager.getThemeResource(ThemeManager.getTheme(intent));
    }

    public static boolean hasSpecifiedTheme(Activity activity) {
        return activity == null ? false : ThemeManager.hasSpecifiedTheme(activity.getIntent());
    }

    public static boolean hasSpecifiedTheme(Intent intent) {
        return intent != null && intent.hasExtra(_THEME_TAG) && intent.getIntExtra(_THEME_TAG, 0) > 0;
    }

    private static boolean is(int config, int key) {
        return (config & key) != 0;
    }

    public static boolean isDark(Activity activity) {
        return ThemeManager.isDark(ThemeManager.getTheme(activity));
    }

    public static boolean isDark(int i) {
        return ThemeManager.is(i, 1);
    }

    public static boolean isDark(Intent intent) {
        return ThemeManager.isDark(ThemeManager.getTheme(intent));
    }

    public static boolean isFullScreen(Activity activity) {
        return ThemeManager.isFullScreen(ThemeManager.getTheme(activity));
    }

    public static boolean isFullScreen(int i) {
        return ThemeManager.is(i, 16);
    }

    public static boolean isFullScreen(Intent intent) {
        return ThemeManager.isFullScreen(ThemeManager.getTheme(intent));
    }

    public static boolean isLight(Activity activity) {
        return ThemeManager.isLight(ThemeManager.getTheme(activity));
    }

    public static boolean isLight(int i) {
        return ThemeManager.is(i, 2);
    }

    public static boolean isLight(Intent intent) {
        return ThemeManager.isLight(ThemeManager.getTheme(intent));
    }

    @Deprecated
    public static boolean isLightWithDarkActionBar(Activity activity) {
        return ThemeManager.isMixed(activity);
    }

    @Deprecated
    public static boolean isLightWithDarkActionBar(int i) {
        return ThemeManager.isMixed(i);
    }

    @Deprecated
    public static boolean isLightWithDarkActionBar(Intent intent) {
        return ThemeManager.isMixed(intent);
    }

    public static boolean isMixed(Activity activity) {
        return ThemeManager.isMixed(ThemeManager.getTheme(activity));
    }

    public static boolean isMixed(int i) {
        return ThemeManager.is(i, 4);
    }

    public static boolean isMixed(Intent intent) {
        return ThemeManager.isMixed(ThemeManager.getTheme(intent));
    }

    public static boolean isNoActionBar(Activity activity) {
        return ThemeManager.isNoActionBar(ThemeManager.getTheme(activity));
    }

    public static boolean isNoActionBar(int i) {
        return ThemeManager.is(i, 8);
    }

    public static boolean isNoActionBar(Intent intent) {
        return ThemeManager.isNoActionBar(ThemeManager.getTheme(intent));
    }

    public static void map(int theme) {
        ThemeManager.map(_DEFAULT_THEME, theme);
    }

    public static void map(int flags, int theme) {
        _THEMES_MAP.put(flags & 0x1F, theme);
    }

    public static void modify(int mod) {
        _THEME_MODIFIER |= mod & 0x1F;
    }

    public static void modifyClear() {
        _THEME_MODIFIER = 0;
    }

    public static void modifyClear(int mod) {
        _THEME_MODIFIER |= (mod &= 0x1F);
        _THEME_MODIFIER ^= mod;
    }

    public static void modifyDefaultTheme(int mod) {
        _DEFAULT_THEME |= mod & 0x1F;
    }

    public static void modifyDefaultThemeClear(int mod) {
        _DEFAULT_THEME |= (mod &= 0x1F);
        _DEFAULT_THEME ^= mod;
    }

    private static int prepareFlags(int i) {
        if (i >= 0x1000000) {
            return i;
        }
        if (_THEME_MODIFIER > 0) {
            i |= _THEME_MODIFIER;
        }
        return i & 0x1F;
    }

    public static void restartWithDarkTheme(Activity activity) {
        ThemeManager.restartWithTheme(activity, 1);
    }

    public static void restartWithLightTheme(Activity activity) {
        ThemeManager.restartWithTheme(activity, 2);
    }

    @Deprecated
    public static void restartWithLightWithDarkActionBarTheme(Activity activity) {
        ThemeManager.restartWithMixedTheme(activity);
    }

    public static void restartWithMixedTheme(Activity activity) {
        ThemeManager.restartWithTheme(activity, 4);
    }

    public static void restartWithTheme(Activity activity, int theme) {
        ThemeManager.restartWithTheme(activity, theme, false);
    }

    public static void restartWithTheme(Activity activity, int theme, boolean force) {
        if (theme < 0x1000000) {
            if (_THEME_MODIFIER > 0) {
                theme |= _THEME_MODIFIER;
            }
            theme &= 0x1F;
        }
        if (force || ThemeManager.getTheme(activity) != theme) {
            Intent intent = activity.getIntent();
            intent.setClass((Context)activity, activity.getClass());
            intent.putExtra(_THEME_TAG, theme);
            if (activity.isRestricted()) {
                Application app = Application.getLastInstance();
                if (app != null && !app.isRestricted()) {
                    intent.addFlags(0x10000000);
                    app.superStartActivity(intent, -1, null);
                }
            } else {
                if (!activity.isFinishing()) {
                    activity.finish();
                }
                if (activity instanceof SuperStartActivity) {
                    ((SuperStartActivity)activity).superStartActivity(intent, -1, null);
                } else {
                    activity.startActivity(intent);
                }
            }
        }
    }

    public static void setDefaultTheme(int theme) {
        _DEFAULT_THEME = theme;
        if (theme < 0x1000000) {
            _DEFAULT_THEME &= 0x1F;
        }
    }

    public static void setModifier(int mod) {
        _THEME_MODIFIER = mod & 0x1F;
    }

    public static void setThemeGetter(ThemeGetter themeGetter) {
        _THEME_GETTER = themeGetter;
    }

    @Deprecated
    public static void setThemeModifier(int mod) {
        ThemeManager.setModifier(mod);
    }

    public static void startActivity(Context context, Intent intent) {
        ThemeManager.startActivity(context, intent, -1);
    }

    public static void startActivity(Context context, Intent intent, Bundle options) {
        ThemeManager.startActivity(context, intent, -1, options);
    }

    public static void startActivity(Context context, Intent intent, int requestCode) {
        ThemeManager.startActivity(context, intent, requestCode, null);
    }

    @SuppressLint(value={"NewApi"})
    public static void startActivity(Context context, Intent intent, int requestCode, Bundle options) {
        Activity activity;
        Activity activity2 = activity = context instanceof Activity ? (Activity)context : null;
        if (activity != null) {
            ThemeManager.cloneTheme(activity.getIntent(), intent, true);
        }
        if (context instanceof SuperStartActivity) {
            ((SuperStartActivity)context).superStartActivity(intent, requestCode, options);
        } else if (activity != null) {
            if (Build.VERSION.SDK_INT >= 16) {
                activity.startActivityForResult(intent, requestCode, options);
            } else {
                activity.startActivityForResult(intent, requestCode);
            }
        } else if (Build.VERSION.SDK_INT >= 16) {
            context.startActivity(intent, options);
        } else {
            context.startActivity(intent);
        }
    }

    private ThemeManager() {
    }

    static {
        _THEME_MODIFIER = 0;
        _THEMES_MAP = new SparseIntArray();
        ThemeManager.map(1, 2131558607);
        ThemeManager.map(17, 2131558612);
        ThemeManager.map(9, 2131558621);
        ThemeManager.map(25, 2131558622);
        ThemeManager.map(2, 2131558613);
        ThemeManager.map(18, 2131558618);
        ThemeManager.map(10, 2131558619);
        ThemeManager.map(26, 2131558620);
        ThemeManager.map(4, 2131558614);
        ThemeManager.map(20, 2131558615);
        ThemeManager.map(12, 2131558616);
        ThemeManager.map(28, 2131558617);
    }

    public static interface ThemeGetter {
        public int getThemeResource(ThemeTag var1);

        public static final class ThemeTag {
            public final boolean dark;
            public final boolean fullscreen;
            public final boolean light;
            public final boolean mixed;
            public final boolean noActionBar;
            public final int flags;

            private ThemeTag(int flags) {
                this.flags = flags;
                this.dark = ThemeManager.isDark(flags);
                this.light = ThemeManager.isLight(flags);
                this.mixed = ThemeManager.isMixed(flags);
                this.noActionBar = ThemeManager.isNoActionBar(flags);
                this.fullscreen = ThemeManager.isFullScreen(flags);
            }
        }
    }

    public static interface SuperStartActivity {
        public void superStartActivity(Intent var1, int var2, Bundle var3);
    }
}

