/*
 * Decompiled with CFR 0.152.
 */
package org.holoeverywhere.app;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.os.Build;
import android.os.Bundle;
import org.holoeverywhere.IHolo;
import org.holoeverywhere.LayoutInflater;
import org.holoeverywhere.Setting;
import org.holoeverywhere.SystemServiceManager;
import org.holoeverywhere.ThemeManager;
import org.holoeverywhere.preference.PreferenceManager;

public class Application
extends android.app.Application
implements IHolo,
ThemeManager.SuperStartActivity,
SystemServiceManager.SuperSystemService {
    private static Application lastInstance;

    public static Config config() {
        return Setting.get(Config.class);
    }

    public static Application getLastInstance() {
        return lastInstance;
    }

    public static boolean isDebugMode() {
        return Application.config().isDebugMode();
    }

    public Application() {
        lastInstance = this;
    }

    @Override
    public Config getConfig() {
        return Application.config();
    }

    @Override
    public org.holoeverywhere.preference.SharedPreferences getDefaultSharedPreferences() {
        return PreferenceManager.getDefaultSharedPreferences((Context)this);
    }

    @Override
    public org.holoeverywhere.preference.SharedPreferences getDefaultSharedPreferences(Config.PreferenceImpl impl) {
        return PreferenceManager.getDefaultSharedPreferences((Context)this, impl);
    }

    @Override
    public LayoutInflater getLayoutInflater() {
        return LayoutInflater.from((Context)this);
    }

    @Override
    public org.holoeverywhere.preference.SharedPreferences getSharedPreferences(Config.PreferenceImpl impl, String name, int mode) {
        return PreferenceManager.wrap((Context)this, impl, name, mode);
    }

    @Override
    public org.holoeverywhere.preference.SharedPreferences getSharedPreferences(String name, int mode) {
        return PreferenceManager.wrap((Context)this, name, mode);
    }

    @Override
    public Application getSupportApplication() {
        return this;
    }

    @Override
    public boolean isABSSupport() {
        return true;
    }

    public void onTerminate() {
        LayoutInflater.clearInstances();
        super.onTerminate();
    }

    @SuppressLint(value={"NewApi"})
    public void startActivities(Intent[] intents) {
        this.startActivities(intents, null);
    }

    @SuppressLint(value={"NewApi"})
    public void startActivities(Intent[] intents, Bundle options) {
        for (Intent intent : intents) {
            this.startActivity(intent, options);
        }
    }

    @SuppressLint(value={"NewApi"})
    public void startActivity(Intent intent) {
        this.startActivity(intent, null);
    }

    public void startActivity(Intent intent, Bundle options) {
        if (Application.config().isAlwaysUseParentTheme()) {
            ThemeManager.startActivity((Context)this, intent, options);
        } else {
            this.superStartActivity(intent, -1, options);
        }
    }

    public SharedPreferences superGetSharedPreferences(String name, int mode) {
        return super.getSharedPreferences(name, mode);
    }

    @Override
    public Object superGetSystemService(String name) {
        return super.getSystemService(name);
    }

    @Override
    @SuppressLint(value={"NewApi"})
    public void superStartActivity(Intent intent, int requestCode, Bundle options) {
        if (Build.VERSION.SDK_INT >= 16) {
            super.startActivity(intent, options);
        } else {
            super.startActivity(intent);
        }
    }

    public static final class Config
    extends Setting<Config> {
        private static final String HOLO_EVERYWHERE_PACKAGE = "org.holoeverywhere";
        private final Setting.SettingListener<Config> _DEFAULT_SETTINGS_LISTENER = new Setting.SettingListener<Config>(){

            @Override
            public void onAttach(Config config) {
                Config.onStateChange(config);
            }

            @Override
            public void onDetach(Config config) {
            }

            @Override
            public void onPropertyChange(Config config, Setting.Property<?> property) {
                if (property == config.holoEverywherePackage) {
                    Config.onStateChange(config);
                }
            }
        };
        @Setting.SettingProperty(create=true, defaultBoolean=false)
        private Setting.BooleanProperty alwaysUseParentTheme;
        @Setting.SettingProperty(create=true, defaultBoolean=false)
        private Setting.BooleanProperty debugMode;
        @Setting.SettingProperty(create=true)
        private Setting.BooleanProperty disableContextMenu;
        @Setting.SettingProperty(create=true, defaultString="org.holoeverywhere")
        private Setting.StringProperty holoEverywherePackage;
        @Setting.SettingProperty(create=true, defaultEnum="XML", enumClass=PreferenceImpl.class)
        private Setting.EnumProperty<PreferenceImpl> preferenceImpl;
        @Setting.SettingProperty(create=true)
        private Setting.StringProperty preferencePackage;
        @Setting.SettingProperty(create=true)
        private Setting.StringProperty widgetsPackage;

        private static void onStateChange(Config config) {
            String p = (String)config.holoEverywherePackage.getValue();
            if (p != null && p.length() > 0) {
                config.setWidgetsPackage(p + ".widget");
                config.setPreferencePackage(p + ".preference");
            }
        }

        public Config attachDefaultListener() {
            return this.addListener(this._DEFAULT_SETTINGS_LISTENER);
        }

        public Config detachDefaultListener() {
            return this.removeListener(this._DEFAULT_SETTINGS_LISTENER);
        }

        public String getHoloEverywherePackage() {
            return (String)this.holoEverywherePackage.getValue();
        }

        public PreferenceImpl getPreferenceImpl() {
            return (PreferenceImpl)((Object)this.preferenceImpl.getValue());
        }

        public String getPreferencePackage() {
            return (String)this.preferencePackage.getValue();
        }

        public String getWidgetsPackage() {
            return (String)this.widgetsPackage.getValue();
        }

        public boolean isAlwaysUseParentTheme() {
            return (Boolean)this.alwaysUseParentTheme.getValue();
        }

        public boolean isDebugMode() {
            return (Boolean)this.debugMode.getValue();
        }

        public boolean isDisableContextMenu() {
            return (Boolean)this.disableContextMenu.getValue();
        }

        @Deprecated
        public boolean isUseThemeManager() {
            return true;
        }

        @Override
        protected void onInit() {
            this.attachDefaultListener();
            SystemServiceManager.register(LayoutInflater.LayoutInflaterCreator.class);
        }

        public Config setAlwaysUseParentTheme(boolean alwaysUseParentTheme) {
            this.alwaysUseParentTheme.setValue(alwaysUseParentTheme);
            return this;
        }

        public Config setDebugMode(boolean debugMode) {
            this.debugMode.setValue(debugMode);
            return this;
        }

        public Config setDisableContextMenu(boolean disableContextMenu) {
            this.disableContextMenu.setValue(disableContextMenu);
            return this;
        }

        public Config setHoloEverywherePackage(String holoEverywherePackage) {
            this.holoEverywherePackage.setValue(holoEverywherePackage);
            return this;
        }

        public Config setPreferenceImpl(PreferenceImpl preferenceImpl) {
            this.preferenceImpl.setValue(preferenceImpl);
            return this;
        }

        public Config setPreferencePackage(String preferencePackage) {
            this.preferencePackage.setValue(preferencePackage);
            return this;
        }

        @Deprecated
        public Config setUseThemeManager(boolean useThemeManager) {
            if (!useThemeManager) {
                throw new RuntimeException("This property always true");
            }
            return this;
        }

        public Config setWidgetsPackage(String widgetsPackage) {
            this.widgetsPackage.setValue(widgetsPackage);
            return this;
        }

        public static enum PreferenceImpl {
            JSON,
            XML;

        }
    }
}

