/*
 * Decompiled with CFR 0.152.
 */
package org.holoeverywhere.app;

import android.app.Activity;
import android.content.Context;
import android.content.DialogInterface;
import android.content.res.TypedArray;
import android.os.Build;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.ContextMenu;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import com.actionbarsherlock.internal.view.menu.ContextMenuBuilder;
import com.actionbarsherlock.internal.view.menu.ContextMenuDecorView;
import com.actionbarsherlock.internal.view.menu.ContextMenuItemWrapper;
import com.actionbarsherlock.internal.view.menu.ContextMenuListener;
import com.actionbarsherlock.internal.view.menu.ContextMenuWrapper;
import com.actionbarsherlock.view.ContextMenu;
import org.holoeverywhere.LayoutInflater;
import org.holoeverywhere.R;

public class Dialog
extends android.app.Dialog
implements ContextMenuListener {
    private static final int checkTheme(Context context, int theme) {
        if (theme >= 0x1000000) {
            return theme;
        }
        TypedValue value = new TypedValue();
        context.getTheme().resolveAttribute(2130772093, value, true);
        if (value.resourceId > 0) {
            return value.resourceId;
        }
        return 2131558608;
    }

    public Dialog(Context context) {
        this(context, 0);
    }

    public Dialog(Context context, boolean cancelable, DialogInterface.OnCancelListener cancelListener) {
        this(context);
        this.setCancelable(cancelable);
        this.setOnCancelListener(cancelListener);
    }

    public Dialog(Context context, int theme) {
        super(context, Dialog.checkTheme(context, theme));
    }

    public void addContentView(View view, ViewGroup.LayoutParams params) {
        super.addContentView(this.prepareDecorView(view), params);
    }

    private void checkWindowSizes() {
        View view = this.findViewById(2131165281);
        if (view == null) {
            view = this.getWindow().getDecorView();
        }
        if (Build.VERSION.SDK_INT < 11 && view != null) {
            DisplayMetrics dm = this.getContext().getResources().getDisplayMetrics();
            TypedArray a = this.getContext().obtainStyledAttributes(R.styleable.HoloActivity);
            int windowMinWidthMajor = (int)a.getFraction(0, dm.widthPixels, 1, 0.0f);
            int windowMinWidthMinor = (int)a.getFraction(1, dm.widthPixels, 1, 0.0f);
            a.recycle();
            if (this.getContext() instanceof Activity) {
                int orientation = ((Activity)this.getContext()).getRequestedOrientation();
                switch (orientation) {
                    case 0: 
                    case 8: {
                        view.setMinimumWidth(windowMinWidthMajor);
                        break;
                    }
                    case 1: 
                    case 9: {
                        view.setMinimumWidth(windowMinWidthMinor);
                    }
                }
            } else {
                int orientation = this.getContext().getResources().getConfiguration().orientation;
                switch (orientation) {
                    case 2: {
                        view.setMinimumWidth(windowMinWidthMajor);
                        break;
                    }
                    case 1: {
                        view.setMinimumWidth(windowMinWidthMinor);
                    }
                }
            }
        }
    }

    @Override
    public void createContextMenu(ContextMenuBuilder contextMenuBuilder, View view, ContextMenu.ContextMenuInfo menuInfo, ContextMenuListener listener) {
        listener.onCreateContextMenu(contextMenuBuilder, view, menuInfo);
    }

    public LayoutInflater getLayoutInflater() {
        return LayoutInflater.from(this.getContext());
    }

    public void onContentChanged() {
        super.onContentChanged();
        this.checkWindowSizes();
    }

    public final boolean onContextItemSelected(MenuItem item) {
        return this.onContextItemSelected(new ContextMenuItemWrapper(item));
    }

    @Override
    public boolean onContextItemSelected(com.actionbarsherlock.view.MenuItem item) {
        if (item instanceof ContextMenuItemWrapper) {
            return super.onContextItemSelected(((ContextMenuItemWrapper)item).unwrap());
        }
        return false;
    }

    @Override
    public void onContextMenuClosed(ContextMenu menu) {
        if (menu instanceof ContextMenuWrapper) {
            super.onContextMenuClosed((Menu)((ContextMenuWrapper)menu).unwrap());
        }
    }

    public final void onContextMenuClosed(Menu menu) {
        if (menu instanceof android.view.ContextMenu) {
            this.onContextMenuClosed(new ContextMenuWrapper((android.view.ContextMenu)menu));
        } else {
            super.onContextMenuClosed(menu);
        }
    }

    public final void onCreateContextMenu(android.view.ContextMenu menu, View view, ContextMenu.ContextMenuInfo menuInfo) {
        this.onCreateContextMenu(new ContextMenuWrapper(menu), view, menuInfo);
    }

    @Override
    public void onCreateContextMenu(ContextMenu menu, View view, ContextMenu.ContextMenuInfo menuInfo) {
        if (menu instanceof ContextMenuWrapper) {
            super.onCreateContextMenu(((ContextMenuWrapper)menu).unwrap(), view, menuInfo);
        }
    }

    public View prepareDecorView(View v) {
        return ContextMenuDecorView.prepareDecorView(this.getContext(), v, this, 0);
    }

    public void setContentView(int layoutResID) {
        this.setContentView(this.getLayoutInflater().inflate(layoutResID));
    }

    public void setContentView(View view) {
        super.setContentView(this.prepareDecorView(view));
    }

    public void setContentView(View view, ViewGroup.LayoutParams params) {
        super.setContentView(this.prepareDecorView(view), params);
    }
}

