/*
 * Decompiled with CFR 0.152.
 */
package org.holoeverywhere.app;

import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentTransaction;
import android.view.View;
import java.util.Random;
import org.holoeverywhere.LayoutInflater;
import org.holoeverywhere.app.Activity;
import org.holoeverywhere.app.AlertDialog;
import org.holoeverywhere.app.Dialog;
import org.holoeverywhere.app.Fragment;

public class DialogFragment
extends Fragment
implements DialogInterface.OnCancelListener,
DialogInterface.OnDismissListener {
    private static final String SAVED_BACK_STACK_ID = "android:backStackId";
    private static final String SAVED_CANCELABLE = "android:cancelable";
    private static final String SAVED_DIALOG_STATE_TAG = "android:savedDialogState";
    private static final String SAVED_SHOWS_DIALOG = "android:showsDialog";
    private static final String SAVED_STYLE = "android:style";
    private static final String SAVED_THEME = "android:theme";
    public static final int STYLE_NO_FRAME = 2;
    public static final int STYLE_NO_INPUT = 3;
    public static final int STYLE_NO_TITLE = 1;
    public static final int STYLE_NORMAL = 0;
    private final String DIALOG_TAG = this.getClass().getName() + "@" + Integer.toHexString(new Random().nextInt(Integer.MAX_VALUE));
    int mBackStackId = -1;
    boolean mCancelable = true;
    Dialog mDialog;
    boolean mDismissed = true;
    boolean mShownByMe;
    boolean mShowsDialog = true;
    int mStyle = 0;
    int mTheme = 0;
    boolean mViewDestroyed;
    private DialogType type = DialogType.Dialog;

    public void dismiss() {
        this.dismissInternal(false);
    }

    public void dismissAllowingStateLoss() {
        this.dismissInternal(true);
    }

    void dismissInternal(boolean allowStateLoss) {
        if (this.mDismissed) {
            return;
        }
        this.mDismissed = true;
        this.mShownByMe = false;
        if (this.mDialog != null) {
            this.mDialog.dismiss();
            this.mDialog = null;
        }
        this.mViewDestroyed = true;
        if (this.mBackStackId >= 0) {
            this.getFragmentManager().popBackStack(this.mBackStackId, 1);
            this.mBackStackId = -1;
        } else {
            FragmentTransaction ft = this.getFragmentManager().beginTransaction();
            ft.remove((android.support.v4.app.Fragment)this);
            if (allowStateLoss) {
                ft.commitAllowingStateLoss();
            } else {
                ft.commit();
            }
        }
    }

    public Dialog getDialog() {
        return this.mDialog;
    }

    public DialogType getDialogType() {
        return this.type;
    }

    @Override
    public LayoutInflater getLayoutInflater(Bundle savedInstanceState) {
        if (!this.mShowsDialog) {
            return super.getLayoutInflater(savedInstanceState);
        }
        this.mDialog = this.onCreateDialog(savedInstanceState);
        switch (this.mStyle) {
            case 3: {
                this.mDialog.getWindow().addFlags(24);
            }
            case 1: 
            case 2: {
                this.mDialog.requestWindowFeature(1);
            }
        }
        if (this.mDialog != null) {
            return LayoutInflater.from(this.mDialog.getContext());
        }
        return LayoutInflater.from((Context)this.getActivity());
    }

    public boolean getShowsDialog() {
        return this.mShowsDialog;
    }

    public int getTheme() {
        return this.mTheme;
    }

    public boolean isCancelable() {
        return this.mCancelable;
    }

    public void onActivityCreated(Bundle savedInstanceState) {
        Bundle dialogState;
        super.onActivityCreated(savedInstanceState);
        if (!this.mShowsDialog) {
            return;
        }
        View view = this.getView();
        if (view != null) {
            if (view.getParent() != null) {
                throw new IllegalStateException("DialogFragment can not be attached to a container view");
            }
            if (this.mDialog instanceof AlertDialog) {
                ((AlertDialog)this.mDialog).setView(view);
            } else {
                this.mDialog.setContentView(view);
            }
        }
        this.mDialog.setOwnerActivity((android.app.Activity)this.getActivity());
        this.mDialog.setCancelable(this.mCancelable);
        this.mDialog.setOnCancelListener(this);
        this.mDialog.setOnDismissListener(this);
        if (savedInstanceState != null && (dialogState = savedInstanceState.getBundle(SAVED_DIALOG_STATE_TAG)) != null) {
            this.mDialog.onRestoreInstanceState(dialogState);
        }
    }

    @Override
    public void onAttach(Activity activity) {
        super.onAttach(activity);
        if (!this.mShownByMe) {
            this.mDismissed = false;
        }
    }

    public void onCancel(DialogInterface dialog) {
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        boolean bl = this.mShowsDialog = this.getContainerId() == 0;
        if (savedInstanceState != null) {
            this.mStyle = savedInstanceState.getInt(SAVED_STYLE, 0);
            this.mTheme = savedInstanceState.getInt(SAVED_THEME, 0);
            this.mCancelable = savedInstanceState.getBoolean(SAVED_CANCELABLE, true);
            this.mShowsDialog = savedInstanceState.getBoolean(SAVED_SHOWS_DIALOG, this.mShowsDialog);
            this.mBackStackId = savedInstanceState.getInt(SAVED_BACK_STACK_ID, -1);
        }
    }

    public Dialog onCreateDialog(Bundle savedInstanceState) {
        switch (this.type) {
            case AlertDialog: {
                return new AlertDialog((Context)this.getActivity(), this.getTheme());
            }
        }
        return new Dialog((Context)this.getActivity(), this.getTheme());
    }

    public void onDestroyView() {
        super.onDestroyView();
        if (this.mDialog != null) {
            this.mViewDestroyed = true;
            this.mDialog.dismiss();
            this.mDialog = null;
        }
    }

    public void onDetach() {
        super.onDetach();
        if (!this.mShownByMe && !this.mDismissed) {
            this.mDismissed = true;
        }
    }

    public void onDismiss(DialogInterface dialog) {
        if (!this.mViewDestroyed) {
            this.dismissInternal(true);
        }
    }

    public void onSaveInstanceState(Bundle outState) {
        Bundle dialogState;
        super.onSaveInstanceState(outState);
        if (this.mDialog != null && (dialogState = this.mDialog.onSaveInstanceState()) != null) {
            outState.putBundle(SAVED_DIALOG_STATE_TAG, dialogState);
        }
        if (this.mStyle != 0) {
            outState.putInt(SAVED_STYLE, this.mStyle);
        }
        if (this.mTheme != 0) {
            outState.putInt(SAVED_THEME, this.mTheme);
        }
        if (!this.mCancelable) {
            outState.putBoolean(SAVED_CANCELABLE, this.mCancelable);
        }
        if (!this.mShowsDialog) {
            outState.putBoolean(SAVED_SHOWS_DIALOG, this.mShowsDialog);
        }
        if (this.mBackStackId != -1) {
            outState.putInt(SAVED_BACK_STACK_ID, this.mBackStackId);
        }
    }

    public void onStart() {
        super.onStart();
        if (this.mDialog != null) {
            this.mViewDestroyed = false;
            this.mDialog.show();
        }
    }

    public void onStop() {
        super.onStop();
        if (this.mDialog != null) {
            this.mDialog.hide();
        }
    }

    public void setCancelable(boolean cancelable) {
        this.mCancelable = cancelable;
        if (this.mDialog != null) {
            this.mDialog.setCancelable(cancelable);
        }
    }

    public void setDialogType(DialogType type) {
        this.type = type;
    }

    public void setShowsDialog(boolean showsDialog) {
        this.mShowsDialog = showsDialog;
    }

    public void setStyle(int style2, int theme) {
        this.mStyle = style2;
        if (this.mStyle == 2 || this.mStyle == 3) {
            this.mTheme = 16973913;
        }
        if (theme != 0) {
            this.mTheme = theme;
        }
    }

    public DialogTransaction show() {
        return this.show(this.getSupportFragmentManager());
    }

    public DialogTransaction show(Activity activity) {
        return this.show(activity == null ? null : activity.getSupportFragmentManager());
    }

    public DialogTransaction show(FragmentManager fm) {
        return this.show(fm, fm == null ? null : fm.beginTransaction());
    }

    public DialogTransaction show(FragmentManager fm, FragmentTransaction ft) {
        if (ft == null) {
            if (fm == null) {
                Activity activity = this.getSupportActivity();
                if (activity == null) {
                    throw new RuntimeException("DialogFragment don't have any reference to Context or FragmentManager");
                }
                fm = activity.getSupportFragmentManager();
            }
            ft = fm.beginTransaction();
        }
        if (!this.mDismissed) {
            this.dismiss();
        }
        DialogTransaction dialogTransaction = new DialogTransaction();
        dialogTransaction.fragmentManager = fm;
        dialogTransaction.dialogTag = this.DIALOG_TAG;
        dialogTransaction.transactionId = this.show(ft, this.DIALOG_TAG);
        return dialogTransaction;
    }

    @Deprecated
    public void show(FragmentManager manager, String tag) {
        this.mDismissed = false;
        this.mShownByMe = true;
        FragmentTransaction ft = manager.beginTransaction();
        ft.add((android.support.v4.app.Fragment)this, tag);
        ft.commit();
    }

    public DialogTransaction show(FragmentTransaction ft) {
        return this.show(null, ft);
    }

    @Deprecated
    public int show(FragmentTransaction transaction, String tag) {
        this.mDismissed = false;
        this.mShownByMe = true;
        transaction.add((android.support.v4.app.Fragment)this, tag);
        this.mViewDestroyed = false;
        this.mBackStackId = transaction.commit();
        return this.mBackStackId;
    }

    public static enum DialogType {
        AlertDialog,
        Dialog;

    }

    public static final class DialogTransaction {
        public String dialogTag;
        public FragmentManager fragmentManager;
        public int transactionId;
    }
}

