/*
 * Decompiled with CFR 0.152.
 */
package org.holoeverywhere.app;

import android.content.Context;
import android.content.DialogInterface;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.text.SpannableString;
import android.text.style.StyleSpan;
import android.view.View;
import android.widget.TextView;
import java.text.NumberFormat;
import org.holoeverywhere.R;
import org.holoeverywhere.app.AlertDialog;
import org.holoeverywhere.widget.ProgressBar;

public class ProgressDialog
extends AlertDialog {
    public static final int STYLE_HORIZONTAL = 1;
    public static final int STYLE_SPINNER = 0;
    private boolean mHasStarted;
    private int mIncrementBy;
    private int mIncrementSecondaryBy;
    private boolean mIndeterminate;
    private Drawable mIndeterminateDrawable;
    private int mMax;
    private CharSequence mMessage;
    private TextView mMessageView;
    private ProgressBar mProgress;
    private Drawable mProgressDrawable;
    private TextView mProgressNumber;
    private String mProgressNumberFormat;
    private TextView mProgressPercent;
    private NumberFormat mProgressPercentFormat;
    private int mProgressStyle = 0;
    private int mProgressVal;
    private int mSecondaryProgressVal;
    private Handler mViewUpdateHandler;

    public static ProgressDialog show(Context context, CharSequence title, CharSequence message) {
        return ProgressDialog.show(context, title, message, false);
    }

    public static ProgressDialog show(Context context, CharSequence title, CharSequence message, boolean indeterminate) {
        return ProgressDialog.show(context, title, message, indeterminate, false, null);
    }

    public static ProgressDialog show(Context context, CharSequence title, CharSequence message, boolean indeterminate, boolean cancelable) {
        return ProgressDialog.show(context, title, message, indeterminate, cancelable, null);
    }

    public static ProgressDialog show(Context context, CharSequence title, CharSequence message, boolean indeterminate, boolean cancelable, DialogInterface.OnCancelListener cancelListener) {
        ProgressDialog dialog = new ProgressDialog(context);
        dialog.setTitle(title);
        dialog.setMessage(message);
        dialog.setIndeterminate(indeterminate);
        dialog.setCancelable(cancelable);
        dialog.setOnCancelListener(cancelListener);
        dialog.show();
        return dialog;
    }

    public ProgressDialog(Context context) {
        super(context);
        this.initFormats();
    }

    public ProgressDialog(Context context, int theme) {
        super(context, theme);
        this.initFormats();
    }

    public int getMax() {
        if (this.mProgress != null) {
            return this.mProgress.getMax();
        }
        return this.mMax;
    }

    public int getProgress() {
        if (this.mProgress != null) {
            return this.mProgress.getProgress();
        }
        return this.mProgressVal;
    }

    public int getSecondaryProgress() {
        if (this.mProgress != null) {
            return this.mProgress.getSecondaryProgress();
        }
        return this.mSecondaryProgressVal;
    }

    public void incrementProgressBy(int diff) {
        if (this.mProgress != null) {
            this.mProgress.incrementProgressBy(diff);
            this.onProgressChanged();
        } else {
            this.mIncrementBy += diff;
        }
    }

    public void incrementSecondaryProgressBy(int diff) {
        if (this.mProgress != null) {
            this.mProgress.incrementSecondaryProgressBy(diff);
            this.onProgressChanged();
        } else {
            this.mIncrementSecondaryBy += diff;
        }
    }

    private void initFormats() {
        this.mProgressNumberFormat = "%1d/%2d";
        this.mProgressPercentFormat = NumberFormat.getPercentInstance();
        this.mProgressPercentFormat.setMaximumFractionDigits(0);
    }

    public boolean isIndeterminate() {
        if (this.mProgress != null) {
            return this.mProgress.isIndeterminate();
        }
        return this.mIndeterminate;
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        View view;
        TypedArray a = this.getContext().obtainStyledAttributes(null, R.styleable.AlertDialog, 2130772091, 2131558493);
        if (this.mProgressStyle == 1) {
            this.mViewUpdateHandler = new Handler(){

                public void handleMessage(Message msg) {
                    super.handleMessage(msg);
                    int progress = ProgressDialog.this.mProgress.getProgress();
                    int max = ProgressDialog.this.mProgress.getMax();
                    if (ProgressDialog.this.mProgressNumberFormat != null) {
                        String format = ProgressDialog.this.mProgressNumberFormat;
                        ProgressDialog.this.mProgressNumber.setText((CharSequence)String.format(format, progress, max));
                    } else {
                        ProgressDialog.this.mProgressNumber.setText((CharSequence)"");
                    }
                    if (ProgressDialog.this.mProgressPercentFormat != null) {
                        double percent = (double)progress / (double)max;
                        SpannableString tmp = new SpannableString((CharSequence)ProgressDialog.this.mProgressPercentFormat.format(percent));
                        tmp.setSpan((Object)new StyleSpan(1), 0, tmp.length(), 33);
                        ProgressDialog.this.mProgressPercent.setText((CharSequence)tmp);
                    } else {
                        ProgressDialog.this.mProgressPercent.setText((CharSequence)"");
                    }
                }
            };
            view = this.getLayoutInflater().inflate(a.getResourceId(16, 2130903065));
            this.mProgress = (ProgressBar)view.findViewById(2131165227);
            this.mProgressNumber = (TextView)view.findViewById(2131165288);
            this.mProgressPercent = (TextView)view.findViewById(2131165287);
        } else {
            view = this.getLayoutInflater().inflate(a.getResourceId(15, 2130903096));
            this.mProgress = (ProgressBar)view.findViewById(2131165227);
            this.mMessageView = (TextView)view.findViewById(2131165279);
        }
        this.setView(view);
        a.recycle();
        if (this.mMax > 0) {
            this.setMax(this.mMax);
        }
        if (this.mProgressVal > 0) {
            this.setProgress(this.mProgressVal);
        }
        if (this.mSecondaryProgressVal > 0) {
            this.setSecondaryProgress(this.mSecondaryProgressVal);
        }
        if (this.mIncrementBy > 0) {
            this.incrementProgressBy(this.mIncrementBy);
        }
        if (this.mIncrementSecondaryBy > 0) {
            this.incrementSecondaryProgressBy(this.mIncrementSecondaryBy);
        }
        if (this.mProgressDrawable != null) {
            this.setProgressDrawable(this.mProgressDrawable);
        }
        if (this.mIndeterminateDrawable != null) {
            this.setIndeterminateDrawable(this.mIndeterminateDrawable);
        }
        if (this.mMessage != null) {
            this.setMessage(this.mMessage);
        }
        this.setIndeterminate(this.mIndeterminate);
        this.onProgressChanged();
        super.onCreate(savedInstanceState);
    }

    private void onProgressChanged() {
        if (this.mProgressStyle == 1 && this.mViewUpdateHandler != null && !this.mViewUpdateHandler.hasMessages(0)) {
            this.mViewUpdateHandler.sendEmptyMessage(0);
        }
    }

    public void onStart() {
        super.onStart();
        this.mHasStarted = true;
    }

    protected void onStop() {
        super.onStop();
        this.mHasStarted = false;
    }

    public void setIndeterminate(boolean indeterminate) {
        if (this.mProgress != null) {
            this.mProgress.setIndeterminate(indeterminate);
        } else {
            this.mIndeterminate = indeterminate;
        }
    }

    public void setIndeterminateDrawable(Drawable d) {
        if (this.mProgress != null) {
            this.mProgress.setIndeterminateDrawable(d);
        } else {
            this.mIndeterminateDrawable = d;
        }
    }

    public void setMax(int max) {
        if (this.mProgress != null) {
            this.mProgress.setMax(max);
            this.onProgressChanged();
        } else {
            this.mMax = max;
        }
    }

    @Override
    public void setMessage(CharSequence message) {
        if (this.mProgress != null) {
            if (this.mProgressStyle == 1) {
                super.setMessage(message);
            } else {
                this.mMessageView.setText(message);
            }
        } else {
            this.mMessage = message;
        }
    }

    public void setProgress(int value) {
        if (this.mHasStarted) {
            this.mProgress.setProgress(value);
            this.onProgressChanged();
        } else {
            this.mProgressVal = value;
        }
    }

    public void setProgressDrawable(Drawable d) {
        if (this.mProgress != null) {
            this.mProgress.setProgressDrawable(d);
        } else {
            this.mProgressDrawable = d;
        }
    }

    public void setProgressNumberFormat(String format) {
        this.mProgressNumberFormat = format;
        this.onProgressChanged();
    }

    public void setProgressPercentFormat(NumberFormat format) {
        this.mProgressPercentFormat = format;
        this.onProgressChanged();
    }

    public void setProgressStyle(int style2) {
        this.mProgressStyle = style2;
    }

    public void setSecondaryProgress(int secondaryProgress) {
        if (this.mProgress != null) {
            this.mProgress.setSecondaryProgress(secondaryProgress);
            this.onProgressChanged();
        } else {
            this.mSecondaryProgressVal = secondaryProgress;
        }
    }
}

