/*
 * Decompiled with CFR 0.152.
 */
package org.holoeverywhere.internal;

import android.content.Context;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.net.Uri;
import android.text.TextUtils;
import java.io.FileNotFoundException;
import java.util.List;

public class ContentResolverCompat {
    public static OpenResourceIdResult getResourceId(Context context, Uri uri) throws FileNotFoundException {
        int id2;
        Resources r;
        String authority = uri.getAuthority();
        if (TextUtils.isEmpty((CharSequence)authority)) {
            throw new FileNotFoundException("No authority: " + uri);
        }
        try {
            r = context.getPackageManager().getResourcesForApplication(authority);
        }
        catch (PackageManager.NameNotFoundException ex) {
            throw new FileNotFoundException("No package found for authority: " + uri);
        }
        List path = uri.getPathSegments();
        if (path == null) {
            throw new FileNotFoundException("No path: " + uri);
        }
        int len = path.size();
        if (len == 1) {
            try {
                id2 = Integer.parseInt((String)path.get(0));
            }
            catch (NumberFormatException e) {
                throw new FileNotFoundException("Single path segment is not a resource ID: " + uri);
            }
        } else if (len == 2) {
            id2 = r.getIdentifier((String)path.get(1), (String)path.get(0), authority);
        } else {
            throw new FileNotFoundException("More than two path segments: " + uri);
        }
        if (id2 == 0) {
            throw new FileNotFoundException("No resource found for: " + uri);
        }
        OpenResourceIdResult res = new OpenResourceIdResult();
        res.r = r;
        res.id = id2;
        return res;
    }

    private ContentResolverCompat() {
    }

    public static class OpenResourceIdResult {
        public int id;
        public Resources r;
    }
}

