/*
 * Decompiled with CFR 0.152.
 */
package org.holoeverywhere.internal;

import android.content.Context;
import android.content.res.XmlResourceParser;
import android.util.AttributeSet;
import android.util.Xml;
import android.view.InflateException;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public abstract class GenericInflater<T, P extends Parent<T>> {
    protected static final HashMap<String, Constructor<?>> constructorMap = new HashMap();
    protected static final Class<?>[] constructorSignature = new Class[]{Context.class, AttributeSet.class};
    protected final Object[] constructorArgs = new Object[2];
    protected final Context context;
    private String defaultPackage;
    private Factory<T> factory;
    private boolean factorySet;

    protected GenericInflater(Context context) {
        this.context = context;
    }

    protected GenericInflater(GenericInflater<T, P> original, Context newContext) {
        this.context = newContext;
        this.factory = original.factory;
    }

    public abstract GenericInflater<T, P> cloneInContext(Context var1);

    public final T createItem(String name, String prefix, AttributeSet attrs) throws ClassNotFoundException, InflateException {
        Constructor<?> constructor = constructorMap.get(name);
        try {
            if (constructor == null) {
                Class<?> clazz = this.context.getClassLoader().loadClass(prefix != null ? prefix + name : name);
                constructor = this.findConstructor(clazz);
                constructorMap.put(name, constructor);
            }
            Object[] args = this.constructorArgs;
            args[1] = attrs;
            return (T)constructor.newInstance(args);
        }
        catch (NoSuchMethodException e) {
            InflateException ie = new InflateException(attrs.getPositionDescription() + ": Error inflating class " + (prefix != null ? prefix + name : name));
            ie.initCause((Throwable)e);
            throw ie;
        }
        catch (Exception e) {
            InflateException ie = new InflateException(attrs.getPositionDescription() + ": Error inflating class " + constructor.toString());
            ie.initCause((Throwable)e);
            throw ie;
        }
    }

    private final T createItemFromTag(XmlPullParser parser, String name, AttributeSet attrs) {
        try {
            T item;
            T t = item = this.factory == null ? null : (T)this.factory.onCreateItem(name, this.context, attrs);
            if (item == null) {
                item = name.indexOf(46) < 0 ? (T)this.onCreateItem(name, attrs) : (T)this.createItem(name, null, attrs);
            }
            return item;
        }
        catch (InflateException e) {
            throw e;
        }
        catch (ClassNotFoundException e) {
            InflateException ie = new InflateException(attrs.getPositionDescription() + ": Error inflating class " + name);
            ie.initCause((Throwable)e);
            throw ie;
        }
        catch (Exception e) {
            InflateException ie = new InflateException(attrs.getPositionDescription() + ": Error inflating class " + name);
            ie.initCause((Throwable)e);
            throw ie;
        }
    }

    protected Constructor<?> findConstructor(Class<?> clazz) throws NoSuchMethodException {
        return clazz.getConstructor(constructorSignature);
    }

    public Context getContext() {
        return this.context;
    }

    public String getDefaultPackage() {
        return this.defaultPackage;
    }

    public final Factory<T> getFactory() {
        return this.factory;
    }

    public T inflate(int resource, P root) {
        return this.inflate(resource, root, root != null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T inflate(int resource, P root, boolean attachToRoot) {
        XmlResourceParser parser = this.getContext().getResources().getXml(resource);
        try {
            T t = this.inflate((XmlPullParser)parser, root, attachToRoot);
            return t;
        }
        finally {
            parser.close();
        }
    }

    public T inflate(XmlPullParser parser, P root) {
        return this.inflate(parser, root, root != null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T inflate(XmlPullParser parser, P root, boolean attachToRoot) {
        Object[] objectArray = this.constructorArgs;
        synchronized (this.constructorArgs) {
            AttributeSet attrs = Xml.asAttributeSet((XmlPullParser)parser);
            this.constructorArgs[0] = this.context;
            Object result = root;
            try {
                int type;
                while ((type = parser.next()) != 2 && type != 1) {
                }
                if (type != 2) {
                    throw new InflateException(parser.getPositionDescription() + ": No start tag found!");
                }
                T xmlRoot = this.createItemFromTag(parser, parser.getName(), attrs);
                result = this.onMergeRoots(root, attachToRoot, (Parent)xmlRoot);
                this.rInflate(parser, result, attrs);
            }
            catch (InflateException e) {
                throw e;
            }
            catch (XmlPullParserException e) {
                InflateException ex = new InflateException(e.getMessage());
                ex.initCause((Throwable)e);
                throw ex;
            }
            catch (IOException e) {
                InflateException ex = new InflateException(parser.getPositionDescription() + ": " + e.getMessage());
                ex.initCause((Throwable)e);
                throw ex;
            }
            return (T)result;
        }
    }

    protected boolean onCreateCustomFromTag(XmlPullParser parser, T parent, AttributeSet attrs) throws XmlPullParserException {
        return false;
    }

    protected T onCreateItem(String name, AttributeSet attrs) throws ClassNotFoundException {
        return this.createItem(name, this.defaultPackage, attrs);
    }

    protected P onMergeRoots(P givenRoot, boolean attachToGivenRoot, P xmlRoot) {
        return xmlRoot;
    }

    private void rInflate(XmlPullParser parser, T parent, AttributeSet attrs) throws XmlPullParserException, IOException {
        int type;
        int depth = parser.getDepth();
        while (((type = parser.next()) != 3 || parser.getDepth() > depth) && type != 1) {
            if (type != 2 || this.onCreateCustomFromTag(parser, parent, attrs)) continue;
            String name = parser.getName();
            T item = this.createItemFromTag(parser, name, attrs);
            ((Parent)parent).addItemFromInflater(item);
            this.rInflate(parser, item, attrs);
        }
    }

    public void setDefaultPackage(String defaultPackage) {
        this.defaultPackage = defaultPackage;
    }

    public void setFactory(Factory<T> factory) {
        if (this.factorySet) {
            throw new IllegalStateException("A factory has already been set on this inflater");
        }
        if (factory == null) {
            throw new NullPointerException("Given factory can not be null");
        }
        this.factorySet = true;
        this.factory = this.factory == null ? factory : new FactoryMerger<T>(factory, this.factory);
    }

    public static interface Parent<T> {
        public void addItemFromInflater(T var1);
    }

    private static class FactoryMerger<T>
    implements Factory<T> {
        private final Factory<T> mF1;
        private final Factory<T> mF2;

        FactoryMerger(Factory<T> f1, Factory<T> f2) {
            this.mF1 = f1;
            this.mF2 = f2;
        }

        @Override
        public T onCreateItem(String name, Context context, AttributeSet attrs) {
            T v = this.mF1.onCreateItem(name, context, attrs);
            if (v != null) {
                return v;
            }
            return this.mF2.onCreateItem(name, context, attrs);
        }
    }

    public static interface Factory<T> {
        public T onCreateItem(String var1, Context var2, AttributeSet var3);
    }
}

