/*
 * Decompiled with CFR 0.152.
 */
package org.holoeverywhere.internal;

import android.app.Activity;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.database.Cursor;
import android.media.Ringtone;
import android.media.RingtoneManager;
import android.net.Uri;
import android.os.Handler;
import android.provider.Settings;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.TextView;
import org.holoeverywhere.LayoutInflater;
import org.holoeverywhere.app.AlertDialog;
import org.holoeverywhere.internal.AlertController;
import org.holoeverywhere.widget.ListView;

public class RingtonePicker
implements AdapterView.OnItemSelectedListener,
Runnable,
DialogInterface.OnClickListener,
AlertController.AlertParams.OnPrepareListViewListener,
DialogInterface.OnCancelListener,
DialogInterface.OnDismissListener {
    private static final int DELAY_MS_SELECTION_PLAYED = 300;
    private AlertDialog.Builder builder;
    private int clickedPos = -1;
    private int defaultRingtonePos = -1;
    private int sampleRingtonePos = -1;
    private int silentPos = -1;
    private int staticItemCount;
    private Context context;
    private Cursor cursor;
    private Ringtone defaultRingtone;
    private AlertDialog dialog;
    private Uri existingUri;
    private Handler handler;
    private boolean hasDefaultItem;
    private boolean hasSilentItem;
    private final Intent intent;
    private final RingtonePickerListener listener;
    private RingtoneManager ringtoneManager;
    private Uri uriForDefaultItem;

    public RingtonePicker(Context context, Intent intent, RingtonePickerListener listener) {
        this.context = context;
        this.intent = intent;
        this.listener = listener;
    }

    private int addDefaultRingtoneItem(ListView listView) {
        return this.addStaticItem(listView, 2131492898);
    }

    private int addSilentItem(ListView listView) {
        return this.addStaticItem(listView, 2131492900);
    }

    private int addStaticItem(ListView listView, int textResId) {
        TextView textView = (TextView)LayoutInflater.inflate(this.context, 2130903100, (ViewGroup)listView, false);
        textView.setText(textResId);
        listView.addHeaderView((View)textView);
        ++this.staticItemCount;
        return listView.getHeaderViewsCount() - 1;
    }

    public RingtonePicker cancel() {
        if (this.dialog != null) {
            this.dialog.cancel();
        }
        return this;
    }

    public RingtonePicker create() {
        if (this.dialog != null) {
            return this;
        }
        this.handler = new Handler();
        this.hasDefaultItem = this.intent.getBooleanExtra("android.intent.extra.ringtone.SHOW_DEFAULT", true);
        this.uriForDefaultItem = (Uri)this.intent.getParcelableExtra("android.intent.extra.ringtone.DEFAULT_URI");
        if (this.uriForDefaultItem == null) {
            this.uriForDefaultItem = Settings.System.DEFAULT_RINGTONE_URI;
        }
        this.hasSilentItem = this.intent.getBooleanExtra("android.intent.extra.ringtone.SHOW_SILENT", true);
        this.ringtoneManager = new RingtoneManager(this.context);
        boolean includeDrm = this.intent.getBooleanExtra("android.intent.extra.ringtone.INCLUDE_DRM", true);
        this.ringtoneManager.setIncludeDrm(includeDrm);
        int types = this.intent.getIntExtra("android.intent.extra.ringtone.TYPE", -1);
        if (types != -1) {
            this.ringtoneManager.setType(types);
        }
        this.cursor = this.ringtoneManager.getCursor();
        if (this.context instanceof Activity) {
            ((Activity)this.context).setVolumeControlStream(this.ringtoneManager.inferStreamType());
        }
        this.existingUri = (Uri)this.intent.getParcelableExtra("android.intent.extra.ringtone.EXISTING_URI");
        this.builder = new AlertDialog.Builder(this.context);
        this.dialog = this.onCreateDialog(this.builder);
        return this;
    }

    public RingtonePicker dismiss() {
        if (this.dialog != null) {
            this.dialog.dismiss();
        }
        return this;
    }

    private CharSequence getDialogTitle() {
        if (this.intent.hasExtra("android.intent.extra.ringtone.TITLE")) {
            return this.intent.getCharSequenceExtra("android.intent.extra.ringtone.TITLE");
        }
        return this.context.getText(2131492899);
    }

    private int getListPosition(int ringtoneManagerPos) {
        if (ringtoneManagerPos < 0) {
            return ringtoneManagerPos;
        }
        return ringtoneManagerPos + this.staticItemCount;
    }

    private int getRingtoneManagerPosition(int listPos) {
        return listPos - this.staticItemCount;
    }

    public void onCancel(DialogInterface dialog) {
        this.stopAnyPlayingRingtone();
    }

    public void onClick(DialogInterface dialog, int which) {
        boolean positiveResult = which == -1;
        this.ringtoneManager.stopPreviousRingtone();
        if (positiveResult) {
            Object uri = null;
            uri = this.clickedPos == this.defaultRingtonePos ? this.uriForDefaultItem : (this.clickedPos == this.silentPos ? null : this.ringtoneManager.getRingtoneUri(this.getRingtoneManagerPosition(this.clickedPos)));
            if (this.listener != null) {
                this.listener.onRingtonePickerChanged((Uri)uri);
            }
        } else if (this.listener != null) {
            this.listener.onRingtonePickerCanceled();
        }
    }

    private AlertDialog onCreateDialog(AlertDialog.Builder builder) {
        builder.setPositiveButton(17039370, (DialogInterface.OnClickListener)this);
        builder.setNegativeButton(0x1040000, (DialogInterface.OnClickListener)this);
        builder.setOnPrepareListViewListener(this);
        builder.setSingleChoiceItems(this.cursor, -1, "title", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                RingtonePicker.this.clickedPos = which;
                RingtonePicker.this.playRingtone(which, 0);
            }
        });
        builder.setTitle(this.getDialogTitle());
        builder.setOnCancelListener(this);
        AlertDialog dialog = builder.create();
        dialog.setOnDismissListener(this);
        return dialog;
    }

    public void onDismiss(DialogInterface dialog) {
        this.stopAnyPlayingRingtone();
    }

    public void onItemSelected(AdapterView<?> parent, View view, int position, long id2) {
        this.playRingtone(position, 300);
    }

    public void onNothingSelected(AdapterView<?> parent) {
    }

    @Override
    public void onPrepareListView(ListView listView) {
        if (this.hasDefaultItem) {
            this.defaultRingtonePos = this.addDefaultRingtoneItem(listView);
            if (RingtoneManager.isDefault((Uri)this.existingUri)) {
                this.clickedPos = this.defaultRingtonePos;
            }
        }
        if (this.hasSilentItem) {
            this.silentPos = this.addSilentItem(listView);
            if (this.existingUri == null) {
                this.clickedPos = this.silentPos;
            }
        }
        if (this.clickedPos == -1) {
            this.clickedPos = this.getListPosition(this.ringtoneManager.getRingtonePosition(this.existingUri));
        }
        this.builder.setCheckedItem(this.clickedPos);
    }

    private void playRingtone(int position, int delayMs) {
        this.handler.removeCallbacks((Runnable)this);
        this.sampleRingtonePos = position;
        this.handler.postDelayed((Runnable)this, (long)delayMs);
    }

    @Override
    public void run() {
        Ringtone ringtone;
        if (this.sampleRingtonePos == this.silentPos) {
            this.ringtoneManager.stopPreviousRingtone();
            return;
        }
        if (this.defaultRingtone != null && this.defaultRingtone.isPlaying()) {
            this.defaultRingtone.stop();
            this.defaultRingtone = null;
        }
        if (this.sampleRingtonePos == this.defaultRingtonePos) {
            if (this.defaultRingtone == null) {
                this.defaultRingtone = RingtoneManager.getRingtone((Context)this.context, (Uri)this.uriForDefaultItem);
            }
            ringtone = this.defaultRingtone;
            this.ringtoneManager.stopPreviousRingtone();
        } else {
            ringtone = this.ringtoneManager.getRingtone(this.getRingtoneManagerPosition(this.sampleRingtonePos));
        }
        if (ringtone != null) {
            ringtone.play();
        }
    }

    public RingtonePicker show() {
        this.create();
        this.dialog.show();
        return this;
    }

    private void stopAnyPlayingRingtone() {
        if (this.defaultRingtone != null && this.defaultRingtone.isPlaying()) {
            this.defaultRingtone.stop();
        }
        if (this.ringtoneManager != null) {
            this.ringtoneManager.stopPreviousRingtone();
        }
    }

    public static interface RingtonePickerListener {
        public void onRingtonePickerCanceled();

        public void onRingtonePickerChanged(Uri var1);
    }
}

