/*
 * Decompiled with CFR 0.152.
 */
package org.holoeverywhere.internal;

import android.content.Context;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.Window;

public class WindowCompat {
    private static boolean isOutOfBounds(Window window, MotionEvent event) {
        int x = (int)event.getX();
        int y = (int)event.getY();
        int slop = ViewConfiguration.get((Context)window.getContext()).getScaledWindowTouchSlop();
        View decorView = window.getDecorView();
        return x < -slop || y < -slop || x > decorView.getWidth() + slop || y > decorView.getHeight() + slop;
    }

    public static boolean shouldCloseOnTouch(Window window, MotionEvent event) {
        return (event.getAction() & 0xFF) == 0 && WindowCompat.isOutOfBounds(window, event) && window.peekDecorView() != null;
    }

    private WindowCompat() {
    }
}

