/*
 * Decompiled with CFR 0.152.
 */
package org.holoeverywhere.internal;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.SharedPreferences;
import android.os.Build;
import android.util.Log;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.holoeverywhere.app.Application;
import org.holoeverywhere.preference.SharedPreferences;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class _SharedPreferencesImpl_JSON
implements SharedPreferences {
    private static final Map<String, ImplReference> refs = new HashMap<String, ImplReference>();
    private String charset;
    private final boolean DEBUG = Application.isDebugMode();
    private File file;
    private final String fileTag;
    private final String TAG = this.getClass().getSimpleName();

    @SuppressLint(value={"NewApi"})
    public _SharedPreferencesImpl_JSON(Context context, String name, int mode) {
        this.setCharset("utf-8");
        try {
            File tempFile = new File(context.getApplicationInfo().dataDir + "/shared_prefs");
            if (tempFile.exists()) {
                if (!tempFile.isDirectory()) {
                    if (!tempFile.delete() && !tempFile.mkdirs()) {
                        throw new CouldNotCreateStorage(tempFile, "\u0421ann't create a storage for the preferences.");
                    }
                    if (Build.VERSION.SDK_INT >= 9) {
                        tempFile.setWritable(true);
                        tempFile.setReadable(true);
                    }
                }
            } else {
                if (!tempFile.mkdirs()) {
                    throw new CouldNotCreateStorage(tempFile, "\u0421ann't create a storage for the preferences.");
                }
                if (Build.VERSION.SDK_INT >= 9) {
                    tempFile.setWritable(true);
                    tempFile.setReadable(true);
                }
            }
            if (!(tempFile = new File(tempFile, name + ".json")).exists() && !tempFile.createNewFile()) {
                throw new CouldNotCreateStorage(tempFile, "\u0421ann't create a storage for the preferences.");
            }
            if (Build.VERSION.SDK_INT >= 9) {
                switch (mode) {
                    case 2: {
                        tempFile.setWritable(true, false);
                        tempFile.setReadable(true, false);
                        break;
                    }
                    case 1: {
                        tempFile.setWritable(true, true);
                        tempFile.setReadable(true, false);
                        break;
                    }
                    default: {
                        tempFile.setWritable(true, true);
                        tempFile.setReadable(true, true);
                    }
                }
            }
            this.file = tempFile;
            this.fileTag = this.file.getAbsolutePath().intern();
            if (this.getReference().data == null) {
                this.getReference().data = this.readDataFromFile(this.file);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("IOException", e);
        }
    }

    @Override
    public synchronized boolean contains(String key) {
        return this.getData().has(key);
    }

    @Override
    public SharedPreferences.Editor edit() {
        return new EditorImpl();
    }

    @Override
    public synchronized Map<String, ?> getAll() {
        HashMap<String, Object> map = new HashMap<String, Object>(this.getData().length());
        Iterator i = this.getData().keys();
        while (i.hasNext()) {
            Object o = i.next();
            String key = o instanceof String ? (String)o : o.toString();
            try {
                map.put(key, this.getData().get(key));
            }
            catch (JSONException e) {}
        }
        return map;
    }

    @Override
    public boolean getBoolean(String key, boolean defValue) {
        return this.getData().optBoolean(key, defValue);
    }

    public String getCharset() {
        return this.charset;
    }

    protected JSONObject getData() {
        return this.getReference().data;
    }

    @Override
    public float getFloat(String key, float defValue) {
        return (float)this.getData().optDouble(key, (double)defValue);
    }

    @Override
    public Set<Float> getFloatSet(String key, Set<Float> defValue) {
        return this.getSet(key, defValue);
    }

    @Override
    public int getInt(String key, int defValue) {
        return this.getData().optInt(key, defValue);
    }

    @Override
    public Set<Integer> getIntSet(String key, Set<Integer> defValue) {
        return this.getSet(key, defValue);
    }

    @Override
    public JSONArray getJSONArray(String key, JSONArray defValue) {
        JSONArray a = this.getData().optJSONArray(key);
        return a == null ? defValue : a;
    }

    @Override
    public JSONObject getJSONObject(String key, JSONObject defValue) {
        JSONObject a = this.getData().optJSONObject(key);
        return a == null ? defValue : a;
    }

    @Override
    public long getLong(String key, long defValue) {
        return this.getData().optLong(key, defValue);
    }

    @Override
    public Set<Long> getLongSet(String key, Set<Long> defValue) {
        return this.getSet(key, defValue);
    }

    protected synchronized ImplReference getReference() {
        ImplReference ref = refs.get(this.fileTag);
        if (ref == null) {
            ref = new ImplReference();
            refs.put(this.fileTag, ref);
        }
        return ref;
    }

    private <T> Set<T> getSet(String key, Set<T> defValue) {
        JSONArray a = this.getData().optJSONArray(key);
        if (a == null) {
            return defValue;
        }
        HashSet<Object> set = new HashSet<Object>(Math.max(a.length(), 0));
        for (int i = 0; i < a.length(); ++i) {
            set.add(a.opt(i));
        }
        return set;
    }

    @Override
    public String getString(String key, String defValue) {
        return this.getData().optString(key, defValue);
    }

    @Override
    public Set<String> getStringSet(String key, Set<String> defValue) {
        return this.getSet(key, defValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyOnChange(String key) {
        Set listeners = this.getReference().listeners;
        if (listeners == null) {
            return;
        }
        Set set = listeners;
        synchronized (set) {
            for (SharedPreferences.OnSharedPreferenceChangeListener listener : listeners) {
                listener.onSharedPreferenceChanged(this, key);
            }
        }
    }

    protected JSONObject readDataFromFile(File file) {
        try {
            int c;
            Reader reader;
            FileInputStream is = new FileInputStream(file);
            try {
                reader = new InputStreamReader((InputStream)is, this.charset);
            }
            catch (UnsupportedEncodingException e) {
                if (this.DEBUG) {
                    Log.w((String)this.TAG, (String)("Encoding unsupport: " + this.charset));
                }
                reader = new InputStreamReader(is);
            }
            reader = new BufferedReader(reader, 1024);
            StringBuilder builder = new StringBuilder(Math.max(((InputStream)is).available(), 0));
            char[] buffer = new char[8192];
            while ((c = reader.read(buffer)) > 0) {
                builder.append(buffer, 0, c);
            }
            reader.close();
            ((InputStream)is).close();
            return new JSONObject(builder.toString());
        }
        catch (Exception e) {
            return new JSONObject();
        }
    }

    public void registerOnSharedPreferenceChangeListener(SharedPreferences.OnSharedPreferenceChangeListener listener) {
        throw new RuntimeException("android.content.SharedPreferences.OnSharedPreferenceChangeListener don't supported on JSON impl");
    }

    @Override
    public synchronized void registerOnSharedPreferenceChangeListener(SharedPreferences.OnSharedPreferenceChangeListener listener) {
        HashSet<SharedPreferences.OnSharedPreferenceChangeListener> listeners = this.getReference().listeners;
        if (listeners == null) {
            listeners = new HashSet<SharedPreferences.OnSharedPreferenceChangeListener>();
            this.getReference().listeners = listeners;
        }
        if (!listeners.contains(listener)) {
            listeners.add(listener);
        }
    }

    public void saveDataToFile(File file, JSONObject data) {
        byte[] b;
        String s;
        if (this.DEBUG) {
            try {
                s = data.toString(2);
            }
            catch (JSONException e) {
                Log.e((String)this.TAG, (String)"JSONException", (Throwable)e);
                s = data.toString();
            }
        } else {
            s = data.toString();
        }
        try {
            b = s.getBytes(this.charset);
        }
        catch (UnsupportedEncodingException e) {
            b = s.getBytes();
        }
        try {
            FileOutputStream os = new FileOutputStream(file);
            ((OutputStream)os).write(b);
            os.flush();
            ((OutputStream)os).close();
        }
        catch (IOException e) {
            throw new RuntimeException("IOException", e);
        }
    }

    public void setCharset(String charset) {
        if (charset == null || !Charset.isSupported(charset)) {
            throw new RuntimeException("Illegal charset: " + charset);
        }
        this.charset = charset;
    }

    public void unregisterOnSharedPreferenceChangeListener(SharedPreferences.OnSharedPreferenceChangeListener listener) {
        throw new RuntimeException("android.content.SharedPreferences.OnSharedPreferenceChangeListener don't supported on JSON impl");
    }

    @Override
    public synchronized void unregisterOnSharedPreferenceChangeListener(SharedPreferences.OnSharedPreferenceChangeListener listener) {
        Set listeners = this.getReference().listeners;
        if (listeners == null) {
            return;
        }
        if (listeners.contains(listener)) {
            listeners.remove(listener);
        }
        if (listeners.size() == 0) {
            this.getReference().listeners = null;
        }
    }

    private class RemoveValueJSONManipulate
    implements FutureJSONManipulate {
        private String key;

        public RemoveValueJSONManipulate(String key) {
            this.key = key;
        }

        @Override
        public boolean onJSONManipulate(JSONObject object) {
            if (object.has(this.key)) {
                object.remove(this.key);
                _SharedPreferencesImpl_JSON.this.notifyOnChange(this.key);
                return true;
            }
            return false;
        }
    }

    private class PutValueJSONManipulate
    implements FutureJSONManipulate {
        private String key;
        private Object t;

        public PutValueJSONManipulate(String key, Object t) {
            this.key = key;
            this.t = t;
        }

        @Override
        public boolean onJSONManipulate(JSONObject object) {
            try {
                if (this.t instanceof Set) {
                    this.t = new JSONArray((Collection)((Set)this.t));
                }
                object.put(this.key, this.t);
                _SharedPreferencesImpl_JSON.this.notifyOnChange(this.key);
                return true;
            }
            catch (JSONException e) {
                return false;
            }
        }
    }

    private static final class ImplReference {
        private JSONObject data;
        private Set<SharedPreferences.OnSharedPreferenceChangeListener> listeners;

        private ImplReference() {
        }
    }

    private static interface FutureJSONManipulate {
        public boolean onJSONManipulate(JSONObject var1);
    }

    private final class EditorImpl
    implements SharedPreferences.Editor {
        private final List<FutureJSONManipulate> manipulate = new ArrayList<FutureJSONManipulate>();

        private EditorImpl() {
        }

        private void add(FutureJSONManipulate t) {
            this.manipulate.add(t);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void apply() {
            JSONObject data;
            JSONObject jSONObject = data = _SharedPreferencesImpl_JSON.this.getData();
            synchronized (jSONObject) {
                try {
                    for (FutureJSONManipulate m : this.manipulate) {
                        if (m.onJSONManipulate(data)) continue;
                        throw new RuntimeException(m.getClass().getSimpleName() + ": Manipulate failed");
                    }
                    _SharedPreferencesImpl_JSON.this.saveDataToFile(_SharedPreferencesImpl_JSON.this.file, data);
                }
                catch (Exception e) {
                    Log.e((String)_SharedPreferencesImpl_JSON.this.TAG, (String)"Error while save preferences data", (Throwable)e);
                }
                finally {
                    this.manipulate.clear();
                }
            }
        }

        @Override
        public SharedPreferences.Editor clear() {
            this.manipulate.clear();
            return this;
        }

        @Override
        public boolean commit() {
            try {
                this.apply();
                return true;
            }
            catch (RuntimeException e) {
                return false;
            }
        }

        @Override
        public SharedPreferences.Editor putBoolean(String key, boolean value) {
            this.add(new PutValueJSONManipulate(key, value));
            return this;
        }

        @Override
        public SharedPreferences.Editor putFloat(String key, float value) {
            this.add(new PutValueJSONManipulate(key, value));
            return this;
        }

        @Override
        public SharedPreferences.Editor putFloatSet(String key, Set<Float> value) {
            this.add(new PutValueJSONManipulate(key, value));
            return this;
        }

        @Override
        public SharedPreferences.Editor putInt(String key, int value) {
            this.add(new PutValueJSONManipulate(key, value));
            return this;
        }

        @Override
        public SharedPreferences.Editor putIntSet(String key, Set<Integer> value) {
            this.add(new PutValueJSONManipulate(key, value));
            return this;
        }

        @Override
        public SharedPreferences.Editor putJSONArray(String key, JSONArray value) {
            this.add(new PutValueJSONManipulate(key, value));
            return this;
        }

        @Override
        public SharedPreferences.Editor putJSONObject(String key, JSONObject value) {
            this.add(new PutValueJSONManipulate(key, value));
            return this;
        }

        @Override
        public SharedPreferences.Editor putLong(String key, long value) {
            this.add(new PutValueJSONManipulate(key, value));
            return this;
        }

        @Override
        public SharedPreferences.Editor putLongSet(String key, Set<Long> value) {
            this.add(new PutValueJSONManipulate(key, value));
            return this;
        }

        @Override
        public SharedPreferences.Editor putString(String key, String value) {
            this.add(new PutValueJSONManipulate(key, value));
            return this;
        }

        @Override
        public SharedPreferences.Editor putStringSet(String key, Set<String> value) {
            this.add(new PutValueJSONManipulate(key, value));
            return this;
        }

        @Override
        public SharedPreferences.Editor remove(String key) {
            this.add(new RemoveValueJSONManipulate(key));
            return this;
        }
    }

    private final class CouldNotCreateStorage
    extends RuntimeException {
        private static final long serialVersionUID = -8602981054023098742L;

        public CouldNotCreateStorage(File file, String message) {
            super("File \"" + file.getAbsolutePath() + "\": " + message);
        }
    }
}

