/*
 * Decompiled with CFR 0.152.
 */
package org.holoeverywhere.internal;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.SharedPreferences;
import android.os.Build;
import android.util.Log;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.holoeverywhere.IHoloActivity;
import org.holoeverywhere.app.Application;
import org.holoeverywhere.preference.SharedPreferences;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class _SharedPreferencesImpl_XML
implements org.holoeverywhere.preference.SharedPreferences {
    private final SharedPreferences prefs;

    private static String setToString(Set<?> set) {
        return new JSONArray(set).toString();
    }

    private static <T> Set<T> stringToSet(String string2, Class<T> clazz) {
        try {
            JSONArray array = new JSONArray(string2);
            HashSet<T> set = new HashSet<T>(array.length());
            for (int i = 0; i < array.length(); ++i) {
                set.add(clazz.cast(array.opt(i)));
            }
            return set;
        }
        catch (ClassCastException e) {
            Log.e((String)_SharedPreferencesImpl_XML.class.getSimpleName(), (String)"Error of cast", (Throwable)e);
            return null;
        }
        catch (JSONException e) {
            return null;
        }
    }

    public _SharedPreferencesImpl_XML(Context context, String name, int mode) {
        this.prefs = context instanceof IHoloActivity ? ((IHoloActivity)context).superGetSharedPreferences(name, mode) : (context instanceof Application ? ((Application)context).superGetSharedPreferences(name, mode) : context.getSharedPreferences(name, mode));
    }

    @Override
    public boolean contains(String key) {
        return this.prefs.contains(key);
    }

    @Override
    public SharedPreferences.Editor edit() {
        return new BaseEditor(this.prefs.edit());
    }

    @Override
    public Map<String, ?> getAll() {
        return this.prefs.getAll();
    }

    @Override
    public boolean getBoolean(String key, boolean defValue) {
        return this.prefs.getBoolean(key, defValue);
    }

    @Override
    public float getFloat(String key, float defValue) {
        return this.prefs.getFloat(key, defValue);
    }

    @Override
    public Set<Float> getFloatSet(String key, Set<Float> defValue) {
        return this.getSet(key, defValue, Float.class);
    }

    @Override
    public int getInt(String key, int defValue) {
        return this.prefs.getInt(key, defValue);
    }

    @Override
    public Set<Integer> getIntSet(String key, Set<Integer> defValue) {
        return this.getSet(key, defValue, Integer.class);
    }

    @Override
    public JSONArray getJSONArray(String key, JSONArray defValue) {
        String s = this.prefs.getString(key, null);
        try {
            return s == null ? defValue : new JSONArray(s);
        }
        catch (JSONException e) {
            return new JSONArray();
        }
    }

    @Override
    public JSONObject getJSONObject(String key, JSONObject defValue) {
        String s = this.prefs.getString(key, null);
        try {
            return s == null ? defValue : new JSONObject(s);
        }
        catch (JSONException e) {
            return new JSONObject();
        }
    }

    @Override
    public long getLong(String key, long defValue) {
        return this.prefs.getLong(key, defValue);
    }

    @Override
    public Set<Long> getLongSet(String key, Set<Long> defValue) {
        return this.getSet(key, defValue, Long.class);
    }

    private <T> Set<T> getSet(String key, Set<T> defValue, Class<T> clazz) {
        String s = this.prefs.getString(key, null);
        if (s == null) {
            return defValue;
        }
        return _SharedPreferencesImpl_XML.stringToSet(s, clazz);
    }

    @Override
    public String getString(String key, String defValue) {
        return this.prefs.getString(key, defValue);
    }

    @Override
    @SuppressLint(value={"NewApi"})
    public Set<String> getStringSet(String key, Set<String> defValue) {
        if (Build.VERSION.SDK_INT >= 11) {
            return this.prefs.getStringSet(key, defValue);
        }
        return this.getSet(key, defValue, String.class);
    }

    public void registerOnSharedPreferenceChangeListener(SharedPreferences.OnSharedPreferenceChangeListener listener) {
        this.prefs.registerOnSharedPreferenceChangeListener(listener);
    }

    @Override
    public void registerOnSharedPreferenceChangeListener(SharedPreferences.OnSharedPreferenceChangeListener listener) {
        this.registerOnSharedPreferenceChangeListener((SharedPreferences.OnSharedPreferenceChangeListener)BaseOnSharedPreferenceChangeListener.obtain(this, listener));
    }

    public void unregisterOnSharedPreferenceChangeListener(SharedPreferences.OnSharedPreferenceChangeListener listener) {
        this.prefs.unregisterOnSharedPreferenceChangeListener(listener);
    }

    @Override
    public void unregisterOnSharedPreferenceChangeListener(SharedPreferences.OnSharedPreferenceChangeListener listener) {
        this.unregisterOnSharedPreferenceChangeListener((SharedPreferences.OnSharedPreferenceChangeListener)BaseOnSharedPreferenceChangeListener.obtain(this, listener));
    }

    public static class BaseOnSharedPreferenceChangeListener
    implements SharedPreferences.OnSharedPreferenceChangeListener {
        private static final Map<SharedPreferences.OnSharedPreferenceChangeListener, BaseOnSharedPreferenceChangeListener> instances = new HashMap<SharedPreferences.OnSharedPreferenceChangeListener, BaseOnSharedPreferenceChangeListener>();
        private SharedPreferences.OnSharedPreferenceChangeListener listener;
        private org.holoeverywhere.preference.SharedPreferences prefs;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static <T extends BaseOnSharedPreferenceChangeListener> T obtain(org.holoeverywhere.preference.SharedPreferences prefs, SharedPreferences.OnSharedPreferenceChangeListener listener) {
            if (!instances.containsKey(listener)) {
                Map<SharedPreferences.OnSharedPreferenceChangeListener, BaseOnSharedPreferenceChangeListener> map = instances;
                synchronized (map) {
                    if (!instances.containsKey(listener)) {
                        try {
                            instances.put(listener, new BaseOnSharedPreferenceChangeListener(prefs, listener));
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
            return (T)instances.get(listener);
        }

        public BaseOnSharedPreferenceChangeListener(org.holoeverywhere.preference.SharedPreferences prefs, SharedPreferences.OnSharedPreferenceChangeListener listener) {
            this.prefs = prefs;
            this.listener = listener;
        }

        public void onSharedPreferenceChanged(SharedPreferences sharedPreferences, String key) {
            this.listener.onSharedPreferenceChanged(this.prefs, key);
        }
    }

    private static final class BaseEditor
    implements SharedPreferences.Editor {
        private SharedPreferences.Editor editor;

        public BaseEditor(SharedPreferences.Editor editor) {
            if (editor == null) {
                throw new IllegalArgumentException("SharedPreferences.Editor can't be null");
            }
            this.editor = editor;
        }

        @Override
        @SuppressLint(value={"NewApi"})
        public void apply() {
            if (Build.VERSION.SDK_INT >= 9) {
                this.editor.apply();
            } else {
                this.editor.commit();
            }
        }

        @Override
        public SharedPreferences.Editor clear() {
            this.editor.clear();
            return this;
        }

        @Override
        public boolean commit() {
            return this.editor.commit();
        }

        @Override
        public SharedPreferences.Editor putBoolean(String key, boolean value) {
            this.editor.putBoolean(key, value);
            return this;
        }

        @Override
        public SharedPreferences.Editor putFloat(String key, float value) {
            this.editor.putFloat(key, value);
            return this;
        }

        @Override
        public SharedPreferences.Editor putFloatSet(String key, Set<Float> value) {
            return this.putSet(key, value);
        }

        @Override
        public SharedPreferences.Editor putInt(String key, int value) {
            this.editor.putInt(key, value);
            return this;
        }

        @Override
        public SharedPreferences.Editor putIntSet(String key, Set<Integer> value) {
            return this.putSet(key, value);
        }

        @Override
        public SharedPreferences.Editor putJSONArray(String key, JSONArray value) {
            this.editor.putString(key, value.toString());
            return this;
        }

        @Override
        public SharedPreferences.Editor putJSONObject(String key, JSONObject value) {
            this.editor.putString(key, value.toString());
            return this;
        }

        @Override
        public SharedPreferences.Editor putLong(String key, long value) {
            this.editor.putLong(key, value);
            return this;
        }

        @Override
        public SharedPreferences.Editor putLongSet(String key, Set<Long> value) {
            return this.putSet(key, value);
        }

        private SharedPreferences.Editor putSet(String key, Set<?> value) {
            this.editor.putString(key, _SharedPreferencesImpl_XML.setToString(value));
            return this;
        }

        @Override
        public SharedPreferences.Editor putString(String key, String value) {
            this.editor.putString(key, value);
            return this;
        }

        @Override
        @SuppressLint(value={"NewApi"})
        public SharedPreferences.Editor putStringSet(String key, Set<String> value) {
            if (Build.VERSION.SDK_INT >= 11) {
                this.editor.putStringSet(key, value);
            } else {
                this.editor.putString(key, _SharedPreferencesImpl_XML.setToString(value));
            }
            return this;
        }

        @Override
        public SharedPreferences.Editor remove(String key) {
            this.editor.remove(key);
            return this;
        }
    }
}

