/*
 * Decompiled with CFR 0.152.
 */
package org.holoeverywhere.preference;

import android.content.Context;
import android.content.DialogInterface;
import android.content.res.TypedArray;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.holoeverywhere.R;
import org.holoeverywhere.app.AlertDialog;
import org.holoeverywhere.preference.DialogPreference;
import org.holoeverywhere.preference.Preference;

public class MultiSelectListPreference
extends DialogPreference {
    private CharSequence[] mEntries;
    private CharSequence[] mEntryValues;
    private Set<String> mNewValues = new HashSet<String>();
    private boolean mPreferenceChanged;
    private Set<String> mValues = new HashSet<String>();

    public MultiSelectListPreference(Context context) {
        this(context, null);
    }

    public MultiSelectListPreference(Context context, AttributeSet attrs) {
        super(context, attrs);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.ListPreference, 0, 0);
        this.mEntries = a.getTextArray(0);
        this.mEntryValues = a.getTextArray(1);
        a.recycle();
    }

    public int findIndexOfValue(String value) {
        if (value != null && this.mEntryValues != null) {
            for (int i = this.mEntryValues.length - 1; i >= 0; --i) {
                if (!this.mEntryValues[i].equals(value)) continue;
                return i;
            }
        }
        return -1;
    }

    public CharSequence[] getEntries() {
        return this.mEntries;
    }

    public CharSequence[] getEntryValues() {
        return this.mEntryValues;
    }

    private boolean[] getSelectedItems() {
        CharSequence[] entries = this.mEntryValues;
        int entryCount = entries.length;
        Set<String> values = this.mValues;
        boolean[] result = new boolean[entryCount];
        for (int i = 0; i < entryCount; ++i) {
            result[i] = values.contains(entries[i].toString());
        }
        return result;
    }

    public Set<String> getValues() {
        return this.mValues;
    }

    @Override
    protected void onDialogClosed(boolean positiveResult) {
        Set<String> values;
        super.onDialogClosed(positiveResult);
        if (positiveResult && this.mPreferenceChanged && this.callChangeListener(values = this.mNewValues)) {
            this.setValues(values);
        }
        this.mPreferenceChanged = false;
    }

    @Override
    protected Object onGetDefaultValue(TypedArray a, int index) {
        CharSequence[] defaultValues = a.getTextArray(index);
        HashSet<String> result = new HashSet<String>();
        if (defaultValues != null) {
            for (CharSequence s : defaultValues) {
                result.add(s.toString());
            }
        }
        return result;
    }

    @Override
    protected void onPrepareDialogBuilder(AlertDialog.Builder builder) {
        super.onPrepareDialogBuilder(builder);
        if (this.mEntries == null || this.mEntryValues == null) {
            throw new IllegalStateException("MultiSelectListPreference requires an entries array and an entryValues array.");
        }
        boolean[] checkedItems = this.getSelectedItems();
        builder.setMultiChoiceItems(this.mEntries, checkedItems, new DialogInterface.OnMultiChoiceClickListener(){

            public void onClick(DialogInterface dialog, int which, boolean isChecked) {
                if (isChecked) {
                    MultiSelectListPreference.this.mPreferenceChanged = (byte)(MultiSelectListPreference.this.mPreferenceChanged | (MultiSelectListPreference.this.mNewValues.add(MultiSelectListPreference.this.mEntryValues[which].toString()) ? 1 : 0));
                } else {
                    MultiSelectListPreference.this.mPreferenceChanged = (byte)(MultiSelectListPreference.this.mPreferenceChanged | (MultiSelectListPreference.this.mNewValues.remove(MultiSelectListPreference.this.mEntryValues[which].toString()) ? 1 : 0));
                }
            }
        });
        this.mNewValues.clear();
        this.mNewValues.addAll(this.mValues);
    }

    @Override
    protected Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        if (this.isPersistent()) {
            return superState;
        }
        SavedState myState = new SavedState(superState);
        myState.values = new HashSet<String>(this.getValues());
        return myState;
    }

    @Override
    protected void onSetInitialValue(boolean restoreValue, Object defaultValue) {
        this.mValues.clear();
        this.mValues.addAll((Collection<String>)(restoreValue ? this.getPersistedStringSet(this.mValues) : (Set<String>)defaultValue));
    }

    public void setEntries(CharSequence[] entries) {
        this.mEntries = entries;
    }

    public void setEntries(int entriesResId) {
        this.setEntries(this.getContext().getResources().getTextArray(entriesResId));
    }

    public void setEntryValues(CharSequence[] entryValues) {
        this.mEntryValues = entryValues;
    }

    public void setEntryValues(int entryValuesResId) {
        this.setEntryValues(this.getContext().getResources().getTextArray(entryValuesResId));
    }

    public void setValues(Set<String> values) {
        this.mValues.clear();
        this.mValues.addAll(values);
        this.persistStringSet(values);
    }

    private static class SavedState
    extends Preference.BaseSavedState {
        Set<String> values;

        public SavedState(Parcel source) {
            super(source);
            String[] v = source.createStringArray();
            this.values = new HashSet<String>(Arrays.asList(v));
        }

        public SavedState(Parcelable superState) {
            super(superState);
        }

        public void writeToParcel(Parcel dest, int flags) {
            super.writeToParcel(dest, flags);
            dest.writeStringArray(this.values.toArray(new String[this.values.size()]));
        }
    }
}

