/*
 * Decompiled with CFR 0.152.
 */
package org.holoeverywhere.preference;

import android.content.Context;
import android.content.Intent;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.AbsSavedState;
import android.view.KeyEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.holoeverywhere.LayoutInflater;
import org.holoeverywhere.R;
import org.holoeverywhere.app.Application;
import org.holoeverywhere.preference.OnDependencyChangeListener;
import org.holoeverywhere.preference.PreferenceManager;
import org.holoeverywhere.preference.PreferenceScreen;
import org.holoeverywhere.preference.SharedPreferences;
import org.holoeverywhere.util.CharSequences;
import org.json.JSONArray;
import org.json.JSONObject;

public class Preference
implements Comparable<Preference>,
OnDependencyChangeListener {
    public static final int DEFAULT_ORDER = Integer.MAX_VALUE;
    private boolean mBaseMethodCalled;
    private Context mContext;
    private Object mDefaultValue;
    private String mDependencyKey;
    private boolean mDependencyMet = true;
    private List<Preference> mDependents;
    private boolean mEnabled = true;
    private Bundle mExtras;
    private String mFragment;
    private boolean mHasSpecifiedLayout = false;
    private Drawable mIcon;
    private int mIconResId;
    private long mId;
    private Intent mIntent;
    private String mKey;
    private int mLayoutResId = 2130903088;
    private OnPreferenceChangeInternalListener mListener;
    private OnPreferenceChangeListener mOnChangeListener;
    private OnPreferenceClickListener mOnClickListener;
    private int mOrder = Integer.MAX_VALUE;
    private boolean mPersistent = true;
    private PreferenceManager mPreferenceManager;
    private boolean mRequiresKey;
    private boolean mSelectable = true;
    private boolean mShouldDisableView = true;
    private CharSequence mSummary;
    private CharSequence mTitle;
    private int mTitleRes;
    private int mWidgetLayoutResId;

    public Preference(Context context) {
        this(context, null);
    }

    public Preference(Context context, AttributeSet attrs) {
        this(context, attrs, 2130772069);
    }

    public Preference(Context context, AttributeSet attrs, int defStyle) {
        this.mContext = context;
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.Preference, defStyle, 0);
        this.mIconResId = a.getResourceId(1, 0);
        this.mKey = a.getString(2);
        this.mTitleRes = a.getResourceId(0, 0);
        this.mTitle = a.getString(0);
        this.mSummary = a.getString(12);
        this.mOrder = a.getInt(3, this.mOrder);
        this.mFragment = a.getString(13);
        this.mLayoutResId = a.getResourceId(4, this.mLayoutResId);
        this.mWidgetLayoutResId = a.getResourceId(5, this.mWidgetLayoutResId);
        this.mEnabled = a.getBoolean(6, true);
        this.mSelectable = a.getBoolean(7, true);
        this.mPersistent = a.getBoolean(9, this.mPersistent);
        this.mDependencyKey = a.getString(8);
        this.mDefaultValue = this.onGetDefaultValue(a, 10);
        this.mShouldDisableView = a.getBoolean(11, this.mShouldDisableView);
        a.recycle();
        if (!this.getClass().getName().startsWith(Application.config().getPreferencePackage())) {
            this.mHasSpecifiedLayout = true;
        }
    }

    protected boolean callChangeListener(Object newValue) {
        return this.mOnChangeListener == null ? true : this.mOnChangeListener.onPreferenceChange(this, newValue);
    }

    @Override
    public int compareTo(Preference another) {
        if (this.mOrder != Integer.MAX_VALUE || this.mOrder == Integer.MAX_VALUE && another.mOrder != Integer.MAX_VALUE) {
            return this.mOrder - another.mOrder;
        }
        if (this.mTitle == null) {
            return 1;
        }
        if (another.mTitle == null) {
            return -1;
        }
        return CharSequences.compareToIgnoreCase(this.mTitle, another.mTitle);
    }

    void dispatchRestoreInstanceState(Bundle container) {
        Parcelable state;
        if (this.hasKey() && (state = container.getParcelable(this.mKey)) != null) {
            this.mBaseMethodCalled = false;
            this.onRestoreInstanceState(state);
            if (!this.mBaseMethodCalled) {
                throw new IllegalStateException("Derived class did not call super.onRestoreInstanceState()");
            }
        }
    }

    void dispatchSaveInstanceState(Bundle container) {
        if (this.hasKey()) {
            this.mBaseMethodCalled = false;
            Parcelable state = this.onSaveInstanceState();
            if (!this.mBaseMethodCalled) {
                throw new IllegalStateException("Derived class did not call super.onSaveInstanceState()");
            }
            if (state != null) {
                container.putParcelable(this.mKey, state);
            }
        }
    }

    private void dispatchSetInitialValue() {
        boolean shouldPersist = this.shouldPersist();
        if (!shouldPersist || !this.getSharedPreferences().contains(this.mKey)) {
            if (this.mDefaultValue != null) {
                this.onSetInitialValue(false, this.mDefaultValue);
            }
        } else {
            this.onSetInitialValue(true, null);
        }
    }

    protected Preference findPreferenceInHierarchy(String key) {
        if (TextUtils.isEmpty((CharSequence)key) || this.mPreferenceManager == null) {
            return null;
        }
        return this.mPreferenceManager.findPreference(key);
    }

    public Context getContext() {
        return this.mContext;
    }

    public String getDependency() {
        return this.mDependencyKey;
    }

    public SharedPreferences.Editor getEditor() {
        if (this.mPreferenceManager == null) {
            return null;
        }
        return this.mPreferenceManager.getEditor();
    }

    public Bundle getExtras() {
        if (this.mExtras == null) {
            this.mExtras = new Bundle();
        }
        return this.mExtras;
    }

    StringBuilder getFilterableStringBuilder() {
        CharSequence summary;
        StringBuilder sb = new StringBuilder();
        CharSequence title = this.getTitle();
        if (!TextUtils.isEmpty((CharSequence)title)) {
            sb.append(title).append(' ');
        }
        if (!TextUtils.isEmpty((CharSequence)(summary = this.getSummary()))) {
            sb.append(summary).append(' ');
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - 1);
        }
        return sb;
    }

    public String getFragment() {
        return this.mFragment;
    }

    public Drawable getIcon() {
        return this.mIcon;
    }

    long getId() {
        return this.mId;
    }

    public Intent getIntent() {
        return this.mIntent;
    }

    public String getKey() {
        return this.mKey;
    }

    public int getLayoutResource() {
        return this.mLayoutResId;
    }

    public OnPreferenceChangeListener getOnPreferenceChangeListener() {
        return this.mOnChangeListener;
    }

    public OnPreferenceClickListener getOnPreferenceClickListener() {
        return this.mOnClickListener;
    }

    public int getOrder() {
        return this.mOrder;
    }

    protected boolean getPersistedBoolean(boolean defaultReturnValue) {
        if (!this.shouldPersist()) {
            return defaultReturnValue;
        }
        return this.mPreferenceManager.getSharedPreferences().getBoolean(this.mKey, defaultReturnValue);
    }

    protected float getPersistedFloat(float defaultReturnValue) {
        if (!this.shouldPersist()) {
            return defaultReturnValue;
        }
        return this.mPreferenceManager.getSharedPreferences().getFloat(this.mKey, defaultReturnValue);
    }

    protected Set<Float> getPersistedFloatSet(Set<Float> defaultReturnValue) {
        if (!this.shouldPersist()) {
            return defaultReturnValue;
        }
        return this.mPreferenceManager.getSharedPreferences().getFloatSet(this.mKey, defaultReturnValue);
    }

    protected int getPersistedInt(int defaultReturnValue) {
        if (!this.shouldPersist()) {
            return defaultReturnValue;
        }
        return this.mPreferenceManager.getSharedPreferences().getInt(this.mKey, defaultReturnValue);
    }

    protected Set<Integer> getPersistedIntSet(Set<Integer> defaultReturnValue) {
        if (!this.shouldPersist()) {
            return defaultReturnValue;
        }
        return this.mPreferenceManager.getSharedPreferences().getIntSet(this.mKey, defaultReturnValue);
    }

    protected JSONArray getPersistedJSONArray(JSONArray defaultReturnValue) {
        if (!this.shouldPersist()) {
            return defaultReturnValue;
        }
        return this.mPreferenceManager.getSharedPreferences().getJSONArray(this.mKey, defaultReturnValue);
    }

    protected JSONObject getPersistedJSONObject(JSONObject defaultReturnValue) {
        if (!this.shouldPersist()) {
            return defaultReturnValue;
        }
        return this.mPreferenceManager.getSharedPreferences().getJSONObject(this.mKey, defaultReturnValue);
    }

    protected long getPersistedLong(long defaultReturnValue) {
        if (!this.shouldPersist()) {
            return defaultReturnValue;
        }
        return this.mPreferenceManager.getSharedPreferences().getLong(this.mKey, defaultReturnValue);
    }

    protected Set<Long> getPersistedLongSet(Set<Long> defaultReturnValue) {
        if (!this.shouldPersist()) {
            return defaultReturnValue;
        }
        return this.mPreferenceManager.getSharedPreferences().getLongSet(this.mKey, defaultReturnValue);
    }

    protected String getPersistedString(String defaultReturnValue) {
        if (!this.shouldPersist()) {
            return defaultReturnValue;
        }
        return this.mPreferenceManager.getSharedPreferences().getString(this.mKey, defaultReturnValue);
    }

    protected Set<String> getPersistedStringSet(Set<String> defaultReturnValue) {
        if (!this.shouldPersist()) {
            return defaultReturnValue;
        }
        return this.mPreferenceManager.getSharedPreferences().getStringSet(this.mKey, defaultReturnValue);
    }

    public PreferenceManager getPreferenceManager() {
        return this.mPreferenceManager;
    }

    public SharedPreferences getSharedPreferences() {
        if (this.mPreferenceManager == null) {
            return null;
        }
        return this.mPreferenceManager.getSharedPreferences();
    }

    public boolean getShouldDisableView() {
        return this.mShouldDisableView;
    }

    public CharSequence getSummary() {
        return this.mSummary;
    }

    public CharSequence getTitle() {
        return this.mTitle;
    }

    public int getTitleRes() {
        return this.mTitleRes;
    }

    public View getView(View convertView, ViewGroup parent) {
        if (convertView == null) {
            convertView = this.onCreateView(parent);
        }
        this.onBindView(convertView);
        return convertView;
    }

    public int getWidgetLayoutResource() {
        return this.mWidgetLayoutResId;
    }

    public boolean hasKey() {
        return !TextUtils.isEmpty((CharSequence)this.mKey);
    }

    boolean hasSpecifiedLayout() {
        return this.mHasSpecifiedLayout;
    }

    public boolean isEnabled() {
        return this.mEnabled && this.mDependencyMet;
    }

    public boolean isPersistent() {
        return this.mPersistent;
    }

    public boolean isSelectable() {
        return this.mSelectable;
    }

    protected void notifyChanged() {
        if (this.mListener != null) {
            this.mListener.onPreferenceChange(this);
        }
    }

    public void notifyDependencyChange(boolean disableDependents) {
        List<Preference> dependents = this.mDependents;
        if (dependents == null) {
            return;
        }
        int dependentsCount = dependents.size();
        for (int i = 0; i < dependentsCount; ++i) {
            dependents.get(i).onDependencyChanged(this, disableDependents);
        }
    }

    protected void notifyHierarchyChanged() {
        if (this.mListener != null) {
            this.mListener.onPreferenceHierarchyChange(this);
        }
    }

    protected void onAttachedToActivity() {
        this.registerDependency();
    }

    protected void onAttachedToHierarchy(PreferenceManager preferenceManager) {
        this.mPreferenceManager = preferenceManager;
        this.mId = preferenceManager.getNextId();
        this.dispatchSetInitialValue();
    }

    protected void onBindView(View view) {
        ImageView imageView;
        TextView summaryView;
        TextView titleView = (TextView)view.findViewById(2131165290);
        if (titleView != null) {
            CharSequence title = this.getTitle();
            if (!TextUtils.isEmpty((CharSequence)title)) {
                titleView.setText(title);
                titleView.setVisibility(0);
            } else {
                titleView.setVisibility(8);
            }
        }
        if ((summaryView = (TextView)view.findViewById(2131165309)) != null) {
            CharSequence summary = this.getSummary();
            if (!TextUtils.isEmpty((CharSequence)summary)) {
                summaryView.setText(summary);
                summaryView.setVisibility(0);
            } else {
                summaryView.setVisibility(8);
            }
        }
        if ((imageView = (ImageView)view.findViewById(2131165274)) != null) {
            if (this.mIconResId != 0 || this.mIcon != null) {
                if (this.mIcon == null) {
                    this.mIcon = this.getContext().getResources().getDrawable(this.mIconResId);
                }
                if (this.mIcon != null) {
                    imageView.setImageDrawable(this.mIcon);
                }
            }
            imageView.setVisibility(this.mIcon != null ? 0 : 8);
        }
        if (this.mShouldDisableView) {
            this.setEnabledStateOnViews(view, this.isEnabled());
        }
    }

    protected void onClick() {
    }

    protected View onCreateView(ViewGroup parent) {
        LayoutInflater layoutInflater = LayoutInflater.from(this.mContext);
        View layout2 = layoutInflater.inflate(this.mLayoutResId, parent, false);
        ViewGroup widgetFrame = (ViewGroup)layout2.findViewById(2131165310);
        if (widgetFrame != null) {
            if (this.mWidgetLayoutResId != 0) {
                layoutInflater.inflate(this.mWidgetLayoutResId, widgetFrame);
            } else {
                widgetFrame.setVisibility(8);
            }
        }
        return layout2;
    }

    @Override
    public void onDependencyChanged(Preference dependency, boolean disableDependent) {
        if (this.mDependencyMet == disableDependent) {
            this.mDependencyMet = !disableDependent;
            this.notifyDependencyChange(this.shouldDisableDependents());
            this.notifyChanged();
        }
    }

    protected Object onGetDefaultValue(TypedArray a, int index) {
        return null;
    }

    public boolean onKey(View v, int keyCode, KeyEvent event) {
        return false;
    }

    protected void onPrepareForRemoval() {
        this.unregisterDependency();
    }

    protected void onRestoreInstanceState(Parcelable state) {
        this.mBaseMethodCalled = true;
        if (state != AbsSavedState.EMPTY_STATE && state != null) {
            throw new IllegalArgumentException("Wrong state class -- expecting Preference State");
        }
    }

    protected Parcelable onSaveInstanceState() {
        this.mBaseMethodCalled = true;
        return AbsSavedState.EMPTY_STATE;
    }

    protected void onSetInitialValue(boolean restorePersistedValue, Object defaultValue) {
    }

    public Bundle peekExtras() {
        return this.mExtras;
    }

    void performClick(PreferenceScreen preferenceScreen) {
        if (!this.isEnabled()) {
            return;
        }
        this.onClick();
        if (this.mOnClickListener != null && this.mOnClickListener.onPreferenceClick(this)) {
            return;
        }
        PreferenceManager preferenceManager = this.getPreferenceManager();
        if (preferenceManager != null) {
            PreferenceManager.OnPreferenceTreeClickListener listener = preferenceManager.getOnPreferenceTreeClickListener();
            if (preferenceScreen != null && listener != null && listener.onPreferenceTreeClick(preferenceScreen, this)) {
                return;
            }
        }
        if (this.mIntent != null) {
            Context context = this.getContext();
            context.startActivity(this.mIntent);
        }
    }

    protected boolean persistBoolean(boolean value) {
        if (this.shouldPersist()) {
            if (value == this.getPersistedBoolean(!value)) {
                return true;
            }
            SharedPreferences.Editor editor = this.mPreferenceManager.getEditor();
            editor.putBoolean(this.mKey, value);
            this.tryCommit(editor);
            return true;
        }
        return false;
    }

    protected boolean persistFloat(float value) {
        if (this.shouldPersist()) {
            if (value == this.getPersistedFloat(Float.NaN)) {
                return true;
            }
            SharedPreferences.Editor editor = this.mPreferenceManager.getEditor();
            editor.putFloat(this.mKey, value);
            this.tryCommit(editor);
            return true;
        }
        return false;
    }

    protected boolean persistFloatSet(Set<Float> values) {
        if (this.shouldPersist()) {
            if (values.equals(this.getPersistedFloatSet(null))) {
                return true;
            }
            SharedPreferences.Editor editor = this.mPreferenceManager.getEditor();
            editor.putFloatSet(this.mKey, values);
            this.tryCommit(editor);
            return true;
        }
        return false;
    }

    protected boolean persistInt(int value) {
        if (this.shouldPersist()) {
            if (value == this.getPersistedInt(~value)) {
                return true;
            }
            SharedPreferences.Editor editor = this.mPreferenceManager.getEditor();
            editor.putInt(this.mKey, value);
            this.tryCommit(editor);
            return true;
        }
        return false;
    }

    protected boolean persistIntSet(Set<Integer> values) {
        if (this.shouldPersist()) {
            if (values.equals(this.getPersistedIntSet(null))) {
                return true;
            }
            SharedPreferences.Editor editor = this.mPreferenceManager.getEditor();
            editor.putIntSet(this.mKey, values);
            this.tryCommit(editor);
            return true;
        }
        return false;
    }

    protected boolean persistJSONArray(JSONArray value) {
        if (this.shouldPersist()) {
            if (value.equals(this.getPersistedJSONArray(null))) {
                return true;
            }
            SharedPreferences.Editor editor = this.mPreferenceManager.getEditor();
            editor.putJSONArray(this.mKey, value);
            this.tryCommit(editor);
            return true;
        }
        return false;
    }

    protected boolean persistJSONObject(JSONObject value) {
        if (this.shouldPersist()) {
            if (value.equals(this.getPersistedJSONObject(null))) {
                return true;
            }
            SharedPreferences.Editor editor = this.mPreferenceManager.getEditor();
            editor.putJSONObject(this.mKey, value);
            this.tryCommit(editor);
            return true;
        }
        return false;
    }

    protected boolean persistLong(long value) {
        if (this.shouldPersist()) {
            if (value == this.getPersistedLong(value ^ 0xFFFFFFFFFFFFFFFFL)) {
                return true;
            }
            SharedPreferences.Editor editor = this.mPreferenceManager.getEditor();
            editor.putLong(this.mKey, value);
            this.tryCommit(editor);
            return true;
        }
        return false;
    }

    protected boolean persistLongSet(Set<Long> values) {
        if (this.shouldPersist()) {
            if (values.equals(this.getPersistedLongSet(null))) {
                return true;
            }
            SharedPreferences.Editor editor = this.mPreferenceManager.getEditor();
            editor.putLongSet(this.mKey, values);
            this.tryCommit(editor);
            return true;
        }
        return false;
    }

    protected boolean persistString(String value) {
        if (this.shouldPersist()) {
            if (value == this.getPersistedString(null)) {
                return true;
            }
            SharedPreferences.Editor editor = this.mPreferenceManager.getEditor();
            editor.putString(this.mKey, value);
            this.tryCommit(editor);
            return true;
        }
        return false;
    }

    protected boolean persistStringSet(Set<String> values) {
        if (this.shouldPersist()) {
            if (values.equals(this.getPersistedStringSet(null))) {
                return true;
            }
            SharedPreferences.Editor editor = this.mPreferenceManager.getEditor();
            editor.putStringSet(this.mKey, values);
            this.tryCommit(editor);
            return true;
        }
        return false;
    }

    private void registerDependency() {
        if (TextUtils.isEmpty((CharSequence)this.mDependencyKey)) {
            return;
        }
        Preference preference = this.findPreferenceInHierarchy(this.mDependencyKey);
        if (preference == null) {
            throw new IllegalStateException("Dependency \"" + this.mDependencyKey + "\" not found for preference \"" + this.mKey + "\" (title: \"" + this.mTitle + "\"");
        }
        preference.registerDependent(this);
    }

    private void registerDependent(Preference dependent) {
        if (this.mDependents == null) {
            this.mDependents = new ArrayList<Preference>();
        }
        this.mDependents.add(dependent);
        dependent.onDependencyChanged(this, this.shouldDisableDependents());
    }

    void requireKey() {
        if (this.mKey == null) {
            throw new IllegalStateException("Preference does not have a key assigned.");
        }
        this.mRequiresKey = true;
    }

    public void restoreHierarchyState(Bundle container) {
        this.dispatchRestoreInstanceState(container);
    }

    public void saveHierarchyState(Bundle container) {
        this.dispatchSaveInstanceState(container);
    }

    public void setDefaultValue(Object defaultValue) {
        this.mDefaultValue = defaultValue;
    }

    public void setDependency(String dependencyKey) {
        this.unregisterDependency();
        this.mDependencyKey = dependencyKey;
        this.registerDependency();
    }

    public void setEnabled(boolean enabled) {
        if (this.mEnabled != enabled) {
            this.mEnabled = enabled;
            this.notifyDependencyChange(this.shouldDisableDependents());
            this.notifyChanged();
        }
    }

    private void setEnabledStateOnViews(View v, boolean enabled) {
        v.setEnabled(enabled);
        if (v instanceof ViewGroup) {
            ViewGroup vg = (ViewGroup)v;
            for (int i = vg.getChildCount() - 1; i >= 0; --i) {
                this.setEnabledStateOnViews(vg.getChildAt(i), enabled);
            }
        }
    }

    public void setFragment(String fragment) {
        this.mFragment = fragment;
    }

    public void setIcon(Drawable icon) {
        if (icon == null && this.mIcon != null || icon != null && this.mIcon != icon) {
            this.mIcon = icon;
            this.notifyChanged();
        }
    }

    public void setIcon(int iconResId) {
        this.mIconResId = iconResId;
        this.setIcon(this.mContext.getResources().getDrawable(iconResId));
    }

    public void setIntent(Intent intent) {
        this.mIntent = intent;
    }

    public void setKey(String key) {
        this.mKey = key;
        if (this.mRequiresKey && !this.hasKey()) {
            this.requireKey();
        }
    }

    public void setLayoutResource(int layoutResId) {
        if (layoutResId != this.mLayoutResId) {
            this.mHasSpecifiedLayout = true;
        }
        this.mLayoutResId = layoutResId;
    }

    final void setOnPreferenceChangeInternalListener(OnPreferenceChangeInternalListener listener) {
        this.mListener = listener;
    }

    public void setOnPreferenceChangeListener(OnPreferenceChangeListener onPreferenceChangeListener) {
        this.mOnChangeListener = onPreferenceChangeListener;
    }

    public void setOnPreferenceClickListener(OnPreferenceClickListener onPreferenceClickListener) {
        this.mOnClickListener = onPreferenceClickListener;
    }

    public void setOrder(int order) {
        if (order != this.mOrder) {
            this.mOrder = order;
            this.notifyHierarchyChanged();
        }
    }

    public void setPersistent(boolean persistent) {
        this.mPersistent = persistent;
    }

    public void setSelectable(boolean selectable) {
        if (this.mSelectable != selectable) {
            this.mSelectable = selectable;
            this.notifyChanged();
        }
    }

    public void setShouldDisableView(boolean shouldDisableView) {
        this.mShouldDisableView = shouldDisableView;
        this.notifyChanged();
    }

    public void setSummary(CharSequence summary) {
        if (summary == null && this.mSummary != null || summary != null && !summary.equals(this.mSummary)) {
            this.mSummary = summary;
            this.notifyChanged();
        }
    }

    public void setSummary(int summaryResId) {
        this.setSummary(this.mContext.getString(summaryResId));
    }

    public void setTitle(CharSequence title) {
        if (title == null && this.mTitle != null || title != null && !title.equals(this.mTitle)) {
            this.mTitleRes = 0;
            this.mTitle = title;
            this.notifyChanged();
        }
    }

    public void setTitle(int titleResId) {
        this.setTitle(this.mContext.getString(titleResId));
        this.mTitleRes = titleResId;
    }

    public void setWidgetLayoutResource(int widgetLayoutResId) {
        if (widgetLayoutResId != this.mWidgetLayoutResId) {
            this.mHasSpecifiedLayout = true;
        }
        this.mWidgetLayoutResId = widgetLayoutResId;
    }

    public boolean shouldCommit() {
        if (this.mPreferenceManager == null) {
            return false;
        }
        return this.mPreferenceManager.shouldCommit();
    }

    public boolean shouldDisableDependents() {
        return !this.isEnabled();
    }

    protected boolean shouldPersist() {
        return this.mPreferenceManager != null && this.isPersistent() && this.hasKey();
    }

    public String toString() {
        return this.getFilterableStringBuilder().toString();
    }

    private void tryCommit(SharedPreferences.Editor editor) {
        if (this.mPreferenceManager.shouldCommit()) {
            try {
                editor.apply();
            }
            catch (AbstractMethodError unused) {
                editor.commit();
            }
        }
    }

    private void unregisterDependency() {
        Preference oldDependency;
        if (this.mDependencyKey != null && (oldDependency = this.findPreferenceInHierarchy(this.mDependencyKey)) != null) {
            oldDependency.unregisterDependent(this);
        }
    }

    private void unregisterDependent(Preference dependent) {
        if (this.mDependents != null) {
            this.mDependents.remove(dependent);
        }
    }

    public static interface OnPreferenceClickListener {
        public boolean onPreferenceClick(Preference var1);
    }

    public static interface OnPreferenceChangeListener {
        public boolean onPreferenceChange(Preference var1, Object var2);
    }

    static interface OnPreferenceChangeInternalListener {
        public void onPreferenceChange(Preference var1);

        public void onPreferenceHierarchyChange(Preference var1);
    }

    public static class BaseSavedState
    extends AbsSavedState {
        public static final Parcelable.Creator<BaseSavedState> CREATOR = new Parcelable.Creator<BaseSavedState>(){

            public BaseSavedState createFromParcel(Parcel in) {
                return new BaseSavedState(in);
            }

            public BaseSavedState[] newArray(int size) {
                return new BaseSavedState[size];
            }
        };

        public BaseSavedState(Parcel source) {
            super(source);
        }

        public BaseSavedState(Parcelable superState) {
            super(superState);
        }
    }
}

