/*
 * Decompiled with CFR 0.152.
 */
package org.holoeverywhere.preference;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.content.res.XmlResourceParser;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentTransaction;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.TypedValue;
import android.util.Xml;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.ListAdapter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.holoeverywhere.ArrayAdapter;
import org.holoeverywhere.LayoutInflater;
import org.holoeverywhere.R;
import org.holoeverywhere.app.ListActivity;
import org.holoeverywhere.preference.Preference;
import org.holoeverywhere.preference.PreferenceFragment;
import org.holoeverywhere.preference.PreferenceManager;
import org.holoeverywhere.preference.PreferenceScreen;
import org.holoeverywhere.util.XmlUtils;
import org.holoeverywhere.widget.Button;
import org.holoeverywhere.widget.FragmentBreadCrumbs;
import org.holoeverywhere.widget.ListView;
import org.holoeverywhere.widget.TextView;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public abstract class PreferenceActivity
extends ListActivity
implements PreferenceManager.OnPreferenceTreeClickListener,
PreferenceFragment.OnPreferenceStartFragmentCallback {
    private static final String BACK_STACK_PREFS = ":android:prefs";
    private static final String CUR_HEADER_TAG = ":android:cur_header";
    public static final String EXTRA_NO_HEADERS = ":android:no_headers";
    private static final String EXTRA_PREFS_SET_BACK_TEXT = "extra_prefs_set_back_text";
    private static final String EXTRA_PREFS_SET_NEXT_TEXT = "extra_prefs_set_next_text";
    private static final String EXTRA_PREFS_SHOW_BUTTON_BAR = "extra_prefs_show_button_bar";
    private static final String EXTRA_PREFS_SHOW_SKIP = "extra_prefs_show_skip";
    public static final String EXTRA_SHOW_FRAGMENT = ":android:show_fragment";
    public static final String EXTRA_SHOW_FRAGMENT_ARGUMENTS = ":android:show_fragment_args";
    public static final String EXTRA_SHOW_FRAGMENT_SHORT_TITLE = ":android:show_fragment_short_title";
    public static final String EXTRA_SHOW_FRAGMENT_TITLE = ":android:show_fragment_title";
    private static final int FIRST_REQUEST_CODE = 100;
    public static final long HEADER_ID_UNDEFINED = -1L;
    private static final String HEADERS_TAG = ":android:headers";
    private static final int MSG_BIND_PREFERENCES = 1;
    private static final int MSG_BUILD_HEADERS = 2;
    private static final String PREFERENCES_TAG = ":android:preferences";
    private Header mCurHeader;
    private FragmentBreadCrumbs mFragmentBreadCrumbs;
    private Handler mHandler = new Handler(){

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    PreferenceActivity.this.bindPreferences();
                    break;
                }
                case 2: {
                    Header mappedHeader;
                    Header header;
                    ArrayList<Header> oldHeaders = new ArrayList<Header>(PreferenceActivity.this.mHeaders);
                    PreferenceActivity.this.mHeaders.clear();
                    PreferenceActivity.this.onBuildHeaders(PreferenceActivity.this.mHeaders);
                    if (PreferenceActivity.this.mAdapter instanceof BaseAdapter) {
                        ((BaseAdapter)PreferenceActivity.this.mAdapter).notifyDataSetChanged();
                    }
                    if ((header = PreferenceActivity.this.onGetNewHeader()) != null && header.fragment != null) {
                        Header mappedHeader2 = PreferenceActivity.this.findBestMatchingHeader(header, oldHeaders);
                        if (mappedHeader2 != null && PreferenceActivity.this.mCurHeader == mappedHeader2) break;
                        PreferenceActivity.this.switchToHeader(header);
                        break;
                    }
                    if (PreferenceActivity.this.mCurHeader == null || (mappedHeader = PreferenceActivity.this.findBestMatchingHeader(PreferenceActivity.this.mCurHeader, PreferenceActivity.this.mHeaders)) == null) break;
                    PreferenceActivity.this.setSelectedHeader(mappedHeader);
                }
            }
        }
    };
    private final ArrayList<Header> mHeaders = new ArrayList();
    private FrameLayout mListFooter;
    private Button mNextButton;
    private PreferenceManager mPreferenceManager;
    private ViewGroup mPrefsContainer;
    private Bundle mSavedInstanceState;
    private boolean mSinglePane;

    @Deprecated
    public void addPreferencesFromIntent(Intent intent) {
        this.requirePreferenceManager();
        this.setPreferenceScreen(this.mPreferenceManager.inflateFromIntent(intent, this.getPreferenceScreen()));
    }

    @Deprecated
    public void addPreferencesFromResource(int preferencesResId) {
        this.requirePreferenceManager();
        this.setPreferenceScreen(this.mPreferenceManager.inflateFromResource((Context)this, preferencesResId, this.getPreferenceScreen()));
    }

    private void bindPreferences() {
        PreferenceScreen preferenceScreen = this.getPreferenceScreen();
        if (preferenceScreen != null) {
            preferenceScreen.bind(this.getListView());
            if (this.mSavedInstanceState != null) {
                super.onRestoreInstanceState(this.mSavedInstanceState);
                this.mSavedInstanceState = null;
            }
        }
    }

    Header findBestMatchingHeader(Header cur, ArrayList<Header> from) {
        int NM;
        ArrayList<Header> matches = new ArrayList<Header>();
        for (int j = 0; j < from.size(); ++j) {
            Header oh = from.get(j);
            if (cur == oh || cur.id != -1L && cur.id == oh.id) {
                matches.clear();
                matches.add(oh);
                break;
            }
            if (cur.fragment != null) {
                if (!cur.fragment.equals(oh.fragment)) continue;
                matches.add(oh);
                continue;
            }
            if (cur.intent != null) {
                if (!cur.intent.equals(oh.intent)) continue;
                matches.add(oh);
                continue;
            }
            if (cur.title == null || !cur.title.equals(oh.title)) continue;
            matches.add(oh);
        }
        if ((NM = matches.size()) == 1) {
            return (Header)matches.get(0);
        }
        if (NM > 1) {
            for (int j = 0; j < NM; ++j) {
                Header oh = (Header)matches.get(j);
                if (cur.fragmentArguments != null && cur.fragmentArguments.equals(oh.fragmentArguments)) {
                    return oh;
                }
                if (cur.extras != null && cur.extras.equals(oh.extras)) {
                    return oh;
                }
                if (cur.title == null || !cur.title.equals(oh.title)) continue;
                return oh;
            }
        }
        return null;
    }

    @Deprecated
    public Preference findPreference(CharSequence key) {
        if (this.mPreferenceManager == null) {
            return null;
        }
        return this.mPreferenceManager.findPreference(key);
    }

    public void finishPreferencePanel(Fragment caller, int resultCode, Intent resultData) {
        if (this.mSinglePane) {
            this.setResult(resultCode, resultData);
            this.finish();
        } else {
            this.onBackPressed();
            if (caller != null && caller.getTargetFragment() != null) {
                caller.getTargetFragment().onActivityResult(caller.getTargetRequestCode(), resultCode, resultData);
            }
        }
    }

    public List<Header> getHeaders() {
        return this.mHeaders;
    }

    protected Button getNextButton() {
        return this.mNextButton;
    }

    @Deprecated
    public PreferenceManager getPreferenceManager() {
        return this.mPreferenceManager;
    }

    @Deprecated
    public PreferenceScreen getPreferenceScreen() {
        if (this.mPreferenceManager != null) {
            return this.mPreferenceManager.getPreferenceScreen();
        }
        return null;
    }

    public boolean hasHeaders() {
        return this.getListView().getVisibility() == 0 && this.mPreferenceManager == null;
    }

    protected boolean hasNextButton() {
        return this.mNextButton != null;
    }

    public void invalidateHeaders() {
        if (!this.mHandler.hasMessages(2)) {
            this.mHandler.sendEmptyMessage(2);
        }
    }

    public boolean isMultiPane() {
        return this.hasHeaders() && this.mPrefsContainer.getVisibility() == 0;
    }

    public void loadHeadersFromResource(int resid, List<Header> target) {
        XmlResourceParser parser = null;
        try {
            int type;
            parser = this.getResources().getXml(resid);
            AttributeSet attrs = Xml.asAttributeSet((XmlPullParser)parser);
            while ((type = parser.next()) != 1 && type != 2) {
            }
            String nodeName = parser.getName();
            if (!"preference-headers".equals(nodeName)) {
                throw new RuntimeException("XML document must start with <preference-headers> tag; found" + nodeName + " at " + parser.getPositionDescription());
            }
            Bundle curBundle = null;
            int outerDepth = parser.getDepth();
            while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
                if (type == 3 || type == 4) continue;
                nodeName = parser.getName();
                if ("header".equals(nodeName)) {
                    Header header = new Header();
                    TypedArray sa = this.getResources().obtainAttributes(attrs, R.styleable.PreferenceHeader);
                    header.id = sa.getResourceId(2, -1);
                    TypedValue tv = sa.peekValue(0);
                    if (tv != null && tv.type == 3) {
                        if (tv.resourceId != 0) {
                            header.titleRes = tv.resourceId;
                        } else {
                            header.title = tv.string;
                        }
                    }
                    if ((tv = sa.peekValue(3)) != null && tv.type == 3) {
                        if (tv.resourceId != 0) {
                            header.summaryRes = tv.resourceId;
                        } else {
                            header.summary = tv.string;
                        }
                    }
                    if ((tv = sa.peekValue(4)) != null && tv.type == 3) {
                        if (tv.resourceId != 0) {
                            header.breadCrumbTitleRes = tv.resourceId;
                        } else {
                            header.breadCrumbTitle = tv.string;
                        }
                    }
                    if ((tv = sa.peekValue(5)) != null && tv.type == 3) {
                        if (tv.resourceId != 0) {
                            header.breadCrumbShortTitleRes = tv.resourceId;
                        } else {
                            header.breadCrumbShortTitle = tv.string;
                        }
                    }
                    header.iconRes = sa.getResourceId(1, 0);
                    header.fragment = sa.getString(6);
                    sa.recycle();
                    if (curBundle == null) {
                        curBundle = new Bundle();
                    }
                    int innerDepth = parser.getDepth();
                    while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > innerDepth)) {
                        if (type == 3 || type == 4) continue;
                        String innerNodeName = parser.getName();
                        if (innerNodeName.equals("extra")) {
                            this.getResources().parseBundleExtra("extra", attrs, curBundle);
                            XmlUtils.skipCurrentTag((XmlPullParser)parser);
                            continue;
                        }
                        if (innerNodeName.equals("intent")) {
                            header.intent = Intent.parseIntent((Resources)this.getResources(), (XmlPullParser)parser, (AttributeSet)attrs);
                            continue;
                        }
                        XmlUtils.skipCurrentTag((XmlPullParser)parser);
                    }
                    if (curBundle.size() > 0) {
                        header.fragmentArguments = curBundle;
                        curBundle = null;
                    }
                    target.add(header);
                    continue;
                }
                XmlUtils.skipCurrentTag((XmlPullParser)parser);
            }
        }
        catch (XmlPullParserException e) {
            throw new RuntimeException("Error parsing headers", e);
        }
        catch (IOException e) {
            throw new RuntimeException("Error parsing headers", e);
        }
        finally {
            if (parser != null) {
                parser.close();
            }
        }
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (this.mPreferenceManager != null) {
            this.mPreferenceManager.dispatchActivityResult(requestCode, resultCode, data);
        }
    }

    public void onBuildHeaders(List<Header> target) {
    }

    public Intent onBuildStartFragmentIntent(String fragmentName, Bundle args, int titleRes, int shortTitleRes) {
        Intent intent = new Intent("android.intent.action.MAIN");
        intent.setClass((Context)this, this.getClass());
        intent.putExtra(EXTRA_SHOW_FRAGMENT, fragmentName);
        intent.putExtra(EXTRA_SHOW_FRAGMENT_ARGUMENTS, args);
        intent.putExtra(EXTRA_SHOW_FRAGMENT_TITLE, titleRes);
        intent.putExtra(EXTRA_SHOW_FRAGMENT_SHORT_TITLE, shortTitleRes);
        intent.putExtra(EXTRA_NO_HEADERS, true);
        return intent;
    }

    @Override
    public void onContentChanged() {
        super.onContentChanged();
        if (this.mPreferenceManager != null) {
            this.postBindPreferences();
        }
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        Intent intent;
        CharSequence initialTitleStr;
        super.onCreate(savedInstanceState);
        this.setContentView(2130903090);
        this.mListFooter = (FrameLayout)this.findViewById(2131165314);
        this.mPrefsContainer = (ViewGroup)this.findViewById(2131165315);
        boolean hidingHeaders = this.onIsHidingHeaders();
        this.mSinglePane = hidingHeaders || !this.onIsMultiPane();
        String initialFragment = this.getIntent().getStringExtra(EXTRA_SHOW_FRAGMENT);
        Bundle initialArguments = this.getIntent().getBundleExtra(EXTRA_SHOW_FRAGMENT_ARGUMENTS);
        int initialTitle = this.getIntent().getIntExtra(EXTRA_SHOW_FRAGMENT_TITLE, 0);
        int initialShortTitle = this.getIntent().getIntExtra(EXTRA_SHOW_FRAGMENT_SHORT_TITLE, 0);
        if (savedInstanceState != null) {
            ArrayList headers = savedInstanceState.getParcelableArrayList(HEADERS_TAG);
            if (headers != null) {
                this.mHeaders.addAll(headers);
                int curHeader = savedInstanceState.getInt(CUR_HEADER_TAG, -1);
                if (curHeader >= 0 && curHeader < this.mHeaders.size()) {
                    this.setSelectedHeader(this.mHeaders.get(curHeader));
                }
            }
        } else if (initialFragment != null && this.mSinglePane) {
            this.switchToHeader(initialFragment, initialArguments);
            if (initialTitle != 0) {
                initialTitleStr = this.getText(initialTitle);
                CharSequence initialShortTitleStr = initialShortTitle != 0 ? this.getText(initialShortTitle) : null;
                this.showBreadCrumbs(initialTitleStr, initialShortTitleStr);
            }
        } else {
            this.onBuildHeaders(this.mHeaders);
            if (this.mHeaders.size() > 0 && !this.mSinglePane) {
                if (initialFragment == null) {
                    Header h = this.onGetInitialHeader();
                    this.switchToHeader(h);
                } else {
                    this.switchToHeader(initialFragment, initialArguments);
                }
            }
        }
        if (initialFragment != null && this.mSinglePane) {
            this.findViewById(2131165313).setVisibility(8);
            this.mPrefsContainer.setVisibility(0);
            if (initialTitle != 0) {
                initialTitleStr = this.getText(initialTitle);
                CharSequence initialShortTitleStr = initialShortTitle != 0 ? this.getText(initialShortTitle) : null;
                this.showBreadCrumbs(initialTitleStr, initialShortTitleStr);
            }
        } else if (this.mHeaders.size() > 0) {
            this.setListAdapter((ListAdapter)new HeaderAdapter((Context)this, this.mHeaders));
            if (!this.mSinglePane) {
                this.getListView().setChoiceMode(1);
                if (this.mCurHeader != null) {
                    this.setSelectedHeader(this.mCurHeader);
                }
                this.mPrefsContainer.setVisibility(0);
            }
        } else {
            this.setContentView(2130903091);
            this.mListFooter = (FrameLayout)this.findViewById(2131165314);
            this.mPrefsContainer = (ViewGroup)this.findViewById(2131165316);
            this.mPreferenceManager = new PreferenceManager((Activity)this, 100);
            this.mPreferenceManager.setOnPreferenceTreeClickListener(this);
        }
        if ((intent = this.getIntent()).getBooleanExtra(EXTRA_PREFS_SHOW_BUTTON_BAR, false)) {
            String buttonText;
            this.findViewById(2131165317).setVisibility(0);
            Button backButton = (Button)this.findViewById(2131165318);
            backButton.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    PreferenceActivity.this.setResult(0);
                    PreferenceActivity.this.finish();
                }
            });
            Button skipButton = (Button)this.findViewById(2131165319);
            skipButton.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    PreferenceActivity.this.setResult(-1);
                    PreferenceActivity.this.finish();
                }
            });
            this.mNextButton = (Button)this.findViewById(2131165320);
            this.mNextButton.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    PreferenceActivity.this.setResult(-1);
                    PreferenceActivity.this.finish();
                }
            });
            if (intent.hasExtra(EXTRA_PREFS_SET_NEXT_TEXT)) {
                buttonText = intent.getStringExtra(EXTRA_PREFS_SET_NEXT_TEXT);
                if (TextUtils.isEmpty((CharSequence)buttonText)) {
                    this.mNextButton.setVisibility(8);
                } else {
                    this.mNextButton.setText(buttonText);
                }
            }
            if (intent.hasExtra(EXTRA_PREFS_SET_BACK_TEXT)) {
                buttonText = intent.getStringExtra(EXTRA_PREFS_SET_BACK_TEXT);
                if (TextUtils.isEmpty((CharSequence)buttonText)) {
                    backButton.setVisibility(8);
                } else {
                    backButton.setText(buttonText);
                }
            }
            if (intent.getBooleanExtra(EXTRA_PREFS_SHOW_SKIP, false)) {
                skipButton.setVisibility(0);
            }
        }
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        if (this.mPreferenceManager != null) {
            this.mPreferenceManager.dispatchActivityDestroy();
        }
    }

    public Header onGetInitialHeader() {
        return this.mHeaders.get(0);
    }

    public Header onGetNewHeader() {
        return null;
    }

    public void onHeaderClick(Header header, int position) {
        if (header.fragment != null) {
            if (this.mSinglePane) {
                int titleRes = header.breadCrumbTitleRes;
                int shortTitleRes = header.breadCrumbShortTitleRes;
                if (titleRes == 0) {
                    titleRes = header.titleRes;
                    shortTitleRes = 0;
                }
                this.startWithFragment(header.fragment, header.fragmentArguments, null, 0, titleRes, shortTitleRes);
            } else {
                this.switchToHeader(header);
            }
        } else if (header.intent != null) {
            this.startActivity(header.intent);
        }
    }

    public boolean onIsHidingHeaders() {
        return this.getIntent().getBooleanExtra(EXTRA_NO_HEADERS, false);
    }

    public boolean onIsMultiPane() {
        boolean preferMultiPane = this.getResources().getBoolean(2131230726);
        return preferMultiPane;
    }

    @Override
    protected void onListItemClick(ListView l, View v, int position, long id2) {
        Object item;
        super.onListItemClick(l, v, position, id2);
        if (this.mAdapter != null && (item = this.mAdapter.getItem(position)) instanceof Header) {
            this.onHeaderClick((Header)item, position);
        }
    }

    protected void onNewIntent(Intent intent) {
        if (this.mPreferenceManager != null) {
            this.mPreferenceManager.dispatchNewIntent(intent);
        }
    }

    @Override
    public boolean onPreferenceStartFragment(PreferenceFragment caller, Preference pref) {
        this.startPreferencePanel(pref.getFragment(), pref.getExtras(), pref.getTitleRes(), pref.getTitle(), null, 0);
        return true;
    }

    @Override
    @Deprecated
    public boolean onPreferenceTreeClick(PreferenceScreen preferenceScreen, Preference preference) {
        return false;
    }

    @Override
    protected void onRestoreInstanceState(Bundle state) {
        PreferenceScreen preferenceScreen;
        Bundle container;
        if (this.mPreferenceManager != null && (container = state.getBundle(PREFERENCES_TAG)) != null && (preferenceScreen = this.getPreferenceScreen()) != null) {
            preferenceScreen.restoreHierarchyState(container);
            this.mSavedInstanceState = state;
            return;
        }
        super.onRestoreInstanceState(state);
    }

    protected void onSaveInstanceState(Bundle outState) {
        PreferenceScreen preferenceScreen;
        super.onSaveInstanceState(outState);
        if (this.mHeaders.size() > 0) {
            int index;
            outState.putParcelableArrayList(HEADERS_TAG, this.mHeaders);
            if (this.mCurHeader != null && (index = this.mHeaders.indexOf(this.mCurHeader)) >= 0) {
                outState.putInt(CUR_HEADER_TAG, index);
            }
        }
        if (this.mPreferenceManager != null && (preferenceScreen = this.getPreferenceScreen()) != null) {
            Bundle container = new Bundle();
            preferenceScreen.saveHierarchyState(container);
            outState.putBundle(PREFERENCES_TAG, container);
        }
    }

    @Override
    protected void onStop() {
        super.onStop();
        if (this.mPreferenceManager != null) {
            this.mPreferenceManager.dispatchActivityStop();
        }
    }

    private void postBindPreferences() {
        if (this.mHandler.hasMessages(1)) {
            return;
        }
        this.mHandler.obtainMessage(1).sendToTarget();
    }

    private void requirePreferenceManager() {
        if (this.mPreferenceManager == null) {
            if (this.mAdapter == null) {
                throw new RuntimeException("This should be called after super.onCreate.");
            }
            throw new RuntimeException("Modern two-pane PreferenceActivity requires use of a PreferenceFragment");
        }
    }

    public void setListFooter(View view) {
        this.mListFooter.removeAllViews();
        this.mListFooter.addView(view, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -2));
    }

    public void setParentTitle(CharSequence title, CharSequence shortTitle, View.OnClickListener listener) {
        if (this.mFragmentBreadCrumbs != null) {
            this.mFragmentBreadCrumbs.setParentTitle(title, shortTitle, listener);
        }
    }

    @Deprecated
    public void setPreferenceScreen(PreferenceScreen preferenceScreen) {
        this.requirePreferenceManager();
        if (this.mPreferenceManager.setPreferences(preferenceScreen) && preferenceScreen != null) {
            this.postBindPreferences();
            CharSequence title = this.getPreferenceScreen().getTitle();
            if (title != null) {
                this.setTitle(title);
            }
        }
    }

    void setSelectedHeader(Header header) {
        this.mCurHeader = header;
        int index = this.mHeaders.indexOf(header);
        if (index >= 0) {
            this.getListView().setItemChecked(index, true);
        } else {
            this.getListView().clearChoices();
        }
        this.showBreadCrumbs(header);
    }

    public void showBreadCrumbs(CharSequence title, CharSequence shortTitle) {
        if (this.mFragmentBreadCrumbs == null) {
            View crumbs = this.findViewById(16908310);
            try {
                this.mFragmentBreadCrumbs = (FragmentBreadCrumbs)crumbs;
            }
            catch (ClassCastException e) {
                return;
            }
            if (this.mFragmentBreadCrumbs == null) {
                if (title != null) {
                    this.setTitle(title);
                }
                return;
            }
            this.mFragmentBreadCrumbs.setMaxVisible(2);
            this.mFragmentBreadCrumbs.setActivity(this);
        }
        this.mFragmentBreadCrumbs.setTitle(title, shortTitle);
        this.mFragmentBreadCrumbs.setParentTitle(null, null, null);
    }

    void showBreadCrumbs(Header header) {
        if (header != null) {
            CharSequence title = header.getBreadCrumbTitle(this.getResources());
            if (title == null) {
                title = header.getTitle(this.getResources());
            }
            if (title == null) {
                title = this.getTitle();
            }
            this.showBreadCrumbs(title, header.getBreadCrumbShortTitle(this.getResources()));
        } else {
            this.showBreadCrumbs(this.getTitle(), null);
        }
    }

    public void startPreferenceFragment(Fragment fragment, boolean push) {
        FragmentTransaction transaction = this.getSupportFragmentManager().beginTransaction();
        transaction.replace(2131165316, fragment);
        if (push) {
            transaction.setTransition(4097);
            transaction.addToBackStack(BACK_STACK_PREFS);
        } else {
            transaction.setTransition(4099);
        }
        transaction.commitAllowingStateLoss();
    }

    public void startPreferencePanel(String fragmentClass, Bundle args, int titleRes, CharSequence titleText, Fragment resultTo, int resultRequestCode) {
        if (this.mSinglePane) {
            this.startWithFragment(fragmentClass, args, resultTo, resultRequestCode, titleRes, 0);
        } else {
            Fragment f = Fragment.instantiate((Context)this, (String)fragmentClass, (Bundle)args);
            if (resultTo != null) {
                f.setTargetFragment(resultTo, resultRequestCode);
            }
            FragmentTransaction transaction = this.getSupportFragmentManager().beginTransaction();
            transaction.replace(2131165316, f);
            if (titleRes != 0) {
                transaction.setBreadCrumbTitle(titleRes);
            } else if (titleText != null) {
                transaction.setBreadCrumbTitle(titleText);
            }
            transaction.setTransition(4097);
            transaction.addToBackStack(BACK_STACK_PREFS);
            transaction.commitAllowingStateLoss();
        }
    }

    public void startWithFragment(String fragmentName, Bundle args, Fragment resultTo, int resultRequestCode) {
        this.startWithFragment(fragmentName, args, resultTo, resultRequestCode, 0, 0);
    }

    public void startWithFragment(String fragmentName, Bundle args, Fragment resultTo, int resultRequestCode, int titleRes, int shortTitleRes) {
        Intent intent = this.onBuildStartFragmentIntent(fragmentName, args, titleRes, shortTitleRes);
        if (resultTo == null) {
            this.startActivity(intent);
        } else {
            resultTo.startActivityForResult(intent, resultRequestCode);
        }
    }

    public void switchToHeader(Header header) {
        if (this.mCurHeader == header) {
            this.getSupportFragmentManager().popBackStack(BACK_STACK_PREFS, 1);
        } else {
            int direction = this.mHeaders.indexOf(header) - this.mHeaders.indexOf(this.mCurHeader);
            this.switchToHeaderInner(header.fragment, header.fragmentArguments, direction);
            this.setSelectedHeader(header);
        }
    }

    public void switchToHeader(String fragmentName, Bundle args) {
        this.setSelectedHeader(null);
        this.switchToHeaderInner(fragmentName, args, 0);
    }

    private void switchToHeaderInner(String fragmentName, Bundle args, int direction) {
        this.getSupportFragmentManager().popBackStack(BACK_STACK_PREFS, 1);
        Fragment f = Fragment.instantiate((Context)this, (String)fragmentName, (Bundle)args);
        FragmentTransaction transaction = this.getSupportFragmentManager().beginTransaction();
        transaction.setTransition(4099);
        transaction.replace(2131165316, f);
        transaction.commitAllowingStateLoss();
    }

    private static class HeaderAdapter
    extends ArrayAdapter<Header> {
        private LayoutInflater mInflater;

        public HeaderAdapter(Context context, List<Header> objects) {
            super(context, 0, objects);
            this.mInflater = LayoutInflater.from(context);
        }

        @Override
        public View getView(int position, View convertView, ViewGroup parent) {
            HeaderViewHolder holder;
            View view;
            if (convertView == null) {
                view = this.mInflater.inflate(2130903087, parent, false);
                holder = new HeaderViewHolder();
                holder.icon = (ImageView)view.findViewById(2131165274);
                holder.title = (TextView)view.findViewById(2131165290);
                holder.summary = (TextView)view.findViewById(2131165309);
                view.setTag((Object)holder);
            } else {
                view = convertView;
                holder = (HeaderViewHolder)view.getTag();
            }
            Header header = (Header)this.getItem(position);
            holder.icon.setImageResource(header.iconRes);
            holder.title.setText(header.getTitle(this.getContext().getResources()));
            CharSequence summary = header.getSummary(this.getContext().getResources());
            if (!TextUtils.isEmpty((CharSequence)summary)) {
                holder.summary.setVisibility(0);
                holder.summary.setText(summary);
            } else {
                holder.summary.setVisibility(8);
            }
            return view;
        }

        private static class HeaderViewHolder {
            ImageView icon;
            TextView summary;
            TextView title;

            private HeaderViewHolder() {
            }
        }
    }

    public static final class Header
    implements Parcelable {
        public static final Parcelable.Creator<Header> CREATOR = new Parcelable.Creator<Header>(){

            public Header createFromParcel(Parcel source) {
                return new Header(source);
            }

            public Header[] newArray(int size) {
                return new Header[size];
            }
        };
        public CharSequence breadCrumbShortTitle;
        public int breadCrumbShortTitleRes;
        public CharSequence breadCrumbTitle;
        public int breadCrumbTitleRes;
        public Bundle extras;
        public String fragment;
        public Bundle fragmentArguments;
        public int iconRes;
        public long id = -1L;
        public Intent intent;
        public CharSequence summary;
        public int summaryRes;
        public CharSequence title;
        public int titleRes;

        public Header() {
        }

        Header(Parcel in) {
            this.readFromParcel(in);
        }

        public int describeContents() {
            return 0;
        }

        public CharSequence getBreadCrumbShortTitle(Resources res) {
            if (this.breadCrumbShortTitleRes != 0) {
                return res.getText(this.breadCrumbShortTitleRes);
            }
            return this.breadCrumbShortTitle;
        }

        public CharSequence getBreadCrumbTitle(Resources res) {
            if (this.breadCrumbTitleRes != 0) {
                return res.getText(this.breadCrumbTitleRes);
            }
            return this.breadCrumbTitle;
        }

        public CharSequence getSummary(Resources res) {
            if (this.summaryRes != 0) {
                return res.getText(this.summaryRes);
            }
            return this.summary;
        }

        public CharSequence getTitle(Resources res) {
            if (this.titleRes != 0) {
                return res.getText(this.titleRes);
            }
            return this.title;
        }

        public void readFromParcel(Parcel in) {
            this.id = in.readLong();
            this.titleRes = in.readInt();
            this.title = (CharSequence)TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(in);
            this.summaryRes = in.readInt();
            this.summary = (CharSequence)TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(in);
            this.breadCrumbTitleRes = in.readInt();
            this.breadCrumbTitle = (CharSequence)TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(in);
            this.breadCrumbShortTitleRes = in.readInt();
            this.breadCrumbShortTitle = (CharSequence)TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(in);
            this.iconRes = in.readInt();
            this.fragment = in.readString();
            this.fragmentArguments = in.readBundle();
            if (in.readInt() != 0) {
                this.intent = (Intent)Intent.CREATOR.createFromParcel(in);
            }
            this.extras = in.readBundle();
        }

        public void writeToParcel(Parcel dest, int flags) {
            dest.writeLong(this.id);
            dest.writeInt(this.titleRes);
            TextUtils.writeToParcel((CharSequence)this.title, (Parcel)dest, (int)flags);
            dest.writeInt(this.summaryRes);
            TextUtils.writeToParcel((CharSequence)this.summary, (Parcel)dest, (int)flags);
            dest.writeInt(this.breadCrumbTitleRes);
            TextUtils.writeToParcel((CharSequence)this.breadCrumbTitle, (Parcel)dest, (int)flags);
            dest.writeInt(this.breadCrumbShortTitleRes);
            TextUtils.writeToParcel((CharSequence)this.breadCrumbShortTitle, (Parcel)dest, (int)flags);
            dest.writeInt(this.iconRes);
            dest.writeString(this.fragment);
            dest.writeBundle(this.fragmentArguments);
            if (this.intent != null) {
                dest.writeInt(1);
                this.intent.writeToParcel(dest, flags);
            } else {
                dest.writeInt(0);
            }
            dest.writeBundle(this.extras);
        }
    }
}

