/*
 * Decompiled with CFR 0.152.
 */
package org.holoeverywhere.preference;

import android.os.Handler;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.holoeverywhere.preference.Preference;
import org.holoeverywhere.preference.PreferenceGroup;

class PreferenceGroupAdapter
extends BaseAdapter
implements Preference.OnPreferenceChangeInternalListener {
    private Handler mHandler = new Handler();
    private boolean mHasReturnedViewTypeCount = false;
    private volatile boolean mIsSyncing = false;
    private PreferenceGroup mPreferenceGroup;
    private List<PreferenceLayout> mPreferenceLayouts;
    private List<Preference> mPreferenceList;
    private Runnable mSyncRunnable = new Runnable(){

        @Override
        public void run() {
            PreferenceGroupAdapter.this.syncMyPreferences();
        }
    };
    private PreferenceLayout mTempPreferenceLayout = new PreferenceLayout();

    public PreferenceGroupAdapter(PreferenceGroup preferenceGroup) {
        this.mPreferenceGroup = preferenceGroup;
        this.mPreferenceGroup.setOnPreferenceChangeInternalListener(this);
        int c = preferenceGroup.getPreferenceCount();
        this.mPreferenceList = new ArrayList<Preference>(c);
        this.mPreferenceLayouts = new ArrayList<PreferenceLayout>(c);
        this.syncMyPreferences();
    }

    private void addPreferenceClassName(Preference preference) {
        PreferenceLayout pl = this.createPreferenceLayout(preference, null);
        int insertPos = Collections.binarySearch(this.mPreferenceLayouts, pl);
        if (insertPos < 0) {
            insertPos = insertPos * -1 - 1;
            this.mPreferenceLayouts.add(insertPos, pl);
        }
    }

    public boolean areAllItemsEnabled() {
        return false;
    }

    private PreferenceLayout createPreferenceLayout(Preference preference, PreferenceLayout in) {
        PreferenceLayout pl = in != null ? in : new PreferenceLayout();
        pl.name = preference.getClass().getName();
        pl.resId = preference.getLayoutResource();
        pl.widgetResId = preference.getWidgetLayoutResource();
        return pl;
    }

    private void flattenPreferenceGroup(List<Preference> preferences, PreferenceGroup group) {
        group.sortPreferences();
        int groupSize = group.getPreferenceCount();
        for (int i = 0; i < groupSize; ++i) {
            PreferenceGroup preferenceAsGroup;
            Preference preference = group.getPreference(i);
            preferences.add(preference);
            if (!this.mHasReturnedViewTypeCount && !preference.hasSpecifiedLayout()) {
                this.addPreferenceClassName(preference);
            }
            if (preference instanceof PreferenceGroup && (preferenceAsGroup = (PreferenceGroup)preference).isOnSameScreenAsChildren()) {
                this.flattenPreferenceGroup(preferences, preferenceAsGroup);
            }
            preference.setOnPreferenceChangeInternalListener(this);
        }
    }

    public int getCount() {
        return this.mPreferenceList.size();
    }

    public Preference getItem(int position) {
        if (position < 0 || position >= this.getCount()) {
            return null;
        }
        return this.mPreferenceList.get(position);
    }

    public long getItemId(int position) {
        if (position < 0 || position >= this.getCount()) {
            return Long.MIN_VALUE;
        }
        return this.getItem(position).getId();
    }

    public int getItemViewType(int position) {
        Preference preference;
        if (!this.mHasReturnedViewTypeCount) {
            this.mHasReturnedViewTypeCount = true;
        }
        if (!(preference = this.getItem(position)).hasSpecifiedLayout()) {
            return -1;
        }
        this.mTempPreferenceLayout = this.createPreferenceLayout(preference, this.mTempPreferenceLayout);
        int viewType = Collections.binarySearch(this.mPreferenceLayouts, this.mTempPreferenceLayout);
        if (viewType < 0) {
            return -1;
        }
        return viewType;
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        Preference preference = this.getItem(position);
        this.mTempPreferenceLayout = this.createPreferenceLayout(preference, this.mTempPreferenceLayout);
        if (Collections.binarySearch(this.mPreferenceLayouts, this.mTempPreferenceLayout) < 0) {
            convertView = null;
        }
        return preference.getView(convertView, parent);
    }

    public int getViewTypeCount() {
        if (!this.mHasReturnedViewTypeCount) {
            this.mHasReturnedViewTypeCount = true;
        }
        return Math.max(1, this.mPreferenceLayouts.size());
    }

    public boolean hasStableIds() {
        return true;
    }

    public boolean isEnabled(int position) {
        if (position < 0 || position >= this.getCount()) {
            return true;
        }
        return this.getItem(position).isSelectable();
    }

    @Override
    public void onPreferenceChange(Preference preference) {
        this.notifyDataSetChanged();
    }

    @Override
    public void onPreferenceHierarchyChange(Preference preference) {
        this.mHandler.removeCallbacks(this.mSyncRunnable);
        this.mHandler.post(this.mSyncRunnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void syncMyPreferences() {
        PreferenceGroupAdapter preferenceGroupAdapter = this;
        synchronized (preferenceGroupAdapter) {
            if (this.mIsSyncing) {
                return;
            }
            this.mIsSyncing = true;
        }
        ArrayList<Preference> newPreferenceList = new ArrayList<Preference>(this.mPreferenceList.size());
        this.flattenPreferenceGroup(newPreferenceList, this.mPreferenceGroup);
        this.mPreferenceList = newPreferenceList;
        this.notifyDataSetChanged();
        PreferenceGroupAdapter preferenceGroupAdapter2 = this;
        synchronized (preferenceGroupAdapter2) {
            this.mIsSyncing = false;
            this.notifyAll();
        }
    }

    private static class PreferenceLayout
    implements Comparable<PreferenceLayout> {
        private String name;
        private int resId;
        private int widgetResId;

        private PreferenceLayout() {
        }

        @Override
        public int compareTo(PreferenceLayout other) {
            int compareNames = this.name.compareTo(other.name);
            if (compareNames == 0) {
                if (this.resId == other.resId) {
                    if (this.widgetResId == other.widgetResId) {
                        return 0;
                    }
                    return this.widgetResId - other.widgetResId;
                }
                return this.resId - other.resId;
            }
            return compareNames;
        }
    }
}

