/*
 * Decompiled with CFR 0.152.
 */
package org.holoeverywhere.preference;

import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.util.AttributeSet;
import java.io.IOException;
import org.holoeverywhere.app.Application;
import org.holoeverywhere.internal.GenericInflater;
import org.holoeverywhere.preference.Preference;
import org.holoeverywhere.preference.PreferenceGroup;
import org.holoeverywhere.preference.PreferenceManager;
import org.holoeverywhere.util.XmlUtils;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

class PreferenceInflater
extends GenericInflater<Preference, PreferenceGroup> {
    private static final String EXTRA_TAG_NAME = "extra";
    private static final String INTENT_TAG_NAME = "intent";
    private PreferenceManager mPreferenceManager;

    public PreferenceInflater(Context context, PreferenceManager preferenceManager) {
        super(context);
        this.init(preferenceManager);
    }

    public PreferenceInflater(GenericInflater<Preference, PreferenceGroup> original, PreferenceManager preferenceManager, Context newContext) {
        super(original, newContext);
        this.init(preferenceManager);
    }

    @Override
    public GenericInflater<Preference, PreferenceGroup> cloneInContext(Context newContext) {
        return new PreferenceInflater(this, this.mPreferenceManager, newContext);
    }

    private void init(PreferenceManager preferenceManager) {
        this.mPreferenceManager = preferenceManager;
        this.setDefaultPackage(Application.config().getPreferencePackage() + ".");
    }

    @Override
    protected boolean onCreateCustomFromTag(XmlPullParser parser, Preference parentPreference, AttributeSet attrs) throws XmlPullParserException {
        String tag = parser.getName();
        if (tag.equals(INTENT_TAG_NAME)) {
            Intent intent = null;
            try {
                intent = Intent.parseIntent((Resources)this.getContext().getResources(), (XmlPullParser)parser, (AttributeSet)attrs);
            }
            catch (IOException e) {
                XmlPullParserException ex = new XmlPullParserException("Error parsing preference");
                ex.initCause((Throwable)e);
                throw ex;
            }
            if (intent != null) {
                parentPreference.setIntent(intent);
            }
            return true;
        }
        if (tag.equals(EXTRA_TAG_NAME)) {
            this.getContext().getResources().parseBundleExtra(EXTRA_TAG_NAME, attrs, parentPreference.getExtras());
            try {
                XmlUtils.skipCurrentTag(parser);
            }
            catch (IOException e) {
                XmlPullParserException ex = new XmlPullParserException("Error parsing preference");
                ex.initCause((Throwable)e);
                throw ex;
            }
            return true;
        }
        return false;
    }

    @Override
    protected PreferenceGroup onMergeRoots(PreferenceGroup givenRoot, boolean attachToGivenRoot, PreferenceGroup xmlRoot) {
        if (givenRoot == null) {
            xmlRoot.onAttachedToHierarchy(this.mPreferenceManager);
            return xmlRoot;
        }
        return givenRoot;
    }
}

