/*
 * Decompiled with CFR 0.152.
 */
package org.holoeverywhere.preference;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.res.XmlResourceParser;
import android.os.Build;
import android.os.Bundle;
import android.util.Log;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.holoeverywhere.app.Application;
import org.holoeverywhere.internal._SharedPreferencesImpl_JSON;
import org.holoeverywhere.internal._SharedPreferencesImpl_XML;
import org.holoeverywhere.preference.Preference;
import org.holoeverywhere.preference.PreferenceFragment;
import org.holoeverywhere.preference.PreferenceInflater;
import org.holoeverywhere.preference.PreferenceScreen;
import org.holoeverywhere.preference.SharedPreferences;
import org.xmlpull.v1.XmlPullParser;

public class PreferenceManager {
    public static final String KEY_HAS_SET_DEFAULT_VALUES = "_has_set_default_values";
    public static final String METADATA_KEY_PREFERENCES = "com.WazaBe.HoloEverywhere.preference";
    private static final String TAG = "PreferenceManager";
    private Activity mActivity;
    private List<OnActivityDestroyListener> mActivityDestroyListeners;
    private List<OnActivityResultListener> mActivityResultListeners;
    private List<OnActivityStopListener> mActivityStopListeners;
    private Context mContext;
    private SharedPreferences.Editor mEditor;
    private PreferenceFragment mFragment;
    private long mNextId = 0L;
    private int mNextRequestCode;
    private boolean mNoCommit;
    private OnPreferenceTreeClickListener mOnPreferenceTreeClickListener;
    private PreferenceScreen mPreferenceScreen;
    private List<DialogInterface> mPreferencesScreens;
    private SharedPreferences mSharedPreferences;
    private int mSharedPreferencesMode;
    private String mSharedPreferencesName;

    public static SharedPreferences getDefaultSharedPreferences(Context context) {
        return PreferenceManager.getDefaultSharedPreferences(context, Application.config().getPreferenceImpl());
    }

    public static SharedPreferences getDefaultSharedPreferences(Context context, Application.Config.PreferenceImpl impl) {
        return PreferenceManager.wrap(context, impl, PreferenceManager.getDefaultSharedPreferencesName(context), PreferenceManager.getDefaultSharedPreferencesMode());
    }

    private static int getDefaultSharedPreferencesMode() {
        return 0;
    }

    private static String getDefaultSharedPreferencesName(Context context) {
        return context.getPackageName() + "_preferences";
    }

    public static void setDefaultValues(Context context, int resId, boolean readAgain) {
        PreferenceManager.setDefaultValues(context, PreferenceManager.getDefaultSharedPreferencesName(context), PreferenceManager.getDefaultSharedPreferencesMode(), resId, readAgain);
    }

    @SuppressLint(value={"NewApi"})
    public static void setDefaultValues(Context context, String sharedPreferencesName, int sharedPreferencesMode, int resId, boolean readAgain) {
        SharedPreferences defaultValueSp = PreferenceManager.wrap(context, KEY_HAS_SET_DEFAULT_VALUES, 0);
        if (readAgain || !defaultValueSp.getBoolean(KEY_HAS_SET_DEFAULT_VALUES, false)) {
            PreferenceManager pm = new PreferenceManager(context);
            pm.setSharedPreferencesName(sharedPreferencesName);
            pm.setSharedPreferencesMode(sharedPreferencesMode);
            pm.inflateFromResource(context, resId, null);
            SharedPreferences.Editor editor = defaultValueSp.edit().putBoolean(KEY_HAS_SET_DEFAULT_VALUES, true);
            try {
                if (Build.VERSION.SDK_INT < 9) {
                    throw new AbstractMethodError();
                }
                editor.apply();
            }
            catch (AbstractMethodError unused) {
                editor.commit();
            }
        }
    }

    public static SharedPreferences wrap(Context context, Application.Config.PreferenceImpl impl, String name, int mode) {
        switch (impl) {
            case XML: {
                return new _SharedPreferencesImpl_XML(context, name, mode);
            }
        }
        return new _SharedPreferencesImpl_JSON(context, name, mode);
    }

    public static SharedPreferences wrap(Context context, String name, int mode) {
        return PreferenceManager.wrap(context, Application.config().getPreferenceImpl(), name, mode);
    }

    PreferenceManager(Activity activity, int firstRequestCode) {
        this.mActivity = activity;
        this.mNextRequestCode = firstRequestCode;
        this.init((Context)activity);
    }

    private PreferenceManager(Context context) {
        this.init(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addPreferencesScreen(DialogInterface screen) {
        PreferenceManager preferenceManager = this;
        synchronized (preferenceManager) {
            if (this.mPreferencesScreens == null) {
                this.mPreferencesScreens = new ArrayList<DialogInterface>();
            }
            this.mPreferencesScreens.add(screen);
        }
    }

    public PreferenceScreen createPreferenceScreen(Context context) {
        PreferenceScreen preferenceScreen = new PreferenceScreen(context, null);
        preferenceScreen.onAttachedToHierarchy(this);
        return preferenceScreen;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dismissAllScreens() {
        ArrayList<DialogInterface> screensToDismiss;
        PreferenceManager preferenceManager = this;
        synchronized (preferenceManager) {
            if (this.mPreferencesScreens == null) {
                return;
            }
            screensToDismiss = new ArrayList<DialogInterface>(this.mPreferencesScreens);
            this.mPreferencesScreens.clear();
        }
        for (int i = screensToDismiss.size() - 1; i >= 0; --i) {
            screensToDismiss.get(i).dismiss();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dispatchActivityDestroy() {
        ArrayList<OnActivityDestroyListener> list = null;
        PreferenceManager preferenceManager = this;
        synchronized (preferenceManager) {
            if (this.mActivityDestroyListeners != null) {
                list = new ArrayList<OnActivityDestroyListener>(this.mActivityDestroyListeners);
            }
        }
        if (list != null) {
            int N = list.size();
            for (int i = 0; i < N; ++i) {
                ((OnActivityDestroyListener)list.get(i)).onActivityDestroy();
            }
        }
        this.dismissAllScreens();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dispatchActivityResult(int requestCode, int resultCode, Intent data) {
        ArrayList<OnActivityResultListener> list;
        PreferenceManager preferenceManager = this;
        synchronized (preferenceManager) {
            if (this.mActivityResultListeners == null) {
                return;
            }
            list = new ArrayList<OnActivityResultListener>(this.mActivityResultListeners);
        }
        int N = list.size();
        for (int i = 0; i < N && !((OnActivityResultListener)list.get(i)).onActivityResult(requestCode, resultCode, data); ++i) {
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dispatchActivityStop() {
        ArrayList<OnActivityStopListener> list;
        PreferenceManager preferenceManager = this;
        synchronized (preferenceManager) {
            if (this.mActivityStopListeners == null) {
                return;
            }
            list = new ArrayList<OnActivityStopListener>(this.mActivityStopListeners);
        }
        int N = list.size();
        for (int i = 0; i < N; ++i) {
            ((OnActivityStopListener)list.get(i)).onActivityStop();
        }
    }

    void dispatchNewIntent(Intent intent) {
        this.dismissAllScreens();
    }

    public Preference findPreference(CharSequence key) {
        if (this.mPreferenceScreen == null) {
            return null;
        }
        return this.mPreferenceScreen.findPreference(key);
    }

    Activity getActivity() {
        return this.mActivity;
    }

    Context getContext() {
        return this.mContext;
    }

    SharedPreferences.Editor getEditor() {
        if (this.mNoCommit) {
            if (this.mEditor == null) {
                this.mEditor = this.getSharedPreferences().edit();
            }
            return this.mEditor;
        }
        return this.getSharedPreferences().edit();
    }

    PreferenceFragment getFragment() {
        return this.mFragment;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long getNextId() {
        PreferenceManager preferenceManager = this;
        synchronized (preferenceManager) {
            return this.mNextId++;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getNextRequestCode() {
        PreferenceManager preferenceManager = this;
        synchronized (preferenceManager) {
            return this.mNextRequestCode++;
        }
    }

    OnPreferenceTreeClickListener getOnPreferenceTreeClickListener() {
        return this.mOnPreferenceTreeClickListener;
    }

    PreferenceScreen getPreferenceScreen() {
        return this.mPreferenceScreen;
    }

    public SharedPreferences getSharedPreferences() {
        if (this.mSharedPreferences == null) {
            this.mSharedPreferences = PreferenceManager.wrap(this.mContext, this.mSharedPreferencesName, this.mSharedPreferencesMode);
        }
        return this.mSharedPreferences;
    }

    public int getSharedPreferencesMode() {
        return this.mSharedPreferencesMode;
    }

    public String getSharedPreferencesName() {
        return this.mSharedPreferencesName;
    }

    PreferenceScreen inflateFromIntent(Intent queryIntent, PreferenceScreen rootPreferences) {
        List<ResolveInfo> activities = this.queryIntentActivities(queryIntent);
        HashSet<String> inflatedRes = new HashSet<String>();
        for (int i = activities.size() - 1; i >= 0; --i) {
            Context context;
            String uniqueResId;
            ActivityInfo activityInfo = activities.get((int)i).activityInfo;
            Bundle metaData = activityInfo.metaData;
            if (metaData == null || !metaData.containsKey(METADATA_KEY_PREFERENCES) || inflatedRes.contains(uniqueResId = activityInfo.packageName + ":" + activityInfo.metaData.getInt(METADATA_KEY_PREFERENCES))) continue;
            inflatedRes.add(uniqueResId);
            try {
                context = this.mContext.createPackageContext(activityInfo.packageName, 0);
            }
            catch (PackageManager.NameNotFoundException e) {
                Log.w((String)TAG, (String)("Could not create context for " + activityInfo.packageName + ": " + Log.getStackTraceString((Throwable)e)));
                continue;
            }
            PreferenceInflater inflater = new PreferenceInflater(context, this);
            XmlResourceParser parser = activityInfo.loadXmlMetaData(context.getPackageManager(), METADATA_KEY_PREFERENCES);
            rootPreferences = (PreferenceScreen)inflater.inflate((XmlPullParser)parser, rootPreferences, true);
            parser.close();
        }
        rootPreferences.onAttachedToHierarchy(this);
        return rootPreferences;
    }

    public PreferenceScreen inflateFromResource(Context context, int resId, PreferenceScreen rootPreferences) {
        this.setNoCommit(true);
        PreferenceInflater inflater = new PreferenceInflater(context, this);
        rootPreferences = (PreferenceScreen)inflater.inflate(resId, rootPreferences, true);
        rootPreferences.onAttachedToHierarchy(this);
        this.setNoCommit(false);
        return rootPreferences;
    }

    private void init(Context context) {
        this.mContext = context;
        this.setSharedPreferencesName(PreferenceManager.getDefaultSharedPreferencesName(context));
    }

    private List<ResolveInfo> queryIntentActivities(Intent queryIntent) {
        return this.mContext.getPackageManager().queryIntentActivities(queryIntent, 128);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerOnActivityDestroyListener(OnActivityDestroyListener listener) {
        PreferenceManager preferenceManager = this;
        synchronized (preferenceManager) {
            if (this.mActivityDestroyListeners == null) {
                this.mActivityDestroyListeners = new ArrayList<OnActivityDestroyListener>();
            }
            if (!this.mActivityDestroyListeners.contains(listener)) {
                this.mActivityDestroyListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerOnActivityResultListener(OnActivityResultListener listener) {
        PreferenceManager preferenceManager = this;
        synchronized (preferenceManager) {
            if (this.mActivityResultListeners == null) {
                this.mActivityResultListeners = new ArrayList<OnActivityResultListener>();
            }
            if (!this.mActivityResultListeners.contains(listener)) {
                this.mActivityResultListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerOnActivityStopListener(OnActivityStopListener listener) {
        PreferenceManager preferenceManager = this;
        synchronized (preferenceManager) {
            if (this.mActivityStopListeners == null) {
                this.mActivityStopListeners = new ArrayList<OnActivityStopListener>();
            }
            if (!this.mActivityStopListeners.contains(listener)) {
                this.mActivityStopListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removePreferencesScreen(DialogInterface screen) {
        PreferenceManager preferenceManager = this;
        synchronized (preferenceManager) {
            if (this.mPreferencesScreens == null) {
                return;
            }
            this.mPreferencesScreens.remove(screen);
        }
    }

    void setFragment(PreferenceFragment fragment) {
        this.mFragment = fragment;
    }

    @SuppressLint(value={"NewApi"})
    private void setNoCommit(boolean noCommit) {
        if (!noCommit && this.mEditor != null) {
            try {
                if (Build.VERSION.SDK_INT < 9) {
                    throw new AbstractMethodError();
                }
                this.mEditor.apply();
            }
            catch (AbstractMethodError unused) {
                this.mEditor.commit();
            }
        }
        this.mNoCommit = noCommit;
    }

    void setOnPreferenceTreeClickListener(OnPreferenceTreeClickListener listener) {
        this.mOnPreferenceTreeClickListener = listener;
    }

    boolean setPreferences(PreferenceScreen preferenceScreen) {
        if (preferenceScreen != this.mPreferenceScreen) {
            this.mPreferenceScreen = preferenceScreen;
            return true;
        }
        return false;
    }

    public void setSharedPreferencesMode(int sharedPreferencesMode) {
        this.mSharedPreferencesMode = sharedPreferencesMode;
        this.mSharedPreferences = null;
    }

    public void setSharedPreferencesName(String sharedPreferencesName) {
        this.mSharedPreferencesName = sharedPreferencesName;
        this.mSharedPreferences = null;
    }

    boolean shouldCommit() {
        return !this.mNoCommit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unregisterOnActivityDestroyListener(OnActivityDestroyListener listener) {
        PreferenceManager preferenceManager = this;
        synchronized (preferenceManager) {
            if (this.mActivityDestroyListeners != null) {
                this.mActivityDestroyListeners.remove(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unregisterOnActivityResultListener(OnActivityResultListener listener) {
        PreferenceManager preferenceManager = this;
        synchronized (preferenceManager) {
            if (this.mActivityResultListeners != null) {
                this.mActivityResultListeners.remove(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unregisterOnActivityStopListener(OnActivityStopListener listener) {
        PreferenceManager preferenceManager = this;
        synchronized (preferenceManager) {
            if (this.mActivityStopListeners != null) {
                this.mActivityStopListeners.remove(listener);
            }
        }
    }

    static interface OnPreferenceTreeClickListener {
        public boolean onPreferenceTreeClick(PreferenceScreen var1, Preference var2);
    }

    public static interface OnActivityStopListener {
        public void onActivityStop();
    }

    public static interface OnActivityResultListener {
        public boolean onActivityResult(int var1, int var2, Intent var3);
    }

    public static interface OnActivityDestroyListener {
        public void onActivityDestroy();
    }
}

