/*
 * Decompiled with CFR 0.152.
 */
package org.holoeverywhere.preference;

import android.annotation.SuppressLint;
import android.app.ActionBar;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.Log;
import android.view.MenuItem;
import android.view.View;
import android.widget.AdapterView;
import android.widget.FrameLayout;
import android.widget.ListAdapter;
import com.actionbarsherlock.internal.view.menu.MenuItemWrapper;
import com.actionbarsherlock.internal.widget.ActionBarView;
import com.actionbarsherlock.view.Window;
import java.lang.reflect.Method;
import org.holoeverywhere.LayoutInflater;
import org.holoeverywhere.app.Activity;
import org.holoeverywhere.app.Dialog;
import org.holoeverywhere.preference.Preference;
import org.holoeverywhere.preference.PreferenceGroup;
import org.holoeverywhere.preference.PreferenceGroupAdapter;
import org.holoeverywhere.widget.ListView;

public final class PreferenceScreen
extends PreferenceGroup
implements AdapterView.OnItemClickListener,
DialogInterface.OnDismissListener {
    private PreferenceDialog mDialog;
    private ListView mListView;
    private ListAdapter mRootAdapter;
    private final String TAG = this.getClass().getSimpleName();

    public PreferenceScreen(Context context, AttributeSet attrs) {
        super(context, attrs, 2130772066);
    }

    public void bind(ListView listView) {
        listView.setOnItemClickListener(this);
        listView.setAdapter(this.getRootAdapter());
        this.onAttachedToActivity();
    }

    public Dialog getDialog() {
        return this.mDialog;
    }

    public ListAdapter getRootAdapter() {
        if (this.mRootAdapter == null) {
            this.mRootAdapter = this.onCreateRootAdapter();
        }
        return this.mRootAdapter;
    }

    protected int getThemeResId(Context context) {
        try {
            Class<?> clazz;
            int t;
            if (context instanceof Activity && (t = ((Activity)context).getLastThemeResourceId()) > 0) {
                return t;
            }
            for (clazz = context.getClass(); clazz != Context.class; clazz = clazz.getSuperclass()) {
            }
            Method method = clazz.getDeclaredMethod("getThemeResId", new Class[0]);
            method.setAccessible(true);
            return (Integer)method.invoke((Object)context, new Object[0]);
        }
        catch (Exception e) {
            Log.e((String)this.TAG, (String)"Failed getting context theme", (Throwable)e);
            return 2131558621;
        }
    }

    @Override
    protected boolean isOnSameScreenAsChildren() {
        return false;
    }

    @Override
    protected void onClick() {
        if (this.getIntent() != null || this.getFragment() != null || this.getPreferenceCount() == 0) {
            return;
        }
        this.showDialog(null);
    }

    protected ListAdapter onCreateRootAdapter() {
        return new PreferenceGroupAdapter(this);
    }

    public void onDismiss(DialogInterface dialog) {
        this.mDialog = null;
        this.getPreferenceManager().removePreferencesScreen(dialog);
    }

    public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
        Object item;
        if (parent instanceof ListView) {
            position -= ((ListView)parent).getHeaderViewsCount();
        }
        if (!((item = this.getRootAdapter().getItem(position)) instanceof Preference)) {
            return;
        }
        Preference preference = (Preference)item;
        preference.performClick(this);
    }

    @Override
    protected void onRestoreInstanceState(Parcelable state) {
        if (state == null || !state.getClass().equals(SavedState.class)) {
            super.onRestoreInstanceState(state);
            return;
        }
        SavedState myState = (SavedState)state;
        super.onRestoreInstanceState(myState.getSuperState());
        if (myState.isDialogShowing) {
            this.showDialog(myState.dialogBundle);
        }
    }

    @Override
    protected Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        PreferenceDialog dialog = this.mDialog;
        if (dialog == null || !dialog.isShowing()) {
            return superState;
        }
        SavedState myState = new SavedState(superState);
        myState.isDialogShowing = true;
        myState.dialogBundle = dialog.onSaveInstanceState();
        return myState;
    }

    @SuppressLint(value={"NewApi"})
    private void showDialog(Bundle state) {
        Context context = this.getContext();
        if (this.mListView != null) {
            this.mListView.setAdapter(null);
        }
        int theme = this.getThemeResId(context);
        LayoutInflater inflater = LayoutInflater.from(context);
        View childPrefScreen = inflater.inflate(2130903092, null);
        this.mListView = (ListView)childPrefScreen.findViewById(16908298);
        this.bind(this.mListView);
        CharSequence title = this.getTitle();
        boolean titleEmpty = TextUtils.isEmpty((CharSequence)title);
        PreferenceDialog dialog = this.mDialog = new PreferenceDialog(theme);
        if (titleEmpty) {
            dialog.requestWindowFeature(1);
        } else {
            if (Build.VERSION.SDK_INT >= 11) {
                dialog.requestWindowFeature(8);
            }
            ((Dialog)dialog).setContentView(childPrefScreen);
            dialog.setTitle(title);
        }
        dialog.setOnDismissListener(this);
        if (state != null) {
            dialog.onRestoreInstanceState(state);
        }
        this.getPreferenceManager().addPreferencesScreen((DialogInterface)dialog);
        dialog.show();
    }

    private static class SavedState
    extends Preference.BaseSavedState {
        Bundle dialogBundle;
        boolean isDialogShowing;

        public SavedState(Parcel source) {
            super(source);
            this.isDialogShowing = source.readInt() == 1;
            this.dialogBundle = source.readBundle();
        }

        public SavedState(Parcelable superState) {
            super(superState);
        }

        public void writeToParcel(Parcel dest, int flags) {
            super.writeToParcel(dest, flags);
            dest.writeInt(this.isDialogShowing ? 1 : 0);
            dest.writeBundle(this.dialogBundle);
        }
    }

    private final class PreferenceDialog
    extends Dialog
    implements Window.Callback {
        public PreferenceDialog(int theme) {
            super(PreferenceScreen.this.getContext(), theme);
        }

        public void onAttachedToWindow() {
            super.onAttachedToWindow();
            this.prepareActionBar();
        }

        protected void onCreate(Bundle savedInstanceState) {
            super.onCreate(savedInstanceState);
            this.prepareActionBar();
        }

        public boolean onMenuItemSelected(int featureId, MenuItem item) {
            return this.onMenuItemSelected(featureId, new MenuItemWrapper(item));
        }

        @Override
        public boolean onMenuItemSelected(int featureId, com.actionbarsherlock.view.MenuItem item) {
            if (featureId == 0 && item.getItemId() == 16908332 && PreferenceScreen.this.mDialog != null) {
                PreferenceScreen.this.mDialog.dismiss();
                return true;
            }
            return false;
        }

        protected void onPrepareActionBar(ActionBarView actionBarView) {
            if (actionBarView == null) {
                return;
            }
            actionBarView.setWindowCallback(PreferenceScreen.this.mDialog);
            actionBarView.setDisplayOptions(4 | actionBarView.getDisplayOptions() & 0xFFFFFFFB);
        }

        @SuppressLint(value={"NewApi"})
        protected void onPrepareActionBar(ActionBar actionBar) {
            if (actionBar == null) {
                return;
            }
            actionBar.setDisplayHomeAsUpEnabled(true);
        }

        @SuppressLint(value={"NewApi"})
        private void prepareActionBar() {
            if (Build.VERSION.SDK_INT >= 11) {
                this.onPrepareActionBar(this.getActionBar());
            } else {
                this.onPrepareActionBar((ActionBarView)this.findViewById(2131165253));
            }
        }

        @Override
        public void setContentView(View view) {
            if (Build.VERSION.SDK_INT >= 11) {
                super.setContentView(view);
            } else {
                FrameLayout content = (FrameLayout)this.findViewById(2131165248);
                if (content == null) {
                    View container = this.getLayoutInflater().inflate(2130903056);
                    content = (FrameLayout)container.findViewById(2131165248);
                    super.setContentView(container);
                }
                content.removeAllViews();
                content.addView(view);
            }
        }

        public void setTitle(CharSequence title) {
            super.setTitle(title);
            if (Build.VERSION.SDK_INT < 11) {
                ((ActionBarView)this.findViewById(2131165253)).setTitle(title);
            }
        }

        public void setTitle(int titleId) {
            this.setTitle(this.getContext().getText(titleId));
        }
    }
}

