/*
 * Decompiled with CFR 0.152.
 */
package org.holoeverywhere.preference;

import android.content.Context;
import android.content.Intent;
import android.content.res.TypedArray;
import android.media.RingtoneManager;
import android.net.Uri;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.AttributeSet;
import org.holoeverywhere.R;
import org.holoeverywhere.internal.RingtonePicker;
import org.holoeverywhere.preference.Preference;

public class RingtonePreference
extends Preference
implements RingtonePicker.RingtonePickerListener {
    private int mRingtoneType;
    private boolean mShowDefault;
    private boolean mShowSilent;

    public RingtonePreference(Context context) {
        this(context, null);
    }

    public RingtonePreference(Context context, AttributeSet attrs) {
        this(context, attrs, 2130772075);
    }

    public RingtonePreference(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.RingtonePreference, defStyle, 0);
        this.mRingtoneType = a.getInt(0, 1);
        this.mShowDefault = a.getBoolean(1, true);
        this.mShowSilent = a.getBoolean(2, true);
        a.recycle();
    }

    public int getRingtoneType() {
        return this.mRingtoneType;
    }

    public boolean getShowDefault() {
        return this.mShowDefault;
    }

    public boolean getShowSilent() {
        return this.mShowSilent;
    }

    @Override
    protected void onClick() {
        Intent intent = new Intent("android.intent.action.RINGTONE_PICKER");
        this.onPrepareRingtonePickerIntent(intent);
        new RingtonePicker(this.getContext(), intent, this).show();
    }

    @Override
    protected Object onGetDefaultValue(TypedArray a, int index) {
        return a.getString(index);
    }

    protected void onPrepareRingtonePickerIntent(Intent ringtonePickerIntent) {
        ringtonePickerIntent.putExtra("android.intent.extra.ringtone.EXISTING_URI", (Parcelable)this.onRestoreRingtone());
        ringtonePickerIntent.putExtra("android.intent.extra.ringtone.SHOW_DEFAULT", this.mShowDefault);
        if (this.mShowDefault) {
            ringtonePickerIntent.putExtra("android.intent.extra.ringtone.DEFAULT_URI", (Parcelable)RingtoneManager.getDefaultUri((int)this.getRingtoneType()));
        }
        ringtonePickerIntent.putExtra("android.intent.extra.ringtone.SHOW_SILENT", this.mShowSilent);
        ringtonePickerIntent.putExtra("android.intent.extra.ringtone.TYPE", this.mRingtoneType);
        ringtonePickerIntent.putExtra("android.intent.extra.ringtone.TITLE", this.getTitle());
    }

    protected Uri onRestoreRingtone() {
        String uriString = this.getPersistedString(null);
        return !TextUtils.isEmpty((CharSequence)uriString) ? Uri.parse((String)uriString) : null;
    }

    @Override
    public void onRingtonePickerCanceled() {
        if (this.callChangeListener("")) {
            this.onSaveRingtone(null);
        }
    }

    @Override
    public void onRingtonePickerChanged(Uri uri) {
        if (this.callChangeListener(uri != null ? uri.toString() : "")) {
            this.onSaveRingtone(uri);
        }
    }

    protected void onSaveRingtone(Uri ringtoneUri) {
        this.persistString(ringtoneUri != null ? ringtoneUri.toString() : "");
    }

    @Override
    protected void onSetInitialValue(boolean restorePersistedValue, Object defaultValueObj) {
        String defaultValue = (String)defaultValueObj;
        if (restorePersistedValue) {
            return;
        }
        if (!TextUtils.isEmpty((CharSequence)defaultValue)) {
            this.onSaveRingtone(Uri.parse((String)defaultValue));
        }
    }

    public void setRingtoneType(int type) {
        this.mRingtoneType = type;
    }

    public void setShowDefault(boolean showDefault) {
        this.mShowDefault = showDefault;
    }

    public void setShowSilent(boolean showSilent) {
        this.mShowSilent = showSilent;
    }
}

