/*
 * Decompiled with CFR 0.152.
 */
package org.holoeverywhere.preference;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.View;
import android.widget.Checkable;
import android.widget.CompoundButton;
import org.holoeverywhere.R;
import org.holoeverywhere.preference.TwoStatePreference;
import org.holoeverywhere.widget.Switch;

public class SwitchPreference
extends TwoStatePreference {
    private final Listener mListener = new Listener();
    private CharSequence mSwitchOff;
    private CharSequence mSwitchOn;

    public SwitchPreference(Context context) {
        this(context, null);
    }

    public SwitchPreference(Context context, AttributeSet attrs) {
        this(context, attrs, 2130772079);
    }

    public SwitchPreference(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.SwitchPreference, defStyle, 2131558554);
        this.setSummaryOn(a.getString(0));
        this.setSummaryOff(a.getString(1));
        this.setSwitchTextOn(a.getString(3));
        this.setSwitchTextOff(a.getString(4));
        this.setDisableDependentsState(a.getBoolean(2, false));
        a.recycle();
    }

    public CharSequence getSwitchTextOff() {
        return this.mSwitchOff;
    }

    public CharSequence getSwitchTextOn() {
        return this.mSwitchOn;
    }

    @Override
    protected void onBindView(View view) {
        super.onBindView(view);
        View checkableView = view.findViewById(2131165322);
        if (checkableView != null && checkableView instanceof Checkable) {
            ((Checkable)checkableView).setChecked(this.mChecked);
            this.sendAccessibilityEvent(checkableView);
            if (checkableView instanceof Switch) {
                Switch switchView = (Switch)checkableView;
                switchView.setTextOn(this.mSwitchOn);
                switchView.setTextOff(this.mSwitchOff);
                switchView.setOnCheckedChangeListener(this.mListener);
            }
        }
        this.syncSummaryView(view);
    }

    public void setSwitchTextOff(CharSequence offText) {
        this.mSwitchOff = offText;
        this.notifyChanged();
    }

    public void setSwitchTextOff(int resId) {
        this.setSwitchTextOff(this.getContext().getText(resId));
    }

    public void setSwitchTextOn(CharSequence onText) {
        this.mSwitchOn = onText;
        this.notifyChanged();
    }

    public void setSwitchTextOn(int resId) {
        this.setSwitchTextOn(this.getContext().getText(resId));
    }

    private class Listener
    implements CompoundButton.OnCheckedChangeListener {
        private Listener() {
        }

        public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
            if (!SwitchPreference.this.callChangeListener(isChecked)) {
                buttonView.setChecked(!isChecked);
                return;
            }
            SwitchPreference.this.setChecked(isChecked);
        }
    }
}

