/*
 * Decompiled with CFR 0.152.
 */
package org.holoeverywhere.widget;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.View;
import android.widget.LinearLayout;
import com.actionbarsherlock.internal.nineoldandroids.view.animation.AnimatorProxy;
import org.holoeverywhere.R;

public class LinearLayout
extends android.widget.LinearLayout {
    public static final int SHOW_DIVIDER_ALL = 7;
    public static final int SHOW_DIVIDER_BEGINNING = 1;
    public static final int SHOW_DIVIDER_END = 4;
    public static final int SHOW_DIVIDER_MIDDLE = 2;
    public static final int SHOW_DIVIDER_NONE = 0;
    private Drawable mDivider;
    private int mDividerHeight;
    private int mDividerPadding;
    private int mDividerWidth;
    private final AnimatorProxy mProxy = AnimatorProxy.NEEDS_PROXY ? AnimatorProxy.wrap((View)this) : null;
    private int mShowDividers;

    public LinearLayout(Context context) {
        this(context, null);
    }

    public LinearLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public LinearLayout(Context context, AttributeSet attrs, int defStyleRes) {
        super(context, attrs);
        this.init(attrs, defStyleRes);
    }

    void drawDividersHorizontal(Canvas canvas) {
        LinearLayout.LayoutParams lp;
        int count = this.getChildCount();
        for (int i = 0; i < count; ++i) {
            View child = this.getChildAt(i);
            if (child == null || child.getVisibility() == 8 || !this.hasDividerBeforeChildAt(i)) continue;
            lp = (LinearLayout.LayoutParams)child.getLayoutParams();
            int left = child.getLeft() - lp.leftMargin;
            this.drawVerticalDivider(canvas, left);
        }
        if (this.hasDividerBeforeChildAt(count)) {
            View child = this.getChildAt(count - 1);
            int right = 0;
            if (child == null) {
                right = this.getWidth() - this.getPaddingRight();
            } else {
                lp = (LinearLayout.LayoutParams)child.getLayoutParams();
                right = child.getRight() + lp.rightMargin;
            }
            this.drawVerticalDivider(canvas, right);
        }
    }

    void drawDividersVertical(Canvas canvas) {
        LinearLayout.LayoutParams lp;
        int count = this.getChildCount();
        for (int i = 0; i < count; ++i) {
            View child = this.getChildAt(i);
            if (child == null || child.getVisibility() == 8 || !this.hasDividerBeforeChildAt(i)) continue;
            lp = (LinearLayout.LayoutParams)child.getLayoutParams();
            int top = child.getTop() - lp.topMargin;
            this.drawHorizontalDivider(canvas, top);
        }
        if (this.hasDividerBeforeChildAt(count)) {
            View child = this.getChildAt(count - 1);
            int bottom = 0;
            if (child == null) {
                bottom = this.getHeight() - this.getPaddingBottom();
            } else {
                lp = (LinearLayout.LayoutParams)child.getLayoutParams();
                bottom = child.getBottom() + lp.bottomMargin;
            }
            this.drawHorizontalDivider(canvas, bottom);
        }
    }

    void drawHorizontalDivider(Canvas canvas, int top) {
        this.mDivider.setBounds(this.getPaddingLeft() + this.mDividerPadding, top, this.getWidth() - this.getPaddingRight() - this.mDividerPadding, top + this.mDividerHeight);
        this.mDivider.draw(canvas);
    }

    void drawVerticalDivider(Canvas canvas, int left) {
        this.mDivider.setBounds(left, this.getPaddingTop() + this.mDividerPadding, left + this.mDividerWidth, this.getHeight() - this.getPaddingBottom() - this.mDividerPadding);
        this.mDivider.draw(canvas);
    }

    @SuppressLint(value={"NewApi"})
    public float getAlpha() {
        if (AnimatorProxy.NEEDS_PROXY) {
            return this.mProxy.getAlpha();
        }
        return super.getAlpha();
    }

    public int getDividerPadding() {
        return this.mDividerPadding;
    }

    public int getDividerWidth() {
        return this.mDividerWidth;
    }

    public int getShowDividers() {
        return this.mShowDividers;
    }

    @SuppressLint(value={"NewApi"})
    public float getTranslationX() {
        if (AnimatorProxy.NEEDS_PROXY) {
            return this.mProxy.getTranslationX();
        }
        return super.getTranslationX();
    }

    @SuppressLint(value={"NewApi"})
    public float getTranslationY() {
        if (AnimatorProxy.NEEDS_PROXY) {
            return this.mProxy.getTranslationY();
        }
        return super.getTranslationY();
    }

    protected boolean hasDividerBeforeChildAt(int childIndex) {
        if (childIndex == 0) {
            return (this.mShowDividers & 1) != 0;
        }
        if (childIndex == this.getChildCount()) {
            return (this.mShowDividers & 4) != 0;
        }
        if ((this.mShowDividers & 2) != 0) {
            boolean hasVisibleViewBefore = false;
            for (int i = childIndex - 1; i >= 0; --i) {
                if (this.getChildAt(i).getVisibility() == 8) continue;
                hasVisibleViewBefore = true;
                break;
            }
            return hasVisibleViewBefore;
        }
        return false;
    }

    @SuppressLint(value={"NewApi"})
    protected void init(AttributeSet attrs, int defStyleRes) {
        TypedArray a = this.getContext().obtainStyledAttributes(attrs, R.styleable.LinearLayout, defStyleRes, 0);
        this.setDividerDrawable(a.getDrawable(0));
        this.mShowDividers = a.hasValue(1) ? a.getInt(1, 0) : a.getInt(3, 0);
        this.mDividerPadding = a.hasValue(2) ? a.getDimensionPixelSize(4, 0) : a.getDimensionPixelSize(4, 0);
        a.recycle();
    }

    @SuppressLint(value={"NewApi"})
    protected boolean isVisibleToUser(Rect boundInView) {
        boolean isVisible;
        Rect visibleRect = new Rect();
        this.getWindowVisibleDisplayFrame(visibleRect);
        boolean bl = isVisible = this.getWindowVisibility() == 0 && this.getAlpha() > 0.0f && this.isShown() && this.getGlobalVisibleRect(visibleRect);
        if (isVisible && boundInView != null) {
            isVisible &= boundInView.intersect(visibleRect);
        }
        return isVisible;
    }

    protected void measureChildWithMargins(View child, int parentWidthMeasureSpec, int widthUsed, int parentHeightMeasureSpec, int heightUsed) {
        int count;
        int index = this.indexOfChild(child);
        int orientation = this.getOrientation();
        LinearLayout.LayoutParams params = (LinearLayout.LayoutParams)child.getLayoutParams();
        if (this.hasDividerBeforeChildAt(index)) {
            if (orientation == 1) {
                params.topMargin = this.mDividerHeight;
            } else {
                params.leftMargin = this.mDividerWidth;
            }
        }
        if (index == (count = this.getChildCount()) - 1 && this.hasDividerBeforeChildAt(count)) {
            if (orientation == 1) {
                params.bottomMargin = this.mDividerHeight;
            } else {
                params.rightMargin = this.mDividerWidth;
            }
        }
        super.measureChildWithMargins(child, parentWidthMeasureSpec, widthUsed, parentHeightMeasureSpec, heightUsed);
    }

    protected void onDraw(Canvas canvas) {
        if (this.mDivider != null) {
            if (this.getOrientation() == 1) {
                this.drawDividersVertical(canvas);
            } else {
                this.drawDividersHorizontal(canvas);
            }
        }
        super.onDraw(canvas);
    }

    @SuppressLint(value={"NewApi"})
    public void setAlpha(float alpha) {
        if (AnimatorProxy.NEEDS_PROXY) {
            this.mProxy.setAlpha(alpha);
        } else {
            super.setAlpha(alpha);
        }
    }

    public void setDividerDrawable(Drawable divider) {
        if (divider == this.mDivider) {
            return;
        }
        this.mDivider = divider;
        if (divider != null) {
            this.mDividerWidth = divider.getIntrinsicWidth();
            this.mDividerHeight = divider.getIntrinsicHeight();
        } else {
            this.mDividerWidth = 0;
            this.mDividerHeight = 0;
        }
        this.setWillNotDraw(divider == null);
        this.requestLayout();
    }

    public void setDividerPadding(int padding) {
        this.mDividerPadding = padding;
    }

    public void setShowDividers(int showDividers) {
        if (showDividers != this.mShowDividers) {
            this.requestLayout();
            this.invalidate();
        }
        this.mShowDividers = showDividers;
    }

    @SuppressLint(value={"NewApi"})
    public void setTranslationX(float translationX) {
        if (AnimatorProxy.NEEDS_PROXY) {
            this.mProxy.setTranslationX(translationX);
        } else {
            super.setTranslationX(translationX);
        }
    }

    @SuppressLint(value={"NewApi"})
    public void setTranslationY(float translationY) {
        if (AnimatorProxy.NEEDS_PROXY) {
            this.mProxy.setTranslationY(translationY);
        } else {
            super.setTranslationY(translationY);
        }
    }

    public void setVisibility(int visibility) {
        if (this.mProxy != null) {
            if (visibility == 8) {
                this.clearAnimation();
            } else if (visibility == 0) {
                this.setAnimation(this.mProxy);
            }
        }
        super.setVisibility(visibility);
    }
}

