/*
 * Decompiled with CFR 0.152.
 */
package org.holoeverywhere.widget;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Build;
import android.util.AttributeSet;
import android.view.ContextMenu;
import android.view.View;
import android.widget.AdapterView;
import android.widget.Checkable;
import android.widget.ListAdapter;
import com.actionbarsherlock.internal.view.menu.ContextMenuBuilder;
import com.actionbarsherlock.view.ActionMode;
import com.actionbarsherlock.view.Menu;
import com.actionbarsherlock.view.MenuItem;
import org.holoeverywhere.IHoloActivity;

public class ListView
extends android.widget.ListView
implements ContextMenuBuilder.ContextMenuInfoGetter {
    public static final int CHOICE_MODE_MULTIPLE_MODAL = 3;
    private ActionMode actionMode;
    private int checkedItemCount;
    private int choiceMode;
    private final MultiChoiceModeWrapper choiceModeListener = new MultiChoiceModeWrapper();
    private ContextMenu.ContextMenuInfo contextMenuInfo;
    private IHoloActivity holoActivity;
    private final OnItemLongClickListenerWrapper longClickListenerWrapper = new OnItemLongClickListenerWrapper();

    public ListView(Context context) {
        super(context);
        this.init(context);
    }

    public ListView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public ListView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init(context);
    }

    protected ContextMenu.ContextMenuInfo createContextMenuInfo(View view, int position, long id2) {
        return new AdapterView.AdapterContextMenuInfo(view, position, id2);
    }

    protected boolean doLongPress(View child, int longPressPosition, long longPressId) {
        if (this.choiceMode == 3) {
            if (this.actionMode == null && (this.actionMode = this.startActionMode(this.choiceModeListener)) != null) {
                this.setItemChecked(longPressPosition, true);
                this.performHapticFeedback(0);
            }
            return true;
        }
        return false;
    }

    public final IHoloActivity getBase() {
        return this.holoActivity;
    }

    public int getChoiceMode() {
        return this.choiceMode;
    }

    @Override
    public ContextMenu.ContextMenuInfo getContextMenuInfo() {
        return this.contextMenuInfo;
    }

    protected void init(Context context) {
        super.setOnItemLongClickListener((AdapterView.OnItemLongClickListener)this.longClickListenerWrapper);
        if (context instanceof IHoloActivity) {
            this.holoActivity = (IHoloActivity)context;
        }
    }

    public boolean performItemClick(View view, int position, long id2) {
        if (this.choiceMode == 3) {
            boolean newValue = !this.getCheckedItemPositions().get(position);
            this.setItemChecked(position, newValue);
            if (this.actionMode != null) {
                this.choiceModeListener.onItemCheckedStateChanged(this.actionMode, position, id2, newValue);
            }
            return true;
        }
        return super.performItemClick(view, position, id2);
    }

    public final void setBase(IHoloActivity mBase) {
        this.holoActivity = mBase;
    }

    public void setChoiceMode(int choiceMode) {
        if (this.choiceMode == choiceMode) {
            return;
        }
        this.choiceMode = choiceMode;
        if (this.actionMode != null) {
            this.actionMode.finish();
            this.actionMode = null;
        }
        if (choiceMode == 3) {
            super.setOnItemLongClickListener((AdapterView.OnItemLongClickListener)this.longClickListenerWrapper);
            this.clearChoices();
            this.checkedItemCount = 0;
            this.setLongClickable(true);
            this.updateOnScreenCheckedViews();
            this.requestLayout();
            this.invalidate();
            super.setChoiceMode(2);
        } else {
            super.setChoiceMode(choiceMode);
        }
    }

    public void setItemChecked(int position, boolean value) {
        if (this.choiceMode == 3) {
            ListAdapter adapter;
            if (value && this.actionMode == null) {
                this.actionMode = this.startActionMode(this.choiceModeListener);
            }
            super.setItemChecked(position, value);
            this.checkedItemCount += value ? 1 : -1;
            if (this.actionMode != null && (adapter = this.getAdapter()) != null) {
                this.choiceModeListener.onItemCheckedStateChanged(this.actionMode, position, adapter.getItemId(position), value);
            }
            this.requestLayout();
            this.invalidate();
        } else {
            super.setItemChecked(position, value);
        }
    }

    public void setMultiChoiceModeListener(MultiChoiceModeListener listener) {
        this.choiceModeListener.setWrapped(listener);
    }

    public void setOnItemLongClickListener(AdapterView.OnItemLongClickListener listener) {
        this.longClickListenerWrapper.wrapped = listener;
    }

    public ActionMode startActionMode(ActionMode.Callback callback) {
        if (this.actionMode != null) {
            return this.actionMode;
        }
        if (this.holoActivity == null) {
            throw new RuntimeException("ListView must have SBase (setSBase(SBase))");
        }
        this.actionMode = this.holoActivity.startActionMode(callback);
        return this.actionMode;
    }

    @SuppressLint(value={"NewApi"})
    private void updateOnScreenCheckedViews() {
        int firstPos = this.getFirstVisiblePosition();
        int count = this.getChildCount();
        for (int i = 0; i < count; ++i) {
            View child = this.getChildAt(i);
            int position = firstPos + i;
            boolean state = this.getCheckedItemPositions().get(position);
            if (child instanceof Checkable) {
                ((Checkable)child).setChecked(state);
                continue;
            }
            if (Build.VERSION.SDK_INT < 11) continue;
            child.setActivated(state);
        }
    }

    private class OnItemLongClickListenerWrapper
    implements AdapterView.OnItemLongClickListener {
        protected AdapterView.OnItemLongClickListener wrapped;

        private OnItemLongClickListenerWrapper() {
        }

        public boolean onItemLongClick(AdapterView<?> view, View child, int position, long id2) {
            boolean handled = ListView.this.doLongPress(child, position, id2);
            if (!handled) {
                if (this.wrapped != null && this.wrapped.onItemLongClick(view, child, position, id2)) {
                    return true;
                }
                ListView.this.contextMenuInfo = ListView.this.createContextMenuInfo((View)view, position, id2);
                handled = ListView.super.showContextMenuForChild((View)ListView.this);
                if (handled) {
                    ListView.this.performHapticFeedback(0);
                    return true;
                }
            }
            return false;
        }
    }

    protected class MultiChoiceModeWrapper
    implements MultiChoiceModeListener {
        protected MultiChoiceModeListener wrapped;

        protected MultiChoiceModeWrapper() {
        }

        @Override
        public boolean onActionItemClicked(ActionMode mode, MenuItem item) {
            if (this.wrapped == null) {
                return false;
            }
            return this.wrapped.onActionItemClicked(mode, item);
        }

        @Override
        public boolean onCreateActionMode(ActionMode mode, Menu menu) {
            if (this.wrapped == null) {
                return false;
            }
            if (this.wrapped.onCreateActionMode(mode, menu)) {
                ListView.this.setLongClickable(false);
                return true;
            }
            return false;
        }

        @Override
        public void onDestroyActionMode(ActionMode mode) {
            if (this.wrapped == null) {
                return;
            }
            this.wrapped.onDestroyActionMode(mode);
            ListView.this.actionMode = null;
            ListView.this.clearChoices();
            ListView.this.checkedItemCount = 0;
            ListView.this.updateOnScreenCheckedViews();
            ListView.this.invalidateViews();
            ListView.this.setLongClickable(true);
            ListView.this.requestLayout();
            ListView.this.invalidate();
        }

        @Override
        public void onItemCheckedStateChanged(ActionMode mode, int position, long id2, boolean checked) {
            if (this.wrapped == null) {
                return;
            }
            this.wrapped.onItemCheckedStateChanged(mode, position, id2, checked);
            if (ListView.this.checkedItemCount == 0) {
                mode.finish();
            }
        }

        @Override
        public boolean onPrepareActionMode(ActionMode mode, Menu menu) {
            if (this.wrapped == null) {
                return false;
            }
            return this.wrapped.onPrepareActionMode(mode, menu);
        }

        public void setWrapped(MultiChoiceModeListener wrapped) {
            this.wrapped = wrapped;
        }
    }

    public static interface MultiChoiceModeListener
    extends ActionMode.Callback {
        public void onItemCheckedStateChanged(ActionMode var1, int var2, long var3, boolean var5);
    }
}

