/*
 * Decompiled with CFR 0.152.
 */
package org.holoeverywhere.widget;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.Configuration;
import android.content.res.TypedArray;
import android.os.Build;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.format.DateUtils;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.accessibility.AccessibilityEvent;
import android.view.inputmethod.InputMethodManager;
import android.widget.Button;
import android.widget.FrameLayout;
import java.text.DateFormatSymbols;
import java.util.Calendar;
import java.util.Locale;
import org.holoeverywhere.FontLoader;
import org.holoeverywhere.LayoutInflater;
import org.holoeverywhere.R;
import org.holoeverywhere.internal.NumberPickerEditText;
import org.holoeverywhere.widget.NumberPicker;
import org.holoeverywhere.widget.TextView;

public class TimePicker
extends FrameLayout {
    private static final boolean DEFAULT_ENABLED_STATE = true;
    private static final int HOURS_IN_HALF_DAY = 12;
    private static final OnTimeChangedListener NO_OP_CHANGE_LISTENER = new OnTimeChangedListener(){

        @Override
        public void onTimeChanged(TimePicker view, int hourOfDay, int minute) {
        }
    };
    private final Button mAmPmButton;
    private final String[] mAmPmStrings;
    private Context mContext;
    private Locale mCurrentLocale;
    private final TextView mDivider;
    private final NumberPicker mHourSpinner;
    private final NumberPicker mMinuteSpinner;
    private final NumberPicker mAmPmSpinner;
    private final NumberPickerEditText mHourSpinnerInput;
    private final NumberPickerEditText mMinuteSpinnerInput;
    private final NumberPickerEditText mAmPmSpinnerInput;
    private boolean mIs24HourView;
    private boolean mIsAm;
    private boolean mIsEnabled = true;
    private OnTimeChangedListener mOnTimeChangedListener;
    private Calendar mTempCalendar;

    private static void setContentDescription(View parent, int childId, int textId) {
        if (parent == null) {
            return;
        }
        View child = parent.findViewById(childId);
        if (child != null) {
            child.setContentDescription(parent.getContext().getText(textId));
        }
    }

    public TimePicker(Context context) {
        this(context, null);
    }

    public TimePicker(Context context, AttributeSet attrs) {
        this(context, attrs, 2130772101);
    }

    public TimePicker(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.mContext = context;
        this.setCurrentLocale(Locale.getDefault());
        TypedArray attributesArray = context.obtainStyledAttributes(attrs, R.styleable.TimePicker, defStyle, 0);
        int layoutResourceId = attributesArray.getResourceId(0, 2130903116);
        attributesArray.recycle();
        LayoutInflater.inflate(this.mContext, layoutResourceId, (ViewGroup)this, true);
        FontLoader.apply((View)this);
        this.mHourSpinner = (NumberPicker)this.findViewById(2131165326);
        this.mHourSpinner.setOnValueChangedListener(new NumberPicker.OnValueChangeListener(){

            @Override
            public void onValueChange(NumberPicker spinner, int oldVal, int newVal) {
                TimePicker.this.updateInputState();
                if (!TimePicker.this.is24HourView() && (oldVal == 11 && newVal == 12 || oldVal == 12 && newVal == 11)) {
                    TimePicker.this.mIsAm = !TimePicker.this.mIsAm;
                    TimePicker.this.updateAmPmControl();
                }
                TimePicker.this.onTimeChanged();
            }
        });
        this.mHourSpinnerInput = this.mHourSpinner.getInputField();
        this.mHourSpinnerInput.setImeOptions(5);
        this.mDivider = (TextView)this.findViewById(2131165327);
        if (this.mDivider != null) {
            this.mDivider.setText(2131492909);
        }
        this.mMinuteSpinner = (NumberPicker)this.findViewById(2131165328);
        this.mMinuteSpinner.setMinValue(0);
        this.mMinuteSpinner.setMaxValue(59);
        this.mMinuteSpinner.setOnLongPressUpdateInterval(100L);
        this.mMinuteSpinner.setFormatter(NumberPicker.TWO_DIGIT_FORMATTER);
        this.mMinuteSpinner.setOnValueChangedListener(new NumberPicker.OnValueChangeListener(){

            @Override
            public void onValueChange(NumberPicker spinner, int oldVal, int newVal) {
                TimePicker.this.updateInputState();
                int minValue = TimePicker.this.mMinuteSpinner.getMinValue();
                int maxValue = TimePicker.this.mMinuteSpinner.getMaxValue();
                if (oldVal == maxValue && newVal == minValue) {
                    int newHour = TimePicker.this.mHourSpinner.getValue() + 1;
                    if (!TimePicker.this.is24HourView() && newHour == 12) {
                        TimePicker.this.mIsAm = !TimePicker.this.mIsAm;
                        TimePicker.this.updateAmPmControl();
                    }
                    TimePicker.this.mHourSpinner.setValue(newHour);
                } else if (oldVal == minValue && newVal == maxValue) {
                    int newHour = TimePicker.this.mHourSpinner.getValue() - 1;
                    if (!TimePicker.this.is24HourView() && newHour == 11) {
                        TimePicker.this.mIsAm = !TimePicker.this.mIsAm;
                        TimePicker.this.updateAmPmControl();
                    }
                    TimePicker.this.mHourSpinner.setValue(newHour);
                }
                TimePicker.this.onTimeChanged();
            }
        });
        this.mMinuteSpinnerInput = this.mMinuteSpinner.getInputField();
        this.mMinuteSpinnerInput.setImeOptions(5);
        this.mAmPmStrings = new DateFormatSymbols().getAmPmStrings();
        View amPmView = this.findViewById(2131165329);
        if (amPmView instanceof Button) {
            this.mAmPmSpinner = null;
            this.mAmPmSpinnerInput = null;
            this.mAmPmButton = (Button)amPmView;
            this.mAmPmButton.setOnClickListener(new View.OnClickListener(){

                public void onClick(View button) {
                    button.requestFocus();
                    TimePicker.this.mIsAm = !TimePicker.this.mIsAm;
                    TimePicker.this.updateAmPmControl();
                    TimePicker.this.onTimeChanged();
                }
            });
        } else {
            this.mAmPmButton = null;
            this.mAmPmSpinner = (NumberPicker)amPmView;
            this.mAmPmSpinner.setMinValue(0);
            this.mAmPmSpinner.setMaxValue(1);
            this.mAmPmSpinner.setDisplayedValues(this.mAmPmStrings);
            this.mAmPmSpinner.setOnValueChangedListener(new NumberPicker.OnValueChangeListener(){

                @Override
                public void onValueChange(NumberPicker picker, int oldVal, int newVal) {
                    TimePicker.this.updateInputState();
                    picker.requestFocus();
                    TimePicker.this.mIsAm = !TimePicker.this.mIsAm;
                    TimePicker.this.updateAmPmControl();
                    TimePicker.this.onTimeChanged();
                }
            });
            this.mAmPmSpinnerInput = this.mAmPmSpinner.getInputField();
            this.mAmPmSpinnerInput.setImeOptions(6);
        }
        this.updateHourControl();
        this.updateAmPmControl();
        this.setOnTimeChangedListener(NO_OP_CHANGE_LISTENER);
        this.setCurrentHour(this.mTempCalendar.get(11));
        this.setCurrentMinute(this.mTempCalendar.get(12));
        if (!this.isEnabled()) {
            this.setEnabled(false);
        }
        this.setContentDescriptions();
    }

    @SuppressLint(value={"NewApi"})
    public boolean dispatchPopulateAccessibilityEvent(AccessibilityEvent event) {
        if (Build.VERSION.SDK_INT >= 14) {
            this.onPopulateAccessibilityEvent(event);
            return true;
        }
        return super.dispatchPopulateAccessibilityEvent(event);
    }

    public int getBaseline() {
        return this.mHourSpinner.getBaseline();
    }

    public Integer getCurrentHour() {
        int currentHour = this.mHourSpinner.getValue();
        if (this.is24HourView()) {
            return currentHour;
        }
        if (this.mIsAm) {
            return currentHour % 12;
        }
        return currentHour % 12 + 12;
    }

    public Integer getCurrentMinute() {
        return this.mMinuteSpinner.getValue();
    }

    public boolean is24HourView() {
        return this.mIs24HourView;
    }

    public boolean isEnabled() {
        return this.mIsEnabled;
    }

    @SuppressLint(value={"NewApi"})
    protected void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        this.setCurrentLocale(newConfig.locale);
    }

    @SuppressLint(value={"NewApi"})
    public void onPopulateAccessibilityEvent(AccessibilityEvent event) {
        super.onPopulateAccessibilityEvent(event);
        int flags = 1;
        flags = this.mIs24HourView ? (flags |= 0x80) : (flags |= 0x40);
        this.mTempCalendar.set(11, this.getCurrentHour());
        this.mTempCalendar.set(12, this.getCurrentMinute());
        String selectedDateUtterance = DateUtils.formatDateTime((Context)this.mContext, (long)this.mTempCalendar.getTimeInMillis(), (int)flags);
        event.getText().add(selectedDateUtterance);
    }

    protected void onRestoreInstanceState(Parcelable state) {
        SavedState ss = (SavedState)state;
        super.onRestoreInstanceState(ss.getSuperState());
        this.setCurrentHour(ss.getHour());
        this.setCurrentMinute(ss.getMinute());
    }

    protected Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        return new SavedState(superState, this.getCurrentHour(), this.getCurrentMinute());
    }

    private void onTimeChanged() {
        this.sendAccessibilityEvent(4);
        if (this.mOnTimeChangedListener != null) {
            this.mOnTimeChangedListener.onTimeChanged(this, this.getCurrentHour(), this.getCurrentMinute());
        }
    }

    private void setContentDescriptions() {
        TimePicker.setContentDescription((View)this.mMinuteSpinner, 2131165233, 2131492907);
        TimePicker.setContentDescription((View)this.mMinuteSpinner, 2131165234, 2131492903);
        TimePicker.setContentDescription((View)this.mHourSpinner, 2131165233, 2131492906);
        TimePicker.setContentDescription((View)this.mHourSpinner, 2131165234, 2131492902);
        if (this.mAmPmSpinner != null) {
            TimePicker.setContentDescription((View)this.mAmPmSpinner, 2131165233, 2131492908);
            TimePicker.setContentDescription((View)this.mAmPmSpinner, 2131165234, 2131492904);
        }
    }

    public void setCurrentHour(Integer currentHour) {
        if (currentHour == null || currentHour == this.getCurrentHour()) {
            return;
        }
        if (!this.is24HourView()) {
            if (currentHour >= 12) {
                this.mIsAm = false;
                if (currentHour > 12) {
                    currentHour = currentHour - 12;
                }
            } else {
                this.mIsAm = true;
                if (currentHour == 0) {
                    currentHour = 12;
                }
            }
            this.updateAmPmControl();
        }
        this.mHourSpinner.setValue(currentHour);
        this.onTimeChanged();
    }

    private void setCurrentLocale(Locale locale) {
        if (locale.equals(this.mCurrentLocale)) {
            return;
        }
        this.mCurrentLocale = locale;
        this.mTempCalendar = Calendar.getInstance(locale);
    }

    public void setCurrentMinute(Integer currentMinute) {
        if (currentMinute == this.getCurrentMinute()) {
            return;
        }
        this.mMinuteSpinner.setValue(currentMinute);
        this.onTimeChanged();
    }

    public void setEnabled(boolean enabled) {
        if (this.mIsEnabled == enabled) {
            return;
        }
        super.setEnabled(enabled);
        this.mMinuteSpinner.setEnabled(enabled);
        if (this.mDivider != null) {
            this.mDivider.setEnabled(enabled);
        }
        this.mHourSpinner.setEnabled(enabled);
        if (this.mAmPmSpinner != null) {
            this.mAmPmSpinner.setEnabled(enabled);
        } else {
            this.mAmPmButton.setEnabled(enabled);
        }
        this.mIsEnabled = enabled;
    }

    public void setIs24HourView(Boolean is24HourView) {
        if (this.mIs24HourView == is24HourView) {
            return;
        }
        this.mIs24HourView = is24HourView;
        int currentHour = this.getCurrentHour();
        this.updateHourControl();
        this.setCurrentHour(currentHour);
        this.updateAmPmControl();
    }

    public void setOnTimeChangedListener(OnTimeChangedListener onTimeChangedListener) {
        this.mOnTimeChangedListener = onTimeChangedListener;
    }

    private void updateAmPmControl() {
        if (this.is24HourView()) {
            if (this.mAmPmSpinner != null) {
                this.mAmPmSpinner.setVisibility(8);
            } else {
                this.mAmPmButton.setVisibility(8);
            }
        } else {
            int index;
            int n = index = this.mIsAm ? 0 : 1;
            if (this.mAmPmSpinner != null) {
                this.mAmPmSpinner.setValue(index);
                this.mAmPmSpinner.setVisibility(0);
            } else {
                this.mAmPmButton.setText((CharSequence)this.mAmPmStrings[index]);
                this.mAmPmButton.setVisibility(0);
            }
        }
        this.sendAccessibilityEvent(4);
    }

    private void updateHourControl() {
        if (this.is24HourView()) {
            this.mHourSpinner.setMinValue(0);
            this.mHourSpinner.setMaxValue(23);
            this.mHourSpinner.setFormatter(NumberPicker.TWO_DIGIT_FORMATTER);
        } else {
            this.mHourSpinner.setMinValue(1);
            this.mHourSpinner.setMaxValue(12);
            this.mHourSpinner.setFormatter(null);
        }
    }

    private void updateInputState() {
        InputMethodManager inputMethodManager = (InputMethodManager)this.mContext.getSystemService("input_method");
        if (inputMethodManager != null) {
            if (inputMethodManager.isActive((View)this.mHourSpinnerInput)) {
                this.mHourSpinnerInput.clearFocus();
                inputMethodManager.hideSoftInputFromWindow(this.getWindowToken(), 0);
            } else if (inputMethodManager.isActive((View)this.mMinuteSpinnerInput)) {
                this.mMinuteSpinnerInput.clearFocus();
                inputMethodManager.hideSoftInputFromWindow(this.getWindowToken(), 0);
            } else if (inputMethodManager.isActive((View)this.mAmPmSpinnerInput)) {
                this.mAmPmSpinnerInput.clearFocus();
                inputMethodManager.hideSoftInputFromWindow(this.getWindowToken(), 0);
            }
        }
    }

    private static class SavedState
    extends View.BaseSavedState {
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };
        private final int mHour;
        private final int mMinute;

        private SavedState(Parcel in) {
            super(in);
            this.mHour = in.readInt();
            this.mMinute = in.readInt();
        }

        private SavedState(Parcelable superState, int hour, int minute) {
            super(superState);
            this.mHour = hour;
            this.mMinute = minute;
        }

        public int getHour() {
            return this.mHour;
        }

        public int getMinute() {
            return this.mMinute;
        }

        public void writeToParcel(Parcel dest, int flags) {
            super.writeToParcel(dest, flags);
            dest.writeInt(this.mHour);
            dest.writeInt(this.mMinute);
        }
    }

    public static interface OnTimeChangedListener {
        public void onTimeChanged(TimePicker var1, int var2, int var3);
    }
}

