/*
 * Decompiled with CFR 0.152.
 */
package org.holoeverywhere;

import android.content.ClipData;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Parcelable;
import org.holoeverywhere.ChooserActivity;
import org.holoeverywhere.app.Application;

public final class IntentCompat {
    public static Intent createChooser(Intent target, CharSequence title) {
        int permFlags;
        if (Build.VERSION.SDK_INT >= 16) {
            return Intent.createChooser((Intent)target, (CharSequence)title);
        }
        Intent intent = new Intent();
        intent.setClass((Context)Application.getLastInstance(), ChooserActivity.class);
        intent.putExtra("android.intent.extra.INTENT", (Parcelable)target);
        if (title != null) {
            intent.putExtra("android.intent.extra.TITLE", title);
        }
        if ((permFlags = target.getFlags() & 3) != 0) {
            ClipData targetClipData = target.getClipData();
            if (targetClipData == null && target.getData() != null) {
                ClipData.Item item = new ClipData.Item(target.getData());
                String[] mimeTypes = target.getType() != null ? new String[]{target.getType()} : new String[]{};
                targetClipData = new ClipData(null, mimeTypes, item);
            }
            if (targetClipData != null) {
                intent.setClipData(targetClipData);
                intent.addFlags(permFlags);
            }
        }
        return intent;
    }

    private IntentCompat() {
    }
}

