/*
 * Decompiled with CFR 0.152.
 */
package org.holoeverywhere;

import android.content.Context;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.HashMap;
import java.util.Map;

public final class SystemServiceManager {
    private static final Map<Class<? extends SystemServiceCreator<?>>, SystemServiceCreator<?>> CREATORS_MAP = new HashMap();
    private static final Map<String, Class<? extends SystemServiceCreator<?>>> MAP = new HashMap();

    private static Object getSuperSystemService(Context context, String name) {
        if (context instanceof SuperSystemService) {
            return ((SuperSystemService)context).superGetSystemService(name);
        }
        return context.getSystemService(name);
    }

    public static Object getSystemService(Context context, String name) {
        Object o;
        if (context == null || context.isRestricted()) {
            throw new RuntimeException("Invalid context");
        }
        if (name == null || name.length() == 0) {
            return null;
        }
        Class<SystemServiceCreator<?>> clazz = MAP.get(name);
        if (clazz == null) {
            return SystemServiceManager.getSuperSystemService(context, name);
        }
        SystemServiceCreator<?> creator = CREATORS_MAP.get(clazz);
        if (creator == null) {
            try {
                creator = clazz.newInstance();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            CREATORS_MAP.put(clazz, creator);
        }
        if (creator != null && (o = creator.createService(context)) != null) {
            return o;
        }
        return SystemServiceManager.getSuperSystemService(context, name);
    }

    public static void register(Class<? extends SystemServiceCreator<?>> clazz) {
        if (!clazz.isAnnotationPresent(SystemServiceCreator.SystemService.class)) {
            throw new RuntimeException("SystemServiceCreator must be implement SystemService");
        }
        SystemServiceCreator.SystemService systemService = clazz.getAnnotation(SystemServiceCreator.SystemService.class);
        String name = systemService.value();
        if (name == null || name.length() == 0) {
            throw new RuntimeException("SystemService has incorrect name");
        }
        MAP.put(name, clazz);
    }

    public static synchronized void unregister(Class<? extends SystemServiceCreator<?>> clazz) {
        if (MAP.containsValue(clazz)) {
            for (Map.Entry<String, Class<SystemServiceCreator<?>>> e : MAP.entrySet()) {
                if (e.getValue() != clazz) continue;
                MAP.remove(e.getKey());
                break;
            }
        }
        CREATORS_MAP.remove(clazz);
    }

    private SystemServiceManager() {
    }

    public static interface SystemServiceCreator<T> {
        public T createService(Context var1);

        @Target(value={ElementType.TYPE})
        @Retention(value=RetentionPolicy.RUNTIME)
        public static @interface SystemService {
            public String value();
        }
    }

    public static interface SuperSystemService {
        public Object superGetSystemService(String var1);
    }
}

