/*
 * Decompiled with CFR 0.152.
 */
package org.holoeverywhere;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.Intent;
import android.content.res.TypedArray;
import android.os.Build;
import android.os.Bundle;
import android.util.SparseIntArray;
import java.util.ArrayList;
import java.util.List;
import org.holoeverywhere.IHoloActivity;
import org.holoeverywhere.app.Activity;
import org.holoeverywhere.app.Application;
import org.holoeverywhere.app.ContextThemeWrapperPlus;
import org.holoeverywhere.preference.PreferenceManagerHelper;

public final class ThemeManager {
    private static int _DEFAULT_THEME;
    public static final int _START_RESOURCES_ID = 0x1000000;
    private static ThemeGetter _THEME_GETTER;
    private static int _THEME_MASK;
    private static int _THEME_MODIFIER;
    private static final String _THEME_TAG = ":holoeverywhere:theme";
    private static final SparseIntArray _THEMES_MAP;
    public static final int COLOR_SCHEME_MASK;
    public static final int DARK;
    public static final int DIALOG;
    public static final int DIALOG_WHEN_LARGE;
    public static final int FULLSCREEN;
    public static final int INVALID = 0;
    public static final String KEY_CREATED_BY_THEME_MANAGER = ":holoeverywhere:createbythememanager";
    public static final String KEY_INSTANCE_STATE = ":holoeverywhere:instancestate";
    public static final int LIGHT;
    public static final int MIXED;
    private static int NEXT_OFFSET;
    public static final int NO_ACTION_BAR;
    private static List<ThemeSetter> sThemeSetters;
    public static final int WALLPAPER;

    public static void applyTheme(Activity activity) {
        boolean force = activity instanceof IHoloActivity ? activity.isForceThemeApply() : false;
        ThemeManager.applyTheme(activity, force);
    }

    public static void applyTheme(Activity activity, boolean force) {
        if (force || ThemeManager.hasSpecifiedTheme(activity)) {
            activity.setTheme(ThemeManager.getThemeResource(activity));
        }
    }

    public static void cloneTheme(Intent sourceIntent, Intent intent) {
        ThemeManager.cloneTheme(sourceIntent, intent, false);
    }

    public static void cloneTheme(Intent sourceIntent, Intent intent, boolean force) {
        boolean hasSourceTheme = ThemeManager.hasSpecifiedTheme(sourceIntent);
        if (force || hasSourceTheme) {
            intent.putExtra(_THEME_TAG, hasSourceTheme ? ThemeManager.getTheme(sourceIntent) : _DEFAULT_THEME);
        }
    }

    public static Context context(Context context, int theme) {
        return ThemeManager.context(context, theme, true);
    }

    public static Context context(Context context, int theme, boolean applyModifier) {
        while (context instanceof ContextThemeWrapperPlus) {
            context = ((ContextThemeWrapperPlus)context).getBaseContext();
        }
        return new ContextThemeWrapperPlus(context, ThemeManager.getThemeResource(theme, applyModifier));
    }

    public static int getDefaultTheme() {
        return _DEFAULT_THEME;
    }

    public static int getModifier() {
        return _THEME_MODIFIER;
    }

    public static int getTheme(Activity activity) {
        return ThemeManager.getTheme(activity.getIntent());
    }

    public static int getTheme(Intent intent) {
        return ThemeManager.getTheme(intent, true);
    }

    public static int getTheme(Intent intent, boolean applyModifier) {
        return ThemeManager.prepareFlags(intent.getIntExtra(_THEME_TAG, _DEFAULT_THEME), applyModifier);
    }

    public static int getThemeMask() {
        return _THEME_MASK;
    }

    public static int getThemeResource(Activity activity) {
        return ThemeManager.getThemeResource(ThemeManager.getTheme(activity));
    }

    public static int getThemeResource(int themeTag) {
        return ThemeManager.getThemeResource(themeTag, true);
    }

    public static int getThemeResource(int themeTag, boolean applyModifier) {
        int getterResource;
        if ((themeTag = ThemeManager.prepareFlags(themeTag, applyModifier)) >= 0x1000000) {
            return themeTag;
        }
        if (_THEME_GETTER != null && (getterResource = _THEME_GETTER.getThemeResource(new ThemeGetter.ThemeTag(themeTag))) > 0) {
            return getterResource;
        }
        int i = _THEMES_MAP.get(themeTag, _DEFAULT_THEME);
        if (i == _DEFAULT_THEME) {
            return _THEMES_MAP.get(_DEFAULT_THEME, 2131558611);
        }
        return i;
    }

    public static int getThemeResource(Intent intent) {
        return ThemeManager.getThemeResource(ThemeManager.getTheme(intent));
    }

    public static int getThemeType(Context context) {
        TypedArray a = context.obtainStyledAttributes(new int[]{2130772106});
        int holoTheme = a.getInt(0, 0);
        a.recycle();
        switch (holoTheme) {
            case 1: {
                return DARK;
            }
            case 2: {
                return LIGHT;
            }
            case 3: {
                return MIXED;
            }
            case 4: {
                return PreferenceManagerHelper.obtainThemeTag();
            }
        }
        return 0;
    }

    public static boolean hasSpecifiedTheme(Activity activity) {
        return activity == null ? false : ThemeManager.hasSpecifiedTheme(activity.getIntent());
    }

    public static boolean hasSpecifiedTheme(Intent intent) {
        return intent != null && intent.hasExtra(_THEME_TAG) && intent.getIntExtra(_THEME_TAG, 0) > 0;
    }

    private static boolean is(int config, int key) {
        return (config & key) == key;
    }

    public static boolean isDark(Activity activity) {
        return ThemeManager.isDark(ThemeManager.getTheme(activity));
    }

    public static boolean isDark(int i) {
        return ThemeManager.is(i, DARK);
    }

    public static boolean isDark(Intent intent) {
        return ThemeManager.isDark(ThemeManager.getTheme(intent));
    }

    public static boolean isDialog(Activity activity) {
        return ThemeManager.isDialog(ThemeManager.getTheme(activity));
    }

    public static boolean isDialog(int i) {
        return ThemeManager.is(i, DIALOG);
    }

    public static boolean isDialog(Intent intent) {
        return ThemeManager.isDialog(ThemeManager.getTheme(intent));
    }

    public static boolean isDialogWhenLarge(Activity activity) {
        return ThemeManager.isDialog(ThemeManager.getTheme(activity));
    }

    public static boolean isDialogWhenLarge(int i) {
        return ThemeManager.is(i, DIALOG_WHEN_LARGE);
    }

    public static boolean isDialogWhenLarge(Intent intent) {
        return ThemeManager.isDialog(ThemeManager.getTheme(intent));
    }

    public static boolean isFullScreen(Activity activity) {
        return ThemeManager.isFullScreen(ThemeManager.getTheme(activity));
    }

    public static boolean isFullScreen(int i) {
        return ThemeManager.is(i, FULLSCREEN);
    }

    public static boolean isFullScreen(Intent intent) {
        return ThemeManager.isFullScreen(ThemeManager.getTheme(intent));
    }

    public static boolean isLight(Activity activity) {
        return ThemeManager.isLight(ThemeManager.getTheme(activity));
    }

    public static boolean isLight(int i) {
        return ThemeManager.is(i, LIGHT);
    }

    public static boolean isLight(Intent intent) {
        return ThemeManager.isLight(ThemeManager.getTheme(intent));
    }

    public static boolean isMixed(Activity activity) {
        return ThemeManager.isMixed(ThemeManager.getTheme(activity));
    }

    public static boolean isMixed(int i) {
        return ThemeManager.is(i, MIXED);
    }

    public static boolean isMixed(Intent intent) {
        return ThemeManager.isMixed(ThemeManager.getTheme(intent));
    }

    public static boolean isNoActionBar(Activity activity) {
        return ThemeManager.isNoActionBar(ThemeManager.getTheme(activity));
    }

    public static boolean isNoActionBar(int i) {
        return ThemeManager.is(i, NO_ACTION_BAR);
    }

    public static boolean isNoActionBar(Intent intent) {
        return ThemeManager.isNoActionBar(ThemeManager.getTheme(intent));
    }

    public static boolean isWallpaper(Activity activity) {
        return ThemeManager.isWallpaper(ThemeManager.getTheme(activity));
    }

    public static boolean isWallpaper(int i) {
        return ThemeManager.is(i, WALLPAPER);
    }

    public static boolean isWallpaper(Intent intent) {
        return ThemeManager.isWallpaper(ThemeManager.getTheme(intent));
    }

    public static int makeNewFlag() {
        if (NEXT_OFFSET > 32) {
            throw new IllegalStateException();
        }
        int flag = 1 << NEXT_OFFSET++;
        _THEME_MASK |= flag;
        return flag;
    }

    public static void map(int theme) {
        ThemeManager.map(_DEFAULT_THEME, theme);
    }

    public static void map(int flags, int theme) {
        if (theme > 0) {
            _THEMES_MAP.put(flags & _THEME_MASK, theme);
        } else {
            int i = _THEMES_MAP.indexOfKey(flags & _THEME_MASK);
            if (i > 0) {
                _THEMES_MAP.removeAt(i);
            }
        }
    }

    public static void modify(int mod) {
        _THEME_MODIFIER |= mod & _THEME_MASK;
    }

    public static void modifyClear() {
        _THEME_MODIFIER = 0;
    }

    public static void modifyClear(int mod) {
        _THEME_MODIFIER |= (mod &= _THEME_MASK);
        _THEME_MODIFIER ^= mod;
    }

    public static void modifyDefaultTheme(int mod) {
        _DEFAULT_THEME |= mod & _THEME_MASK;
    }

    public static void modifyDefaultThemeClear(int mod) {
        _DEFAULT_THEME |= (mod &= _THEME_MASK);
        _DEFAULT_THEME ^= mod;
    }

    private static int prepareFlags(int i, boolean applyModifier) {
        if (i >= 0x1000000) {
            return i;
        }
        if (applyModifier && _THEME_MODIFIER > 0) {
            i |= _THEME_MODIFIER;
        }
        return i & _THEME_MASK;
    }

    public static void registerThemeSetter(ThemeSetter themeSetter) {
        if (themeSetter == null) {
            return;
        }
        if (sThemeSetters == null) {
            sThemeSetters = new ArrayList<ThemeSetter>();
        }
        if (!sThemeSetters.contains(themeSetter)) {
            sThemeSetters.add(themeSetter);
            themeSetter.setupThemes();
        }
    }

    public static void removeTheme(Activity activity) {
        activity.getIntent().removeExtra(_THEME_TAG);
    }

    public static void reset() {
        if ((_DEFAULT_THEME & COLOR_SCHEME_MASK) == 0) {
            _DEFAULT_THEME = DARK;
        }
        _THEME_MODIFIER = 0;
        _THEMES_MAP.clear();
        ThemeManager.map(DARK, 2131558611);
        ThemeManager.map(DARK | FULLSCREEN, 2131558618);
        ThemeManager.map(DARK | NO_ACTION_BAR, 2131558636);
        ThemeManager.map(DARK | NO_ACTION_BAR | FULLSCREEN, 2131558637);
        ThemeManager.map(DARK | DIALOG, 2131558496);
        ThemeManager.map(DARK | DIALOG_WHEN_LARGE, 2131558612);
        ThemeManager.map(DARK | DIALOG_WHEN_LARGE | NO_ACTION_BAR, 2131558617);
        ThemeManager.map(DARK | WALLPAPER, 2131558640);
        ThemeManager.map(DARK | NO_ACTION_BAR | WALLPAPER, 2131558639);
        ThemeManager.map(DARK | FULLSCREEN | WALLPAPER, 2131558619);
        ThemeManager.map(DARK | NO_ACTION_BAR | FULLSCREEN | WALLPAPER, 2131558638);
        ThemeManager.map(LIGHT, 2131558620);
        ThemeManager.map(LIGHT | FULLSCREEN, 2131558629);
        ThemeManager.map(LIGHT | NO_ACTION_BAR, 2131558631);
        ThemeManager.map(LIGHT | NO_ACTION_BAR | FULLSCREEN, 2131558632);
        ThemeManager.map(LIGHT | DIALOG, 2131558500);
        ThemeManager.map(LIGHT | DIALOG_WHEN_LARGE, 2131558613);
        ThemeManager.map(LIGHT | DIALOG_WHEN_LARGE | NO_ACTION_BAR, 2131558616);
        ThemeManager.map(LIGHT | WALLPAPER, 2131558635);
        ThemeManager.map(LIGHT | NO_ACTION_BAR | WALLPAPER, 2131558634);
        ThemeManager.map(LIGHT | FULLSCREEN | WALLPAPER, 2131558630);
        ThemeManager.map(LIGHT | NO_ACTION_BAR | FULLSCREEN | WALLPAPER, 2131558633);
        ThemeManager.map(MIXED, 2131558621);
        ThemeManager.map(MIXED | FULLSCREEN, 2131558622);
        ThemeManager.map(MIXED | NO_ACTION_BAR, 2131558624);
        ThemeManager.map(MIXED | NO_ACTION_BAR | FULLSCREEN, 2131558625);
        ThemeManager.map(MIXED | DIALOG, 2131558500);
        ThemeManager.map(MIXED | DIALOG_WHEN_LARGE, 2131558614);
        ThemeManager.map(MIXED | DIALOG_WHEN_LARGE | NO_ACTION_BAR, 2131558615);
        ThemeManager.map(MIXED | WALLPAPER, 2131558628);
        ThemeManager.map(MIXED | NO_ACTION_BAR | WALLPAPER, 2131558627);
        ThemeManager.map(MIXED | FULLSCREEN | WALLPAPER, 2131558623);
        ThemeManager.map(MIXED | NO_ACTION_BAR | FULLSCREEN | WALLPAPER, 2131558626);
        if (sThemeSetters != null) {
            for (ThemeSetter setter : sThemeSetters) {
                setter.setupThemes();
            }
        }
    }

    public static void restart(Activity activity) {
        ThemeManager.restart(activity, true);
    }

    public static void restart(Activity activity, boolean force) {
        ThemeManager.restartWithTheme(activity, -1, force);
    }

    public static void restartWithDarkTheme(Activity activity) {
        ThemeManager.restartWithTheme(activity, DARK);
    }

    public static void restartWithLightTheme(Activity activity) {
        ThemeManager.restartWithTheme(activity, LIGHT);
    }

    public static void restartWithMixedTheme(Activity activity) {
        ThemeManager.restartWithTheme(activity, MIXED);
    }

    public static void restartWithTheme(Activity activity, int theme) {
        ThemeManager.restartWithTheme(activity, theme, false);
    }

    public static void restartWithTheme(Activity activity, int theme, boolean force) {
        if (theme < 0x1000000 && theme > 0) {
            if (_THEME_MODIFIER > 0) {
                theme |= _THEME_MODIFIER;
            }
            theme &= _THEME_MASK;
        }
        if (force || ThemeManager.getTheme(activity) != theme) {
            Intent intent = new Intent(activity.getIntent());
            intent.setClass((Context)activity, activity.getClass());
            intent.addFlags(65536);
            intent.addFlags(32768);
            if (theme > 0) {
                intent.putExtra(_THEME_TAG, theme);
            }
            intent.putExtra(KEY_INSTANCE_STATE, activity.saveInstanceState());
            intent.putExtra(KEY_CREATED_BY_THEME_MANAGER, true);
            if (activity.isRestricted()) {
                Application app = Application.getLastInstance();
                if (app != null && !app.isRestricted()) {
                    intent.addFlags(0x10000000);
                    app.superStartActivity(intent, -1, null);
                }
            } else {
                if (!activity.isFinishing()) {
                    activity.finish();
                    activity.overridePendingTransition(0, 0);
                }
                if (activity instanceof SuperStartActivity) {
                    activity.superStartActivity(intent, -1, null);
                } else {
                    activity.startActivity(intent);
                }
            }
        }
    }

    public static void setDefaultTheme(int theme) {
        _DEFAULT_THEME = theme;
        if (theme < 0x1000000) {
            _DEFAULT_THEME &= _THEME_MASK;
        }
    }

    public static void setModifier(int mod) {
        _THEME_MODIFIER = mod & _THEME_MASK;
    }

    public static void setThemeGetter(ThemeGetter themeGetter) {
        _THEME_GETTER = themeGetter;
    }

    public static void startActivity(Context context, Intent intent) {
        ThemeManager.startActivity(context, intent, -1);
    }

    public static void startActivity(Context context, Intent intent, Bundle options) {
        ThemeManager.startActivity(context, intent, -1, options);
    }

    public static void startActivity(Context context, Intent intent, int requestCode) {
        ThemeManager.startActivity(context, intent, requestCode, null);
    }

    @SuppressLint(value={"NewApi"})
    public static void startActivity(Context context, Intent intent, int requestCode, Bundle options) {
        Activity activity;
        Activity activity2 = activity = context instanceof Activity ? (Activity)context : null;
        if (activity != null) {
            ThemeManager.cloneTheme(activity.getIntent(), intent, true);
        }
        if (context instanceof SuperStartActivity) {
            ((SuperStartActivity)context).superStartActivity(intent, requestCode, options);
        } else if (activity != null) {
            if (Build.VERSION.SDK_INT >= 16) {
                activity.startActivityForResult(intent, requestCode, options);
            } else {
                activity.startActivityForResult(intent, requestCode);
            }
        } else if (Build.VERSION.SDK_INT >= 16) {
            context.startActivity(intent, options);
        } else {
            context.startActivity(intent);
        }
    }

    public static void unregisterThemeSetter(ThemeSetter themeSetter) {
        if (sThemeSetters == null || themeSetter == null) {
            return;
        }
        sThemeSetters.remove(themeSetter);
    }

    private ThemeManager() {
    }

    static {
        _THEME_MASK = 0;
        _THEME_MODIFIER = 0;
        _THEMES_MAP = new SparseIntArray();
        NEXT_OFFSET = 0;
        DARK = ThemeManager.makeNewFlag();
        LIGHT = ThemeManager.makeNewFlag();
        MIXED = DARK | LIGHT;
        FULLSCREEN = ThemeManager.makeNewFlag();
        NO_ACTION_BAR = ThemeManager.makeNewFlag();
        WALLPAPER = ThemeManager.makeNewFlag();
        DIALOG = ThemeManager.makeNewFlag();
        DIALOG_WHEN_LARGE = ThemeManager.makeNewFlag();
        COLOR_SCHEME_MASK = DARK | LIGHT | MIXED;
        ThemeManager.reset();
    }

    public static interface ThemeSetter {
        public void setupThemes();
    }

    public static interface ThemeGetter {
        public int getThemeResource(ThemeTag var1);

        public static final class ThemeTag {
            public final boolean dark;
            public final boolean fullscreen;
            public final boolean light;
            public final boolean mixed;
            public final boolean noActionBar;
            public final boolean wallpaper;
            public final boolean dialog;
            public final boolean dialogWhenLarge;
            public final int flags;

            private ThemeTag(int flags) {
                this.flags = flags;
                this.dark = ThemeManager.isDark(flags);
                this.light = ThemeManager.isLight(flags);
                this.mixed = ThemeManager.isMixed(flags);
                this.noActionBar = ThemeManager.isNoActionBar(flags);
                this.fullscreen = ThemeManager.isFullScreen(flags);
                this.wallpaper = ThemeManager.isWallpaper(flags);
                this.dialog = ThemeManager.isDialog(flags);
                this.dialogWhenLarge = ThemeManager.isDialogWhenLarge(flags);
            }
        }
    }

    public static interface SuperStartActivity {
        public void superStartActivity(Intent var1, int var2, Bundle var3);
    }
}

