/*
 * Decompiled with CFR 0.152.
 */
package org.holoeverywhere.app;

import android.content.Context;
import android.content.DialogInterface;
import android.database.Cursor;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.Message;
import android.util.TypedValue;
import android.view.KeyEvent;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ListAdapter;
import org.holoeverywhere.app.Dialog;
import org.holoeverywhere.internal.AlertController;
import org.holoeverywhere.widget.Button;
import org.holoeverywhere.widget.ListView;

public class AlertDialog
extends Dialog
implements DialogInterface,
AlertController.AlertDecorViewInstaller {
    public static final int DISMISS_ON_ALL = 7;
    public static final int DISMISS_ON_NEGATIVE = 1;
    public static final int DISMISS_ON_NEUTRAL = 2;
    public static final int DISMISS_ON_POSITIVE = 4;
    public static final int THEME_HOLO_DARK = 1;
    public static final int THEME_HOLO_LIGHT = 2;
    private final AlertController mAlert;

    static int resolveDialogTheme(Context context, int resid) {
        if (resid == 1) {
            return 2131558497;
        }
        if (resid == 2) {
            return 2131558498;
        }
        if (resid >= 0x1000000) {
            return resid;
        }
        TypedValue outValue = new TypedValue();
        context.getTheme().resolveAttribute(2130772068, outValue, true);
        return outValue.resourceId;
    }

    protected AlertDialog(Context context) {
        this(context, true, null, 0);
    }

    protected AlertDialog(Context context, boolean cancelable, DialogInterface.OnCancelListener cancelListener) {
        this(context, cancelable, cancelListener, 0);
    }

    protected AlertDialog(Context context, boolean cancelable, DialogInterface.OnCancelListener cancelListener, int theme) {
        super(context, AlertDialog.resolveDialogTheme(context, theme));
        this.setCancelable(cancelable);
        this.setOnCancelListener(cancelListener);
        this.mAlert = new AlertController(this.getContext(), this, this.getWindow(), this);
    }

    protected AlertDialog(Context context, int theme) {
        this(context, true, null, theme);
    }

    public Button getButton(int whichButton) {
        return this.mAlert.getButton(whichButton);
    }

    public ListView getListView() {
        return this.mAlert.getListView();
    }

    @Override
    public void installDecorView(Context context, int layout2) {
        this.setContentView(layout2);
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.mAlert.installContent();
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (this.mAlert.onKeyDown(keyCode, event)) {
            return true;
        }
        return super.onKeyDown(keyCode, event);
    }

    public boolean onKeyUp(int keyCode, KeyEvent event) {
        if (this.mAlert.onKeyUp(keyCode, event)) {
            return true;
        }
        return super.onKeyUp(keyCode, event);
    }

    @Deprecated
    public void setButton(CharSequence text, Message msg) {
        this.setButton(-1, text, msg);
    }

    @Deprecated
    public void setButton(CharSequence text, DialogInterface.OnClickListener listener) {
        this.setButton(-1, text, listener);
    }

    public void setButton(int whichButton, CharSequence text, Message msg) {
        this.mAlert.setButton(whichButton, text, null, msg);
    }

    public void setButton(int whichButton, CharSequence text, DialogInterface.OnClickListener listener) {
        this.mAlert.setButton(whichButton, text, listener, null);
    }

    @Deprecated
    public void setButton2(CharSequence text, Message msg) {
        this.setButton(-2, text, msg);
    }

    @Deprecated
    public void setButton2(CharSequence text, DialogInterface.OnClickListener listener) {
        this.setButton(-2, text, listener);
    }

    @Deprecated
    public void setButton3(CharSequence text, Message msg) {
        this.setButton(-3, text, msg);
    }

    @Deprecated
    public void setButton3(CharSequence text, DialogInterface.OnClickListener listener) {
        this.setButton(-3, text, listener);
    }

    public void setButtonBehavior(int buttonBehavior) {
        this.mAlert.setButtonBehavior(buttonBehavior);
    }

    public void setCustomTitle(View customTitleView) {
        this.mAlert.setCustomTitle(customTitleView);
    }

    public void setIcon(Drawable icon) {
        this.mAlert.setIcon(icon);
    }

    public void setIcon(int resId) {
        this.mAlert.setIcon(resId);
    }

    public void setIconAttribute(int attrId) {
        TypedValue out = new TypedValue();
        this.getContext().getTheme().resolveAttribute(attrId, out, true);
        this.mAlert.setIcon(out.resourceId);
    }

    public void setInverseBackgroundForced(boolean forceInverseBackground) {
        this.mAlert.setInverseBackgroundForced(forceInverseBackground);
    }

    public void setMessage(CharSequence message) {
        this.mAlert.setMessage(message);
    }

    public void setTitle(CharSequence title) {
        super.setTitle(title);
        this.mAlert.setTitle(title);
    }

    public void setView(View view) {
        this.mAlert.setView(view);
    }

    public void setView(View view, int viewSpacingLeft, int viewSpacingTop, int viewSpacingRight, int viewSpacingBottom) {
        this.mAlert.setView(view, viewSpacingLeft, viewSpacingTop, viewSpacingRight, viewSpacingBottom);
    }

    public static class Builder {
        private static final Class<?>[] CONSTRUCTOR_SIGNATURE = new Class[]{Context.class, Integer.TYPE};
        private Class<? extends AlertDialog> mDialogClass;
        private final AlertController.AlertParams mParams;

        public Builder(Context context) {
            this(context, 0);
        }

        public Builder(Context context, int theme) {
            this.mParams = new AlertController.AlertParams(context, theme);
        }

        public Builder addButtonBehavior(int buttonBehavior) {
            this.mParams.mButtonBehavior |= buttonBehavior;
            return this;
        }

        public AlertDialog create() {
            AlertDialog dialog = null;
            if (this.mDialogClass != null) {
                try {
                    dialog = this.mDialogClass.getConstructor(CONSTRUCTOR_SIGNATURE).newInstance(this.mParams.mContext, this.mParams.mTheme);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (dialog == null) {
                dialog = new AlertDialog(this.mParams.mContext, this.mParams.mTheme);
            }
            this.mParams.apply(dialog.mAlert);
            dialog.setCancelable(this.mParams.mCancelable);
            if (this.mParams.mCancelable) {
                dialog.setCanceledOnTouchOutside(true);
            }
            if (this.mParams.mOnCancelListener != null) {
                dialog.setOnCancelListener(this.mParams.mOnCancelListener);
            }
            if (this.mParams.mOnKeyListener != null) {
                dialog.setOnKeyListener(this.mParams.mOnKeyListener);
            }
            if (this.mParams.mOnDismissListener != null) {
                dialog.setOnDismissListener(this.mParams.mOnDismissListener);
            }
            return dialog;
        }

        public Context getContext() {
            return this.mParams.mContext;
        }

        public Builder removeButtonBehavior(int buttonBehavior) {
            this.mParams.mButtonBehavior |= buttonBehavior;
            this.mParams.mButtonBehavior ^= buttonBehavior;
            return this;
        }

        public Builder setAdapter(ListAdapter adapter, DialogInterface.OnClickListener listener) {
            this.mParams.mAdapter = adapter;
            this.mParams.mOnClickListener = listener;
            return this;
        }

        public Builder setAlertDialogClass(Class<? extends AlertDialog> clazz) {
            this.mDialogClass = clazz;
            return this;
        }

        public Builder setBlockDismiss(boolean blockDismiss) {
            return this.setButtonBehavior(blockDismiss ? 0 : 7);
        }

        public Builder setButtonBehavior(int buttonBehavior) {
            this.mParams.mButtonBehavior = buttonBehavior;
            return this;
        }

        public Builder setCancelable(boolean cancelable) {
            this.mParams.mCancelable = cancelable;
            return this;
        }

        public Builder setCheckedItem(int checkedItem) {
            this.mParams.mCheckedItem = checkedItem;
            return this;
        }

        public Builder setCursor(Cursor cursor, DialogInterface.OnClickListener listener, String labelColumn) {
            this.mParams.mCursor = cursor;
            this.mParams.mLabelColumn = labelColumn;
            this.mParams.mOnClickListener = listener;
            return this;
        }

        public Builder setCustomTitle(View customTitleView) {
            this.mParams.mCustomTitleView = customTitleView;
            return this;
        }

        public Builder setIcon(Drawable icon) {
            this.mParams.mIcon = icon;
            return this;
        }

        public Builder setIcon(int iconId) {
            this.mParams.mIconId = iconId;
            return this;
        }

        public Builder setIconAttribute(int attrId) {
            TypedValue out = new TypedValue();
            this.mParams.mContext.getTheme().resolveAttribute(attrId, out, true);
            this.mParams.mIconId = out.resourceId;
            return this;
        }

        public Builder setInverseBackgroundForced(boolean useInverseBackground) {
            this.mParams.mForceInverseBackground = useInverseBackground;
            return this;
        }

        public Builder setItems(CharSequence[] items, DialogInterface.OnClickListener listener) {
            this.mParams.mItems = items;
            this.mParams.mOnClickListener = listener;
            return this;
        }

        public Builder setItems(int itemsId, DialogInterface.OnClickListener listener) {
            this.mParams.mItems = this.mParams.mContext.getResources().getTextArray(itemsId);
            this.mParams.mOnClickListener = listener;
            return this;
        }

        public Builder setMessage(CharSequence message) {
            this.mParams.mMessage = message;
            return this;
        }

        public Builder setMessage(int messageId) {
            this.mParams.mMessage = this.mParams.mContext.getText(messageId);
            return this;
        }

        public Builder setMultiChoiceItems(CharSequence[] items, boolean[] checkedItems, DialogInterface.OnMultiChoiceClickListener listener) {
            this.mParams.mItems = items;
            this.mParams.mOnCheckboxClickListener = listener;
            this.mParams.mCheckedItems = checkedItems;
            this.mParams.mIsMultiChoice = true;
            return this;
        }

        public Builder setMultiChoiceItems(Cursor cursor, String isCheckedColumn, String labelColumn, DialogInterface.OnMultiChoiceClickListener listener) {
            this.mParams.mCursor = cursor;
            this.mParams.mOnCheckboxClickListener = listener;
            this.mParams.mIsCheckedColumn = isCheckedColumn;
            this.mParams.mLabelColumn = labelColumn;
            this.mParams.mIsMultiChoice = true;
            return this;
        }

        public Builder setMultiChoiceItems(int itemsId, boolean[] checkedItems, DialogInterface.OnMultiChoiceClickListener listener) {
            this.mParams.mItems = this.mParams.mContext.getResources().getTextArray(itemsId);
            this.mParams.mOnCheckboxClickListener = listener;
            this.mParams.mCheckedItems = checkedItems;
            this.mParams.mIsMultiChoice = true;
            return this;
        }

        public Builder setNegativeButton(CharSequence text, DialogInterface.OnClickListener listener) {
            this.mParams.mNegativeButtonText = text;
            this.mParams.mNegativeButtonListener = listener;
            return this;
        }

        public Builder setNegativeButton(int textId, DialogInterface.OnClickListener listener) {
            this.mParams.mNegativeButtonText = this.mParams.mContext.getText(textId);
            this.mParams.mNegativeButtonListener = listener;
            return this;
        }

        public Builder setNeutralButton(CharSequence text, DialogInterface.OnClickListener listener) {
            this.mParams.mNeutralButtonText = text;
            this.mParams.mNeutralButtonListener = listener;
            return this;
        }

        public Builder setNeutralButton(int textId, DialogInterface.OnClickListener listener) {
            this.mParams.mNeutralButtonText = this.mParams.mContext.getText(textId);
            this.mParams.mNeutralButtonListener = listener;
            return this;
        }

        public Builder setOnCancelListener(DialogInterface.OnCancelListener onCancelListener) {
            this.mParams.mOnCancelListener = onCancelListener;
            return this;
        }

        public Builder setOnDismissListener(DialogInterface.OnDismissListener onDismissListener) {
            this.mParams.mOnDismissListener = onDismissListener;
            return this;
        }

        public Builder setOnItemSelectedListener(AdapterView.OnItemSelectedListener listener) {
            this.mParams.mOnItemSelectedListener = listener;
            return this;
        }

        public Builder setOnKeyListener(DialogInterface.OnKeyListener onKeyListener) {
            this.mParams.mOnKeyListener = onKeyListener;
            return this;
        }

        public Builder setOnPrepareListViewListener(AlertController.AlertParams.OnPrepareListViewListener listener) {
            this.mParams.mOnPrepareListViewListener = listener;
            return this;
        }

        public Builder setPositiveButton(CharSequence text, DialogInterface.OnClickListener listener) {
            this.mParams.mPositiveButtonText = text;
            this.mParams.mPositiveButtonListener = listener;
            return this;
        }

        public Builder setPositiveButton(int textId, DialogInterface.OnClickListener listener) {
            this.mParams.mPositiveButtonText = this.mParams.mContext.getText(textId);
            this.mParams.mPositiveButtonListener = listener;
            return this;
        }

        public Builder setSingleChoiceItems(CharSequence[] items, int checkedItem, DialogInterface.OnClickListener listener) {
            this.mParams.mItems = items;
            this.mParams.mOnClickListener = listener;
            this.mParams.mCheckedItem = checkedItem;
            this.mParams.mIsSingleChoice = true;
            return this;
        }

        public Builder setSingleChoiceItems(Cursor cursor, int checkedItem, String labelColumn, DialogInterface.OnClickListener listener) {
            this.mParams.mCursor = cursor;
            this.mParams.mOnClickListener = listener;
            this.mParams.mCheckedItem = checkedItem;
            this.mParams.mLabelColumn = labelColumn;
            this.mParams.mIsSingleChoice = true;
            return this;
        }

        public Builder setSingleChoiceItems(int itemsId, int checkedItem, DialogInterface.OnClickListener listener) {
            this.mParams.mItems = this.mParams.mContext.getResources().getTextArray(itemsId);
            this.mParams.mOnClickListener = listener;
            this.mParams.mCheckedItem = checkedItem;
            this.mParams.mIsSingleChoice = true;
            return this;
        }

        public Builder setSingleChoiceItems(ListAdapter adapter, int checkedItem, DialogInterface.OnClickListener listener) {
            this.mParams.mAdapter = adapter;
            this.mParams.mOnClickListener = listener;
            this.mParams.mCheckedItem = checkedItem;
            this.mParams.mIsSingleChoice = true;
            return this;
        }

        public Builder setTheme(int theme) {
            this.mParams.mTheme = theme;
            return this;
        }

        public Builder setTitle(CharSequence title) {
            this.mParams.mTitle = title;
            return this;
        }

        public Builder setTitle(int titleId) {
            this.mParams.mTitle = this.mParams.mContext.getText(titleId);
            return this;
        }

        public Builder setView(View view) {
            this.mParams.mView = view;
            this.mParams.mViewSpacingSpecified = false;
            return this;
        }

        public Builder setView(View view, int viewSpacingLeft, int viewSpacingTop, int viewSpacingRight, int viewSpacingBottom) {
            this.mParams.mView = view;
            this.mParams.mViewSpacingSpecified = true;
            this.mParams.mViewSpacingLeft = viewSpacingLeft;
            this.mParams.mViewSpacingTop = viewSpacingTop;
            this.mParams.mViewSpacingRight = viewSpacingRight;
            this.mParams.mViewSpacingBottom = viewSpacingBottom;
            return this;
        }

        public AlertDialog show() {
            AlertDialog dialog = this.create();
            dialog.show();
            return dialog;
        }
    }
}

