/*
 * Decompiled with CFR 0.152.
 */
package org.holoeverywhere.app;

import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.text.format.DateUtils;
import android.view.View;
import java.util.Calendar;
import org.holoeverywhere.LayoutInflater;
import org.holoeverywhere.app.AlertDialog;
import org.holoeverywhere.widget.DatePicker;

public class DatePickerDialog
extends AlertDialog
implements DialogInterface.OnClickListener,
DatePicker.OnDateChangedListener {
    private static final String DAY = "day";
    private static final String MONTH = "month";
    private static final String YEAR = "year";
    private final Calendar mCalendar;
    private final OnDateSetListener mCallBack;
    private final DatePicker mDatePicker;
    private boolean mTitleNeedsUpdate = true;

    public DatePickerDialog(Context context, int theme, OnDateSetListener callBack, int year, int monthOfYear, int dayOfMonth) {
        super(context, theme);
        this.mCallBack = callBack;
        this.mCalendar = Calendar.getInstance();
        this.setButton(-1, this.getContext().getText(2131492890), this);
        this.setButton(-2, this.getContext().getText(0x1040000), this);
        this.setIcon(0);
        LayoutInflater inflater = LayoutInflater.from(context);
        View view = inflater.inflate(2130903064, null);
        this.setView(view);
        this.mDatePicker = (DatePicker)view.findViewById(2131165293);
        this.mDatePicker.init(year, monthOfYear, dayOfMonth, this);
        this.updateTitle(year, monthOfYear, dayOfMonth);
    }

    public DatePickerDialog(Context context, OnDateSetListener callBack, int year, int monthOfYear, int dayOfMonth) {
        this(context, 0, callBack, year, monthOfYear, dayOfMonth);
    }

    public DatePicker getDatePicker() {
        return this.mDatePicker;
    }

    public void onClick(DialogInterface dialog, int which) {
        if (which == -1) {
            this.tryNotifyDateSet();
        }
    }

    @Override
    public void onDateChanged(DatePicker view, int year, int month, int day) {
        this.mDatePicker.init(year, month, day, this);
        this.updateTitle(year, month, day);
    }

    public void onRestoreInstanceState(Bundle savedInstanceState) {
        super.onRestoreInstanceState(savedInstanceState);
        int year = savedInstanceState.getInt(YEAR);
        int month = savedInstanceState.getInt(MONTH);
        int day = savedInstanceState.getInt(DAY);
        this.mDatePicker.init(year, month, day, this);
    }

    public Bundle onSaveInstanceState() {
        Bundle state = super.onSaveInstanceState();
        state.putInt(YEAR, this.mDatePicker.getYear());
        state.putInt(MONTH, this.mDatePicker.getMonth());
        state.putInt(DAY, this.mDatePicker.getDayOfMonth());
        return state;
    }

    private void tryNotifyDateSet() {
        if (this.mCallBack != null) {
            this.mDatePicker.clearFocus();
            this.mCallBack.onDateSet(this.mDatePicker, this.mDatePicker.getYear(), this.mDatePicker.getMonth(), this.mDatePicker.getDayOfMonth());
        }
    }

    public void updateDate(int year, int monthOfYear, int dayOfMonth) {
        this.mDatePicker.updateDate(year, monthOfYear, dayOfMonth);
    }

    private void updateTitle(int year, int month, int day) {
        if (!this.mDatePicker.getCalendarViewShown()) {
            this.mCalendar.set(1, year);
            this.mCalendar.set(2, month);
            this.mCalendar.set(5, day);
            String title = DateUtils.formatDateTime((Context)this.getContext(), (long)this.mCalendar.getTimeInMillis(), (int)98326);
            this.setTitle(title);
            this.mTitleNeedsUpdate = true;
        } else if (this.mTitleNeedsUpdate) {
            this.mTitleNeedsUpdate = false;
            this.setTitle(2131492886);
        }
    }

    public static interface OnDateSetListener {
        public void onDateSet(DatePicker var1, int var2, int var3, int var4);
    }
}

