/*
 * Decompiled with CFR 0.152.
 */
package org.holoeverywhere.app;

import android.content.Context;
import android.os.Bundle;
import android.view.View;
import org.holoeverywhere.ITabSwipe;
import org.holoeverywhere.app.Activity;
import org.holoeverywhere.app.Fragment;
import org.holoeverywhere.app.TabSwipeFragment;
import org.holoeverywhere.widget.FrameLayout;

public abstract class TabSwipeActivity
extends Activity
implements ITabSwipe<TabSwipeFragment.TabInfo> {
    private int mCustomLayout = -1;
    private InnerFragment mFragment;

    @Override
    public TabSwipeFragment.TabInfo addTab(CharSequence title, Class<? extends Fragment> fragmentClass) {
        return this.mFragment.addTab(title, (Class)fragmentClass);
    }

    @Override
    public TabSwipeFragment.TabInfo addTab(CharSequence title, Class<? extends Fragment> fragmentClass, Bundle fragmentArguments) {
        return this.mFragment.addTab(title, (Class)fragmentClass, fragmentArguments);
    }

    @Override
    public TabSwipeFragment.TabInfo addTab(int title, Class<? extends Fragment> fragmentClass) {
        return this.mFragment.addTab(title, (Class)fragmentClass);
    }

    @Override
    public TabSwipeFragment.TabInfo addTab(int title, Class<? extends Fragment> fragmentClass, Bundle fragmentArguments) {
        return this.mFragment.addTab(title, (Class)fragmentClass, fragmentArguments);
    }

    @Override
    public TabSwipeFragment.TabInfo addTab(TabSwipeFragment.TabInfo tabInfo) {
        return this.mFragment.addTab(tabInfo);
    }

    @Override
    public TabSwipeFragment.TabInfo addTab(TabSwipeFragment.TabInfo tabInfo, int position) {
        return this.mFragment.addTab(tabInfo, position);
    }

    @Override
    public ITabSwipe.OnTabSelectedListener getOnTabSelectedListener() {
        return this.mFragment.getOnTabSelectedListener();
    }

    @Override
    public boolean isSmoothScroll() {
        return this.mFragment.isSmoothScroll();
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.mFragment = (InnerFragment)this.getSupportFragmentManager().findFragmentById(2131165278);
        if (this.mFragment == null) {
            this.mFragment = new InnerFragment();
        }
        this.mFragment.setActivity(this);
        if (this.mCustomLayout > 0) {
            this.mFragment.setCustomLayout(this.mCustomLayout);
        }
        if (this.mFragment.isDetached()) {
            FrameLayout layout2 = new FrameLayout((Context)this);
            layout2.setId(2131165278);
            this.setContentView((View)layout2);
            this.getSupportFragmentManager().beginTransaction().replace(2131165278, (android.support.v4.app.Fragment)this.mFragment).commit();
            this.getSupportFragmentManager().executePendingTransactions();
        }
    }

    protected abstract void onHandleTabs();

    @Override
    public void reloadTabs() {
        this.mFragment.reloadTabs();
    }

    @Override
    public void removeAllTabs() {
        this.mFragment.removeAllTabs();
    }

    @Override
    public TabSwipeFragment.TabInfo removeTab(int position) {
        return this.mFragment.removeTab(position);
    }

    @Override
    public TabSwipeFragment.TabInfo removeTab(TabSwipeFragment.TabInfo tabInfo) {
        return this.mFragment.removeTab(tabInfo);
    }

    @Override
    public void setCurrentTab(int position) {
        this.mFragment.setCurrentTab(position);
    }

    @Override
    public void setCustomLayout(int customLayout) {
        this.mCustomLayout = customLayout;
    }

    @Override
    public void setOnTabSelectedListener(ITabSwipe.OnTabSelectedListener onTabSelectedListener) {
        this.mFragment.setOnTabSelectedListener(onTabSelectedListener);
    }

    @Override
    public void setSmoothScroll(boolean smoothScroll) {
        this.mFragment.setSmoothScroll(smoothScroll);
    }

    public static class InnerFragment
    extends TabSwipeFragment {
        private TabSwipeActivity mActivity;
        private boolean mTabsWasHandled = false;

        @Override
        protected void onHandleTabs() {
            this.mTabsWasHandled = true;
            if (this.mActivity != null) {
                this.mActivity.onHandleTabs();
            }
        }

        public void setActivity(TabSwipeActivity activity) {
            if (activity == null) {
                return;
            }
            this.mActivity = activity;
            if (this.mTabsWasHandled) {
                this.mActivity.onHandleTabs();
            }
        }
    }
}

