/*
 * Decompiled with CFR 0.152.
 */
package org.holoeverywhere.drawable;

import android.content.res.Resources;
import android.content.res.TypedArray;
import android.content.res.XmlResourceParser;
import android.graphics.BitmapFactory;
import android.graphics.drawable.Drawable;
import android.support.v4.util.LongSparseArray;
import android.util.AttributeSet;
import android.util.TypedValue;
import android.util.Xml;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import org.holoeverywhere.drawable.ColorDrawable;
import org.holoeverywhere.drawable.LayerDrawable;
import org.holoeverywhere.drawable.RotateDrawable;
import org.holoeverywhere.drawable.StateListDrawable;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public final class DrawableCompat {
    private static final Map<String, Class<? extends Drawable>> CLASS_MAP = new HashMap<String, Class<? extends Drawable>>();
    private static final LongSparseArray<WeakReference<Drawable.ConstantState>> sDrawableCache = new LongSparseArray();

    public static Drawable createFromPath(String pathName) {
        return Drawable.createFromPath((String)pathName);
    }

    public static Drawable createFromResourceStream(Resources res, TypedValue value, InputStream is, String srcName) {
        return DrawableCompat.createFromResourceStream(res, value, is, srcName, null);
    }

    public static Drawable createFromResourceStream(Resources res, TypedValue value, InputStream is, String srcName, BitmapFactory.Options opts) {
        return Drawable.createFromResourceStream((Resources)res, (TypedValue)value, (InputStream)is, (String)srcName, (BitmapFactory.Options)opts);
    }

    public static Drawable createFromStream(InputStream is, String srcName) {
        return DrawableCompat.createFromResourceStream(null, null, is, srcName, null);
    }

    public static Drawable createFromXml(Resources r, XmlPullParser parser) throws XmlPullParserException, IOException {
        int type;
        AttributeSet attrs = Xml.asAttributeSet((XmlPullParser)parser);
        while ((type = parser.next()) != 2 && type != 1) {
        }
        if (type != 2) {
            throw new XmlPullParserException("No start tag found");
        }
        Drawable drawable2 = DrawableCompat.createFromXmlInner(r, parser, attrs);
        if (drawable2 == null) {
            throw new RuntimeException("Unknown initial tag: " + parser.getName());
        }
        return drawable2;
    }

    public static Drawable createFromXmlInner(Resources r, XmlPullParser parser, AttributeSet attrs) throws XmlPullParserException, IOException {
        Drawable drawable2 = null;
        String name = parser.getName();
        try {
            Class<? extends Drawable> clazz = CLASS_MAP.get(name);
            if (clazz != null) {
                drawable2 = clazz.newInstance();
            } else if (name.indexOf(46) > 0) {
                drawable2 = (Drawable)Class.forName(name).newInstance();
            }
        }
        catch (Exception e) {
            throw new XmlPullParserException("Error while inflating drawable resource", parser, (Throwable)e);
        }
        if (drawable2 == null) {
            return Drawable.createFromXmlInner((Resources)r, (XmlPullParser)parser, (AttributeSet)attrs);
        }
        drawable2.inflate(r, parser, attrs);
        return drawable2;
    }

    private static Drawable getCachedDrawable(long key, Resources res) {
        WeakReference wr = (WeakReference)sDrawableCache.get(key);
        if (wr != null) {
            Drawable.ConstantState entry = (Drawable.ConstantState)wr.get();
            if (entry != null) {
                return entry.newDrawable(res);
            }
            sDrawableCache.delete(key);
        }
        return null;
    }

    public static Drawable getDrawable(Resources res, int resid) {
        TypedValue value = new TypedValue();
        res.getValue(resid, value, true);
        return DrawableCompat.loadDrawable(res, value);
    }

    public static Drawable getDrawable(TypedArray array, int index) {
        TypedValue value = new TypedValue();
        array.getValue(index, value);
        return DrawableCompat.loadDrawable(array.getResources(), value);
    }

    public static Drawable loadDrawable(Resources res, TypedValue value) throws Resources.NotFoundException {
        if (value == null || value.resourceId <= 0) {
            return null;
        }
        long key = (long)value.assetCookie << 32 | (long)value.data;
        Drawable dr = DrawableCompat.getCachedDrawable(key, res);
        if (dr != null) {
            return dr;
        }
        Drawable.ConstantState cs = null;
        if (value.string == null) {
            throw new Resources.NotFoundException("Resource is not a Drawable (color or path): " + value);
        }
        String file = value.string.toString();
        if (file.endsWith(".xml")) {
            try {
                XmlResourceParser rp = res.getAssets().openXmlResourceParser(value.assetCookie, file);
                dr = DrawableCompat.createFromXml(res, (XmlPullParser)rp);
                rp.close();
            }
            catch (Exception e) {
                Resources.NotFoundException rnf = new Resources.NotFoundException("File " + file + " from drawable resource ID #0x" + Integer.toHexString(value.resourceId));
                rnf.initCause((Throwable)e);
                throw rnf;
            }
        }
        try {
            FileInputStream is = res.getAssets().openNonAssetFd(value.assetCookie, file).createInputStream();
            dr = DrawableCompat.createFromResourceStream(res, value, is, file, null);
            ((InputStream)is).close();
        }
        catch (Exception e) {
            Resources.NotFoundException rnf = new Resources.NotFoundException("File " + file + " from drawable resource ID #0x" + Integer.toHexString(value.resourceId));
            rnf.initCause((Throwable)e);
            throw rnf;
        }
        if (dr != null) {
            dr.setChangingConfigurations(value.changingConfigurations);
            cs = dr.getConstantState();
            if (cs != null) {
                sDrawableCache.put(key, new WeakReference<Drawable.ConstantState>(cs));
            }
        }
        return dr;
    }

    private DrawableCompat() {
    }

    static {
        CLASS_MAP.put("rotate", RotateDrawable.class);
        CLASS_MAP.put("layer-list", LayerDrawable.class);
        CLASS_MAP.put("selector", StateListDrawable.class);
        CLASS_MAP.put("color", ColorDrawable.class);
    }
}

