/*
 * Decompiled with CFR 0.152.
 */
package org.holoeverywhere.preference;

import android.content.Context;
import android.util.Log;
import org.holoeverywhere.HoloEverywhere;
import org.holoeverywhere.preference.SharedPreferences;

public class PreferenceManagerHelper {
    private static PreferenceManagerImpl IMPL;

    private static void checkImpl() {
        if (IMPL == null) {
            throw new UnsatisfiedLinkError("HoloEverywhere: PreferenceFramework not found");
        }
    }

    public static SharedPreferences getDefaultSharedPreferences(Context context) {
        return PreferenceManagerHelper.getDefaultSharedPreferences(context, HoloEverywhere.PREFERENCE_IMPL);
    }

    public static SharedPreferences getDefaultSharedPreferences(Context context, HoloEverywhere.PreferenceImpl impl) {
        PreferenceManagerHelper.checkImpl();
        return IMPL.getDefaultSharedPreferences(context, impl);
    }

    public static int obtainThemeTag() {
        PreferenceManagerHelper.checkImpl();
        return IMPL.obtainThemeTag();
    }

    public static SharedPreferences wrap(Context context, HoloEverywhere.PreferenceImpl impl, String name, int mode) {
        PreferenceManagerHelper.checkImpl();
        return IMPL.wrap(context, impl, name, mode);
    }

    public static SharedPreferences wrap(Context context, String name, int mode) {
        return PreferenceManagerHelper.wrap(context, HoloEverywhere.PREFERENCE_IMPL, name, mode);
    }

    private PreferenceManagerHelper() {
    }

    static {
        block2: {
            try {
                Class<?> clazz = Class.forName(HoloEverywhere.PACKAGE + ".preference._PreferenceManagerImpl");
                IMPL = (PreferenceManagerImpl)clazz.newInstance();
            }
            catch (Exception e) {
                IMPL = null;
                if (!HoloEverywhere.DEBUG) break block2;
                Log.w((String)"HoloEverywhere", (String)"Cannot find PreferenceManager class. Preference framework are disabled.", (Throwable)e);
            }
        }
    }

    static interface PreferenceManagerImpl {
        public SharedPreferences getDefaultSharedPreferences(Context var1, HoloEverywhere.PreferenceImpl var2);

        public int obtainThemeTag();

        public SharedPreferences wrap(Context var1, HoloEverywhere.PreferenceImpl var2, String var3, int var4);
    }
}

