/*
 * Decompiled with CFR 0.152.
 */
package org.holoeverywhere.util;

import android.os.Parcel;
import android.os.Parcelable;
import org.holoeverywhere.util.ArrayUtils;

public class SparseIntArray
implements Cloneable,
Parcelable {
    public static final Parcelable.Creator<SparseIntArray> CREATOR = new Parcelable.Creator<SparseIntArray>(){

        public SparseIntArray createFromParcel(Parcel source) {
            int size = source.readInt();
            SparseIntArray array = new SparseIntArray(size);
            array.mSize = size;
            SparseIntArray.access$102(array, source.createIntArray());
            SparseIntArray.access$202(array, source.createIntArray());
            return array;
        }

        public SparseIntArray[] newArray(int size) {
            return new SparseIntArray[size];
        }
    };
    private int[] mKeys;
    private int mSize;
    private int[] mValues;

    private static int binarySearch(int[] a, int start, int len, int key) {
        int high = start + len;
        int low = start - 1;
        while (high - low > 1) {
            int guess = (high + low) / 2;
            if (a[guess] < key) {
                low = guess;
                continue;
            }
            high = guess;
        }
        if (high == start + len) {
            return ~(start + len);
        }
        if (a[high] == key) {
            return high;
        }
        return ~high;
    }

    public SparseIntArray() {
        this(10);
    }

    public SparseIntArray(int initialCapacity) {
        initialCapacity = ArrayUtils.idealIntArraySize(initialCapacity);
        this.mKeys = new int[initialCapacity];
        this.mValues = new int[initialCapacity];
        this.mSize = 0;
    }

    public SparseIntArray(SparseIntArray arrayForCopy) {
        if (arrayForCopy == null) {
            int initialCapacity = ArrayUtils.idealIntArraySize(10);
            this.mKeys = new int[initialCapacity];
            this.mValues = new int[initialCapacity];
            this.mSize = 0;
        } else {
            this.mKeys = (int[])arrayForCopy.mKeys.clone();
            this.mValues = (int[])arrayForCopy.mValues.clone();
        }
    }

    public void append(int key, int value) {
        if (this.mSize != 0 && key <= this.mKeys[this.mSize - 1]) {
            this.put(key, value);
            return;
        }
        int pos = this.mSize;
        if (pos >= this.mKeys.length) {
            int n = ArrayUtils.idealIntArraySize(pos + 1);
            int[] nkeys = new int[n];
            int[] nvalues = new int[n];
            System.arraycopy(this.mKeys, 0, nkeys, 0, this.mKeys.length);
            System.arraycopy(this.mValues, 0, nvalues, 0, this.mValues.length);
            this.mKeys = nkeys;
            this.mValues = nvalues;
        }
        this.mKeys[pos] = key;
        this.mValues[pos] = value;
        this.mSize = pos + 1;
    }

    public void clear() {
        this.mSize = 0;
    }

    public SparseIntArray clone() {
        SparseIntArray clone = null;
        try {
            clone = (SparseIntArray)super.clone();
            clone.mKeys = (int[])this.mKeys.clone();
            clone.mValues = (int[])this.mValues.clone();
            clone.mSize = this.mSize;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return clone;
    }

    public void delete(int key) {
        int i = SparseIntArray.binarySearch(this.mKeys, 0, this.mSize, key);
        if (i >= 0) {
            this.removeAt(i);
        }
    }

    public int describeContents() {
        return 0;
    }

    public int get(int key) {
        return this.get(key, 0);
    }

    public int get(int key, int valueIfKeyNotFound) {
        int i = SparseIntArray.binarySearch(this.mKeys, 0, this.mSize, key);
        if (i < 0) {
            return valueIfKeyNotFound;
        }
        return this.mValues[i];
    }

    public int indexOfKey(int key) {
        return SparseIntArray.binarySearch(this.mKeys, 0, this.mSize, key);
    }

    public int indexOfValue(int value) {
        for (int i = 0; i < this.mSize; ++i) {
            if (this.mValues[i] != value) continue;
            return i;
        }
        return -1;
    }

    public int keyAt(int index) {
        return this.mKeys[index];
    }

    public void put(int key, int value) {
        int i = SparseIntArray.binarySearch(this.mKeys, 0, this.mSize, key);
        if (i >= 0) {
            this.mValues[i] = value;
        } else {
            i ^= 0xFFFFFFFF;
            if (this.mSize >= this.mKeys.length) {
                int n = ArrayUtils.idealIntArraySize(this.mSize + 1);
                int[] nkeys = new int[n];
                int[] nvalues = new int[n];
                System.arraycopy(this.mKeys, 0, nkeys, 0, this.mKeys.length);
                System.arraycopy(this.mValues, 0, nvalues, 0, this.mValues.length);
                this.mKeys = nkeys;
                this.mValues = nvalues;
            }
            if (this.mSize - i != 0) {
                System.arraycopy(this.mKeys, i, this.mKeys, i + 1, this.mSize - i);
                System.arraycopy(this.mValues, i, this.mValues, i + 1, this.mSize - i);
            }
            this.mKeys[i] = key;
            this.mValues[i] = value;
            ++this.mSize;
        }
    }

    public void removeAt(int index) {
        System.arraycopy(this.mKeys, index + 1, this.mKeys, index, this.mSize - (index + 1));
        System.arraycopy(this.mValues, index + 1, this.mValues, index, this.mSize - (index + 1));
        --this.mSize;
    }

    public int size() {
        return this.mSize;
    }

    public int valueAt(int index) {
        return this.mValues[index];
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mSize);
        dest.writeIntArray(this.mKeys);
        dest.writeIntArray(this.mValues);
    }

    static /* synthetic */ int[] access$102(SparseIntArray x0, int[] x1) {
        x0.mKeys = x1;
        return x1;
    }

    static /* synthetic */ int[] access$202(SparseIntArray x0, int[] x1) {
        x0.mValues = x1;
        return x1;
    }
}

