/*
 * Decompiled with CFR 0.152.
 */
package org.holoeverywhere.widget;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.Configuration;
import android.content.res.TypedArray;
import android.database.DataSetObserver;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.text.TextUtils;
import android.text.format.DateUtils;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.TypedValue;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.BaseAdapter;
import android.widget.ListAdapter;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Locale;
import org.holoeverywhere.FontLoader;
import org.holoeverywhere.LayoutInflater;
import org.holoeverywhere.R;
import org.holoeverywhere.widget.FrameLayout;
import org.holoeverywhere.widget.ListView;
import org.holoeverywhere.widget.TextView;

public class CalendarView
extends FrameLayout {
    private static final int ADJUSTMENT_SCROLL_DURATION = 500;
    private static final String DATE_FORMAT = "MM/dd/yyyy";
    private static final int DAYS_PER_WEEK = 7;
    private static final String DEFAULT_MAX_DATE = "01/01/2100";
    private static final String DEFAULT_MIN_DATE = "01/01/1900";
    private static final boolean DEFAULT_SHOW_WEEK_NUMBER = true;
    private static final int DEFAULT_SHOWN_WEEK_COUNT = 6;
    private static final int DEFAULT_WEEK_DAY_TEXT_APPEARANCE_RES_ID = -1;
    private static final int GOTO_SCROLL_DURATION = 1000;
    private static final String LOG_TAG = CalendarView.class.getSimpleName();
    private static final long MILLIS_IN_DAY = 86400000L;
    private static final long MILLIS_IN_WEEK = 604800000L;
    private static final int SCROLL_CHANGE_DELAY = 40;
    private static final int SCROLL_HYST_WEEKS = 2;
    private static final int UNSCALED_BOTTOM_BUFFER = 20;
    private static final int UNSCALED_LIST_SCROLL_TOP_OFFSET = 2;
    private static final int UNSCALED_SELECTED_DATE_VERTICAL_BAR_WIDTH = 6;
    private static final int UNSCALED_WEEK_MIN_VISIBLE_HEIGHT = 12;
    private static final int UNSCALED_WEEK_SEPARATOR_LINE_WIDTH = 1;
    private WeeksAdapter mAdapter;
    private int mBottomBuffer = 20;
    private Locale mCurrentLocale;
    private int mCurrentMonthDisplayed;
    private int mCurrentScrollState = 0;
    private int mCurrentYearDisplayed;
    private final DateFormat mDateFormat = new SimpleDateFormat("MM/dd/yyyy");
    private final int mDateTextSize;
    private String[] mDayLabels;
    private ViewGroup mDayNamesHeader;
    private int mDaysPerWeek = 7;
    private Calendar mFirstDayOfMonth;
    private int mFirstDayOfWeek;
    private final int mFocusedMonthDateColor;
    private float mFriction = 0.05f;
    private boolean mIsScrollingUp = false;
    private int mListScrollTopOffset = 2;
    private ListView mListView;
    private Calendar mMaxDate;
    private Calendar mMinDate;
    private TextView mMonthName;
    private OnDateChangeListener mOnDateChangeListener;
    private long mPreviousScrollPosition;
    private int mPreviousScrollState = 0;
    private ScrollStateRunnable mScrollStateChangedRunnable = new ScrollStateRunnable();
    private final Drawable mSelectedDateVerticalBar;
    private final int mSelectedDateVerticalBarWidth;
    private final int mSelectedWeekBackgroundColor;
    private int mShownWeekCount;
    private boolean mShowWeekNumber;
    private Calendar mTempDate;
    private final int mUnfocusedMonthDateColor;
    private float mVelocityScale = 0.333f;
    private int mWeekMinVisibleHeight = 12;
    private final int mWeekNumberColor;
    private final int mWeekSeparatorLineColor;
    private final int mWeekSeperatorLineWidth;

    public CalendarView(Context context) {
        this(context, null);
    }

    public CalendarView(Context context, AttributeSet attrs) {
        this(context, attrs, 2130772077);
    }

    public CalendarView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        String maxDate;
        this.setCurrentLocale(Locale.getDefault());
        TypedArray attributesArray = context.obtainStyledAttributes(attrs, R.styleable.CalendarView, defStyle, 2131558523);
        this.mShowWeekNumber = attributesArray.getBoolean(7, true);
        this.mFirstDayOfWeek = attributesArray.getInt(1, 1);
        String minDate = attributesArray.getString(4);
        if (TextUtils.isEmpty((CharSequence)minDate) || !this.parseDate(minDate, this.mMinDate)) {
            this.parseDate(DEFAULT_MIN_DATE, this.mMinDate);
        }
        if (TextUtils.isEmpty((CharSequence)(maxDate = attributesArray.getString(3))) || !this.parseDate(maxDate, this.mMaxDate)) {
            this.parseDate(DEFAULT_MAX_DATE, this.mMaxDate);
        }
        if (this.mMaxDate.before(this.mMinDate)) {
            throw new IllegalArgumentException("Max date cannot be before min date.");
        }
        this.mShownWeekCount = attributesArray.getInt(8, 6);
        this.mSelectedWeekBackgroundColor = attributesArray.getColor(6, 0);
        this.mFocusedMonthDateColor = attributesArray.getColor(2, 0);
        this.mUnfocusedMonthDateColor = attributesArray.getColor(9, 0);
        this.mWeekSeparatorLineColor = attributesArray.getColor(12, 0);
        this.mWeekNumberColor = attributesArray.getColor(11, 0);
        this.mSelectedDateVerticalBar = attributesArray.getDrawable(5);
        attributesArray.getResourceId(0, 16973894);
        this.mDateTextSize = (int)(12.0f * this.getContext().getResources().getDisplayMetrics().density);
        int weekDayTextAppearanceResId = attributesArray.getResourceId(10, -1);
        attributesArray.recycle();
        DisplayMetrics displayMetrics = this.getResources().getDisplayMetrics();
        this.mWeekMinVisibleHeight = (int)TypedValue.applyDimension((int)1, (float)12.0f, (DisplayMetrics)displayMetrics);
        this.mListScrollTopOffset = (int)TypedValue.applyDimension((int)1, (float)2.0f, (DisplayMetrics)displayMetrics);
        this.mBottomBuffer = (int)TypedValue.applyDimension((int)1, (float)20.0f, (DisplayMetrics)displayMetrics);
        this.mSelectedDateVerticalBarWidth = (int)TypedValue.applyDimension((int)1, (float)6.0f, (DisplayMetrics)displayMetrics);
        this.mWeekSeperatorLineWidth = (int)TypedValue.applyDimension((int)1, (float)1.0f, (DisplayMetrics)displayMetrics);
        LayoutInflater.inflate(context, 2130903063, (ViewGroup)this, true);
        FontLoader.apply(this);
        this.mListView = (ListView)this.findViewById(2131165292);
        this.mDayNamesHeader = (ViewGroup)this.findViewById(2131165291);
        this.mMonthName = (TextView)this.findViewById(2131165290);
        this.setUpHeader(weekDayTextAppearanceResId);
        this.setUpListView();
        this.setUpAdapter();
        this.mTempDate.setTimeInMillis(System.currentTimeMillis());
        if (this.mTempDate.before(this.mMinDate)) {
            this.goTo(this.mMinDate, false, true, true);
        } else if (this.mMaxDate.before(this.mTempDate)) {
            this.goTo(this.mMaxDate, false, true, true);
        } else {
            this.goTo(this.mTempDate, false, true, true);
        }
        this.invalidate();
    }

    private Calendar getCalendarForLocale(Calendar oldCalendar, Locale locale) {
        if (oldCalendar == null) {
            return Calendar.getInstance(locale);
        }
        long currentTimeMillis = oldCalendar.getTimeInMillis();
        Calendar newCalendar = Calendar.getInstance(locale);
        newCalendar.setTimeInMillis(currentTimeMillis);
        return newCalendar;
    }

    public long getDate() {
        return this.mAdapter.mSelectedDate.getTimeInMillis();
    }

    public int getFirstDayOfWeek() {
        return this.mFirstDayOfWeek;
    }

    public long getMaxDate() {
        return this.mMaxDate.getTimeInMillis();
    }

    public long getMinDate() {
        return this.mMinDate.getTimeInMillis();
    }

    public boolean getShowWeekNumber() {
        return this.mShowWeekNumber;
    }

    private int getWeeksSinceMinDate(Calendar date) {
        if (date.before(this.mMinDate)) {
            throw new IllegalArgumentException("fromDate: " + this.mMinDate.getTime() + " does not precede toDate: " + date.getTime());
        }
        long endTimeMillis = date.getTimeInMillis() + (long)date.getTimeZone().getOffset(date.getTimeInMillis());
        long startTimeMillis = this.mMinDate.getTimeInMillis() + (long)this.mMinDate.getTimeZone().getOffset(this.mMinDate.getTimeInMillis());
        long dayOffsetMillis = (long)(this.mMinDate.get(7) - this.mFirstDayOfWeek) * 86400000L;
        return (int)((endTimeMillis - startTimeMillis + dayOffsetMillis) / 604800000L);
    }

    @SuppressLint(value={"NewApi"})
    private void goTo(Calendar date, boolean animate, boolean setSelected, boolean forceScroll) {
        int position;
        if (date.before(this.mMinDate) || date.after(this.mMaxDate)) {
            throw new IllegalArgumentException("Time not between " + this.mMinDate.getTime() + " and " + this.mMaxDate.getTime());
        }
        int firstFullyVisiblePosition = this.mListView.getFirstVisiblePosition();
        View firstChild = this.mListView.getChildAt(0);
        if (firstChild != null && firstChild.getTop() < 0) {
            ++firstFullyVisiblePosition;
        }
        int lastFullyVisiblePosition = firstFullyVisiblePosition + this.mShownWeekCount - 1;
        if (firstChild != null && firstChild.getTop() > this.mBottomBuffer) {
            --lastFullyVisiblePosition;
        }
        if (setSelected) {
            this.mAdapter.setSelectedDay(date);
        }
        if ((position = this.getWeeksSinceMinDate(date)) < firstFullyVisiblePosition || position > lastFullyVisiblePosition || forceScroll) {
            this.mFirstDayOfMonth.setTimeInMillis(date.getTimeInMillis());
            this.mFirstDayOfMonth.set(5, 1);
            this.setMonthDisplayed(this.mFirstDayOfMonth);
            position = this.mFirstDayOfMonth.before(this.mMinDate) ? 0 : this.getWeeksSinceMinDate(this.mFirstDayOfMonth);
            this.mPreviousScrollState = 2;
            if (animate && Build.VERSION.SDK_INT >= 11) {
                this.mListView.smoothScrollToPositionFromTop(position, this.mListScrollTopOffset, 1000);
            } else {
                this.mListView.setSelectionFromTop(position, this.mListScrollTopOffset);
                this.onScrollStateChanged((AbsListView)this.mListView, 0);
            }
        } else if (setSelected) {
            this.setMonthDisplayed(date);
        }
    }

    public boolean isEnabled() {
        return this.mListView.isEnabled();
    }

    private boolean isSameDate(Calendar firstDate, Calendar secondDate) {
        return firstDate.get(6) == secondDate.get(6) && firstDate.get(1) == secondDate.get(1);
    }

    @SuppressLint(value={"NewApi"})
    protected void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        this.setCurrentLocale(newConfig.locale);
    }

    private void onScroll(AbsListView view, int firstVisibleItem, int visibleItemCount, int totalItemCount) {
        int offset;
        WeekView child = (WeekView)view.getChildAt(0);
        if (child == null) {
            return;
        }
        long currScroll = view.getFirstVisiblePosition() * child.getHeight() - child.getBottom();
        if (currScroll < this.mPreviousScrollPosition) {
            this.mIsScrollingUp = true;
        } else if (currScroll > this.mPreviousScrollPosition) {
            this.mIsScrollingUp = false;
        } else {
            return;
        }
        int n = offset = child.getBottom() < this.mWeekMinVisibleHeight ? 1 : 0;
        if (this.mIsScrollingUp) {
            child = (WeekView)view.getChildAt(2 + offset);
        } else if (offset != 0) {
            child = (WeekView)view.getChildAt(offset);
        }
        int month = this.mIsScrollingUp ? child.getMonthOfFirstWeekDay() : child.getMonthOfLastWeekDay();
        int monthDiff = this.mCurrentMonthDisplayed == 11 && month == 0 ? 1 : (this.mCurrentMonthDisplayed == 0 && month == 11 ? -1 : month - this.mCurrentMonthDisplayed);
        if (!this.mIsScrollingUp && monthDiff > 0 || this.mIsScrollingUp && monthDiff < 0) {
            Calendar firstDay = child.getFirstDay();
            if (this.mIsScrollingUp) {
                firstDay.add(5, -7);
            } else {
                firstDay.add(5, 7);
            }
            this.setMonthDisplayed(firstDay);
        }
        this.mPreviousScrollPosition = currScroll;
        this.mPreviousScrollState = this.mCurrentScrollState;
    }

    private void onScrollStateChanged(AbsListView view, int scrollState) {
        this.mScrollStateChangedRunnable.doScrollStateChange(view, scrollState);
    }

    private boolean parseDate(String date, Calendar outDate) {
        try {
            outDate.setTime(this.mDateFormat.parse(date));
            return true;
        }
        catch (ParseException e) {
            Log.w((String)LOG_TAG, (String)("Date: " + date + " not in format: " + DATE_FORMAT));
            return false;
        }
    }

    private void setCurrentLocale(Locale locale) {
        if (locale.equals(this.mCurrentLocale)) {
            return;
        }
        this.mCurrentLocale = locale;
        this.mTempDate = this.getCalendarForLocale(this.mTempDate, locale);
        this.mFirstDayOfMonth = this.getCalendarForLocale(this.mFirstDayOfMonth, locale);
        this.mMinDate = this.getCalendarForLocale(this.mMinDate, locale);
        this.mMaxDate = this.getCalendarForLocale(this.mMaxDate, locale);
    }

    public void setDate(long date) {
        this.setDate(date, false, false);
    }

    public void setDate(long date, boolean animate, boolean center) {
        this.mTempDate.setTimeInMillis(date);
        if (this.isSameDate(this.mTempDate, this.mAdapter.mSelectedDate)) {
            return;
        }
        this.goTo(this.mTempDate, animate, true, center);
    }

    public void setEnabled(boolean enabled) {
        this.mListView.setEnabled(enabled);
    }

    public void setFirstDayOfWeek(int firstDayOfWeek) {
        if (this.mFirstDayOfWeek == firstDayOfWeek) {
            return;
        }
        this.mFirstDayOfWeek = firstDayOfWeek;
        this.mAdapter.init();
        this.mAdapter.notifyDataSetChanged();
        this.setUpHeader(-1);
    }

    public void setMaxDate(long maxDate) {
        this.mTempDate.setTimeInMillis(maxDate);
        if (this.isSameDate(this.mTempDate, this.mMaxDate)) {
            return;
        }
        this.mMaxDate.setTimeInMillis(maxDate);
        this.mAdapter.init();
        Calendar date = this.mAdapter.mSelectedDate;
        if (date.after(this.mMaxDate)) {
            this.setDate(this.mMaxDate.getTimeInMillis());
        } else {
            this.goTo(date, false, true, false);
        }
    }

    public void setMinDate(long minDate) {
        this.mTempDate.setTimeInMillis(minDate);
        if (this.isSameDate(this.mTempDate, this.mMinDate)) {
            return;
        }
        this.mMinDate.setTimeInMillis(minDate);
        Calendar date = this.mAdapter.mSelectedDate;
        if (date.before(this.mMinDate)) {
            this.mAdapter.setSelectedDay(this.mMinDate);
        }
        this.mAdapter.init();
        if (date.before(this.mMinDate)) {
            this.setDate(this.mTempDate.getTimeInMillis());
        } else {
            this.goTo(date, false, true, false);
        }
    }

    private void setMonthDisplayed(Calendar calendar) {
        int newMonthDisplayed = calendar.get(2);
        int newYearDisplayed = calendar.get(1);
        if (this.mCurrentMonthDisplayed != newMonthDisplayed || this.mCurrentYearDisplayed != newYearDisplayed) {
            this.mCurrentMonthDisplayed = newMonthDisplayed;
            this.mCurrentYearDisplayed = newYearDisplayed;
            this.mAdapter.setFocusMonth(this.mCurrentMonthDisplayed);
            int flags = 52;
            long millis = calendar.getTimeInMillis();
            String newMonthName = DateUtils.formatDateRange((Context)this.getContext(), (long)millis, (long)millis, (int)52);
            this.mMonthName.setText(newMonthName);
            this.mMonthName.invalidate();
        }
    }

    public void setOnDateChangeListener(OnDateChangeListener listener) {
        this.mOnDateChangeListener = listener;
    }

    public void setShowWeekNumber(boolean showWeekNumber) {
        if (this.mShowWeekNumber == showWeekNumber) {
            return;
        }
        this.mShowWeekNumber = showWeekNumber;
        this.mAdapter.notifyDataSetChanged();
        this.setUpHeader(-1);
    }

    private void setUpAdapter() {
        if (this.mAdapter == null) {
            this.mAdapter = new WeeksAdapter(this.getContext());
            this.mAdapter.registerDataSetObserver(new DataSetObserver(){

                public void onChanged() {
                    if (CalendarView.this.mOnDateChangeListener != null) {
                        Calendar selectedDay = CalendarView.this.mAdapter.getSelectedDay();
                        CalendarView.this.mOnDateChangeListener.onSelectedDayChange(CalendarView.this, selectedDay.get(1), selectedDay.get(2), selectedDay.get(5));
                    }
                }
            });
            this.mListView.setAdapter((ListAdapter)this.mAdapter);
        }
        this.mAdapter.notifyDataSetChanged();
    }

    private void setUpHeader(int weekDayTextAppearanceResId) {
        this.mDayLabels = new String[this.mDaysPerWeek];
        int count = this.mFirstDayOfWeek + this.mDaysPerWeek;
        for (int i = this.mFirstDayOfWeek; i < count; ++i) {
            int calendarDay = i > 7 ? i - 7 : i;
            this.mDayLabels[i - this.mFirstDayOfWeek] = DateUtils.getDayOfWeekString((int)calendarDay, (int)50);
        }
        TextView label = (TextView)this.mDayNamesHeader.getChildAt(0);
        if (this.mShowWeekNumber) {
            label.setVisibility(0);
        } else {
            label.setVisibility(8);
        }
        int count2 = this.mDayNamesHeader.getChildCount();
        for (int i = 1; i < count2; ++i) {
            label = (TextView)this.mDayNamesHeader.getChildAt(i);
            if (weekDayTextAppearanceResId > -1) {
                label.setTextAppearance(this.getContext(), weekDayTextAppearanceResId);
            }
            if (i < this.mDaysPerWeek + 1) {
                label.setText(this.mDayLabels[i - 1]);
                label.setVisibility(0);
                continue;
            }
            label.setVisibility(8);
        }
        this.mDayNamesHeader.invalidate();
    }

    @SuppressLint(value={"NewApi"})
    private void setUpListView() {
        this.mListView.setDivider(null);
        this.mListView.setItemsCanFocus(true);
        this.mListView.setVerticalScrollBarEnabled(false);
        this.mListView.setOnScrollListener(new AbsListView.OnScrollListener(){

            public void onScroll(AbsListView view, int firstVisibleItem, int visibleItemCount, int totalItemCount) {
                CalendarView.this.onScroll(view, firstVisibleItem, visibleItemCount, totalItemCount);
            }

            public void onScrollStateChanged(AbsListView view, int scrollState) {
                CalendarView.this.onScrollStateChanged(view, scrollState);
            }
        });
        if (Build.VERSION.SDK_INT >= 11) {
            this.mListView.setFriction(this.mFriction);
            this.mListView.setVelocityScale(this.mVelocityScale);
        }
    }

    private class WeekView
    extends View {
        private String[] mDayNumbers;
        private final Paint mDrawPaint;
        private Calendar mFirstDay;
        private boolean[] mFocusDay;
        private boolean mHasSelectedDay;
        private int mHeight;
        private int mLastWeekDayMonth;
        private final Paint mMonthNumDrawPaint;
        private int mMonthOfFirstWeekDay;
        private int mNumCells;
        private int mSelectedDay;
        private int mSelectedLeft;
        private int mSelectedRight;
        private final Rect mTempRect;
        private int mWeek;
        private int mWidth;

        public WeekView(Context context) {
            super(context);
            this.mDrawPaint = new Paint();
            this.mHasSelectedDay = false;
            this.mLastWeekDayMonth = -1;
            this.mMonthNumDrawPaint = new Paint();
            this.mMonthOfFirstWeekDay = -1;
            this.mSelectedDay = -1;
            this.mSelectedLeft = -1;
            this.mSelectedRight = -1;
            this.mTempRect = new Rect();
            this.mWeek = -1;
            this.mHeight = (CalendarView.this.mListView.getHeight() - CalendarView.this.mListView.getPaddingTop() - CalendarView.this.mListView.getPaddingBottom()) / CalendarView.this.mShownWeekCount;
            this.setPaintProperties();
        }

        private void drawBackground(Canvas canvas) {
            if (!this.mHasSelectedDay) {
                return;
            }
            this.mDrawPaint.setColor(CalendarView.this.mSelectedWeekBackgroundColor);
            this.mTempRect.top = CalendarView.this.mWeekSeperatorLineWidth;
            this.mTempRect.bottom = this.mHeight;
            this.mTempRect.left = CalendarView.this.mShowWeekNumber ? this.mWidth / this.mNumCells : 0;
            this.mTempRect.right = this.mSelectedLeft - 2;
            canvas.drawRect(this.mTempRect, this.mDrawPaint);
            this.mTempRect.left = this.mSelectedRight + 3;
            this.mTempRect.right = this.mWidth;
            canvas.drawRect(this.mTempRect, this.mDrawPaint);
        }

        private void drawSelectedDateVerticalBars(Canvas canvas) {
            if (!this.mHasSelectedDay) {
                return;
            }
            CalendarView.this.mSelectedDateVerticalBar.setBounds(this.mSelectedLeft - CalendarView.this.mSelectedDateVerticalBarWidth / 2, CalendarView.this.mWeekSeperatorLineWidth, this.mSelectedLeft + CalendarView.this.mSelectedDateVerticalBarWidth / 2, this.mHeight);
            CalendarView.this.mSelectedDateVerticalBar.draw(canvas);
            CalendarView.this.mSelectedDateVerticalBar.setBounds(this.mSelectedRight - CalendarView.this.mSelectedDateVerticalBarWidth / 2, CalendarView.this.mWeekSeperatorLineWidth, this.mSelectedRight + CalendarView.this.mSelectedDateVerticalBarWidth / 2, this.mHeight);
            CalendarView.this.mSelectedDateVerticalBar.draw(canvas);
        }

        private void drawWeekNumbers(Canvas canvas) {
            int x;
            float textHeight = this.mDrawPaint.getTextSize();
            int y = (int)(((float)this.mHeight + textHeight) / 2.0f) - CalendarView.this.mWeekSeperatorLineWidth;
            int nDays = this.mNumCells;
            this.mDrawPaint.setTextAlign(Paint.Align.CENTER);
            int i = 0;
            int divisor = 2 * nDays;
            if (CalendarView.this.mShowWeekNumber) {
                this.mDrawPaint.setColor(CalendarView.this.mWeekNumberColor);
                x = this.mWidth / divisor;
                canvas.drawText(this.mDayNumbers[0], (float)x, (float)y, this.mDrawPaint);
                ++i;
            }
            while (i < nDays) {
                this.mMonthNumDrawPaint.setColor(this.mFocusDay[i] ? CalendarView.this.mFocusedMonthDateColor : CalendarView.this.mUnfocusedMonthDateColor);
                x = (2 * i + 1) * this.mWidth / divisor;
                canvas.drawText(this.mDayNumbers[i], (float)x, (float)y, this.mMonthNumDrawPaint);
                ++i;
            }
        }

        private void drawWeekSeparators(Canvas canvas) {
            int firstFullyVisiblePosition = CalendarView.this.mListView.getFirstVisiblePosition();
            if (CalendarView.this.mListView.getChildAt(0).getTop() < 0) {
                ++firstFullyVisiblePosition;
            }
            if (firstFullyVisiblePosition == this.mWeek) {
                return;
            }
            this.mDrawPaint.setColor(CalendarView.this.mWeekSeparatorLineColor);
            this.mDrawPaint.setStrokeWidth((float)CalendarView.this.mWeekSeperatorLineWidth);
            float x = CalendarView.this.mShowWeekNumber ? (float)(this.mWidth / this.mNumCells) : 0.0f;
            canvas.drawLine(x, 0.0f, (float)this.mWidth, 0.0f, this.mDrawPaint);
        }

        public boolean getDayFromLocation(float x, Calendar outCalendar) {
            int dayStart;
            int n = dayStart = CalendarView.this.mShowWeekNumber ? this.mWidth / this.mNumCells : 0;
            if (x < (float)dayStart || x > (float)this.mWidth) {
                outCalendar.clear();
                return false;
            }
            int dayPosition = (int)((x - (float)dayStart) * (float)CalendarView.this.mDaysPerWeek / (float)(this.mWidth - dayStart));
            outCalendar.setTimeInMillis(this.mFirstDay.getTimeInMillis());
            outCalendar.add(5, dayPosition);
            return true;
        }

        public Calendar getFirstDay() {
            return this.mFirstDay;
        }

        public int getMonthOfFirstWeekDay() {
            return this.mMonthOfFirstWeekDay;
        }

        public int getMonthOfLastWeekDay() {
            return this.mLastWeekDayMonth;
        }

        public void init(int weekNumber, int selectedWeekDay, int focusedMonth) {
            this.mSelectedDay = selectedWeekDay;
            this.mHasSelectedDay = this.mSelectedDay != -1;
            this.mNumCells = CalendarView.this.mShowWeekNumber ? CalendarView.this.mDaysPerWeek + 1 : CalendarView.this.mDaysPerWeek;
            this.mWeek = weekNumber;
            CalendarView.this.mTempDate.setTimeInMillis(CalendarView.this.mMinDate.getTimeInMillis());
            CalendarView.this.mTempDate.add(3, this.mWeek);
            CalendarView.this.mTempDate.setFirstDayOfWeek(CalendarView.this.mFirstDayOfWeek);
            this.mDayNumbers = new String[this.mNumCells];
            this.mFocusDay = new boolean[this.mNumCells];
            int i = 0;
            if (CalendarView.this.mShowWeekNumber) {
                this.mDayNumbers[0] = Integer.toString(CalendarView.this.mTempDate.get(3));
                ++i;
            }
            int diff = CalendarView.this.mFirstDayOfWeek - CalendarView.this.mTempDate.get(7);
            CalendarView.this.mTempDate.add(5, diff);
            this.mFirstDay = (Calendar)CalendarView.this.mTempDate.clone();
            this.mMonthOfFirstWeekDay = CalendarView.this.mTempDate.get(2);
            while (i < this.mNumCells) {
                this.mFocusDay[i] = CalendarView.this.mTempDate.get(2) == focusedMonth;
                this.mDayNumbers[i] = CalendarView.this.mTempDate.before(CalendarView.this.mMinDate) || CalendarView.this.mTempDate.after(CalendarView.this.mMaxDate) ? "" : Integer.toString(CalendarView.this.mTempDate.get(5));
                CalendarView.this.mTempDate.add(5, 1);
                ++i;
            }
            if (CalendarView.this.mTempDate.get(5) == 1) {
                CalendarView.this.mTempDate.add(5, -1);
            }
            this.mLastWeekDayMonth = CalendarView.this.mTempDate.get(2);
            this.updateSelectionPositions();
        }

        protected void onDraw(Canvas canvas) {
            this.drawBackground(canvas);
            this.drawWeekNumbers(canvas);
            this.drawWeekSeparators(canvas);
            this.drawSelectedDateVerticalBars(canvas);
        }

        protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
            this.setMeasuredDimension(View.MeasureSpec.getSize((int)widthMeasureSpec), this.mHeight);
        }

        protected void onSizeChanged(int w, int h, int oldw, int oldh) {
            this.mWidth = w;
            this.updateSelectionPositions();
        }

        private void setPaintProperties() {
            this.mDrawPaint.setFakeBoldText(false);
            this.mDrawPaint.setAntiAlias(true);
            this.mDrawPaint.setTextSize((float)CalendarView.this.mDateTextSize);
            this.mDrawPaint.setStyle(Paint.Style.FILL);
            this.mMonthNumDrawPaint.setFakeBoldText(true);
            this.mMonthNumDrawPaint.setAntiAlias(true);
            this.mMonthNumDrawPaint.setTextSize((float)CalendarView.this.mDateTextSize);
            this.mMonthNumDrawPaint.setColor(CalendarView.this.mFocusedMonthDateColor);
            this.mMonthNumDrawPaint.setStyle(Paint.Style.FILL);
            this.mMonthNumDrawPaint.setTextAlign(Paint.Align.CENTER);
        }

        private void updateSelectionPositions() {
            if (this.mHasSelectedDay) {
                int selectedPosition = this.mSelectedDay - CalendarView.this.mFirstDayOfWeek;
                if (selectedPosition < 0) {
                    selectedPosition += 7;
                }
                if (CalendarView.this.mShowWeekNumber) {
                    ++selectedPosition;
                }
                this.mSelectedLeft = selectedPosition * this.mWidth / this.mNumCells;
                this.mSelectedRight = (selectedPosition + 1) * this.mWidth / this.mNumCells;
            }
        }
    }

    private class WeeksAdapter
    extends BaseAdapter
    implements View.OnTouchListener {
        private Context context;
        private int mFocusedMonth;
        private GestureDetector mGestureDetector;
        private final Calendar mSelectedDate = Calendar.getInstance();
        private int mSelectedWeek;
        private int mTotalWeekCount;

        public WeeksAdapter(Context context) {
            this.context = context;
            this.mGestureDetector = new GestureDetector(context, (GestureDetector.OnGestureListener)new CalendarGestureListener());
            this.init();
        }

        public int getCount() {
            return this.mTotalWeekCount;
        }

        public Object getItem(int position) {
            return null;
        }

        public long getItemId(int position) {
            return position;
        }

        public Calendar getSelectedDay() {
            return this.mSelectedDate;
        }

        public View getView(int position, View convertView, ViewGroup parent) {
            WeekView weekView = null;
            if (convertView != null) {
                weekView = (WeekView)convertView;
            } else {
                weekView = new WeekView(this.context);
                AbsListView.LayoutParams params = new AbsListView.LayoutParams(-2, -2);
                weekView.setLayoutParams((ViewGroup.LayoutParams)params);
                weekView.setClickable(true);
                weekView.setOnTouchListener(this);
            }
            int selectedWeekDay = this.mSelectedWeek == position ? this.mSelectedDate.get(7) : -1;
            weekView.init(position, selectedWeekDay, this.mFocusedMonth);
            return weekView;
        }

        private void init() {
            this.mSelectedWeek = CalendarView.this.getWeeksSinceMinDate(this.mSelectedDate);
            this.mTotalWeekCount = CalendarView.this.getWeeksSinceMinDate(CalendarView.this.mMaxDate);
            if (CalendarView.this.mMinDate.get(7) != CalendarView.this.mFirstDayOfWeek || CalendarView.this.mMaxDate.get(7) != CalendarView.this.mFirstDayOfWeek) {
                ++this.mTotalWeekCount;
            }
        }

        private void onDateTapped(Calendar day) {
            this.setSelectedDay(day);
            CalendarView.this.setMonthDisplayed(day);
        }

        public boolean onTouch(View v, MotionEvent event) {
            if (CalendarView.this.mListView.isEnabled() && this.mGestureDetector.onTouchEvent(event)) {
                WeekView weekView = (WeekView)v;
                if (!weekView.getDayFromLocation(event.getX(), CalendarView.this.mTempDate)) {
                    return true;
                }
                if (CalendarView.this.mTempDate.before(CalendarView.this.mMinDate) || CalendarView.this.mTempDate.after(CalendarView.this.mMaxDate)) {
                    return true;
                }
                this.onDateTapped(CalendarView.this.mTempDate);
                return true;
            }
            return false;
        }

        public void setFocusMonth(int month) {
            if (this.mFocusedMonth == month) {
                return;
            }
            this.mFocusedMonth = month;
            this.notifyDataSetChanged();
        }

        public void setSelectedDay(Calendar selectedDay) {
            if (selectedDay.get(6) == this.mSelectedDate.get(6) && selectedDay.get(1) == this.mSelectedDate.get(1)) {
                return;
            }
            this.mSelectedDate.setTimeInMillis(selectedDay.getTimeInMillis());
            this.mSelectedWeek = CalendarView.this.getWeeksSinceMinDate(this.mSelectedDate);
            this.mFocusedMonth = this.mSelectedDate.get(2);
            this.notifyDataSetChanged();
        }

        class CalendarGestureListener
        extends GestureDetector.SimpleOnGestureListener {
            CalendarGestureListener() {
            }

            public boolean onSingleTapUp(MotionEvent e) {
                return true;
            }
        }
    }

    private class ScrollStateRunnable
    implements Runnable {
        private int mNewState;
        private AbsListView mView;

        private ScrollStateRunnable() {
        }

        public void doScrollStateChange(AbsListView view, int scrollState) {
            this.mView = view;
            this.mNewState = scrollState;
            CalendarView.this.removeCallbacks(this);
            CalendarView.this.postDelayed(this, 40L);
        }

        @Override
        @SuppressLint(value={"NewApi"})
        public void run() {
            CalendarView.this.mCurrentScrollState = this.mNewState;
            if (this.mNewState == 0 && CalendarView.this.mPreviousScrollState != 0) {
                View child = this.mView.getChildAt(0);
                if (child == null) {
                    return;
                }
                int dist = child.getBottom() - CalendarView.this.mListScrollTopOffset;
                if (dist > CalendarView.this.mListScrollTopOffset) {
                    int y = dist - (CalendarView.this.mIsScrollingUp ? child.getHeight() : 0);
                    if (Build.VERSION.SDK_INT >= 11) {
                        this.mView.smoothScrollBy(y, 500);
                    } else {
                        this.mView.scrollBy(0, y);
                    }
                }
            }
            CalendarView.this.mPreviousScrollState = this.mNewState;
        }
    }

    public static interface OnDateChangeListener {
        public void onSelectedDayChange(CalendarView var1, int var2, int var3, int var4);
    }
}

