/*
 * Decompiled with CFR 0.152.
 */
package org.holoeverywhere.widget;

import java.util.ArrayList;
import org.holoeverywhere.widget.ExpandableListView;

public class ExpandableListPosition {
    public static final int CHILD = 1;
    public static final int GROUP = 2;
    private static final int MAX_POOL_SIZE = 5;
    private static ArrayList<ExpandableListPosition> sPool = new ArrayList(5);
    public int childPos;
    int flatListPos;
    public int groupPos;
    public int type;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ExpandableListPosition getRecycledOrCreate() {
        ExpandableListPosition elp;
        ArrayList<ExpandableListPosition> arrayList = sPool;
        synchronized (arrayList) {
            if (sPool.size() <= 0) {
                return new ExpandableListPosition();
            }
            elp = sPool.remove(0);
        }
        elp.resetState();
        return elp;
    }

    static ExpandableListPosition obtain(int type, int groupPos, int childPos, int flatListPos) {
        ExpandableListPosition elp = ExpandableListPosition.getRecycledOrCreate();
        elp.type = type;
        elp.groupPos = groupPos;
        elp.childPos = childPos;
        elp.flatListPos = flatListPos;
        return elp;
    }

    static ExpandableListPosition obtainChildPosition(int groupPosition, int childPosition) {
        return ExpandableListPosition.obtain(1, groupPosition, childPosition, 0);
    }

    static ExpandableListPosition obtainGroupPosition(int groupPosition) {
        return ExpandableListPosition.obtain(2, groupPosition, 0, 0);
    }

    static ExpandableListPosition obtainPosition(long packedPosition) {
        if (packedPosition == 0xFFFFFFFFL) {
            return null;
        }
        ExpandableListPosition elp = ExpandableListPosition.getRecycledOrCreate();
        elp.groupPos = ExpandableListView.getPackedPositionGroup(packedPosition);
        if (ExpandableListView.getPackedPositionType(packedPosition) == 1) {
            elp.type = 1;
            elp.childPos = ExpandableListView.getPackedPositionChild(packedPosition);
        } else {
            elp.type = 2;
        }
        return elp;
    }

    private ExpandableListPosition() {
    }

    long getPackedPosition() {
        if (this.type == 1) {
            return ExpandableListView.getPackedPositionForChild(this.groupPos, this.childPos);
        }
        return ExpandableListView.getPackedPositionForGroup(this.groupPos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recycle() {
        ArrayList<ExpandableListPosition> arrayList = sPool;
        synchronized (arrayList) {
            if (sPool.size() < 5) {
                sPool.add(this);
            }
        }
    }

    private void resetState() {
        this.groupPos = 0;
        this.childPos = 0;
        this.flatListPos = 0;
        this.type = 0;
    }
}

