/*
 * Decompiled with CFR 0.152.
 */
package org.holoeverywhere.widget;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Rect;
import android.os.Build;
import android.support.v4.util.LongSparseArray;
import android.util.AttributeSet;
import android.util.SparseBooleanArray;
import android.view.ContextMenu;
import android.view.KeyEvent;
import android.view.View;
import android.view.ViewDebug;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.widget.AbsListView;
import android.widget.AdapterView;
import android.widget.Checkable;
import android.widget.ListAdapter;
import com.actionbarsherlock.internal.view.menu.ContextMenuBuilder;
import com.actionbarsherlock.view.ActionMode;
import com.actionbarsherlock.view.Menu;
import com.actionbarsherlock.view.MenuItem;
import java.util.ArrayList;
import java.util.List;
import org.holoeverywhere.HoloEverywhere;
import org.holoeverywhere.IHoloActivity;
import org.holoeverywhere.app.Activity;
import org.holoeverywhere.widget.HeaderViewListAdapter;
import org.holoeverywhere.widget.ListAdapterWrapper;
import org.holoeverywhere.widget.ListView;

public class GridView
extends android.widget.GridView
implements IHoloActivity.OnWindowFocusChangeListener,
ContextMenuBuilder.ContextMenuInfoGetter,
ListAdapterWrapper.ListAdapterCallback {
    public static final int CHOICE_MODE_MULTIPLE_MODAL = 3;
    private static final boolean USE_ACTIVATED = Build.VERSION.SDK_INT >= 11;
    private Activity mActivity;
    private ListAdapterWrapper mAdapter;
    private boolean mAdapterHasStableIds;
    private LongSparseArray<Integer> mCheckedIdStates;
    private int mCheckedItemCount;
    private SparseBooleanArray mCheckStates;
    private ActionMode mChoiceActionMode;
    private int mChoiceMode;
    private ContextMenu.ContextMenuInfo mContextMenuInfo;
    private boolean mEnableModalBackgroundWrapper;
    private boolean mFastScrollEnabled;
    private final List<HeaderViewListAdapter.ViewInfo> mFooterViewInfos = new ArrayList<HeaderViewListAdapter.ViewInfo>();
    private final List<HeaderViewListAdapter.ViewInfo> mHeaderViewInfos = new ArrayList<HeaderViewListAdapter.ViewInfo>();
    private boolean mForceHeaderListAdapter = false;
    private boolean mIsAttached;
    private int mLastScrollState = 0;
    private MultiChoiceModeWrapper mMultiChoiceModeCallback;
    private final OnItemLongClickListenerWrapper mOnItemLongClickListenerWrapper;
    private AbsListView.OnScrollListener mOnScrollListener;

    public GridView(Context context) {
        this(context, null);
    }

    public GridView(Context context, AttributeSet attrs) {
        this(context, attrs, 0x1010071);
    }

    @SuppressLint(value={"NewApi"})
    public GridView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        if (context instanceof Activity) {
            this.setActivity((Activity)context);
        }
        if (HoloEverywhere.DISABLE_OVERSCROLL_EFFECT && Build.VERSION.SDK_INT >= 9) {
            this.setOverScrollMode(2);
        }
        this.mOnItemLongClickListenerWrapper = new OnItemLongClickListenerWrapper();
        super.setOnItemLongClickListener((AdapterView.OnItemLongClickListener)this.mOnItemLongClickListenerWrapper);
        this.setLongClickable(false);
    }

    public void addFooterView(View v) {
        this.addFooterView(v, null, true);
    }

    public void addFooterView(View v, Object data, boolean isSelectable) {
        if (this.mAdapter != null && !(this.mAdapter instanceof HeaderViewListAdapter)) {
            throw new IllegalStateException("Cannot add footer view to list -- setAdapter has already been called.");
        }
        HeaderViewListAdapter.ViewInfo info = new HeaderViewListAdapter.ViewInfo();
        info.view = v;
        info.data = data;
        info.isSelectable = isSelectable;
        this.mFooterViewInfos.add(info);
        if (this.mAdapter != null) {
            this.invalidateViews();
        }
    }

    public void addHeaderView(View v) {
        this.addHeaderView(v, null, true);
    }

    public void addHeaderView(View v, Object data, boolean isSelectable) {
        if (this.mAdapter != null && !(this.mAdapter instanceof HeaderViewListAdapter)) {
            throw new IllegalStateException("Cannot add header view to list -- setAdapter has already been called.");
        }
        HeaderViewListAdapter.ViewInfo info = new HeaderViewListAdapter.ViewInfo();
        info.view = v;
        info.data = data;
        info.isSelectable = isSelectable;
        this.mHeaderViewInfos.add(info);
        if (this.mAdapter != null) {
            this.invalidateViews();
        }
    }

    public void clearChoices() {
        if (this.mCheckStates != null) {
            this.mCheckStates.clear();
        }
        if (this.mCheckedIdStates != null) {
            this.mCheckedIdStates.clear();
        }
        this.mCheckedItemCount = 0;
    }

    protected ContextMenu.ContextMenuInfo createContextMenuInfo(View view, int position, long id2) {
        return new AdapterView.AdapterContextMenuInfo(view, position, id2);
    }

    public Activity getActivity() {
        return this.mActivity;
    }

    public int getCheckedItemCount() {
        return this.mCheckedItemCount;
    }

    public long[] getCheckedItemIds() {
        if (this.mChoiceMode == 0 || this.mCheckedIdStates == null || this.mAdapter == null) {
            return new long[0];
        }
        LongSparseArray<Integer> idStates = this.mCheckedIdStates;
        int count = idStates.size();
        long[] ids = new long[count];
        for (int i = 0; i < count; ++i) {
            ids[i] = idStates.keyAt(i);
        }
        return ids;
    }

    public int getCheckedItemPosition() {
        if (this.mChoiceMode == 1 && this.mCheckStates != null && this.mCheckStates.size() == 1) {
            return this.mCheckStates.keyAt(0);
        }
        return -1;
    }

    public SparseBooleanArray getCheckedItemPositions() {
        if (this.mChoiceMode != 0) {
            return this.mCheckStates;
        }
        return null;
    }

    @Deprecated
    public long[] getCheckItemIds() {
        return this.getCheckedItemIds();
    }

    public int getChoiceMode() {
        return this.mChoiceMode;
    }

    @Override
    public ContextMenu.ContextMenuInfo getContextMenuInfo() {
        return this.mContextMenuInfo;
    }

    public int getFooterViewsCount() {
        return this.mFooterViewInfos.size();
    }

    public int getHeaderViewsCount() {
        return this.mHeaderViewInfos.size();
    }

    public boolean isAttached() {
        return this.mIsAttached;
    }

    @ViewDebug.ExportedProperty
    public boolean isFastScrollEnabled() {
        return this.mFastScrollEnabled;
    }

    public boolean isForceHeaderListAdapter() {
        return this.mForceHeaderListAdapter;
    }

    public boolean isInScrollingContainer() {
        for (ViewParent p = this.getParent(); p != null && p instanceof ViewGroup; p = p.getParent()) {
            if (!((ViewGroup)p).shouldDelayChildPressedState()) continue;
            return true;
        }
        return false;
    }

    public boolean isItemChecked(int position) {
        if (this.mChoiceMode != 0 && this.mCheckStates != null) {
            return this.mCheckStates.get(position);
        }
        return false;
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.mIsAttached = true;
    }

    @Override
    public void onChanged() {
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.mIsAttached = false;
    }

    protected void onFocusChanged(boolean gainFocus, int direction, Rect previouslyFocusedRect) {
        super.onFocusChanged(gainFocus, direction, previouslyFocusedRect);
        if (gainFocus && this.getSelectedItemPosition() < 0 && !this.isInTouchMode() && !this.mIsAttached && this.mAdapter != null) {
            this.invalidateViews();
        }
    }

    @Override
    public void onInvalidated() {
    }

    public boolean onKeyUp(int keyCode, KeyEvent event) {
        switch (keyCode) {
            case 23: 
            case 66: {
                if (!this.isEnabled()) {
                    return true;
                }
                if (!this.isClickable() || !this.isPressed() || this.getSelectedItemPosition() < 0 || this.mAdapter == null || this.getSelectedItemPosition() >= this.mAdapter.getCount()) break;
                View view = this.getChildAt(this.getSelectedItemPosition() - this.getFirstVisiblePosition());
                if (view != null) {
                    this.performItemClick(view, this.getSelectedItemPosition(), this.getSelectedItemId());
                    view.setPressed(false);
                }
                this.setPressed(false);
                return true;
            }
        }
        return super.onKeyUp(keyCode, event);
    }

    @Override
    public View onPrepareView(View view, int position) {
        if (this.mCheckStates != null) {
            this.setStateOnView(view, this.mCheckStates.get(position));
        } else {
            this.setStateOnView(view, false);
        }
        return view;
    }

    @Override
    public void onWindowFocusChanged(boolean hasWindowFocus) {
        super.onWindowFocusChanged(hasWindowFocus);
        if (hasWindowFocus) {
            this.invalidate();
            this.invalidateViews();
        }
    }

    public boolean performItemClick(View view, int position, long id2) {
        boolean handled = false;
        boolean dispatchItemClick = true;
        if (this.mChoiceMode != 0) {
            handled = true;
            boolean checkedStateChanged = false;
            if (this.mChoiceMode == 2 || this.mChoiceMode == 3 && this.mChoiceActionMode != null) {
                boolean newValue = !this.mCheckStates.get(position, false);
                this.mCheckStates.put(position, newValue);
                if (this.mCheckedIdStates != null && this.mAdapter.hasStableIds()) {
                    if (newValue) {
                        this.mCheckedIdStates.put(this.mAdapter.getItemId(position), (Object)position);
                    } else {
                        this.mCheckedIdStates.delete(this.mAdapter.getItemId(position));
                    }
                }
                this.mCheckedItemCount = newValue ? ++this.mCheckedItemCount : --this.mCheckedItemCount;
                if (this.mChoiceActionMode != null) {
                    this.mMultiChoiceModeCallback.onItemCheckedStateChanged(this.mChoiceActionMode, position, id2, newValue);
                    dispatchItemClick = false;
                }
                checkedStateChanged = true;
            } else if (this.mChoiceMode == 1) {
                boolean newValue;
                boolean bl = newValue = !this.mCheckStates.get(position, false);
                if (newValue) {
                    this.mCheckStates.clear();
                    this.mCheckStates.put(position, true);
                    if (this.mCheckedIdStates != null && this.mAdapter.hasStableIds()) {
                        this.mCheckedIdStates.clear();
                        this.mCheckedIdStates.put(this.mAdapter.getItemId(position), (Object)position);
                    }
                    this.mCheckedItemCount = 1;
                } else if (this.mCheckStates.size() == 0 || !this.mCheckStates.valueAt(0)) {
                    this.mCheckedItemCount = 0;
                }
                checkedStateChanged = true;
            }
            if (checkedStateChanged) {
                this.updateOnScreenCheckedViews();
            }
        }
        if (dispatchItemClick) {
            handled |= super.performItemClick(view, position, id2);
        }
        return handled;
    }

    public boolean performItemLongClick(View child, int longPressPosition, long longPressId) {
        if (this.mChoiceMode == 3) {
            if (this.mChoiceActionMode == null && (this.mChoiceActionMode = this.startActionMode(this.mMultiChoiceModeCallback)) != null) {
                this.setItemChecked(longPressPosition, true);
                this.performHapticFeedback(0);
            }
            return true;
        }
        boolean handled = false;
        if (this.mOnItemLongClickListenerWrapper.wrapped != null) {
            handled = this.mOnItemLongClickListenerWrapper.wrapped.onItemLongClick((AdapterView)this, child, longPressPosition, longPressId);
        }
        if (!handled) {
            this.mContextMenuInfo = this.createContextMenuInfo(child, longPressPosition, longPressId);
            handled = super.showContextMenuForChild((View)this);
        }
        if (handled) {
            this.performHapticFeedback(0);
        }
        return handled;
    }

    public boolean removeFooterView(View v) {
        if (this.mFooterViewInfos.size() > 0) {
            boolean result = false;
            if (this.mAdapter != null && ((HeaderViewListAdapter)this.mAdapter).removeFooter(v)) {
                this.invalidateViews();
                result = true;
            }
            this.removeViewInfo(v, this.mFooterViewInfos);
            return result;
        }
        return false;
    }

    public boolean removeHeaderView(View v) {
        if (this.mHeaderViewInfos.size() > 0) {
            boolean result = false;
            if (this.mAdapter != null && ((HeaderViewListAdapter)this.mAdapter).removeHeader(v)) {
                this.invalidateViews();
                result = true;
            }
            this.removeViewInfo(v, this.mHeaderViewInfos);
            return result;
        }
        return false;
    }

    private void removeViewInfo(View v, List<HeaderViewListAdapter.ViewInfo> where) {
        int len = where.size();
        for (int i = 0; i < len; ++i) {
            HeaderViewListAdapter.ViewInfo info = where.get(i);
            if (info.view != v) continue;
            where.remove(i);
            break;
        }
    }

    protected void reportScrollStateChange(int newState) {
        if (newState != this.mLastScrollState && this.mOnScrollListener != null) {
            this.mLastScrollState = newState;
            this.mOnScrollListener.onScrollStateChanged((AbsListView)this, newState);
        }
    }

    public final void setActivity(Activity activity) {
        this.mActivity = activity;
        if (this.mActivity != null) {
            this.mActivity.addOnWindowFocusChangeListener(this);
        }
    }

    public void setAdapter(ListAdapter adapter) {
        this.mAdapter = adapter == null ? null : (this.mForceHeaderListAdapter || this.mHeaderViewInfos.size() > 0 || this.mFooterViewInfos.size() > 0 ? new HeaderViewListAdapter(this.mHeaderViewInfos, this.mFooterViewInfos, adapter, this) : new ListAdapterWrapper(adapter, this));
        if (this.mAdapter != null) {
            this.mAdapterHasStableIds = this.mAdapter.hasStableIds();
            if (this.mChoiceMode != 0 && this.mAdapterHasStableIds && this.mCheckedIdStates == null) {
                this.mCheckedIdStates = new LongSparseArray();
            }
        }
        if (this.mCheckStates != null) {
            this.mCheckStates.clear();
        }
        if (this.mCheckedIdStates != null) {
            this.mCheckedIdStates.clear();
        }
        super.setAdapter((ListAdapter)this.mAdapter);
    }

    public void setChoiceMode(int choiceMode) {
        this.mChoiceMode = choiceMode;
        if (this.mChoiceActionMode != null) {
            this.mChoiceActionMode.finish();
            this.mChoiceActionMode = null;
        }
        if (this.mChoiceMode != 0) {
            if (this.mCheckStates == null) {
                this.mCheckStates = new SparseBooleanArray();
            }
            if (this.mCheckedIdStates == null && this.mAdapter != null && this.mAdapter.hasStableIds()) {
                this.mCheckedIdStates = new LongSparseArray();
            }
            if (this.mChoiceMode == 3) {
                this.clearChoices();
                this.setLongClickable(true);
                this.setEnableModalBackgroundWrapper(true);
            }
        }
    }

    public void setEnableModalBackgroundWrapper(boolean enableModalBackgroundWrapper) {
        if (enableModalBackgroundWrapper == this.mEnableModalBackgroundWrapper) {
            return;
        }
        this.mEnableModalBackgroundWrapper = enableModalBackgroundWrapper;
        if (this.mAdapter != null) {
            this.mAdapter.notifyDataSetChanged();
        }
    }

    public void setForceHeaderListAdapter(boolean forceHeaderListAdapter) {
        this.mForceHeaderListAdapter = forceHeaderListAdapter;
    }

    public void setItemChecked(int position, boolean value) {
        if (this.mChoiceMode == 0) {
            return;
        }
        if (value && this.mChoiceMode == 3 && this.mChoiceActionMode == null) {
            this.mChoiceActionMode = this.startActionMode(this.mMultiChoiceModeCallback);
        }
        if (this.mChoiceMode == 2 || this.mChoiceMode == 3) {
            boolean oldValue = this.mCheckStates.get(position);
            this.mCheckStates.put(position, value);
            if (this.mCheckedIdStates != null && this.mAdapter.hasStableIds()) {
                if (value) {
                    this.mCheckedIdStates.put(this.mAdapter.getItemId(position), (Object)position);
                } else {
                    this.mCheckedIdStates.delete(this.mAdapter.getItemId(position));
                }
            }
            if (oldValue != value) {
                this.mCheckedItemCount = value ? ++this.mCheckedItemCount : --this.mCheckedItemCount;
            }
            if (this.mChoiceActionMode != null) {
                long id2 = this.mAdapter.getItemId(position);
                this.mMultiChoiceModeCallback.onItemCheckedStateChanged(this.mChoiceActionMode, position, id2, value);
            }
        } else {
            boolean updateIds;
            boolean bl = updateIds = this.mCheckedIdStates != null && this.mAdapter.hasStableIds();
            if (value || this.isItemChecked(position)) {
                this.mCheckStates.clear();
                if (updateIds) {
                    this.mCheckedIdStates.clear();
                }
            }
            if (value) {
                this.mCheckStates.put(position, true);
                if (updateIds) {
                    this.mCheckedIdStates.put(this.mAdapter.getItemId(position), (Object)position);
                }
                this.mCheckedItemCount = 1;
            } else if (this.mCheckStates.size() == 0 || !this.mCheckStates.valueAt(0)) {
                this.mCheckedItemCount = 0;
            }
        }
        this.updateOnScreenCheckedViews();
        this.invalidateViews();
    }

    public void setMultiChoiceModeListener(ListView.MultiChoiceModeListener listener) {
        if (this.mMultiChoiceModeCallback == null) {
            this.mMultiChoiceModeCallback = new MultiChoiceModeWrapper();
        }
        this.mMultiChoiceModeCallback.setWrapped(listener);
    }

    public void setOnItemLongClickListener(AdapterView.OnItemLongClickListener listener) {
        this.mOnItemLongClickListenerWrapper.setWrapped(listener);
    }

    public void setOnScrollListener(AbsListView.OnScrollListener l) {
        this.mOnScrollListener = l;
        super.setOnScrollListener(this.mOnScrollListener);
    }

    protected final void setStateOnView(View child, boolean value) {
        if (child instanceof Checkable) {
            ((Checkable)child).setChecked(value);
        } else if (USE_ACTIVATED) {
            child.setActivated(value);
        }
    }

    public boolean showContextMenuForChild(View originalView) {
        int longPressPosition = this.getPositionForView(originalView);
        if (longPressPosition >= 0) {
            long longPressId = this.mAdapter.getItemId(longPressPosition);
            boolean handled = false;
            if (this.mOnItemLongClickListenerWrapper.wrapped != null) {
                handled = this.mOnItemLongClickListenerWrapper.wrapped.onItemLongClick((AdapterView)this, originalView, longPressPosition, longPressId);
            }
            if (!handled) {
                this.mContextMenuInfo = this.createContextMenuInfo(this.getChildAt(longPressPosition - this.getFirstVisiblePosition()), longPressPosition, longPressId);
                handled = super.showContextMenuForChild(originalView);
            }
            return handled;
        }
        return false;
    }

    public ActionMode startActionMode(ActionMode.Callback callback) {
        if (this.mActivity != null) {
            return this.mActivity.startActionMode(callback);
        }
        throw new RuntimeException("HoloEverywhere.ListView (" + this + ") don't have reference on Activity");
    }

    private void updateOnScreenCheckedViews() {
        if (this.mCheckStates == null) {
            return;
        }
        int firstPos = this.getFirstVisiblePosition();
        int count = this.getChildCount();
        for (int i = 0; i < count; ++i) {
            View child = this.getChildAt(i);
            int position = firstPos + i;
            boolean value = this.mCheckStates.get(position);
            this.setStateOnView(child, value);
        }
    }

    private final class OnItemLongClickListenerWrapper
    implements AdapterView.OnItemLongClickListener {
        private AdapterView.OnItemLongClickListener wrapped;

        private OnItemLongClickListenerWrapper() {
        }

        public boolean onItemLongClick(AdapterView<?> adapterView, View view, int position, long id2) {
            return GridView.this.performItemLongClick(view, position, id2);
        }

        public void setWrapped(AdapterView.OnItemLongClickListener wrapped) {
            this.wrapped = wrapped;
            if (wrapped != null) {
                GridView.this.setLongClickable(true);
            }
        }
    }

    private final class MultiChoiceModeWrapper
    implements ListView.MultiChoiceModeListener {
        private ListView.MultiChoiceModeListener mWrapped;

        private MultiChoiceModeWrapper() {
        }

        @Override
        public boolean onActionItemClicked(ActionMode mode, MenuItem item) {
            return this.mWrapped.onActionItemClicked(mode, item);
        }

        @Override
        public boolean onCreateActionMode(ActionMode mode, Menu menu) {
            if (this.mWrapped.onCreateActionMode(mode, menu)) {
                GridView.this.setLongClickable(false);
                return true;
            }
            return false;
        }

        @Override
        public void onDestroyActionMode(ActionMode mode) {
            this.mWrapped.onDestroyActionMode(mode);
            GridView.this.mChoiceActionMode = null;
            GridView.this.clearChoices();
            GridView.this.invalidateViews();
            GridView.this.setLongClickable(true);
        }

        @Override
        public void onItemCheckedStateChanged(ActionMode mode, int position, long id2, boolean checked) {
            this.mWrapped.onItemCheckedStateChanged(mode, position, id2, checked);
            if (GridView.this.getCheckedItemCount() == 0) {
                mode.finish();
            }
        }

        @Override
        public boolean onPrepareActionMode(ActionMode mode, Menu menu) {
            return this.mWrapped.onPrepareActionMode(mode, menu);
        }

        public void setWrapped(ListView.MultiChoiceModeListener wrapped) {
            this.mWrapped = wrapped;
        }
    }
}

