/*
 * Decompiled with CFR 0.152.
 */
package org.holoeverywhere.widget;

import android.database.DataSetObserver;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ListAdapter;
import android.widget.WrapperListAdapter;

public class ListAdapterWrapper
implements WrapperListAdapter {
    private final ListAdapterCallback mCallback;
    private DataSetObserver mLastDataSetObserver;
    private final ListAdapter mWrapped;

    public ListAdapterWrapper(ListAdapter wrapped) {
        this(wrapped, null);
    }

    public ListAdapterWrapper(ListAdapter wrapped, ListAdapterCallback callback) {
        this.mWrapped = wrapped;
        this.mCallback = callback;
    }

    public boolean areAllItemsEnabled() {
        return this.mWrapped.areAllItemsEnabled();
    }

    public int getCount() {
        return this.mWrapped.getCount();
    }

    public Object getItem(int position) {
        return this.mWrapped.getItem(position);
    }

    public long getItemId(int position) {
        return this.mWrapped.getItemId(position);
    }

    public int getItemViewType(int position) {
        return this.mWrapped.getItemViewType(position);
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        return this.onPrepareView(this.mWrapped.getView(position, convertView, parent), position);
    }

    public int getViewTypeCount() {
        return this.mWrapped.getViewTypeCount();
    }

    public ListAdapter getWrappedAdapter() {
        return this.mWrapped;
    }

    public boolean hasStableIds() {
        return this.mWrapped.hasStableIds();
    }

    public boolean isEmpty() {
        return this.mWrapped.isEmpty();
    }

    public boolean isEnabled(int position) {
        return this.mWrapped.isEnabled(position);
    }

    public void notifyDataSetChanged() {
        if (this.mLastDataSetObserver != null) {
            this.mLastDataSetObserver.onChanged();
        }
    }

    public View onPrepareView(View view, int position) {
        if (this.mCallback != null) {
            return this.mCallback.onPrepareView(view, position);
        }
        return view;
    }

    public void registerDataSetObserver(DataSetObserver dataSetObserver) {
        this.mLastDataSetObserver = new WrapperDataSetObserver(dataSetObserver);
        this.mWrapped.registerDataSetObserver(this.mLastDataSetObserver);
    }

    public void unregisterDataSetObserver(DataSetObserver dataSetObserver) {
        this.mWrapped.unregisterDataSetObserver(this.mLastDataSetObserver);
        this.mLastDataSetObserver = null;
    }

    private final class WrapperDataSetObserver
    extends DataSetObserver {
        private DataSetObserver mDataSetObserver;

        public WrapperDataSetObserver(DataSetObserver dataSetObserver) {
            this.mDataSetObserver = dataSetObserver;
        }

        public void onChanged() {
            this.mDataSetObserver.onChanged();
            if (ListAdapterWrapper.this.mCallback != null) {
                ListAdapterWrapper.this.mCallback.onChanged();
            }
        }

        public void onInvalidated() {
            this.mDataSetObserver.onInvalidated();
            if (ListAdapterWrapper.this.mCallback != null) {
                ListAdapterWrapper.this.mCallback.onInvalidated();
            }
        }
    }

    public static interface ListAdapterCallback {
        public void onChanged();

        public void onInvalidated();

        public View onPrepareView(View var1, int var2);
    }
}

