/*
 * Decompiled with CFR 0.152.
 */
package org.holoeverywhere.widget;

import android.annotation.SuppressLint;
import android.content.Context;
import android.text.Editable;
import android.text.Spannable;
import android.text.SpannableString;
import android.text.Spanned;
import android.text.TextUtils;
import android.text.method.QwertyKeyListener;
import android.util.AttributeSet;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityNodeInfo;
import android.widget.Filter;
import org.holoeverywhere.widget.AutoCompleteTextView;

public class MultiAutoCompleteTextView
extends AutoCompleteTextView {
    private Tokenizer mTokenizer;

    public MultiAutoCompleteTextView(Context context) {
        super(context);
    }

    public MultiAutoCompleteTextView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public MultiAutoCompleteTextView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    @Override
    public boolean enoughToFilter() {
        Editable text = this.getText();
        int end = this.getSelectionEnd();
        if (end < 0 || this.mTokenizer == null) {
            return false;
        }
        int start = this.mTokenizer.findTokenStart((CharSequence)text, end);
        return end - start >= this.getThreshold();
    }

    public void onInitializeAccessibilityEvent(AccessibilityEvent event) {
        super.onInitializeAccessibilityEvent(event);
        event.setClassName((CharSequence)MultiAutoCompleteTextView.class.getName());
    }

    @SuppressLint(value={"NewApi"})
    public void onInitializeAccessibilityNodeInfo(AccessibilityNodeInfo info) {
        super.onInitializeAccessibilityNodeInfo(info);
        info.setClassName((CharSequence)MultiAutoCompleteTextView.class.getName());
    }

    @Override
    protected void onLoadEntries(CharSequence[] entries) {
        super.onLoadEntries(entries);
        if (this.mTokenizer == null) {
            this.setTokenizer(new CommaTokenizer());
        }
    }

    @Override
    protected void performFiltering(CharSequence text, int keyCode) {
        if (this.enoughToFilter()) {
            int end = this.getSelectionEnd();
            int start = this.mTokenizer.findTokenStart(text, end);
            this.performFiltering(text, start, end, keyCode);
        } else {
            this.dismissDropDown();
            Filter f = this.getFilter();
            if (f != null) {
                f.filter(null);
            }
        }
    }

    protected void performFiltering(CharSequence text, int start, int end, int keyCode) {
        this.getFilter().filter(text.subSequence(start, end), (Filter.FilterListener)this);
    }

    @Override
    public void performValidation() {
        AutoCompleteTextView.Validator v = this.getValidator();
        if (v == null || this.mTokenizer == null) {
            return;
        }
        Editable e = this.getText();
        int i = this.getText().length();
        while (i > 0) {
            int end;
            int start = this.mTokenizer.findTokenStart((CharSequence)e, i);
            CharSequence sub = e.subSequence(start, end = this.mTokenizer.findTokenEnd((CharSequence)e, start));
            if (TextUtils.isEmpty((CharSequence)sub)) {
                e.replace(start, i, (CharSequence)"");
            } else if (!v.isValid(sub)) {
                e.replace(start, i, this.mTokenizer.terminateToken(v.fixText(sub)));
            }
            i = start;
        }
    }

    @Override
    protected void replaceText(CharSequence text) {
        this.clearComposingText();
        int end = this.getSelectionEnd();
        int start = this.mTokenizer.findTokenStart((CharSequence)this.getText(), end);
        Editable editable = this.getText();
        String original = TextUtils.substring((CharSequence)editable, (int)start, (int)end);
        QwertyKeyListener.markAsReplaced((Spannable)editable, (int)start, (int)end, (String)original);
        editable.replace(start, end, this.mTokenizer.terminateToken(text));
    }

    public void setTokenizer(Tokenizer t) {
        this.mTokenizer = t;
    }

    public static interface Tokenizer {
        public int findTokenEnd(CharSequence var1, int var2);

        public int findTokenStart(CharSequence var1, int var2);

        public CharSequence terminateToken(CharSequence var1);
    }

    public static class CommaTokenizer
    implements Tokenizer {
        @Override
        public int findTokenEnd(CharSequence text, int cursor) {
            int len = text.length();
            for (int i = cursor; i < len; ++i) {
                if (text.charAt(i) != ',') continue;
                return i;
            }
            return len;
        }

        @Override
        public int findTokenStart(CharSequence text, int cursor) {
            int i;
            for (i = cursor; i > 0 && text.charAt(i - 1) != ','; --i) {
            }
            while (i < cursor && text.charAt(i) == ' ') {
                ++i;
            }
            return i;
        }

        @Override
        public CharSequence terminateToken(CharSequence text) {
            int i;
            for (i = text.length(); i > 0 && text.charAt(i - 1) == ' '; --i) {
            }
            if (i > 0 && text.charAt(i - 1) == ',') {
                return text;
            }
            if (text instanceof Spanned) {
                SpannableString sp = new SpannableString((CharSequence)(text + ", "));
                TextUtils.copySpansFrom((Spanned)((Spanned)text), (int)0, (int)text.length(), Object.class, (Spannable)sp, (int)0);
                return sp;
            }
            return text + ", ";
        }
    }
}

