/*
 * Decompiled with CFR 0.152.
 */
package org.holoeverywhere.widget;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.IBinder;
import android.util.AttributeSet;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.WindowManager;
import android.widget.FrameLayout;
import java.lang.ref.WeakReference;
import org.holoeverywhere.R;
import org.holoeverywhere.drawable.DrawableCompat;
import org.holoeverywhere.drawable.StateListDrawable;
import org.holoeverywhere.widget.FrameLayout;

public class PopupWindow {
    private static final int[] ABOVE_ANCHOR_STATE_SET = new int[]{0x10100AA};
    public static final int INPUT_METHOD_FROM_FOCUSABLE = 0;
    public static final int INPUT_METHOD_NEEDED = 1;
    public static final int INPUT_METHOD_NOT_NEEDED = 2;
    private boolean mAboveAnchor;
    private Drawable mAboveAnchorBackgroundDrawable;
    private boolean mAllowScrollingAnchorParent = true;
    private WeakReference<View> mAnchor;
    private int mAnchorXoff;
    private int mAnchorYoff;
    private int mAnimationStyle = -1;
    private Drawable mBackground;
    private Drawable mBelowAnchorBackgroundDrawable;
    private boolean mClippingEnabled = true;
    private boolean mClipToScreen;
    private View mContentView;
    private Context mContext;
    private int[] mDrawingLocation = new int[2];
    private boolean mFocusable;
    private int mHeight;
    private int mHeightMode;
    private boolean mIgnoreCheekPress = false;
    private int mInputMethodMode = 0;
    private boolean mIsDropdown;
    private boolean mIsShowing;
    private int mLastHeight;
    private int mLastWidth;
    private boolean mLayoutInScreen;
    private boolean mLayoutInsetDecor = false;
    private boolean mNotTouchModal;
    private OnDismissListener mOnDismissListener;
    private ViewTreeObserver.OnScrollChangedListener mOnScrollChangedListener = new ViewTreeObserver.OnScrollChangedListener(){

        public void onScrollChanged() {
            View anchor;
            View view = anchor = PopupWindow.this.mAnchor != null ? (View)PopupWindow.this.mAnchor.get() : null;
            if (anchor != null && PopupWindow.this.mPopupView != null) {
                WindowManager.LayoutParams p = (WindowManager.LayoutParams)PopupWindow.this.mPopupView.getLayoutParams();
                PopupWindow.this.updateAboveAnchor(PopupWindow.this.findDropDownPosition(anchor, p, PopupWindow.this.mAnchorXoff, PopupWindow.this.mAnchorYoff));
                PopupWindow.this.update(p.x, p.y, -1, -1, true);
            }
        }
    };
    private boolean mOutsideTouchable = false;
    private int mPopupHeight;
    private View mPopupView;
    private int mPopupWidth;
    private int[] mScreenLocation = new int[2];
    private int mSoftInputMode = 1;
    private int mSplitTouchEnabled = -1;
    private Rect mTempRect = new Rect();
    private boolean mTouchable = true;
    private View.OnTouchListener mTouchInterceptor;
    private int mWidth;
    private int mWidthMode;
    private int mWindowLayoutType = 1000;
    private WindowManager mWindowManager;

    public PopupWindow() {
        this(null, 0, 0);
    }

    public PopupWindow(Context context) {
        this(context, null);
    }

    public PopupWindow(Context context, AttributeSet attrs) {
        this(context, attrs, 2130772123);
    }

    public PopupWindow(Context context, AttributeSet attrs, int defStyle) {
        this(context, attrs, defStyle, 0);
    }

    public PopupWindow(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        this.mContext = context;
        this.mWindowManager = (WindowManager)context.getSystemService("window");
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.PopupWindow, defStyleAttr, defStyleRes);
        this.mBackground = DrawableCompat.getDrawable(a, 0);
        int animStyle = a.getResourceId(1, -1);
        int n = this.mAnimationStyle = animStyle == 2131558508 ? -1 : animStyle;
        if (this.mBackground instanceof StateListDrawable) {
            StateListDrawable background = (StateListDrawable)this.mBackground;
            int aboveAnchorStateIndex = background.getStateDrawableIndex(ABOVE_ANCHOR_STATE_SET);
            int count = background.getStateCount();
            int belowAnchorStateIndex = -1;
            for (int i = 0; i < count; ++i) {
                if (i == aboveAnchorStateIndex) continue;
                belowAnchorStateIndex = i;
                break;
            }
            if (aboveAnchorStateIndex != -1 && belowAnchorStateIndex != -1) {
                this.mAboveAnchorBackgroundDrawable = background.getStateDrawable(aboveAnchorStateIndex);
                this.mBelowAnchorBackgroundDrawable = background.getStateDrawable(belowAnchorStateIndex);
            } else {
                this.mBelowAnchorBackgroundDrawable = null;
                this.mAboveAnchorBackgroundDrawable = null;
            }
        }
        a.recycle();
    }

    public PopupWindow(int width, int height) {
        this(null, width, height);
    }

    public PopupWindow(View contentView) {
        this(contentView, 0, 0);
    }

    public PopupWindow(View contentView, int width, int height) {
        this(contentView, width, height, false);
    }

    public PopupWindow(View contentView, int width, int height, boolean focusable) {
        if (contentView != null) {
            this.mContext = contentView.getContext();
            this.mWindowManager = (WindowManager)this.mContext.getSystemService("window");
        }
        this.setContentView(contentView);
        this.setWidth(width);
        this.setHeight(height);
        this.setFocusable(focusable);
    }

    private int computeAnimationResource() {
        if (this.mAnimationStyle == -1) {
            if (this.mIsDropdown) {
                return this.mAboveAnchor ? 2131558507 : 2131558506;
            }
            return 0;
        }
        return this.mAnimationStyle;
    }

    private int computeFlags(int curFlags) {
        curFlags &= 0xFF797DE7;
        if (this.mIgnoreCheekPress) {
            curFlags |= 0x8000;
        }
        if (!this.mFocusable) {
            curFlags |= 8;
            if (this.mInputMethodMode == 1) {
                curFlags |= 0x20000;
            }
        } else if (this.mInputMethodMode == 2) {
            curFlags |= 0x20000;
        }
        if (!this.mTouchable) {
            curFlags |= 0x10;
        }
        if (this.mOutsideTouchable) {
            curFlags |= 0x40000;
        }
        if (!this.mClippingEnabled) {
            curFlags |= 0x200;
        }
        if (this.isSplitTouchEnabled()) {
            curFlags |= 0x800000;
        }
        if (this.mLayoutInScreen) {
            curFlags |= 0x100;
        }
        if (this.mLayoutInsetDecor) {
            curFlags |= 0x10000;
        }
        if (this.mNotTouchModal) {
            curFlags |= 0x20;
        }
        return curFlags;
    }

    private WindowManager.LayoutParams createPopupLayout(IBinder token) {
        WindowManager.LayoutParams p = new WindowManager.LayoutParams();
        p.gravity = 51;
        p.width = this.mLastWidth = this.mWidth;
        p.height = this.mLastHeight = this.mHeight;
        p.format = this.mBackground != null ? this.mBackground.getOpacity() : -3;
        p.flags = this.computeFlags(p.flags);
        p.type = this.mWindowLayoutType;
        p.token = token;
        p.softInputMode = this.mSoftInputMode;
        p.setTitle((CharSequence)("PopupWindow:" + Integer.toHexString(this.hashCode())));
        return p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dismiss() {
        if (this.isShowing() && this.mPopupView != null) {
            this.mIsShowing = false;
            this.unregisterForScrollChanged();
            try {
                this.mWindowManager.removeViewImmediate(this.mPopupView);
            }
            finally {
                if (this.mPopupView != this.mContentView && this.mPopupView instanceof ViewGroup) {
                    ((ViewGroup)this.mPopupView).removeView(this.mContentView);
                }
                this.mPopupView = null;
                if (this.mOnDismissListener != null) {
                    this.mOnDismissListener.onDismiss();
                }
            }
        }
    }

    private boolean findDropDownPosition(View anchor, WindowManager.LayoutParams p, int xoff, int yoff) {
        int anchorHeight = anchor.getHeight();
        anchor.getLocationInWindow(this.mDrawingLocation);
        p.x = this.mDrawingLocation[0] + xoff;
        p.y = this.mDrawingLocation[1] + anchorHeight + yoff;
        boolean onTop = false;
        p.gravity = 51;
        anchor.getLocationOnScreen(this.mScreenLocation);
        Rect displayFrame = new Rect();
        anchor.getWindowVisibleDisplayFrame(displayFrame);
        int screenY = this.mScreenLocation[1] + anchorHeight + yoff;
        View root = anchor.getRootView();
        if (screenY + this.mPopupHeight > displayFrame.bottom || p.x + this.mPopupWidth - root.getWidth() > 0) {
            if (this.mAllowScrollingAnchorParent) {
                int scrollX = anchor.getScrollX();
                int scrollY = anchor.getScrollY();
                Rect r = new Rect(scrollX, scrollY, scrollX + this.mPopupWidth + xoff, scrollY + this.mPopupHeight + anchor.getHeight() + yoff);
                anchor.requestRectangleOnScreen(r, true);
            }
            anchor.getLocationInWindow(this.mDrawingLocation);
            p.x = this.mDrawingLocation[0] + xoff;
            p.y = this.mDrawingLocation[1] + anchor.getHeight() + yoff;
            anchor.getLocationOnScreen(this.mScreenLocation);
            boolean bl = onTop = displayFrame.bottom - this.mScreenLocation[1] - anchor.getHeight() - yoff < this.mScreenLocation[1] - yoff - displayFrame.top;
            if (onTop) {
                p.gravity = 83;
                p.y = root.getHeight() - this.mDrawingLocation[1] + yoff;
            } else {
                p.y = this.mDrawingLocation[1] + anchor.getHeight() + yoff;
            }
        }
        if (this.mClipToScreen) {
            int right = p.x + p.width;
            int displayFrameWidth = displayFrame.right - displayFrame.left;
            if (right > displayFrameWidth) {
                p.x -= right - displayFrameWidth;
            }
            if (p.x < displayFrame.left) {
                p.x = displayFrame.left;
                p.width = Math.min(p.width, displayFrameWidth);
            }
            if (onTop) {
                int popupTop = this.mScreenLocation[1] + yoff - this.mPopupHeight;
                if (popupTop < 0) {
                    p.y += popupTop;
                }
            } else {
                p.y = Math.max(p.y, displayFrame.top);
            }
        }
        p.gravity |= 0x10000000;
        return onTop;
    }

    public int getAnimationStyle() {
        return this.mAnimationStyle;
    }

    public Drawable getBackground() {
        return this.mBackground;
    }

    public View getContentView() {
        return this.mContentView;
    }

    public int getHeight() {
        return this.mHeight;
    }

    public int getInputMethodMode() {
        return this.mInputMethodMode;
    }

    public int getMaxAvailableHeight(View anchor) {
        return this.getMaxAvailableHeight(anchor, 0);
    }

    public int getMaxAvailableHeight(View anchor, int yOffset) {
        return this.getMaxAvailableHeight(anchor, yOffset, false);
    }

    public int getMaxAvailableHeight(View anchor, int yOffset, boolean ignoreBottomDecorations) {
        Rect displayFrame = new Rect();
        anchor.getWindowVisibleDisplayFrame(displayFrame);
        int[] anchorPos = this.mDrawingLocation;
        anchor.getLocationOnScreen(anchorPos);
        int bottomEdge = displayFrame.bottom;
        if (ignoreBottomDecorations) {
            Resources res = anchor.getContext().getResources();
            bottomEdge = res.getDisplayMetrics().heightPixels;
        }
        int distanceToBottom = bottomEdge - (anchorPos[1] + anchor.getHeight()) - yOffset;
        int distanceToTop = anchorPos[1] - displayFrame.top + yOffset;
        int returnedHeight = Math.max(distanceToBottom, distanceToTop);
        if (this.mBackground != null) {
            this.mBackground.getPadding(this.mTempRect);
            returnedHeight -= this.mTempRect.top + this.mTempRect.bottom;
        }
        return returnedHeight;
    }

    public int getSoftInputMode() {
        return this.mSoftInputMode;
    }

    public int getWidth() {
        return this.mWidth;
    }

    public int getWindowLayoutType() {
        return this.mWindowLayoutType;
    }

    private void invokePopup(WindowManager.LayoutParams p) {
        if (this.mContext != null) {
            p.packageName = this.mContext.getPackageName();
        }
        if (Build.VERSION.SDK_INT >= 14) {
            this.mPopupView.setFitsSystemWindows(this.mLayoutInsetDecor);
        }
        this.mWindowManager.addView(this.mPopupView, (ViewGroup.LayoutParams)p);
    }

    public boolean isAboveAnchor() {
        return this.mAboveAnchor;
    }

    public boolean isClippingEnabled() {
        return this.mClippingEnabled;
    }

    public boolean isFocusable() {
        return this.mFocusable;
    }

    public boolean isLayoutInScreenEnabled() {
        return this.mLayoutInScreen;
    }

    public boolean isOutsideTouchable() {
        return this.mOutsideTouchable;
    }

    public boolean isShowing() {
        return this.mIsShowing;
    }

    public boolean isSplitTouchEnabled() {
        if (this.mSplitTouchEnabled < 0 && this.mContext != null) {
            return this.mContext.getApplicationInfo().targetSdkVersion >= 11;
        }
        return this.mSplitTouchEnabled == 1;
    }

    public boolean isTouchable() {
        return this.mTouchable;
    }

    private void preparePopup(WindowManager.LayoutParams p) {
        if (this.mContentView == null || this.mContext == null || this.mWindowManager == null) {
            throw new IllegalStateException("You must specify a valid content view by calling setContentView() before attempting to show the popup.");
        }
        if (this.mBackground != null) {
            ViewGroup.LayoutParams layoutParams = this.mContentView.getLayoutParams();
            int height = -1;
            if (layoutParams != null && layoutParams.height == -2) {
                height = -2;
            }
            PopupViewContainer popupViewContainer = new PopupViewContainer(this.mContext);
            FrameLayout.LayoutParams listParams = new FrameLayout.LayoutParams(-1, height);
            popupViewContainer.setBackgroundDrawable(this.mBackground);
            popupViewContainer.addView(this.mContentView, (ViewGroup.LayoutParams)listParams);
            this.mPopupView = popupViewContainer;
        } else {
            this.mPopupView = this.mContentView;
        }
        this.mPopupWidth = p.width;
        this.mPopupHeight = p.height;
    }

    private void registerForScrollChanged(View anchor, int xoff, int yoff) {
        this.unregisterForScrollChanged();
        this.mAnchor = new WeakReference<View>(anchor);
        ViewTreeObserver vto = anchor.getViewTreeObserver();
        if (vto != null) {
            vto.addOnScrollChangedListener(this.mOnScrollChangedListener);
        }
        this.mAnchorXoff = xoff;
        this.mAnchorYoff = yoff;
    }

    void setAllowScrollingAnchorParent(boolean enabled) {
        this.mAllowScrollingAnchorParent = enabled;
    }

    public void setAnimationStyle(int animationStyle) {
        this.mAnimationStyle = animationStyle;
    }

    public void setBackgroundDrawable(Drawable background) {
        this.mBackground = background;
    }

    public void setClippingEnabled(boolean enabled) {
        this.mClippingEnabled = enabled;
    }

    public void setClipToScreenEnabled(boolean enabled) {
        this.mClipToScreen = enabled;
        this.setClippingEnabled(!enabled);
    }

    public void setContentView(View contentView) {
        if (this.isShowing()) {
            return;
        }
        this.mContentView = contentView;
        if (this.mContext == null && this.mContentView != null) {
            this.mContext = this.mContentView.getContext();
        }
        if (this.mWindowManager == null && this.mContext != null) {
            this.mWindowManager = (WindowManager)this.mContext.getSystemService("window");
        }
    }

    public void setFocusable(boolean focusable) {
        this.mFocusable = focusable;
    }

    public void setHeight(int height) {
        this.mHeight = height;
    }

    public void setIgnoreCheekPress() {
        this.mIgnoreCheekPress = true;
    }

    public void setInputMethodMode(int mode) {
        this.mInputMethodMode = mode;
    }

    public void setLayoutInScreenEnabled(boolean enabled) {
        this.mLayoutInScreen = enabled;
    }

    public void setLayoutInsetDecor(boolean enabled) {
        this.mLayoutInsetDecor = enabled;
    }

    public void setOnDismissListener(OnDismissListener onDismissListener) {
        this.mOnDismissListener = onDismissListener;
    }

    public void setOutsideTouchable(boolean touchable) {
        this.mOutsideTouchable = touchable;
    }

    public void setSoftInputMode(int mode) {
        this.mSoftInputMode = mode;
    }

    public void setSplitTouchEnabled(boolean enabled) {
        this.mSplitTouchEnabled = enabled ? 1 : 0;
    }

    public void setTouchable(boolean touchable) {
        this.mTouchable = touchable;
    }

    public void setTouchInterceptor(View.OnTouchListener l) {
        this.mTouchInterceptor = l;
    }

    public void setTouchModal(boolean touchModal) {
        this.mNotTouchModal = !touchModal;
    }

    public void setWidth(int width) {
        this.mWidth = width;
    }

    public void setWindowLayoutMode(int widthSpec, int heightSpec) {
        this.mWidthMode = widthSpec;
        this.mHeightMode = heightSpec;
    }

    public void setWindowLayoutType(int layoutType) {
        this.mWindowLayoutType = layoutType;
    }

    public void showAsDropDown(View anchor) {
        this.showAsDropDown(anchor, 0, 0);
    }

    public void showAsDropDown(View anchor, int xoff, int yoff) {
        if (this.isShowing() || this.mContentView == null) {
            return;
        }
        this.registerForScrollChanged(anchor, xoff, yoff);
        this.mIsShowing = true;
        this.mIsDropdown = true;
        WindowManager.LayoutParams p = this.createPopupLayout(anchor.getWindowToken());
        this.preparePopup(p);
        this.updateAboveAnchor(this.findDropDownPosition(anchor, p, xoff, yoff));
        if (this.mHeightMode < 0) {
            p.height = this.mLastHeight = this.mHeightMode;
        }
        if (this.mWidthMode < 0) {
            p.width = this.mLastWidth = this.mWidthMode;
        }
        p.windowAnimations = this.computeAnimationResource();
        this.invokePopup(p);
    }

    public void showAtLocation(IBinder token, int gravity, int x, int y) {
        if (this.isShowing() || this.mContentView == null) {
            return;
        }
        this.unregisterForScrollChanged();
        this.mIsShowing = true;
        this.mIsDropdown = false;
        WindowManager.LayoutParams p = this.createPopupLayout(token);
        p.windowAnimations = this.computeAnimationResource();
        this.preparePopup(p);
        if (gravity == 0) {
            gravity = 51;
        }
        p.gravity = gravity;
        p.x = x;
        p.y = y;
        if (this.mHeightMode < 0) {
            p.height = this.mLastHeight = this.mHeightMode;
        }
        if (this.mWidthMode < 0) {
            p.width = this.mLastWidth = this.mWidthMode;
        }
        this.invokePopup(p);
    }

    public void showAtLocation(View parent, int gravity, int x, int y) {
        this.showAtLocation(parent.getWindowToken(), gravity, x, y);
    }

    private void unregisterForScrollChanged() {
        WeakReference<View> anchorRef = this.mAnchor;
        View anchor = null;
        if (anchorRef != null) {
            anchor = (View)anchorRef.get();
        }
        if (anchor != null) {
            ViewTreeObserver vto = anchor.getViewTreeObserver();
            vto.removeOnScrollChangedListener(this.mOnScrollChangedListener);
        }
        this.mAnchor = null;
    }

    public void update() {
        int newFlags;
        if (!this.isShowing() || this.mContentView == null) {
            return;
        }
        WindowManager.LayoutParams p = (WindowManager.LayoutParams)this.mPopupView.getLayoutParams();
        boolean update = false;
        int newAnim = this.computeAnimationResource();
        if (newAnim != p.windowAnimations) {
            p.windowAnimations = newAnim;
            update = true;
        }
        if ((newFlags = this.computeFlags(p.flags)) != p.flags) {
            p.flags = newFlags;
            update = true;
        }
        if (update) {
            this.mWindowManager.updateViewLayout(this.mPopupView, (ViewGroup.LayoutParams)p);
        }
    }

    public void update(int width, int height) {
        WindowManager.LayoutParams p = (WindowManager.LayoutParams)this.mPopupView.getLayoutParams();
        this.update(p.x, p.y, width, height, false);
    }

    public void update(int x, int y, int width, int height) {
        this.update(x, y, width, height, false);
    }

    public void update(int x, int y, int width, int height, boolean force) {
        int newFlags;
        int newAnim;
        int finalHeight;
        int finalWidth;
        if (width != -1) {
            this.mLastWidth = width;
            this.setWidth(width);
        }
        if (height != -1) {
            this.mLastHeight = height;
            this.setHeight(height);
        }
        if (!this.isShowing() || this.mContentView == null) {
            return;
        }
        WindowManager.LayoutParams p = (WindowManager.LayoutParams)this.mPopupView.getLayoutParams();
        boolean update = force;
        int n = finalWidth = this.mWidthMode < 0 ? this.mWidthMode : this.mLastWidth;
        if (width != -1 && p.width != finalWidth) {
            p.width = this.mLastWidth = finalWidth;
            update = true;
        }
        int n2 = finalHeight = this.mHeightMode < 0 ? this.mHeightMode : this.mLastHeight;
        if (height != -1 && p.height != finalHeight) {
            p.height = this.mLastHeight = finalHeight;
            update = true;
        }
        if (p.x != x) {
            p.x = x;
            update = true;
        }
        if (p.y != y) {
            p.y = y;
            update = true;
        }
        if ((newAnim = this.computeAnimationResource()) != p.windowAnimations) {
            p.windowAnimations = newAnim;
            update = true;
        }
        if ((newFlags = this.computeFlags(p.flags)) != p.flags) {
            p.flags = newFlags;
            update = true;
        }
        if (update) {
            this.mWindowManager.updateViewLayout(this.mPopupView, (ViewGroup.LayoutParams)p);
        }
    }

    private void update(View anchor, boolean updateLocation, int xoff, int yoff, boolean updateDimension, int width, int height) {
        boolean needsUpdate;
        if (!this.isShowing() || this.mContentView == null) {
            return;
        }
        WeakReference<View> oldAnchor = this.mAnchor;
        boolean bl = needsUpdate = updateLocation && (this.mAnchorXoff != xoff || this.mAnchorYoff != yoff);
        if (oldAnchor == null || oldAnchor.get() != anchor || needsUpdate && !this.mIsDropdown) {
            this.registerForScrollChanged(anchor, xoff, yoff);
        } else if (needsUpdate) {
            this.mAnchorXoff = xoff;
            this.mAnchorYoff = yoff;
        }
        WindowManager.LayoutParams p = (WindowManager.LayoutParams)this.mPopupView.getLayoutParams();
        if (updateDimension) {
            if (width == -1) {
                width = this.mPopupWidth;
            } else {
                this.mPopupWidth = width;
            }
            if (height == -1) {
                height = this.mPopupHeight;
            } else {
                this.mPopupHeight = height;
            }
        }
        int x = p.x;
        int y = p.y;
        if (updateLocation) {
            this.updateAboveAnchor(this.findDropDownPosition(anchor, p, xoff, yoff));
        } else {
            this.updateAboveAnchor(this.findDropDownPosition(anchor, p, this.mAnchorXoff, this.mAnchorYoff));
        }
        this.update(p.x, p.y, width, height, x != p.x || y != p.y);
    }

    public void update(View anchor, int width, int height) {
        this.update(anchor, false, 0, 0, true, width, height);
    }

    public void update(View anchor, int xoff, int yoff, int width, int height) {
        this.update(anchor, true, xoff, yoff, true, width, height);
    }

    private void updateAboveAnchor(boolean aboveAnchor) {
        if (aboveAnchor != this.mAboveAnchor) {
            this.mAboveAnchor = aboveAnchor;
            if (this.mBackground != null) {
                if (this.mAboveAnchorBackgroundDrawable != null) {
                    if (this.mAboveAnchor) {
                        this.mPopupView.setBackgroundDrawable(this.mAboveAnchorBackgroundDrawable);
                    } else {
                        this.mPopupView.setBackgroundDrawable(this.mBelowAnchorBackgroundDrawable);
                    }
                } else {
                    this.mPopupView.refreshDrawableState();
                }
            }
        }
    }

    private class PopupViewContainer
    extends FrameLayout {
        public PopupViewContainer(Context context) {
            super(context);
        }

        public boolean dispatchKeyEvent(KeyEvent event) {
            if (event.getKeyCode() == 4) {
                KeyEvent.DispatcherState state;
                if (this.getKeyDispatcherState() == null) {
                    return super.dispatchKeyEvent(event);
                }
                if (event.getAction() == 0 && event.getRepeatCount() == 0) {
                    KeyEvent.DispatcherState state2 = this.getKeyDispatcherState();
                    if (state2 != null) {
                        state2.startTracking(event, (Object)this);
                    }
                    return true;
                }
                if (event.getAction() == 1 && (state = this.getKeyDispatcherState()) != null && state.isTracking(event) && !event.isCanceled()) {
                    PopupWindow.this.dismiss();
                    return true;
                }
                return super.dispatchKeyEvent(event);
            }
            return super.dispatchKeyEvent(event);
        }

        public boolean dispatchTouchEvent(MotionEvent ev) {
            if (PopupWindow.this.mTouchInterceptor != null && PopupWindow.this.mTouchInterceptor.onTouch((View)this, ev)) {
                return true;
            }
            return super.dispatchTouchEvent(ev);
        }

        protected int[] onCreateDrawableState(int extraSpace) {
            if (PopupWindow.this.mAboveAnchor) {
                int[] drawableState = super.onCreateDrawableState(extraSpace + 1);
                View.mergeDrawableStates((int[])drawableState, (int[])ABOVE_ANCHOR_STATE_SET);
                return drawableState;
            }
            return super.onCreateDrawableState(extraSpace);
        }

        public boolean onTouchEvent(MotionEvent event) {
            int x = (int)event.getX();
            int y = (int)event.getY();
            if (event.getAction() == 0 && (x < 0 || x >= this.getWidth() || y < 0 || y >= this.getHeight())) {
                PopupWindow.this.dismiss();
                return true;
            }
            if (event.getAction() == 4) {
                PopupWindow.this.dismiss();
                return true;
            }
            return super.onTouchEvent(event);
        }

        public void sendAccessibilityEvent(int eventType) {
            if (PopupWindow.this.mContentView != null) {
                PopupWindow.this.mContentView.sendAccessibilityEvent(eventType);
            } else {
                super.sendAccessibilityEvent(eventType);
            }
        }
    }

    public static interface OnDismissListener {
        public void onDismiss();
    }
}

