/*
 * Decompiled with CFR 0.152.
 */
package org.holoeverywhere.widget;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.DialogInterface;
import android.content.res.TypedArray;
import android.database.DataSetObserver;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityNodeInfo;
import android.widget.AdapterView;
import android.widget.ListAdapter;
import android.widget.SpinnerAdapter;
import org.holoeverywhere.R;
import org.holoeverywhere.app.AlertDialog;
import org.holoeverywhere.widget.AbsSpinner;
import org.holoeverywhere.widget.AdapterView;
import org.holoeverywhere.widget.ListPopupWindow;
import org.holoeverywhere.widget.PopupWindow;

public class Spinner
extends AbsSpinner
implements DialogInterface.OnClickListener {
    private static final int MAX_ITEMS_MEASURED = 15;
    public static final int MODE_DIALOG = 0;
    public static final int MODE_DROPDOWN = 1;
    private static final int MODE_THEME = -1;
    private static final String TAG = "Spinner";
    private boolean mDisableChildrenWhenDisabled;
    int mDropDownWidth;
    private int mGravity;
    private SpinnerPopup mPopup;
    private DropDownAdapter mTempAdapter;
    private Rect mTempRect = new Rect();

    public Spinner(Context context) {
        this(context, null);
    }

    public Spinner(Context context, AttributeSet attrs) {
        this(context, attrs, 2130772138);
    }

    public Spinner(Context context, AttributeSet attrs, int defStyle) {
        this(context, attrs, defStyle, -1);
    }

    public Spinner(Context context, AttributeSet attrs, int defStyle, int mode) {
        super(context, attrs, defStyle);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.Spinner, defStyle, 2131558564);
        if (mode == -1) {
            mode = a.getInt(9, 0);
        }
        switch (mode) {
            case 0: {
                this.mPopup = new DialogPopup();
                break;
            }
            case 1: {
                int horizontalOffset;
                DropdownPopup popup = new DropdownPopup(context, attrs, defStyle);
                this.mDropDownWidth = a.getLayoutDimension(4, -2);
                popup.setBackgroundDrawable(a.getDrawable(2));
                int verticalOffset = a.getDimensionPixelOffset(7, 0);
                if (verticalOffset != 0) {
                    popup.setVerticalOffset(verticalOffset);
                }
                if ((horizontalOffset = a.getDimensionPixelOffset(6, 0)) != 0) {
                    popup.setHorizontalOffset(horizontalOffset);
                }
                this.mPopup = popup;
                break;
            }
        }
        this.mGravity = a.getInt(0, 17);
        this.mPopup.setPromptText(a.getString(3));
        this.mDisableChildrenWhenDisabled = a.getBoolean(5, false);
        a.recycle();
        if (this.mTempAdapter != null) {
            this.mPopup.setAdapter(this.mTempAdapter);
            this.mTempAdapter = null;
        }
    }

    public Spinner(Context context, int mode) {
        this(context, null, 2130772138, mode);
    }

    public int getBaseline() {
        View child = null;
        if (this.getChildCount() > 0) {
            child = this.getChildAt(0);
        } else if (this.getAdapter() != null && this.getAdapter().getCount() > 0) {
            child = this.makeAndAddView(0);
            this.mRecycler.put(0, child);
            this.removeAllViewsInLayout();
        }
        if (child != null) {
            int childBaseline = child.getBaseline();
            return childBaseline >= 0 ? child.getTop() + childBaseline : -1;
        }
        return -1;
    }

    public int getDropDownHorizontalOffset() {
        return this.mPopup.getHorizontalOffset();
    }

    public int getDropDownVerticalOffset() {
        return this.mPopup.getVerticalOffset();
    }

    public int getDropDownWidth() {
        return this.mDropDownWidth;
    }

    public int getGravity() {
        return this.mGravity;
    }

    public Drawable getPopupBackground() {
        return this.mPopup.getBackground();
    }

    public CharSequence getPrompt() {
        return this.mPopup.getHintText();
    }

    public void internalSetOnItemClickListener(AdapterView.OnItemClickListener l) {
        super.setOnItemClickListener(l);
    }

    @Override
    public void layout(int delta, boolean animate) {
        int childrenLeft = this.mSpinnerPadding.left;
        int childrenWidth = this.getRight() - this.getLeft() - this.mSpinnerPadding.left - this.mSpinnerPadding.right;
        if (this.mDataChanged) {
            this.handleDataChanged();
        }
        if (this.mItemCount == 0) {
            this.resetList();
            return;
        }
        if (this.mNextSelectedPosition >= 0) {
            this.setSelectedPositionInt(this.mNextSelectedPosition);
        }
        this.recycleAllViews();
        this.removeAllViewsInLayout();
        this.mFirstPosition = this.mSelectedPosition;
        View sel = this.makeAndAddView(this.mSelectedPosition);
        int width = sel.getMeasuredWidth();
        int selectedOffset = childrenLeft;
        switch (this.mGravity & 7) {
            case 1: {
                selectedOffset = childrenLeft + childrenWidth / 2 - width / 2;
                break;
            }
            case 5: {
                selectedOffset = childrenLeft + childrenWidth - width;
            }
        }
        sel.offsetLeftAndRight(selectedOffset);
        this.mRecycler.clear();
        this.invalidate();
        this.checkSelectionChanged();
        this.mDataChanged = false;
        this.mNeedSync = false;
        this.setNextSelectedPositionInt(this.mSelectedPosition);
    }

    private View makeAndAddView(int position) {
        View child;
        if (!this.mDataChanged && (child = this.mRecycler.get(position)) != null) {
            this.setUpChild(child);
            return child;
        }
        child = this.mAdapter.getView(position, null, (ViewGroup)this);
        this.setUpChild(child);
        return child;
    }

    int measureContentWidth(SpinnerAdapter adapter, Drawable background) {
        if (adapter == null) {
            return 0;
        }
        int width = 0;
        View itemView = null;
        int itemType = 0;
        int widthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
        int heightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
        int start = Math.max(0, this.getSelectedItemPosition());
        int end = Math.min(adapter.getCount(), start + 15);
        int count = end - start;
        for (int i = start = Math.max(0, start - (15 - count)); i < end; ++i) {
            int positionType = adapter.getItemViewType(i);
            if (positionType != itemType) {
                itemType = positionType;
                itemView = null;
            }
            if ((itemView = adapter.getView(i, itemView, (ViewGroup)this)).getLayoutParams() == null) {
                itemView.setLayoutParams(new ViewGroup.LayoutParams(-2, -2));
            }
            itemView.measure(widthMeasureSpec, heightMeasureSpec);
            width = Math.max(width, itemView.getMeasuredWidth());
        }
        if (background != null) {
            background.getPadding(this.mTempRect);
            width += this.mTempRect.left + this.mTempRect.right;
        }
        return width;
    }

    public void onClick(DialogInterface dialog, int which) {
        this.setSelection(which);
        dialog.dismiss();
    }

    @Override
    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.mPopup != null && this.mPopup.isShowing()) {
            this.mPopup.dismiss();
        }
    }

    @Override
    public void onInitializeAccessibilityEvent(AccessibilityEvent event) {
        super.onInitializeAccessibilityEvent(event);
        event.setClassName((CharSequence)Spinner.class.getName());
    }

    @Override
    @SuppressLint(value={"NewApi"})
    public void onInitializeAccessibilityNodeInfo(AccessibilityNodeInfo info) {
        super.onInitializeAccessibilityNodeInfo(info);
        info.setClassName((CharSequence)Spinner.class.getName());
    }

    @Override
    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        super.onLayout(changed, l, t, r, b);
        this.layout(0, false);
    }

    @Override
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        if (this.mPopup != null && View.MeasureSpec.getMode((int)widthMeasureSpec) == Integer.MIN_VALUE) {
            int measuredWidth = this.getMeasuredWidth();
            this.setMeasuredDimension(Math.min(Math.max(measuredWidth, this.measureContentWidth(this.getAdapter(), this.getBackground())), View.MeasureSpec.getSize((int)widthMeasureSpec)), this.getMeasuredHeight());
        }
    }

    public boolean performClick() {
        boolean handled = super.performClick();
        if (!handled) {
            handled = true;
            if (!this.mPopup.isShowing()) {
                this.mPopup.show();
            }
        }
        return handled;
    }

    @Override
    public void setAdapter(SpinnerAdapter adapter) {
        super.setAdapter(adapter);
        if (this.mPopup != null) {
            this.mPopup.setAdapter(new DropDownAdapter(adapter));
        } else {
            this.mTempAdapter = new DropDownAdapter(adapter);
        }
    }

    public void setDropDownHorizontalOffset(int pixels) {
        this.mPopup.setHorizontalOffset(pixels);
    }

    public void setDropDownVerticalOffset(int pixels) {
        this.mPopup.setVerticalOffset(pixels);
    }

    public void setDropDownWidth(int pixels) {
        if (!(this.mPopup instanceof DropdownPopup)) {
            Log.e((String)TAG, (String)"Cannot set dropdown width for MODE_DIALOG, ignoring");
            return;
        }
        this.mDropDownWidth = pixels;
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (this.mDisableChildrenWhenDisabled) {
            int count = this.getChildCount();
            for (int i = 0; i < count; ++i) {
                this.getChildAt(i).setEnabled(enabled);
            }
        }
    }

    public void setGravity(int gravity) {
        if (this.mGravity != gravity) {
            if ((gravity & 7) == 0) {
                gravity |= 3;
            }
            this.mGravity = gravity;
            this.requestLayout();
        }
    }

    @Override
    public void setOnItemClickListener(AdapterView.OnItemClickListener l) {
        throw new RuntimeException("setOnItemClickListener cannot be used with a spinner.");
    }

    public void setPopupBackgroundDrawable(Drawable background) {
        if (!(this.mPopup instanceof DropdownPopup)) {
            Log.e((String)TAG, (String)"setPopupBackgroundDrawable: incompatible spinner mode; ignoring...");
            return;
        }
        ((DropdownPopup)this.mPopup).setBackgroundDrawable(background);
    }

    public void setPopupBackgroundResource(int resId) {
        this.setPopupBackgroundDrawable(this.getContext().getResources().getDrawable(resId));
    }

    public void setPrompt(CharSequence prompt) {
        this.mPopup.setPromptText(prompt);
    }

    public void setPromptId(int promptId) {
        this.setPrompt(this.getContext().getText(promptId));
    }

    private void setUpChild(View child) {
        ViewGroup.LayoutParams lp = child.getLayoutParams();
        if (lp == null) {
            lp = this.generateDefaultLayoutParams();
        }
        this.addViewInLayout(child, 0, lp);
        child.setSelected(this.hasFocus());
        if (this.mDisableChildrenWhenDisabled) {
            child.setEnabled(this.isEnabled());
        }
        int childHeightSpec = ViewGroup.getChildMeasureSpec((int)this.mHeightMeasureSpec, (int)(this.mSpinnerPadding.top + this.mSpinnerPadding.bottom), (int)lp.height);
        int childWidthSpec = ViewGroup.getChildMeasureSpec((int)this.mWidthMeasureSpec, (int)(this.mSpinnerPadding.left + this.mSpinnerPadding.right), (int)lp.width);
        child.measure(childWidthSpec, childHeightSpec);
        int childLeft = 0;
        int childTop = this.mSpinnerPadding.top + (this.getMeasuredHeight() - this.mSpinnerPadding.bottom - this.mSpinnerPadding.top - child.getMeasuredHeight()) / 2;
        int childBottom = childTop + child.getMeasuredHeight();
        int width = child.getMeasuredWidth();
        int childRight = childLeft + width;
        child.layout(childLeft, childTop, childRight, childBottom);
    }

    private static interface SpinnerPopup {
        public void dismiss();

        public Drawable getBackground();

        public CharSequence getHintText();

        public int getHorizontalOffset();

        public int getVerticalOffset();

        public boolean isShowing();

        public void setAdapter(ListAdapter var1);

        public void setBackgroundDrawable(Drawable var1);

        public void setHorizontalOffset(int var1);

        public void setPromptText(CharSequence var1);

        public void setVerticalOffset(int var1);

        public void show();
    }

    private class DropdownPopup
    extends ListPopupWindow
    implements SpinnerPopup,
    PopupWindow.OnDismissListener {
        private ListAdapter mAdapter;
        private CharSequence mHintText;
        private boolean mSelectionSetted;

        public DropdownPopup(Context context, AttributeSet attrs, int defStyle) {
            super(context, attrs, 2130772037);
            this.mSelectionSetted = false;
            this.setAnchorView((View)Spinner.this);
            this.setModal(true);
            this.setPromptPosition(0);
            this.setOnItemClickListener(new AdapterView.OnItemClickListener(){

                public void onItemClick(AdapterView<?> parent, View v, int position, long id2) {
                    Spinner.this.setSelection(position);
                    if (Spinner.this.mOnItemClickListener != null) {
                        Spinner.this.performItemClick(v, position, DropdownPopup.this.mAdapter.getItemId(position));
                    }
                    DropdownPopup.this.dismiss();
                }
            });
        }

        @Override
        public CharSequence getHintText() {
            return this.mHintText;
        }

        @Override
        public void onDismiss() {
            this.mSelectionSetted = false;
        }

        @Override
        public void setAdapter(ListAdapter adapter) {
            super.setAdapter(adapter);
            this.mAdapter = adapter;
        }

        @Override
        public void setPromptText(CharSequence hintText) {
            this.mHintText = hintText;
        }

        @Override
        public void show() {
            Drawable background = this.getBackground();
            int bgOffset = 0;
            if (background != null) {
                background.getPadding(Spinner.this.mTempRect);
                bgOffset = -((Spinner)Spinner.this).mTempRect.left;
            } else {
                ((Spinner)Spinner.this).mTempRect.right = 0;
                ((Spinner)Spinner.this).mTempRect.left = 0;
            }
            int spinnerPaddingLeft = Spinner.this.getPaddingLeft();
            if (Spinner.this.mDropDownWidth == -2) {
                int contentWidthLimit;
                int spinnerWidth = Spinner.this.getWidth();
                int spinnerPaddingRight = Spinner.this.getPaddingRight();
                int contentWidth = Spinner.this.measureContentWidth((SpinnerAdapter)this.mAdapter, this.getBackground());
                if (contentWidth > (contentWidthLimit = Spinner.this.getContext().getResources().getDisplayMetrics().widthPixels - ((Spinner)Spinner.this).mTempRect.left - ((Spinner)Spinner.this).mTempRect.right)) {
                    contentWidth = contentWidthLimit;
                }
                this.setContentWidth(Math.max(contentWidth, spinnerWidth - spinnerPaddingLeft - spinnerPaddingRight));
            } else if (Spinner.this.mDropDownWidth == -1) {
                int spinnerWidth = Spinner.this.getWidth();
                int spinnerPaddingRight = Spinner.this.getPaddingRight();
                this.setContentWidth(spinnerWidth - spinnerPaddingLeft - spinnerPaddingRight);
            } else {
                this.setContentWidth(Spinner.this.mDropDownWidth);
            }
            this.setHorizontalOffset(bgOffset + spinnerPaddingLeft);
            this.setInputMethodMode(2);
            super.show();
            this.getListView().setChoiceMode(1);
            if (!this.mSelectionSetted) {
                this.mSelectionSetted = true;
                this.setSelection(Spinner.this.getSelectedItemPosition());
            }
            this.setOnDismissListener(this);
        }
    }

    private static class DropDownAdapter
    implements ListAdapter,
    SpinnerAdapter {
        private SpinnerAdapter mAdapter;
        private ListAdapter mListAdapter;

        public DropDownAdapter(SpinnerAdapter adapter) {
            this.mAdapter = adapter;
            if (adapter instanceof ListAdapter) {
                this.mListAdapter = (ListAdapter)adapter;
            }
        }

        public boolean areAllItemsEnabled() {
            ListAdapter adapter = this.mListAdapter;
            if (adapter != null) {
                return adapter.areAllItemsEnabled();
            }
            return true;
        }

        public int getCount() {
            return this.mAdapter == null ? 0 : this.mAdapter.getCount();
        }

        public View getDropDownView(int position, View convertView, ViewGroup parent) {
            return this.mAdapter == null ? null : this.mAdapter.getDropDownView(position, convertView, parent);
        }

        public Object getItem(int position) {
            return this.mAdapter == null ? null : this.mAdapter.getItem(position);
        }

        public long getItemId(int position) {
            return this.mAdapter == null ? -1L : this.mAdapter.getItemId(position);
        }

        public int getItemViewType(int position) {
            return 0;
        }

        public View getView(int position, View convertView, ViewGroup parent) {
            return this.getDropDownView(position, convertView, parent);
        }

        public int getViewTypeCount() {
            return 1;
        }

        public boolean hasStableIds() {
            return this.mAdapter != null && this.mAdapter.hasStableIds();
        }

        public boolean isEmpty() {
            return this.getCount() == 0;
        }

        public boolean isEnabled(int position) {
            ListAdapter adapter = this.mListAdapter;
            if (adapter != null) {
                return adapter.isEnabled(position);
            }
            return true;
        }

        public void registerDataSetObserver(DataSetObserver observer) {
            if (this.mAdapter != null) {
                this.mAdapter.registerDataSetObserver(observer);
            }
        }

        public void unregisterDataSetObserver(DataSetObserver observer) {
            if (this.mAdapter != null) {
                this.mAdapter.unregisterDataSetObserver(observer);
            }
        }
    }

    private class DialogPopup
    implements SpinnerPopup,
    DialogInterface.OnClickListener {
        private ListAdapter mListAdapter;
        private AlertDialog mPopup;
        private CharSequence mPrompt;

        private DialogPopup() {
        }

        @Override
        public void dismiss() {
            this.mPopup.dismiss();
            this.mPopup = null;
        }

        @Override
        public Drawable getBackground() {
            return null;
        }

        @Override
        public CharSequence getHintText() {
            return this.mPrompt;
        }

        @Override
        public int getHorizontalOffset() {
            return 0;
        }

        @Override
        public int getVerticalOffset() {
            return 0;
        }

        @Override
        public boolean isShowing() {
            return this.mPopup != null ? this.mPopup.isShowing() : false;
        }

        public void onClick(DialogInterface dialog, int which) {
            Spinner.this.setSelection(which);
            if (Spinner.this.mOnItemClickListener != null) {
                Spinner.this.performItemClick(null, which, this.mListAdapter.getItemId(which));
            }
            this.dismiss();
        }

        @Override
        public void setAdapter(ListAdapter adapter) {
            this.mListAdapter = adapter;
        }

        @Override
        public void setBackgroundDrawable(Drawable bg) {
            Log.e((String)Spinner.TAG, (String)"Cannot set popup background for MODE_DIALOG, ignoring");
        }

        @Override
        public void setHorizontalOffset(int px) {
            Log.e((String)Spinner.TAG, (String)"Cannot set horizontal offset for MODE_DIALOG, ignoring");
        }

        @Override
        public void setPromptText(CharSequence hintText) {
            this.mPrompt = hintText;
        }

        @Override
        public void setVerticalOffset(int px) {
            Log.e((String)Spinner.TAG, (String)"Cannot set vertical offset for MODE_DIALOG, ignoring");
        }

        @Override
        public void show() {
            AlertDialog.Builder builder = new AlertDialog.Builder(Spinner.this.getContext());
            if (this.mPrompt != null) {
                builder.setTitle(this.mPrompt);
            }
            this.mPopup = builder.setSingleChoiceItems(this.mListAdapter, Spinner.this.getSelectedItemPosition(), (DialogInterface.OnClickListener)this).show();
        }
    }
}

