/*
 * Decompiled with CFR 0.152.
 */
package org.holoeverywhere.widget;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.support.v4.view.MotionEventCompat;
import android.text.Layout;
import android.text.StaticLayout;
import android.text.TextPaint;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityNodeInfo;
import android.widget.CompoundButton;
import org.holoeverywhere.R;
import org.holoeverywhere.text.AllCapsTransformationMethod;
import org.holoeverywhere.text.TransformationMethod;

public class Switch
extends CompoundButton {
    private static final int[] CHECKED_STATE_SET = new int[]{0x10100A0};
    private static final int MONOSPACE = 3;
    private static final int SANS = 1;
    private static final int SERIF = 2;
    private static final int TOUCH_MODE_DOWN = 1;
    private static final int TOUCH_MODE_DRAGGING = 2;
    private static final int TOUCH_MODE_IDLE = 0;
    private int mMinFlingVelocity;
    private Layout mOffLayout;
    private Layout mOnLayout;
    private int mSwitchBottom;
    private int mSwitchHeight;
    private int mSwitchLeft;
    private int mSwitchMinWidth;
    private int mSwitchPadding;
    private int mSwitchRight;
    private int mSwitchTop;
    private TransformationMethod mSwitchTransformationMethod;
    private int mSwitchWidth;
    private final Rect mTempRect = new Rect();
    private ColorStateList mTextColors;
    private CharSequence mTextOff;
    private CharSequence mTextOn;
    private TextPaint mTextPaint;
    private Drawable mThumbDrawable;
    private float mThumbPosition;
    private int mThumbTextPadding;
    private int mThumbWidth;
    private boolean mToggleWhenClick;
    private int mTouchMode;
    private int mTouchSlop;
    private float mTouchX;
    private float mTouchY;
    private Drawable mTrackDrawable;
    private VelocityTracker mVelocityTracker = VelocityTracker.obtain();

    public Switch(Context context) {
        this(context, null);
    }

    public Switch(Context context, AttributeSet attrs) {
        this(context, attrs, 2130772143);
    }

    public Switch(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.mTextPaint = new TextPaint(1);
        Resources res = this.getResources();
        this.mTextPaint.density = res.getDisplayMetrics().density;
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.Switch, defStyle, 0);
        this.mThumbDrawable = a.getDrawable(5);
        this.mTrackDrawable = a.getDrawable(8);
        this.mTextOn = a.getText(4);
        this.mTextOff = a.getText(3);
        this.mThumbTextPadding = a.getDimensionPixelSize(6, 0);
        this.mSwitchMinWidth = a.getDimensionPixelSize(0, 0);
        this.mSwitchPadding = a.getDimensionPixelSize(1, 0);
        this.mToggleWhenClick = a.getBoolean(7, true);
        int appearance = a.getResourceId(2, 0);
        if (appearance != 0) {
            this.setSwitchTextAppearance(context, appearance);
        }
        a.recycle();
        ViewConfiguration config = ViewConfiguration.get((Context)context);
        this.mTouchSlop = config.getScaledTouchSlop();
        this.mMinFlingVelocity = config.getScaledMinimumFlingVelocity();
        this.refreshDrawableState();
        this.setChecked(this.isChecked());
    }

    private void animateThumbToCheckedState(boolean newCheckedState) {
        this.setChecked(newCheckedState);
    }

    private void cancelSuperTouch(MotionEvent ev) {
        MotionEvent cancel = MotionEvent.obtain((MotionEvent)ev);
        cancel.setAction(3);
        super.onTouchEvent(cancel);
        cancel.recycle();
    }

    protected void drawableStateChanged() {
        super.drawableStateChanged();
        int[] myDrawableState = this.getDrawableState();
        if (this.mThumbDrawable != null) {
            this.mThumbDrawable.setState(myDrawableState);
        }
        if (this.mTrackDrawable != null) {
            this.mTrackDrawable.setState(myDrawableState);
        }
        this.invalidate();
    }

    public int getCompoundPaddingRight() {
        int padding = super.getCompoundPaddingRight() + this.mSwitchWidth;
        if (!TextUtils.isEmpty((CharSequence)this.getText())) {
            padding += this.mSwitchPadding;
        }
        return padding;
    }

    public int getSwitchMinWidth() {
        return this.mSwitchMinWidth;
    }

    public int getSwitchPadding() {
        return this.mSwitchPadding;
    }

    private boolean getTargetCheckedState() {
        return this.mThumbPosition >= (float)(this.getThumbScrollRange() / 2);
    }

    public CharSequence getTextOff() {
        return this.mTextOff;
    }

    public CharSequence getTextOn() {
        return this.mTextOn;
    }

    public Drawable getThumbDrawable() {
        return this.mThumbDrawable;
    }

    private int getThumbScrollRange() {
        if (this.mTrackDrawable == null) {
            return 0;
        }
        this.mTrackDrawable.getPadding(this.mTempRect);
        return this.mSwitchWidth - this.mThumbWidth - this.mTempRect.left - this.mTempRect.right;
    }

    public int getThumbTextPadding() {
        return this.mThumbTextPadding;
    }

    public Drawable getTrackDrawable() {
        return this.mTrackDrawable;
    }

    private boolean hitThumb(float x, float y) {
        this.mThumbDrawable.getPadding(this.mTempRect);
        int thumbTop = this.mSwitchTop - this.mTouchSlop;
        int thumbLeft = this.mSwitchLeft + (int)(this.mThumbPosition + 0.5f) - this.mTouchSlop;
        int thumbRight = thumbLeft + this.mThumbWidth + this.mTempRect.left + this.mTempRect.right + this.mTouchSlop;
        int thumbBottom = this.mSwitchBottom + this.mTouchSlop;
        return x > (float)thumbLeft && x < (float)thumbRight && y > (float)thumbTop && y < (float)thumbBottom;
    }

    public boolean isToggleWhenClick() {
        return this.mToggleWhenClick;
    }

    public void jumpDrawablesToCurrentState() {
        super.jumpDrawablesToCurrentState();
        this.mThumbDrawable.jumpToCurrentState();
        this.mTrackDrawable.jumpToCurrentState();
    }

    private Layout makeLayout(CharSequence text) {
        CharSequence transformed = this.mSwitchTransformationMethod != null ? this.mSwitchTransformationMethod.getTransformation(text, (View)this) : text;
        return new StaticLayout(transformed, this.mTextPaint, (int)Math.ceil(Layout.getDesiredWidth((CharSequence)transformed, (TextPaint)this.mTextPaint)), Layout.Alignment.ALIGN_NORMAL, 1.0f, 0.0f, true);
    }

    protected int[] onCreateDrawableState(int extraSpace) {
        int[] drawableState = super.onCreateDrawableState(extraSpace + 1);
        if (this.isChecked()) {
            Switch.mergeDrawableStates((int[])drawableState, (int[])CHECKED_STATE_SET);
        }
        return drawableState;
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        int switchLeft = this.mSwitchLeft;
        int switchTop = this.mSwitchTop;
        int switchRight = this.mSwitchRight;
        int switchBottom = this.mSwitchBottom;
        this.mTrackDrawable.setBounds(switchLeft, switchTop, switchRight, switchBottom);
        this.mTrackDrawable.draw(canvas);
        int saveState = canvas.save();
        this.mTrackDrawable.getPadding(this.mTempRect);
        int switchInnerLeft = switchLeft + this.mTempRect.left;
        int switchInnerTop = switchTop + this.mTempRect.top;
        int switchInnerRight = switchRight - this.mTempRect.right;
        int switchInnerBottom = switchBottom - this.mTempRect.bottom;
        canvas.clipRect(switchInnerLeft, switchTop, switchInnerRight, switchBottom);
        this.mThumbDrawable.getPadding(this.mTempRect);
        int thumbPos = (int)(this.mThumbPosition + 0.5f);
        int thumbLeft = switchInnerLeft - this.mTempRect.left + thumbPos;
        int thumbRight = switchInnerLeft + thumbPos + this.mThumbWidth + this.mTempRect.right;
        this.mThumbDrawable.setBounds(thumbLeft, switchTop, thumbRight, switchBottom);
        this.mThumbDrawable.draw(canvas);
        if (this.mTextColors != null) {
            this.mTextPaint.setColor(this.mTextColors.getColorForState(this.getDrawableState(), this.mTextColors.getDefaultColor()));
        }
        this.mTextPaint.drawableState = this.getDrawableState();
        Layout switchText = this.getTargetCheckedState() ? this.mOnLayout : this.mOffLayout;
        canvas.translate((float)((thumbLeft + thumbRight) / 2 - switchText.getWidth() / 2), (float)((switchInnerTop + switchInnerBottom) / 2 - switchText.getHeight() / 2));
        switchText.draw(canvas);
        canvas.restoreToCount(saveState);
    }

    public void onInitializeAccessibilityEvent(AccessibilityEvent event) {
        super.onInitializeAccessibilityEvent(event);
        event.setClassName((CharSequence)Switch.class.getName());
    }

    public void onInitializeAccessibilityNodeInfo(AccessibilityNodeInfo info) {
        CharSequence switchText;
        super.onInitializeAccessibilityNodeInfo(info);
        info.setClassName((CharSequence)Switch.class.getName());
        CharSequence charSequence = switchText = this.isChecked() ? this.mTextOn : this.mTextOff;
        if (!TextUtils.isEmpty((CharSequence)switchText)) {
            CharSequence oldText = info.getText();
            if (TextUtils.isEmpty((CharSequence)oldText)) {
                info.setText(switchText);
            } else {
                StringBuilder newText = new StringBuilder();
                newText.append(oldText).append(' ').append(switchText);
                info.setText((CharSequence)newText);
            }
        }
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        this.mThumbPosition = this.isChecked() ? (float)this.getThumbScrollRange() : 0.0f;
        int switchRight = this.getWidth() - this.getPaddingRight();
        int switchLeft = switchRight - this.mSwitchWidth;
        int switchTop = 0;
        int switchBottom = 0;
        switch (this.getGravity() & 0x70) {
            default: {
                switchTop = this.getPaddingTop();
                switchBottom = switchTop + this.mSwitchHeight;
                break;
            }
            case 16: {
                switchTop = (this.getPaddingTop() + this.getHeight() - this.getPaddingBottom()) / 2 - this.mSwitchHeight / 2;
                switchBottom = switchTop + this.mSwitchHeight;
                break;
            }
            case 80: {
                switchBottom = this.getHeight() - this.getPaddingBottom();
                switchTop = switchBottom - this.mSwitchHeight;
            }
        }
        this.mSwitchLeft = switchLeft;
        this.mSwitchTop = switchTop;
        this.mSwitchBottom = switchBottom;
        this.mSwitchRight = switchRight;
    }

    public void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        if (this.mOnLayout == null) {
            this.mOnLayout = this.makeLayout(this.mTextOn);
        }
        if (this.mOffLayout == null) {
            this.mOffLayout = this.makeLayout(this.mTextOff);
        }
        this.mTrackDrawable.getPadding(this.mTempRect);
        int maxTextWidth = Math.max(this.mOnLayout.getWidth(), this.mOffLayout.getWidth());
        int switchWidth = Math.max(this.mSwitchMinWidth, maxTextWidth * 2 + this.mThumbTextPadding * 4 + this.mTempRect.left + this.mTempRect.right);
        int switchHeight = this.mTrackDrawable.getIntrinsicHeight();
        this.mThumbWidth = maxTextWidth + this.mThumbTextPadding * 2;
        switch (widthMode) {
            case -2147483648: {
                widthSize = Math.min(widthSize, switchWidth);
                break;
            }
            case 0: {
                widthSize = switchWidth;
                break;
            }
        }
        switch (heightMode) {
            case -2147483648: {
                heightSize = Math.min(heightSize, switchHeight);
                break;
            }
            case 0: {
                heightSize = switchHeight;
                break;
            }
        }
        this.mSwitchWidth = switchWidth;
        this.mSwitchHeight = switchHeight;
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int measuredHeight = this.getMeasuredHeight();
        if (measuredHeight < switchHeight) {
            this.setMeasuredDimension(this.getMeasuredWidth(), switchHeight);
        }
    }

    public void onPopulateAccessibilityEvent(AccessibilityEvent event) {
        CharSequence text;
        super.onPopulateAccessibilityEvent(event);
        CharSequence charSequence = text = this.isChecked() ? this.mOnLayout.getText() : this.mOffLayout.getText();
        if (!TextUtils.isEmpty((CharSequence)text)) {
            event.getText().add(text);
        }
    }

    public boolean onTouchEvent(MotionEvent ev) {
        this.mVelocityTracker.addMovement(ev);
        switch (MotionEventCompat.getActionMasked((MotionEvent)ev)) {
            case 0: {
                float x = ev.getX();
                float y = ev.getY();
                if (this.isEnabled() && this.hitThumb(x, y)) {
                    this.mTouchMode = 1;
                    this.mTouchX = x;
                    this.mTouchY = y;
                }
                return true;
            }
            case 2: {
                switch (this.mTouchMode) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        float x = ev.getX();
                        float y = ev.getY();
                        if (!(Math.abs(x - this.mTouchX) > (float)this.mTouchSlop) && !(Math.abs(y - this.mTouchY) > (float)this.mTouchSlop)) break;
                        this.mTouchMode = 2;
                        this.getParent().requestDisallowInterceptTouchEvent(true);
                        this.mTouchX = x;
                        this.mTouchY = y;
                        return true;
                    }
                    case 2: {
                        float x = ev.getX();
                        float dx = x - this.mTouchX;
                        float newPos = Math.max(0.0f, Math.min(this.mThumbPosition + dx, (float)this.getThumbScrollRange()));
                        if (newPos != this.mThumbPosition) {
                            this.mThumbPosition = newPos;
                            this.mTouchX = x;
                            this.invalidate();
                        }
                        return true;
                    }
                }
                break;
            }
            case 1: {
                if (this.mTouchMode == 1 && this.mToggleWhenClick) {
                    this.toggle();
                    this.cancelSuperTouch(ev);
                    this.mTouchMode = 0;
                    this.mVelocityTracker.clear();
                    return true;
                }
            }
            case 3: {
                if (this.mTouchMode == 2) {
                    this.stopDrag(ev);
                    return true;
                }
                this.mTouchMode = 0;
                this.mVelocityTracker.clear();
            }
        }
        return super.onTouchEvent(ev);
    }

    public void setChecked(boolean checked) {
        super.setChecked(checked);
        this.mThumbPosition = checked ? (float)this.getThumbScrollRange() : 0.0f;
        this.invalidate();
    }

    public void setSwitchMinWidth(int pixels) {
        this.mSwitchMinWidth = pixels;
        this.requestLayout();
    }

    public void setSwitchPadding(int pixels) {
        this.mSwitchPadding = pixels;
        this.requestLayout();
    }

    public void setSwitchTextAppearance(Context context, int resid) {
        TypedArray appearance = context.obtainStyledAttributes(resid, R.styleable.TextAppearance);
        ColorStateList colors = appearance.getColorStateList(3);
        this.mTextColors = colors != null ? colors : this.getTextColors();
        int ts = appearance.getDimensionPixelSize(0, 0);
        if (ts != 0 && (float)ts != this.mTextPaint.getTextSize()) {
            this.mTextPaint.setTextSize((float)ts);
            this.requestLayout();
        }
        int typefaceIndex = appearance.getInt(1, -1);
        int styleIndex = appearance.getInt(2, -1);
        this.setSwitchTypefaceByIndex(typefaceIndex, styleIndex);
        boolean allCaps = appearance.getBoolean(7, false);
        if (allCaps) {
            this.mSwitchTransformationMethod = new AllCapsTransformationMethod(this.getContext());
            this.mSwitchTransformationMethod.setLengthChangesAllowed(true);
        } else {
            this.mSwitchTransformationMethod = null;
        }
        appearance.recycle();
    }

    public void setSwitchTypeface(Typeface tf) {
        if (this.mTextPaint.getTypeface() != tf) {
            this.mTextPaint.setTypeface(tf);
            this.requestLayout();
            this.invalidate();
        }
    }

    public void setSwitchTypeface(Typeface tf, int style2) {
        if (style2 > 0) {
            tf = tf == null ? Typeface.defaultFromStyle((int)style2) : Typeface.create((Typeface)tf, (int)style2);
            this.setSwitchTypeface(tf);
            int typefaceStyle = tf != null ? tf.getStyle() : 0;
            int need = style2 & ~typefaceStyle;
            this.mTextPaint.setFakeBoldText((need & 1) != 0);
            this.mTextPaint.setTextSkewX((need & 2) != 0 ? -0.25f : 0.0f);
        } else {
            this.mTextPaint.setFakeBoldText(false);
            this.mTextPaint.setTextSkewX(0.0f);
            this.setSwitchTypeface(tf);
        }
    }

    private void setSwitchTypefaceByIndex(int typefaceIndex, int styleIndex) {
        Typeface tf = null;
        switch (typefaceIndex) {
            case 1: {
                tf = Typeface.SANS_SERIF;
                break;
            }
            case 2: {
                tf = Typeface.SERIF;
                break;
            }
            case 3: {
                tf = Typeface.MONOSPACE;
            }
        }
        this.setSwitchTypeface(tf, styleIndex);
    }

    public void setTextOff(CharSequence textOff) {
        this.mTextOff = textOff;
        this.requestLayout();
    }

    public void setTextOn(CharSequence textOn) {
        this.mTextOn = textOn;
        this.requestLayout();
    }

    public void setThumbDrawable(Drawable thumb) {
        this.mThumbDrawable = thumb;
        this.requestLayout();
    }

    public void setThumbResource(int resId) {
        this.setThumbDrawable(this.getContext().getResources().getDrawable(resId));
    }

    public void setThumbTextPadding(int pixels) {
        this.mThumbTextPadding = pixels;
        this.requestLayout();
    }

    public void setToggleWhenClick(boolean mToggleWhenClick) {
        this.mToggleWhenClick = mToggleWhenClick;
    }

    public void setTrackDrawable(Drawable track) {
        this.mTrackDrawable = track;
        this.requestLayout();
    }

    public void setTrackResource(int resId) {
        this.setTrackDrawable(this.getContext().getResources().getDrawable(resId));
    }

    private void stopDrag(MotionEvent ev) {
        this.mTouchMode = 0;
        boolean commitChange = ev.getAction() == 1 && this.isEnabled();
        this.cancelSuperTouch(ev);
        if (commitChange) {
            this.mVelocityTracker.computeCurrentVelocity(1000);
            float xvel = this.mVelocityTracker.getXVelocity();
            boolean newState = Math.abs(xvel) > (float)this.mMinFlingVelocity ? xvel > 0.0f : this.getTargetCheckedState();
            this.animateThumbToCheckedState(newState);
        } else {
            this.animateThumbToCheckedState(this.isChecked());
        }
    }

    protected boolean verifyDrawable(Drawable who) {
        return super.verifyDrawable(who) || who == this.mThumbDrawable || who == this.mTrackDrawable;
    }
}

