/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.app;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.res.Resources;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.v4.app.Watson;
import android.view.ContextMenu;
import android.view.Menu;
import android.view.View;
import android.view.ViewGroup;
import com.actionbarsherlock.ActionBarSherlock;
import com.actionbarsherlock.app.ActionBar;
import com.actionbarsherlock.internal.view.menu.ContextMenuCallbackGetter;
import com.actionbarsherlock.internal.view.menu.ContextMenuDecorView;
import com.actionbarsherlock.internal.view.menu.ContextMenuItemWrapper;
import com.actionbarsherlock.internal.view.menu.ContextMenuListener;
import com.actionbarsherlock.internal.view.menu.ContextMenuWrapper;
import com.actionbarsherlock.view.ActionMode;
import com.actionbarsherlock.view.ContextMenu;
import com.actionbarsherlock.view.MenuInflater;
import com.actionbarsherlock.view.MenuItem;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.holoeverywhere.HoloEverywhere;
import org.holoeverywhere.LayoutInflater;
import org.holoeverywhere.SystemServiceManager;
import org.holoeverywhere.ThemeManager;
import org.holoeverywhere.addon.IAddonActivity;
import org.holoeverywhere.addon.IAddonAttacher;
import org.holoeverywhere.app.Activity;
import org.holoeverywhere.app.Application;
import org.holoeverywhere.app.ContextThemeWrapperPlus;
import org.holoeverywhere.internal.WindowDecorView;
import org.holoeverywhere.preference.PreferenceManagerHelper;
import org.holoeverywhere.util.SparseIntArray;
import org.holoeverywhere.util.WeaklyMap;

public abstract class _HoloActivity
extends Watson
implements ThemeManager.SuperStartActivity,
ActionBarSherlock.OnCreatePanelMenuListener,
ActionBarSherlock.OnPreparePanelListener,
ActionBarSherlock.OnMenuItemSelectedListener,
ActionBarSherlock.OnActionModeStartedListener,
ActionBarSherlock.OnActionModeFinishedListener,
SystemServiceManager.SuperSystemService,
ContextMenuListener,
ContextMenuDecorView.ContextMenuListenersProvider,
IAddonAttacher<IAddonActivity> {
    private static final String CONFIG_KEY = "holo:config:activity";
    private Context mActionBarContext;
    private Holo mConfig;
    private Map<View, ContextMenuListener> mContextMenuListeners;
    private WindowDecorView mDecorView;
    private boolean mForceThemeApply = false;
    private boolean mInited = false;
    private int mLastThemeResourceId = 0;
    private MenuInflater mMenuInflater;
    private final List<WeakReference<OnWindowFocusChangeListener>> mOnWindowFocusChangeListeners = new ArrayList<WeakReference<OnWindowFocusChangeListener>>();
    private Handler mUserHandler;

    public void addContentView(View view, ViewGroup.LayoutParams params) {
        if (this.requestDecorView(view, params, -1)) {
            this.mDecorView.addView(view, params);
            this.onContentChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addOnWindowFocusChangeListener(OnWindowFocusChangeListener listener) {
        List<WeakReference<OnWindowFocusChangeListener>> list = this.mOnWindowFocusChangeListeners;
        synchronized (list) {
            Iterator<WeakReference<OnWindowFocusChangeListener>> i = this.mOnWindowFocusChangeListeners.iterator();
            while (i.hasNext()) {
                WeakReference<OnWindowFocusChangeListener> reference = i.next();
                if (reference == null) {
                    i.remove();
                    continue;
                }
                OnWindowFocusChangeListener iListener = (OnWindowFocusChangeListener)reference.get();
                if (iListener == null) {
                    i.remove();
                    continue;
                }
                if (iListener != listener) continue;
                return;
            }
            this.mOnWindowFocusChangeListeners.add(new WeakReference<OnWindowFocusChangeListener>(listener));
        }
    }

    protected Holo createConfig(Bundle savedInstanceState) {
        if (this.mConfig == null) {
            this.mConfig = this.onCreateConfig(savedInstanceState);
        }
        if (this.mConfig == null) {
            this.mConfig = Holo.defaultConfig();
        }
        return this.mConfig;
    }

    protected void forceInit(Bundle savedInstanceState) {
        if (this.mInited) {
            return;
        }
        if (this.mConfig == null && savedInstanceState != null && savedInstanceState.containsKey(CONFIG_KEY)) {
            this.mConfig = (Holo)savedInstanceState.getParcelable(CONFIG_KEY);
        }
        this.onInit(this.mConfig, savedInstanceState);
    }

    public Holo getConfig() {
        return this.mConfig;
    }

    @Override
    public ContextMenuListener getContextMenuListener(View view) {
        if (this.mContextMenuListeners == null) {
            return null;
        }
        return this.mContextMenuListeners.get(view);
    }

    public org.holoeverywhere.preference.SharedPreferences getDefaultSharedPreferences() {
        return PreferenceManagerHelper.getDefaultSharedPreferences((Context)this);
    }

    public org.holoeverywhere.preference.SharedPreferences getDefaultSharedPreferences(HoloEverywhere.PreferenceImpl impl) {
        return PreferenceManagerHelper.getDefaultSharedPreferences((Context)this, impl);
    }

    public int getLastThemeResourceId() {
        return this.mLastThemeResourceId;
    }

    public LayoutInflater getLayoutInflater() {
        return LayoutInflater.from((Context)this);
    }

    public org.holoeverywhere.preference.SharedPreferences getSharedPreferences(HoloEverywhere.PreferenceImpl impl, String name, int mode) {
        return PreferenceManagerHelper.wrap((Context)this, impl, name, mode);
    }

    public org.holoeverywhere.preference.SharedPreferences getSharedPreferences(String name, int mode) {
        return PreferenceManagerHelper.wrap((Context)this, name, mode);
    }

    public abstract ActionBar getSupportActionBar();

    public Context getSupportActionBarContext() {
        if (this.mActionBarContext == null) {
            int theme = ThemeManager.getThemeType((Context)this);
            if (theme != ThemeManager.LIGHT) {
                theme = ThemeManager.DARK;
            }
            this.mActionBarContext = this.mLastThemeResourceId == (theme = ThemeManager.getThemeResource(theme, false)) ? this : new ContextThemeWrapperPlus((Context)this, theme);
        }
        return this.mActionBarContext;
    }

    public Application getSupportApplication() {
        return Application.getLastInstance();
    }

    @Override
    public MenuInflater getSupportMenuInflater() {
        if (this.mMenuInflater != null) {
            return this.mMenuInflater;
        }
        this.mMenuInflater = new MenuInflater(this.getSupportActionBarContext(), this);
        return this.mMenuInflater;
    }

    public Object getSystemService(String name) {
        return SystemServiceManager.getSystemService((Context)this, name);
    }

    public Resources.Theme getTheme() {
        if (this.mLastThemeResourceId == 0) {
            this.setTheme(ThemeManager.getDefaultTheme());
        }
        return super.getTheme();
    }

    public LayoutInflater getThemedLayoutInflater() {
        return this.getLayoutInflater();
    }

    public Handler getUserHandler() {
        if (this.mUserHandler == null) {
            this.mUserHandler = new Handler(this.getMainLooper());
        }
        return this.mUserHandler;
    }

    protected final WindowDecorView getWindowDecorView() {
        return this.mDecorView;
    }

    protected void init(Holo config) {
        this.init(config, null);
    }

    protected void init(Holo config, Bundle savedInstanceState) {
        this.mConfig = config;
        if (this.mConfig.applyImmediately) {
            this.onInit(this.mConfig, savedInstanceState);
        }
    }

    public void invalidateOptionsMenu() {
        this.supportInvalidateOptionsMenu();
    }

    public boolean isForceThemeApply() {
        return this.mForceThemeApply;
    }

    public boolean isInited() {
        return this.mInited;
    }

    @SuppressLint(value={"NewApi"})
    public void onBackPressed() {
        if (!this.getSupportFragmentManager().popBackStackImmediate()) {
            this.finish();
        }
    }

    public final boolean onContextItemSelected(android.view.MenuItem item) {
        return this.onContextItemSelected(new ContextMenuItemWrapper(item));
    }

    @Override
    public boolean onContextItemSelected(MenuItem item) {
        if (item instanceof ContextMenuItemWrapper) {
            return super.onContextItemSelected(((ContextMenuItemWrapper)item).unwrap());
        }
        return false;
    }

    public final void onContextMenuClosed(Menu menu) {
        if (menu instanceof android.view.ContextMenu) {
            this.onContextMenuClosed(new ContextMenuWrapper((android.view.ContextMenu)menu));
        } else {
            super.onContextMenuClosed(menu);
        }
    }

    @Override
    public void onContextMenuClosed(ContextMenu menu) {
        if (menu instanceof ContextMenuWrapper) {
            super.onContextMenuClosed((Menu)((ContextMenuWrapper)menu).unwrap());
        }
    }

    protected void onCreate(Bundle savedInstanceState) {
        this.forceInit(savedInstanceState);
        super.onCreate(savedInstanceState);
    }

    protected Holo onCreateConfig(Bundle savedInstanceState) {
        Holo config;
        if (savedInstanceState != null && savedInstanceState.containsKey(CONFIG_KEY) && (config = (Holo)savedInstanceState.getParcelable(CONFIG_KEY)) != null) {
            return config;
        }
        return Holo.defaultConfig();
    }

    public final void onCreateContextMenu(android.view.ContextMenu menu, View v, ContextMenu.ContextMenuInfo menuInfo) {
        this.onCreateContextMenu(new ContextMenuWrapper(menu), v, menuInfo);
    }

    @Override
    public void onCreateContextMenu(ContextMenu menu, View view, ContextMenu.ContextMenuInfo menuInfo) {
        if (menu instanceof ContextMenuWrapper) {
            View.OnCreateContextMenuListener l;
            android.view.ContextMenu nativeMenu = ((ContextMenuWrapper)menu).unwrap();
            super.onCreateContextMenu(nativeMenu, view, menuInfo);
            if (view instanceof ContextMenuCallbackGetter && (l = ((ContextMenuCallbackGetter)view).getOnCreateContextMenuListener()) != null) {
                l.onCreateContextMenu(nativeMenu, view, menuInfo);
            }
        }
    }

    @Override
    public boolean onCreateOptionsMenu(com.actionbarsherlock.view.Menu menu) {
        return false;
    }

    protected void onDestroy() {
        super.onDestroy();
        LayoutInflater.removeInstance((Context)this);
    }

    protected void onInit(Holo config, Bundle savedInstanceState) {
        if (this.mInited) {
            throw new IllegalStateException("This instance was already inited");
        }
        this.mInited = true;
        if (config == null) {
            config = this.createConfig(savedInstanceState);
        }
        if (config == null) {
            config = Holo.defaultConfig();
        }
        this.onPreInit(config, savedInstanceState);
        if (!config.ignoreApplicationInstanceCheck && !(this.getApplication() instanceof Application)) {
            String text = "Application instance isn't HoloEverywhere.\n";
            text = this.getApplication().getClass() == android.app.Application.class ? text + "Put attr 'android:name=\"org.holoeverywhere.app.Application\"' in <application> tag of AndroidManifest.xml" : text + "Please sure that you extend " + this.getApplication().getClass() + " from a org.holoeverywhere.app.Application";
            throw new IllegalStateException(text);
        }
        this.getLayoutInflater().setFragmentActivity(this);
        if (this instanceof Activity) {
            SparseIntArray windowFeatures;
            Activity activity = (Activity)this;
            if (config.requireRoboguice) {
                activity.addon("Roboguice");
            }
            if (config.requireSlider) {
                activity.addon("Slider");
            }
            if (config.requireSherlock) {
                activity.addonSherlock();
            }
            if ((windowFeatures = config.windowFeatures) != null) {
                for (int i = 0; i < windowFeatures.size(); ++i) {
                    if (windowFeatures.valueAt(i) <= 0) continue;
                    this.requestWindowFeature(windowFeatures.keyAt(i));
                }
            }
            boolean forceThemeApply = this.isForceThemeApply();
            if (config.forceThemeApply) {
                forceThemeApply = true;
                this.setForceThemeApply(true);
            }
            if (this.mLastThemeResourceId == 0) {
                forceThemeApply = true;
            }
            ThemeManager.applyTheme(activity, forceThemeApply);
            if (!config.ignoreThemeCheck && ThemeManager.getThemeType((Context)this) == 0) {
                throw new HoloThemeException(activity);
            }
        }
        this.onPostInit(config, savedInstanceState);
        this.lockAttaching();
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        return false;
    }

    protected void onPostCreate(Bundle savedInstanceState) {
        this.requestDecorView(null, null, -1);
        super.onPostCreate(savedInstanceState);
    }

    protected void onPostInit(Holo config, Bundle savedInstanceState) {
    }

    protected void onPreInit(Holo config, Bundle savedInstanceState) {
    }

    @Override
    public boolean onPrepareOptionsMenu(com.actionbarsherlock.view.Menu menu) {
        return false;
    }

    protected void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        if (this.mConfig != null) {
            outState.putParcelable(CONFIG_KEY, (Parcelable)this.mConfig);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onWindowFocusChanged(boolean hasFocus) {
        super.onWindowFocusChanged(hasFocus);
        List<WeakReference<OnWindowFocusChangeListener>> list = this.mOnWindowFocusChangeListeners;
        synchronized (list) {
            Iterator<WeakReference<OnWindowFocusChangeListener>> i = this.mOnWindowFocusChangeListeners.iterator();
            while (i.hasNext()) {
                WeakReference<OnWindowFocusChangeListener> reference = i.next();
                if (reference == null) {
                    i.remove();
                    continue;
                }
                OnWindowFocusChangeListener iListener = (OnWindowFocusChangeListener)reference.get();
                if (iListener == null) {
                    i.remove();
                    continue;
                }
                iListener.onWindowFocusChanged(hasFocus);
            }
        }
    }

    public void registerForContextMenu(View view) {
        if (HoloEverywhere.WRAP_TO_NATIVE_CONTEXT_MENU) {
            super.registerForContextMenu(view);
        } else {
            this.registerForContextMenu(view, this);
        }
    }

    public void registerForContextMenu(View view, ContextMenuListener listener) {
        if (this.mContextMenuListeners == null) {
            this.mContextMenuListeners = new WeaklyMap<View, ContextMenuListener>();
        }
        this.mContextMenuListeners.put(view, listener);
        view.setLongClickable(true);
    }

    private boolean requestDecorView(View view, ViewGroup.LayoutParams params, int layoutRes) {
        if (this.mDecorView != null) {
            return true;
        }
        this.mDecorView = new WindowDecorView((Context)this);
        this.mDecorView.setId(0x1020002);
        this.mDecorView.setProvider(this);
        if (view != null) {
            this.mDecorView.addView(view, params);
        } else if (layoutRes > 0) {
            this.getThemedLayoutInflater().inflate(layoutRes, (ViewGroup)this.mDecorView, true);
        }
        final ViewGroup.LayoutParams p = new ViewGroup.LayoutParams(-1, -1);
        this.performAddonAction(new IAddonAttacher.AddonCallback<IAddonActivity>(){

            @Override
            public boolean action(IAddonActivity addon) {
                return addon.installDecorView((View)_HoloActivity.this.mDecorView, p);
            }

            @Override
            public void justPost() {
                _HoloActivity.this.getWindow().setContentView((View)_HoloActivity.this.mDecorView, p);
            }
        });
        return false;
    }

    public void requestWindowFeature(long featureId) {
        if (!this.mInited) {
            this.createConfig(null).requestWindowFeature((int)featureId);
        }
    }

    public void setContentView(int layoutResID) {
        if (this.requestDecorView(null, null, layoutResID)) {
            this.mDecorView.removeAllViewsInLayout();
            this.getThemedLayoutInflater().inflate(layoutResID, (ViewGroup)this.mDecorView, true);
            this.onContentChanged();
        }
    }

    public void setContentView(View view) {
        this.setContentView(view, new ViewGroup.LayoutParams(-1, -1));
    }

    public void setContentView(View view, ViewGroup.LayoutParams params) {
        if (this.requestDecorView(view, params, -1)) {
            this.mDecorView.removeAllViewsInLayout();
            this.mDecorView.addView(view, params);
            this.onContentChanged();
        }
    }

    public void setForceThemeApply(boolean forceThemeApply) {
        this.mForceThemeApply = forceThemeApply;
    }

    public abstract void setSupportProgress(int var1);

    public abstract void setSupportProgressBarIndeterminate(boolean var1);

    public abstract void setSupportProgressBarIndeterminateVisibility(boolean var1);

    public abstract void setSupportProgressBarVisibility(boolean var1);

    public abstract void setSupportSecondaryProgress(int var1);

    public void setTheme(int resid) {
        this.setTheme(resid, true);
    }

    public synchronized void setTheme(int resid, boolean modifyGlobal) {
        if (resid > 0x1000000) {
            if (this.mLastThemeResourceId != resid) {
                this.mActionBarContext = null;
                this.mMenuInflater = null;
                this.mLastThemeResourceId = resid;
                super.setTheme(this.mLastThemeResourceId);
            }
        } else {
            if ((resid & ThemeManager.COLOR_SCHEME_MASK) == 0) {
                android.app.Activity activity;
                int theme = ThemeManager.getTheme(this.getIntent(), false);
                if (theme == 0 && (activity = this.getParent()) != null) {
                    theme = ThemeManager.getTheme(activity.getIntent(), false);
                }
                if ((theme &= ThemeManager.COLOR_SCHEME_MASK) != 0) {
                    resid |= theme;
                }
            }
            this.setTheme(ThemeManager.getThemeResource(resid, modifyGlobal));
        }
    }

    public abstract ActionMode startActionMode(ActionMode.Callback var1);

    @SuppressLint(value={"NewApi"})
    public void startActivities(Intent[] intents) {
        this.startActivities(intents, null);
    }

    @SuppressLint(value={"NewApi"})
    public void startActivities(Intent[] intents, Bundle options) {
        for (Intent intent : intents) {
            this.startActivity(intent, options);
        }
    }

    @SuppressLint(value={"NewApi"})
    public void startActivity(Intent intent) {
        this.startActivity(intent, null);
    }

    @SuppressLint(value={"NewApi"})
    public void startActivity(Intent intent, Bundle options) {
        this.startActivityForResult(intent, -1, options);
    }

    @SuppressLint(value={"NewApi"})
    public void startActivityForResult(Intent intent, int requestCode) {
        this.startActivityForResult(intent, requestCode, null);
    }

    public void startActivityForResult(Intent intent, int requestCode, Bundle options) {
        if (HoloEverywhere.ALWAYS_USE_PARENT_THEME) {
            ThemeManager.startActivity((Context)this, intent, requestCode, options);
        } else {
            this.superStartActivity(intent, requestCode, options);
        }
    }

    public SharedPreferences superGetSharedPreferences(String name, int mode) {
        return super.getSharedPreferences(name, mode);
    }

    @Override
    public Object superGetSystemService(String name) {
        return super.getSystemService(name);
    }

    @Override
    @SuppressLint(value={"NewApi"})
    public void superStartActivity(Intent intent, int requestCode, Bundle options) {
        if (Build.VERSION.SDK_INT >= 16) {
            super.startActivityForResult(intent, requestCode, options);
        } else {
            super.startActivityForResult(intent, requestCode);
        }
    }

    @SuppressLint(value={"NewApi"})
    public void supportInvalidateOptionsMenu() {
        if (Build.VERSION.SDK_INT >= 11) {
            super.invalidateOptionsMenu();
        }
    }

    public void unregisterForContextMenu(View view) {
        if (HoloEverywhere.WRAP_TO_NATIVE_CONTEXT_MENU) {
            super.unregisterForContextMenu(view);
        } else if (this.mContextMenuListeners != null) {
            this.mContextMenuListeners.remove(view);
        }
    }

    public static interface OnWindowFocusChangeListener {
        public void onWindowFocusChanged(boolean var1);
    }

    private static final class HoloThemeException
    extends RuntimeException {
        private static final long serialVersionUID = -2346897999325868420L;

        public HoloThemeException(_HoloActivity activity) {
            super("You must apply Holo.Theme, Holo.Theme.Light or Holo.Theme.Light.DarkActionBar theme on the activity (" + activity.getClass().getSimpleName() + ") for using HoloEverywhere");
        }
    }

    public static final class Holo
    implements Parcelable {
        public static final Parcelable.Creator<Holo> CREATOR = new Parcelable.Creator<Holo>(){

            public Holo createFromParcel(Parcel source) {
                return new Holo(source);
            }

            public Holo[] newArray(int size) {
                return new Holo[size];
            }
        };
        public boolean applyImmediately = false;
        public boolean forceThemeApply = false;
        public boolean ignoreApplicationInstanceCheck = false;
        public boolean ignoreThemeCheck = false;
        public boolean requireRoboguice = false;
        public boolean requireSherlock = true;
        public boolean requireSlider = false;
        private SparseIntArray windowFeatures;

        public static Holo defaultConfig() {
            return new Holo();
        }

        public Holo() {
        }

        private Holo(Parcel source) {
            this.forceThemeApply = source.readInt() == 1;
            this.ignoreThemeCheck = source.readInt() == 1;
            this.ignoreApplicationInstanceCheck = source.readInt() == 1;
            this.requireSherlock = source.readInt() == 1;
            this.requireSlider = source.readInt() == 1;
            this.requireRoboguice = source.readInt() == 1;
            this.applyImmediately = source.readInt() == 1;
            this.windowFeatures = (SparseIntArray)source.readParcelable(SparseIntArray.class.getClassLoader());
        }

        public int describeContents() {
            return 0;
        }

        public void requestWindowFeature(int feature) {
            if (this.windowFeatures == null) {
                this.windowFeatures = new SparseIntArray();
            }
            this.windowFeatures.put(feature, 1);
        }

        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.forceThemeApply ? 1 : 0);
            dest.writeInt(this.ignoreThemeCheck ? 1 : 0);
            dest.writeInt(this.ignoreApplicationInstanceCheck ? 1 : 0);
            dest.writeInt(this.requireSherlock ? 1 : 0);
            dest.writeInt(this.requireSlider ? 1 : 0);
            dest.writeInt(this.requireRoboguice ? 1 : 0);
            dest.writeInt(this.applyImmediately ? 1 : 0);
            dest.writeParcelable((Parcelable)this.windowFeatures, flags);
        }
    }
}

