/*
 * Decompiled with CFR 0.152.
 */
package com.actionbarsherlock.internal;

import android.app.Activity;
import android.content.Context;
import android.content.res.AssetManager;
import android.content.res.XmlResourceParser;
import android.os.Build;
import android.util.DisplayMetrics;
import android.util.Log;
import com.actionbarsherlock.R;
import com.actionbarsherlock.internal.ActionBarSherlockCompat;

public final class ResourcesCompat {
    private static final String TAG = "ResourcesCompat";

    private ResourcesCompat() {
    }

    public static boolean getResources_getBoolean(Context context, int id2) {
        float smallestWidthDp;
        if (Build.VERSION.SDK_INT >= 13) {
            return context.getResources().getBoolean(id2);
        }
        DisplayMetrics metrics = context.getResources().getDisplayMetrics();
        float widthDp = (float)metrics.widthPixels / metrics.density;
        float heightDp = (float)metrics.heightPixels / metrics.density;
        float f = smallestWidthDp = widthDp < heightDp ? widthDp : heightDp;
        if (id2 == R.bool.abs__action_bar_embed_tabs) {
            return widthDp >= 480.0f;
        }
        if (id2 == R.bool.abs__split_action_bar_is_narrow) {
            return !(widthDp >= 480.0f);
        }
        if (id2 == R.bool.abs__action_bar_expanded_action_views_exclusive) {
            return !(smallestWidthDp >= 600.0f);
        }
        if (id2 == R.bool.abs__config_allowActionMenuItemTextWithIcon) {
            return widthDp >= 480.0f;
        }
        throw new IllegalArgumentException("Unknown boolean resource ID " + id2);
    }

    public static int getResources_getInteger(Context context, int id2) {
        if (Build.VERSION.SDK_INT >= 13) {
            return context.getResources().getInteger(id2);
        }
        DisplayMetrics metrics = context.getResources().getDisplayMetrics();
        float widthDp = (float)metrics.widthPixels / metrics.density;
        if (id2 == R.integer.abs__max_action_buttons) {
            if (widthDp >= 600.0f) {
                return 5;
            }
            if (widthDp >= 500.0f) {
                return 4;
            }
            if (widthDp >= 360.0f) {
                return 3;
            }
            return 2;
        }
        throw new IllegalArgumentException("Unknown integer resource ID " + id2);
    }

    public static int loadLogoFromManifest(Activity activity) {
        int logo = 0;
        try {
            String thisPackage = activity.getClass().getName();
            Log.i((String)TAG, (String)("Parsing AndroidManifest.xml for " + thisPackage));
            String packageName = activity.getApplicationInfo().packageName;
            AssetManager am = activity.createPackageContext(packageName, 0).getAssets();
            XmlResourceParser xml = am.openXmlResourceParser("AndroidManifest.xml");
            int eventType = xml.getEventType();
            while (eventType != 1) {
                if (eventType == 2) {
                    String name = xml.getName();
                    if ("application".equals(name)) {
                        Log.d((String)TAG, (String)"Got <application>");
                        for (int i = xml.getAttributeCount() - 1; i >= 0; --i) {
                            Log.d((String)TAG, (String)(xml.getAttributeName(i) + ": " + xml.getAttributeValue(i)));
                            if (!"logo".equals(xml.getAttributeName(i))) continue;
                            logo = xml.getAttributeResourceValue(i, 0);
                            break;
                        }
                    } else if ("activity".equals(name)) {
                        Log.d((String)TAG, (String)"Got <activity>");
                        Integer activityLogo = null;
                        String activityPackage = null;
                        boolean isOurActivity = false;
                        for (int i = xml.getAttributeCount() - 1; i >= 0; --i) {
                            Log.d((String)TAG, (String)(xml.getAttributeName(i) + ": " + xml.getAttributeValue(i)));
                            String attrName = xml.getAttributeName(i);
                            if ("logo".equals(attrName)) {
                                activityLogo = xml.getAttributeResourceValue(i, 0);
                            } else if ("name".equals(attrName)) {
                                activityPackage = ActionBarSherlockCompat.cleanActivityName(packageName, xml.getAttributeValue(i));
                                if (!thisPackage.equals(activityPackage)) break;
                                isOurActivity = true;
                            }
                            if (activityLogo == null || activityPackage == null) continue;
                            logo = activityLogo;
                        }
                        if (isOurActivity) break;
                    }
                }
                eventType = xml.nextToken();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Log.i((String)TAG, (String)("Returning " + Integer.toHexString(logo)));
        return logo;
    }
}

