/*
 * Decompiled with CFR 0.152.
 */
package com.actionbarsherlock.internal.nineoldandroids.animation;

import android.view.animation.Interpolator;
import com.actionbarsherlock.internal.nineoldandroids.animation.FloatKeyframeSet;
import com.actionbarsherlock.internal.nineoldandroids.animation.IntKeyframeSet;
import com.actionbarsherlock.internal.nineoldandroids.animation.Keyframe;
import com.actionbarsherlock.internal.nineoldandroids.animation.TypeEvaluator;
import java.util.ArrayList;
import java.util.Arrays;

class KeyframeSet {
    int mNumKeyframes;
    Keyframe mFirstKeyframe;
    Keyframe mLastKeyframe;
    Interpolator mInterpolator;
    ArrayList<Keyframe> mKeyframes;
    TypeEvaluator mEvaluator;

    public KeyframeSet(Keyframe ... keyframes) {
        this.mNumKeyframes = keyframes.length;
        this.mKeyframes = new ArrayList();
        this.mKeyframes.addAll(Arrays.asList(keyframes));
        this.mFirstKeyframe = this.mKeyframes.get(0);
        this.mLastKeyframe = this.mKeyframes.get(this.mNumKeyframes - 1);
        this.mInterpolator = this.mLastKeyframe.getInterpolator();
    }

    public static KeyframeSet ofInt(int ... values) {
        int numKeyframes = values.length;
        Keyframe.IntKeyframe[] keyframes = new Keyframe.IntKeyframe[Math.max(numKeyframes, 2)];
        if (numKeyframes == 1) {
            keyframes[0] = (Keyframe.IntKeyframe)Keyframe.ofInt(0.0f);
            keyframes[1] = (Keyframe.IntKeyframe)Keyframe.ofInt(1.0f, values[0]);
        } else {
            keyframes[0] = (Keyframe.IntKeyframe)Keyframe.ofInt(0.0f, values[0]);
            for (int i = 1; i < numKeyframes; ++i) {
                keyframes[i] = (Keyframe.IntKeyframe)Keyframe.ofInt((float)i / (float)(numKeyframes - 1), values[i]);
            }
        }
        return new IntKeyframeSet(keyframes);
    }

    public static KeyframeSet ofFloat(float ... values) {
        int numKeyframes = values.length;
        Keyframe.FloatKeyframe[] keyframes = new Keyframe.FloatKeyframe[Math.max(numKeyframes, 2)];
        if (numKeyframes == 1) {
            keyframes[0] = (Keyframe.FloatKeyframe)Keyframe.ofFloat(0.0f);
            keyframes[1] = (Keyframe.FloatKeyframe)Keyframe.ofFloat(1.0f, values[0]);
        } else {
            keyframes[0] = (Keyframe.FloatKeyframe)Keyframe.ofFloat(0.0f, values[0]);
            for (int i = 1; i < numKeyframes; ++i) {
                keyframes[i] = (Keyframe.FloatKeyframe)Keyframe.ofFloat((float)i / (float)(numKeyframes - 1), values[i]);
            }
        }
        return new FloatKeyframeSet(keyframes);
    }

    public static KeyframeSet ofKeyframe(Keyframe ... keyframes) {
        int numKeyframes = keyframes.length;
        boolean hasFloat = false;
        boolean hasInt = false;
        boolean hasOther = false;
        for (int i = 0; i < numKeyframes; ++i) {
            if (keyframes[i] instanceof Keyframe.FloatKeyframe) {
                hasFloat = true;
                continue;
            }
            if (keyframes[i] instanceof Keyframe.IntKeyframe) {
                hasInt = true;
                continue;
            }
            hasOther = true;
        }
        if (hasFloat && !hasInt && !hasOther) {
            Keyframe.FloatKeyframe[] floatKeyframes = new Keyframe.FloatKeyframe[numKeyframes];
            for (int i = 0; i < numKeyframes; ++i) {
                floatKeyframes[i] = (Keyframe.FloatKeyframe)keyframes[i];
            }
            return new FloatKeyframeSet(floatKeyframes);
        }
        if (hasInt && !hasFloat && !hasOther) {
            Keyframe.IntKeyframe[] intKeyframes = new Keyframe.IntKeyframe[numKeyframes];
            for (int i = 0; i < numKeyframes; ++i) {
                intKeyframes[i] = (Keyframe.IntKeyframe)keyframes[i];
            }
            return new IntKeyframeSet(intKeyframes);
        }
        return new KeyframeSet(keyframes);
    }

    public static KeyframeSet ofObject(Object ... values) {
        int numKeyframes = values.length;
        Keyframe[] keyframes = new Keyframe.ObjectKeyframe[Math.max(numKeyframes, 2)];
        if (numKeyframes == 1) {
            keyframes[0] = (Keyframe.ObjectKeyframe)Keyframe.ofObject(0.0f);
            keyframes[1] = (Keyframe.ObjectKeyframe)Keyframe.ofObject(1.0f, values[0]);
        } else {
            keyframes[0] = (Keyframe.ObjectKeyframe)Keyframe.ofObject(0.0f, values[0]);
            for (int i = 1; i < numKeyframes; ++i) {
                keyframes[i] = (Keyframe.ObjectKeyframe)Keyframe.ofObject((float)i / (float)(numKeyframes - 1), values[i]);
            }
        }
        return new KeyframeSet(keyframes);
    }

    public void setEvaluator(TypeEvaluator evaluator) {
        this.mEvaluator = evaluator;
    }

    public KeyframeSet clone() {
        ArrayList<Keyframe> keyframes = this.mKeyframes;
        int numKeyframes = this.mKeyframes.size();
        Keyframe[] newKeyframes = new Keyframe[numKeyframes];
        for (int i = 0; i < numKeyframes; ++i) {
            newKeyframes[i] = keyframes.get(i).clone();
        }
        KeyframeSet newSet = new KeyframeSet(newKeyframes);
        return newSet;
    }

    public Object getValue(float fraction) {
        if (this.mNumKeyframes == 2) {
            if (this.mInterpolator != null) {
                fraction = this.mInterpolator.getInterpolation(fraction);
            }
            return this.mEvaluator.evaluate(fraction, this.mFirstKeyframe.getValue(), this.mLastKeyframe.getValue());
        }
        if (fraction <= 0.0f) {
            Keyframe nextKeyframe = this.mKeyframes.get(1);
            Interpolator interpolator2 = nextKeyframe.getInterpolator();
            if (interpolator2 != null) {
                fraction = interpolator2.getInterpolation(fraction);
            }
            float prevFraction = this.mFirstKeyframe.getFraction();
            float intervalFraction = (fraction - prevFraction) / (nextKeyframe.getFraction() - prevFraction);
            return this.mEvaluator.evaluate(intervalFraction, this.mFirstKeyframe.getValue(), nextKeyframe.getValue());
        }
        if (fraction >= 1.0f) {
            Keyframe prevKeyframe = this.mKeyframes.get(this.mNumKeyframes - 2);
            Interpolator interpolator3 = this.mLastKeyframe.getInterpolator();
            if (interpolator3 != null) {
                fraction = interpolator3.getInterpolation(fraction);
            }
            float prevFraction = prevKeyframe.getFraction();
            float intervalFraction = (fraction - prevFraction) / (this.mLastKeyframe.getFraction() - prevFraction);
            return this.mEvaluator.evaluate(intervalFraction, prevKeyframe.getValue(), this.mLastKeyframe.getValue());
        }
        Keyframe prevKeyframe = this.mFirstKeyframe;
        for (int i = 1; i < this.mNumKeyframes; ++i) {
            Keyframe nextKeyframe = this.mKeyframes.get(i);
            if (fraction < nextKeyframe.getFraction()) {
                Interpolator interpolator4 = nextKeyframe.getInterpolator();
                if (interpolator4 != null) {
                    fraction = interpolator4.getInterpolation(fraction);
                }
                float prevFraction = prevKeyframe.getFraction();
                float intervalFraction = (fraction - prevFraction) / (nextKeyframe.getFraction() - prevFraction);
                return this.mEvaluator.evaluate(intervalFraction, prevKeyframe.getValue(), nextKeyframe.getValue());
            }
            prevKeyframe = nextKeyframe;
        }
        return this.mLastKeyframe.getValue();
    }

    public String toString() {
        String returnVal = " ";
        for (int i = 0; i < this.mNumKeyframes; ++i) {
            returnVal = returnVal + this.mKeyframes.get(i).getValue() + "  ";
        }
        return returnVal;
    }
}

