/*
 * Decompiled with CFR 0.152.
 */
package org.holoeverywhere;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Typeface;
import android.util.Log;
import android.util.SparseArray;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.holoeverywhere.R;

public final class FontLoader {
    private static HoloFont sDefaultFont = HoloFont.ROBOTO;
    private static final SparseArray<Typeface> sFontCache = new SparseArray();
    private static final String TAG = FontLoader.class.getSimpleName();

    public static <T extends View> T apply(T view) {
        if (sDefaultFont == null) {
            return view;
        }
        return FontLoader.apply(view, sDefaultFont);
    }

    public static <T extends View> T apply(T view, FontSelector fontSelector) {
        if (view == null || view.getContext() == null || view.getContext().isRestricted()) {
            Log.e((String)TAG, (String)"View or context is invalid");
            return view;
        }
        return FontLoader.internalApply(view, fontSelector);
    }

    public static <T extends View> T apply(T view, HoloFont font) {
        return FontLoader.apply(view, (FontSelector)font);
    }

    @SuppressLint(value={"NewApi"})
    public static <T extends View> T apply(T view, int font) {
        if (view == null || view.getContext() == null || view.getContext().isRestricted()) {
            Log.e((String)TAG, (String)"View or context is invalid");
            return view;
        }
        Typeface typeface = FontLoader.loadTypeface(view.getContext(), font);
        if (typeface == null) {
            Log.v((String)TAG, (String)("Font " + font + " not found in resources"));
            return view;
        }
        return FontLoader.apply(view, typeface);
    }

    public static <T extends View> T apply(T view, Typeface typeface) {
        if (view == null || view.getContext() == null || view.getContext().isRestricted()) {
            return view;
        }
        if (typeface == null) {
            Log.v((String)TAG, (String)"Font is null");
            return view;
        }
        if (view instanceof TextView) {
            ((TextView)view).setTypeface(typeface);
        }
        if (view instanceof ViewGroup) {
            ViewGroup group = (ViewGroup)view;
            for (int i = 0; i < group.getChildCount(); ++i) {
                FontLoader.apply(group.getChildAt(i), typeface);
            }
        }
        return view;
    }

    public static HoloFont getDefaultFont() {
        return sDefaultFont;
    }

    private static <T extends View> T internalApply(T view, FontSelector fontSelector) {
        if (view instanceof TextView) {
            Typeface typeface;
            TextView textView = (TextView)view;
            HoloFont font = fontSelector.getFontForView((View)textView);
            if (font != null && !font.mIgnore && (typeface = font.obtainTypeface(view.getContext())) != null) {
                textView.setTypeface(typeface);
            }
        } else if (view instanceof ViewGroup) {
            ViewGroup group = (ViewGroup)view;
            int childCount = group.getChildCount();
            for (int i = 0; i < childCount; ++i) {
                FontLoader.internalApply(group.getChildAt(i), fontSelector);
            }
        }
        return view;
    }

    public static Typeface loadTypeface(Context context, int font) {
        Typeface typeface = (Typeface)sFontCache.get(font);
        if (typeface == null) {
            try {
                File file = new File(context.getCacheDir(), "fonts");
                if (!file.exists()) {
                    file.mkdirs();
                }
                file = new File(file, "font_0x" + Integer.toHexString(font));
                typeface = FontLoader.readTypeface(file, context.getResources(), font, true);
                sFontCache.put(font, (Object)typeface);
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)"Error of loading font", (Throwable)e);
            }
        }
        return typeface;
    }

    private static Typeface readTypeface(File file, Resources res, int font, boolean allowReadExistsFile) throws Exception {
        try {
            if (!allowReadExistsFile || !file.exists()) {
                int read;
                BufferedInputStream is = new BufferedInputStream(res.openRawResource(font));
                OutputStream os = new ByteArrayOutputStream(Math.max(((InputStream)is).available(), 1024));
                byte[] buffer = new byte[1024];
                while ((read = ((InputStream)is).read(buffer)) > 0) {
                    os.write(buffer, 0, read);
                }
                ((InputStream)is).close();
                os.flush();
                buffer = ((ByteArrayOutputStream)os).toByteArray();
                os.close();
                os = new FileOutputStream(file);
                os.write(buffer);
                os.flush();
                os.close();
            }
            return Typeface.createFromFile((File)file);
        }
        catch (Exception e) {
            if (allowReadExistsFile) {
                return FontLoader.readTypeface(file, res, font, false);
            }
            throw e;
        }
    }

    public static void setDefaultFont(HoloFont defaultFont) {
        sDefaultFont = defaultFont;
    }

    private FontLoader() {
    }

    private static final class HoloFontMerger
    extends HoloFont {
        private HoloFont mBold;
        private HoloFont mBoldItalic;
        private HoloFont mItalic;
        private HoloFont mRegular;

        public HoloFontMerger(HoloFont regular, HoloFont bold, HoloFont italic, HoloFont boldItalic) {
            super(regular.mFontId, false);
            this.mRegular = regular;
            this.mBold = bold;
            this.mItalic = italic;
            this.mBoldItalic = boldItalic;
        }

        @Override
        public HoloFont getFontForView(View view) {
            if (!(view instanceof TextView)) {
                return super.getFontForView(view);
            }
            TextView textView = (TextView)view;
            Typeface typeface = textView.getTypeface();
            if (typeface == null) {
                return this.mRegular;
            }
            boolean bold = typeface.isBold();
            boolean italic = typeface.isItalic();
            if (bold && italic) {
                return this.mBoldItalic;
            }
            if (bold) {
                return this.mBold;
            }
            if (italic) {
                return this.mItalic;
            }
            return this.mRegular;
        }
    }

    public static class HoloFont
    implements FontSelector {
        public static final HoloFont ROBOTO;
        public static final HoloFont ROBOTO_BOLD;
        public static final HoloFont ROBOTO_BOLD_ITALIC;
        public static final HoloFont ROBOTO_ITALIC;
        public static final HoloFont ROBOTO_REGULAR;
        protected int mFontId;
        protected boolean mIgnore;
        protected Typeface mTypeface;

        public static HoloFont makeFont(HoloFont regular, HoloFont bold, HoloFont italic, HoloFont boldItalic) {
            return new HoloFontMerger(regular, bold, italic, boldItalic);
        }

        public static HoloFont makeFont(int rawResourceId) {
            return new HoloFont(rawResourceId);
        }

        public static HoloFont makeFont(int rawResourceId, boolean ignore) {
            return new HoloFont(rawResourceId, ignore);
        }

        public static HoloFont makeFont(Typeface typeface) {
            return new HoloFont(typeface);
        }

        private HoloFont(int font) {
            this(font, false);
        }

        private HoloFont(int font, boolean ignore) {
            this.mFontId = font;
            this.mIgnore = ignore;
            this.mTypeface = null;
        }

        private HoloFont(Typeface typeface) {
            this.mFontId = -1;
            this.mIgnore = false;
            this.mTypeface = typeface;
        }

        public <T extends View> T apply(T view) {
            if (this.mIgnore || this.mTypeface == null && this.mFontId <= 0 || view == null) {
                return view;
            }
            return FontLoader.apply(view, this.obtainTypeface(view.getContext()));
        }

        @Override
        public HoloFont getFontForView(View view) {
            return this;
        }

        public Typeface obtainTypeface(Context context) {
            if (this.mTypeface != null) {
                return this.mTypeface;
            }
            if (this.mTypeface == null && this.mFontId > 0) {
                this.mTypeface = FontLoader.loadTypeface(context, this.mFontId);
            }
            return this.mTypeface;
        }

        static {
            ROBOTO_REGULAR = HoloFont.makeFont(R.raw.roboto_regular);
            ROBOTO_BOLD = HoloFont.makeFont(R.raw.roboto_bold);
            ROBOTO_ITALIC = HoloFont.makeFont(R.raw.roboto_italic);
            ROBOTO_BOLD_ITALIC = HoloFont.makeFont(R.raw.roboto_bolditalic);
            ROBOTO = HoloFont.makeFont(ROBOTO_REGULAR, ROBOTO_BOLD, ROBOTO_ITALIC, ROBOTO_BOLD_ITALIC);
        }
    }

    public static interface FontSelector {
        public HoloFont getFontForView(View var1);
    }
}

